package com.biz.crm.tpm.business.audit.handle.local.controller;

import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName AuditHandleCacheController
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/3 15:54
 **/
@RequestMapping("/v1/audit/handle/cache/")
@RestController
@Slf4j
@Api(tags = "手动上账 缓存 controller")
public class AuditHandleCacheController extends MnPageCacheController<AuditHandleDetailVo, AuditHandleDetailDto> {

    @Autowired(required = false)
    private AuditHandleCacheService auditHandleCacheService;

//    /**
//     * 获取导入明细缓存
//     * @param cacheKey
//     * @return
//     */
//    @GetMapping("/findImportDetailCache")
//    @ApiOperation(value = "获取导入明细缓存")
//    public Result<List<AuditHandleDetailVo>> findImportDetailCache(@RequestParam(name = "cacheKey") String cacheKey){
//        try {
//            List<AuditHandleDetailVo> detailVos = this.auditHandleCacheService.findImportDetailCache(cacheKey);
//            return Result.ok(detailVos);
//        }catch (Exception e){
//            log.error(e.getMessage(),e);
//            return Result.error(e.getMessage());
//        }
//    }

//    @GetMapping("/findDetailCachePageList")
//    @ApiOperation(value = "获取明细列表缓存分页接口")
//    public Result<Page<AuditHandleDetailVo>> findDetailCachePageList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
//                                                                     @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
//                                                                     @ApiParam(name = "auditHandleCode", value = "直接上账编码") @RequestParam(required = false) String auditHandleCode) {
//        try {
//            Page<AuditHandleDetailVo> cachePageList = this.auditHandleCacheService.findCachePageList(pageable, cacheKey, auditHandleCode);
//            return Result.ok(cachePageList);
//        }catch (Exception e){
//            log.error(e.getMessage(),e);
//            return Result.error(e.getMessage());
//        }
//
//    }

//    /**
//     * 新增行
//     * @param pageable
//     * @param cacheKey
//     * @return
//     */
//    @GetMapping("/addCacheItemData")
//    @ApiOperation(value = "新增行")
//    public Result<Page<AuditHandleDetailVo>> addCacheItemData(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
//                                                              @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
//                                                              @ApiParam(name = "dtos", value = "当前页数据集合") @RequestBody List<AuditHandleDetailDto> dtos){
//        try {
//            this.auditHandleCacheService.saveCurrentCachePage(cacheKey,dtos);
//            this.auditHandleCacheService.addCacheItemData(cacheKey);
//            Page<AuditHandleDetailVo> detailCachePageList = this.auditHandleCacheService.findCachePageList(pageable, cacheKey, null);
//            return Result.ok(detailCachePageList);
//        }catch (Exception e){
//            log.error(e.getMessage(),e);
//            return Result.error(e.getMessage());
//        }
//    }

//    /**
//     * 批量删除缓存数据
//     * @param pageable
//     * @param cacheKey
//     * @param dtos
//     * @return
//     */
//    @PostMapping("/batchDeleteCache")
//    @ApiOperation(value = "批量删除缓存数据")
//    public Result<Page<AuditHandleDetailVo>> batchDeleteCache(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
//                                                              @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
//                                                              @ApiParam(name = "dtos", value = "选中的删除数据集合") @RequestBody List<AuditHandleDetailDto> dtos){
//        try {
//            this.auditHandleCacheService.batchDeleteCache(cacheKey,dtos);
//            Page<AuditHandleDetailVo> cachePageList = this.auditHandleCacheService.findCachePageList(pageable, cacheKey, null);
//            return Result.ok(cachePageList);
//        }catch (Exception e){
//            log.error(e.getMessage(),e);
//            return Result.error(e.getMessage());
//        }
//    }

//    /**
//     * 复制行
//     * @param pageable
//     * @param cacheKey
//     * @param dto
//     * @return
//     */
//    @PostMapping("/copyRowData")
//    @ApiOperation(value = "复制行")
//    public Result<Page<AuditHandleDetailVo>> copyRowData(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
//                                                         @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
//                                                         @ApiParam(name = "dtos" , value = "需要复制的对象集合") @RequestBody List<AuditHandleDetailDto> dtos){
//        try {
//            this.auditHandleCacheService.saveCurrentCachePage(cacheKey,dtos);
//            this.auditHandleCacheService.copyRowData(cacheKey,dtos);
//            Page<AuditHandleDetailVo> cachePageList = this.auditHandleCacheService.findCachePageList(pageable, cacheKey, null);
//            return Result.ok(cachePageList);
//        }catch (Exception e){
//            log.error(e.getMessage(),e);
//            return Result.error(e.getMessage());
//        }
//    }

//    /**
//     * 清空
//     * @param pageable
//     * @param cacheKey
//     * @return
//     */
//    @GetMapping("/cleanUpCache")
//    @ApiOperation(value = "清空")
//    public Result<Page<AuditHandleDetailVo>> cleanUpCache(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
//                                                          @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey){
//        try {
//            this.auditHandleCacheService.cleanUpCache(cacheKey);
//            Page<AuditHandleDetailVo> cachePageList = this.auditHandleCacheService.findCachePageList(pageable, cacheKey, null);
//            return Result.ok(cachePageList);
//        }catch (Exception e){
//            log.error(e.getMessage(),e);
//            return Result.error(e.getMessage());
//        }
//    }
//
//    /**
//     * 保存当前页
//     * @param pageable
//     * @param cacheKey
//     * @param dtos
//     * @return
//     */
//    @PostMapping("/saveCurrentPageCache")
//    @ApiOperation(value = "保存当前页")
//    public Result<Page<AuditHandleDetailVo>> saveCurrentPageCache(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
//                                                                  @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
//                                                                  @ApiParam(name = "dtos", value = "需要保存的数据") @RequestBody List<AuditHandleDetailDto> dtos){
//        try{
//            this.auditHandleCacheService.saveCurrentCachePage(cacheKey,dtos);
//            Page<AuditHandleDetailVo> cachePageList = this.auditHandleCacheService.findCachePageList(pageable, cacheKey, null);
//            return Result.ok(cachePageList);
//        }catch (Exception e){
//            log.error(e.getMessage(),e);
//            return Result.error(e.getMessage());
//        }
//    }

//    /**
//     * 获取表头汇总数据
//     * @param cacheKey
//     * @return
//     */
//    @GetMapping("/getSummaryDataFromCache")
//    @ApiOperation(value = "获取表头汇总数据")
//    public Result<AuditHandleVo> getSummaryDataFromCache(@ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey){
//        try {
//            AuditHandleVo handleVo = this.auditHandleCacheService.getSummaryDataFromCache(cacheKey);
//            return Result.ok(handleVo);
//        }catch (Exception e){
//            log.error(e.getMessage(),e);
//            return Result.error(e.getMessage());
//        }
//    }


}
