package com.biz.crm.tpm.business.audit.handle.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleInvoiceCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleInvoiceDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleSaveInvoiceCacheDto;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleInvoiceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author : dengwei
 * @Date :2023/10/8  21:56
 * @Description: 发票
 */
@RequestMapping("/v1/audit/auditHandleInvoice")
@RestController
@Slf4j
@Api(tags = "发票controller")
public class AuditHandleInvoiceCacheController extends MnPageCacheController<AuditHandleInvoiceVo, AuditHandleInvoiceDto> {


    @Autowired(required = false)
    private AuditHandleInvoiceCacheService auditHandleInvoiceCacheService;

    @Autowired(required = false)
    private AuditHandleSdkService auditHandleSdkService;
    /**
     * 保存发票到缓存
     *
     */
    @ApiOperation(value = "保存发票到缓存")
    @PostMapping("saveInvoiceCache")
    public Result<?> saveInvoiceCache(@RequestBody AuditHandleSaveInvoiceCacheDto dto) {
        try {
            this.auditHandleInvoiceCacheService.saveInvoiceCache(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiModelProperty("发票提交")
    @GetMapping("invoiceSubmit")
    public Result<?> invoiceSubmit(@RequestParam("cacheKey") String cacheKey,@RequestParam("auditHandleCode")String auditHandleCode,@RequestParam("appendices")Integer appendices){
        try {
            Validate.notBlank(cacheKey,"缓存key不能为空");
            Validate.notBlank(auditHandleCode,"手动上账编码不能为空");
            Validate.notNull(appendices,"附件张数不能为空");
            List<AuditHandleInvoiceDto> cacheList = this.auditHandleInvoiceCacheService.findCacheList(cacheKey);
            this.auditHandleInvoiceCacheService.deleteAuditHandleCodeInvoiceRelation(auditHandleCode);
            if(CollectionUtils.isNotEmpty(cacheList)){
                this.auditHandleInvoiceCacheService.invoiceSubmit(cacheList,auditHandleCode);
                this.auditHandleInvoiceCacheService.clearCache(cacheKey);
                this.auditHandleSdkService.updateAppendicesByAuditHandleCode(appendices,auditHandleCode);
            }
            return Result.ok();
        }catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
