package com.biz.crm.tpm.business.audit.handle.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName AuditHandle
 * @Description 手动上账实体类
 * @AUTHOR WangJJ
 * @DATE 2023/5/29 15:41
 **/

@ApiModel(value = "AuditHandle", description = "手动上账实体类")
@TableName("tpm_audit_handle")
@Data
@Entity(name = "tpm_audit_handle")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_handle", comment = "手动上账主表")
@Table(name = "tpm_audit_handle", indexes = {@Index(name = "audit_handle_code_idx", columnList = "audit_handle_code")})
public class AuditHandle extends TenantFlagOpEntity {

    @ApiModelProperty(name = "auditHandleCode", notes = "手动上账编码")
    @Column(name = "audit_handle_code",  length = 64, unique = true, columnDefinition = "VARCHAR(64) COMMENT '手动上账编码'")
    private String auditHandleCode;

    @ApiModelProperty(name = "auditHandleName", notes = "手动上账名称（文件名称）")
    @Column(name = "audit_handle_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '手动上账名称'")
    private String auditHandleName;

    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("公司代码")
    @Column(name = "company_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '公司代码'")
    private String companyCode;

    @ApiModelProperty("公司名称")
    @Column(name = "company_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '公司名称'")
    private String companyName;

    @ApiModelProperty("部门名称")
    @Column(name = "department_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '部门名称'")
    private String departmentName;

    @ApiModelProperty("部门编码")
    @Column(name = "department_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '部门编码'")
    private String departmentCode;

    @ApiModelProperty("本次结案金额汇总（含税）（本次应报费用之和）")
    @Column(name = "this_audit_amount_total_tax",  length = 24, columnDefinition = "decimal(24,6) COMMENT '本次结案金额汇总（含税）（本次应报费用之和）'")
    private BigDecimal thisAuditAmountTotalTax;

    @ApiModelProperty("折扣应处理金额汇总")
    @Column(name = "discount_should_handle_amount_total",  length = 24, columnDefinition = "decimal(24,6) COMMENT '折扣应处理金额汇总'")
    private BigDecimal discountShouldHandleAmountTotal;

    @ApiModelProperty("入费用池金额汇总")
    @Column(name = "fee_pool_amount_total",  length = 24, columnDefinition = "decimal(24,6) COMMENT '入费用池金额汇总'")
    private BigDecimal feePoolAmountTotal;

    @ApiModelProperty("折扣扣税金额汇总")
    @Column(name = "discount_tax_deduction_amount_total",  length = 24, columnDefinition = "decimal(24,6) COMMENT '折扣扣税金额汇总'")
    private BigDecimal discountTaxDeductionAmountTotal;

    @ApiModelProperty("报销金额汇总（含税）")
    @Column(name = "reimburse_amount_total_tax",  length = 24, columnDefinition = "decimal(24,6) COMMENT '报销金额汇总（含税）'")
    private BigDecimal reimburseAmountTotalTax;

    @ApiModelProperty("报销金额汇总（未税）")
    @Column(name = "reimburse_amount_total_no_tax",  length = 24, columnDefinition = "decimal(24,6) COMMENT '报销金额汇总（未税）'")
    private BigDecimal reimburseAmountTotalNoTax;

    @ApiModelProperty(name = "结案审批流程编码", notes = "结案审批流程编码")
    @Column(name = "process_no",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '结案审批流程编码'")
    private String processNo;

    @ApiModelProperty(name = "结案审批状态", notes = "结案审批状态")
    @Column(name = "process_status",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '结案审批状态'")
    private String processStatus;

    @ApiModelProperty(name = "upAccountStatusReimburse", notes = "报销上账状态")
    @Column(name = "up_account_status_reimburse", length = 10, columnDefinition = "VARCHAR(10) COMMENT '报销上账状态'")
    private String upAccountStatusReimburse;

    @ApiModelProperty(name = "upAccountMessageReimburse", notes = "报销上账信息")
    @Column(name = "up_account_message_reimburse", length = 256, columnDefinition = "VARCHAR(256) COMMENT '报销上账信息'")
    private String upAccountMessageReimburse;

    @ApiModelProperty(name = "accId", notes = "sap凭证标识")
    @Column(name = "acc_id", length = 10, columnDefinition = "VARCHAR(10) COMMENT 'sap凭证标识'")
    private String accId;

    @ApiModelProperty("公司代码")
    @Column(name = "bukrs",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '公司代码'")
    private String bukrs;

    @ApiModelProperty("会计凭证号")
    @Column(name = "belnr",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '会计凭证号'")
    private String belnr;

    @ApiModelProperty("财年")
    @Column(name = "gjahr",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '财年'")
    private String gjahr;

    @ApiModelProperty("冲销公司代码")
    @Column(name = "bukrs2",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '冲销公司代码'")
    private String bukrs2;

    @ApiModelProperty("冲销会计凭证号")
    @Column(name = "belnr2",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '冲销会计凭证号'")
    private String belnr2;

    @ApiModelProperty("冲销财年")
    @Column(name = "gjahr2",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '冲销财年'")
    private String gjahr2;

    @ApiModelProperty("本次结案金额汇总（未税）（本次实报费用之和）")
    @Column(name = "this_audit_amount_total_not_tax",  length = 24, columnDefinition = "decimal(24,6) COMMENT '本次结案金额汇总（未税）（本次实报费用之和）'")
    private BigDecimal thisAuditAmountTotalNotTax;

    @ApiModelProperty("附件数")
    @Column(name = "appendices", length = 2, columnDefinition = "int(10) COMMENT '附件数'")
    private Integer appendices;

    @ApiModelProperty("审批时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "process_date", length = 32, columnDefinition = "datetime COMMENT '审批时间'")
    private Date processDate;

}
