package com.biz.crm.tpm.business.audit.handle.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName AuditHandleDetail
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/29 18:56
 **/
@ApiModel(value = "AuditHandleDetail", description = "手动上账明细实体类")
@TableName("tpm_audit_handle_detail")
@Data
@Entity(name = "tpm_audit_handle_detail")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_handle_detail", comment = "手动上账明细表")
@Table(name = "tpm_audit_handle_detail", indexes = {@Index(name = "audit_handle_code_idx", columnList = "audit_handle_code")})
public class AuditHandleDetail extends TenantFlagOpEntity {


    @ApiModelProperty(name = "auditHandleCode", notes = "手动上账编码")
    @Column(name = "audit_handle_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '手动上账编码'")
    private String auditHandleCode;

    @ApiModelProperty(name = "auditHandleName", notes = "手动上账名称（文件名称）")
    @Column(name = "audit_handle_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '手动上账名称（文件名称）'")
    private String auditHandleName;

    @ApiModelProperty(name = "auditHandleDetailCode", notes = "手动上账明细编码")
    @Column(name = "audit_handle_detail_code",  length = 64, unique = true, columnDefinition = "VARCHAR(64) COMMENT '手动上账明细编码'")
    private String auditHandleDetailCode;

    @ApiModelProperty(name = "undertakingType", notes = "承接类型（分子）")
    @Column(name = "undertaking_type",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '承接类型'")
    private String undertakingType;

    @ApiModelProperty(name = "relationType", notes = "关联类型（分子）")
    @Column(name = "relation_type",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '关联类型'")
    private String relationType;

    @ApiModelProperty(name = "costManage", notes = "费用归口")
    @Column(name = "cost_manage",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '费用归口'")
    private String costManage;

    @ApiModelProperty(name = "budgetCode", notes = "预算编码")
    @Column(name = "budget_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算编码'")
    private String budgetCode;

    @ApiModelProperty(name = "costYearMonth", notes = "费用年月")
    @Column(name = "cost_year_month",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '费用年月'")
    private String costYearMonth;

    @ApiModelProperty(name = "activityTypeCode", notes = "活动分类编码")
    @Column(name = "activity_type_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动分类编码'")
    private String activityTypeCode;

    @ApiModelProperty(name = "activityTypeName", notes = "活动分类名称")
    @Column(name = "activity_type_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动分类名称'")
    private String activityTypeName;

    @ApiModelProperty(name = "activityFormCode", notes = "活动形式编码")
    @Column(name = "activity_form_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName", notes = "活动形式名称")
    @Column(name = "activity_form_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "productBrandCode", notes = "品牌编码")
    @Column(name = "product_brand_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName", notes = "品牌名称")
    @Column(name = "product_brand_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty(name = "productCategoryCode", notes = "品类编码")
    @Column(name = "product_category_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码'")
    private String productCategoryCode;

    @ApiModelProperty(name = "productCategoryName", notes = "品类名称")
    @Column(name = "product_category_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称'")
    private String productCategoryName;

    @ApiModelProperty(name = "productItemCode", notes = "品项编码")
    @Column(name = "product_item_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码'")
    private String productItemCode;

    @ApiModelProperty(name = "productItemName", notes = "品项名称")
    @Column(name = "product_item_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '品项名称'")
    private String productItemName;

    @ApiModelProperty(name = "productCode", notes = "产品编码")
    @Column(name = "product_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "productName", notes = "产品名称")
    @Column(name = "product_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(name = "activityPrice", notes = "活动价（元）（分子）")
    @Column(name = "activity_price",  length = 24, columnDefinition = "decimal(24,6) COMMENT '活动价（元）'")
    private BigDecimal activityPrice;

    @ApiModelProperty(name = "productPrice", notes = "产品单价（元）（分子）")
    @Column(name = "product_price",  length = 24, columnDefinition = "decimal(24,6) COMMENT '产品单价（元）'")
    private BigDecimal productPrice;

    @ApiModelProperty(name = "impulseDifferenceProductCode", notes = "冲差产品编码（分子）")
    @Column(name = "impulse_difference_product_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '冲差产品编码'")
    private String impulseDifferenceProductCode;

    @ApiModelProperty(name = "impulseDifferenceProductName", notes = "冲差产品名称（分子）")
    @Column(name = "impulse_difference_product_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '冲差产品名称'")
    private String impulseDifferenceProductName;

    @ApiModelProperty(name = "unit", notes = "单位（分子）")
    @Column(name = "unit",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '单位'")
    private String unit;

    @ApiModelProperty(name = "quantity", notes = "数量（分子)")
    @Column(name = "quantity",  length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer quantity;

    @ApiModelProperty(name = "factoryName", notes = "工厂名称（分子）")
    @Column(name = "factory_name",  length = 128, columnDefinition = "int(128) COMMENT '工厂名称'")
    private String factoryName;

    @ApiModelProperty(name = "customerCode", notes = "客户编码(不拼接的)")
    @Column(name = "customer_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码(不拼接的)'")
    private String customerCode;

    @ApiModelProperty(name = "customerName", notes = "客户名称")
    @Column(name = "customer_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "whetherDeductionFeePool", notes = "是否扣减费用池")
    @Column(name = "whether_deduction_fee_pool",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否扣减费用池'")
    private String whetherDeductionFeePool;

    @ApiModelProperty(name = "auditForm", notes = "结案形式")
    @Column(name = "end_case_form",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '结案形式'")
    private String endCaseForm;

    @ApiModelProperty(name = "whetherWholeAudit", notes = "是否完全结案")
    @Column(name = "whether_whole_audit",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否完全结案'")
    private String whetherWholeAudit;

    @ApiModelProperty(name = "discountTaxRate", notes = "折扣税率")
    @Column(name = "discount_tax_rate", length = 20, columnDefinition = "decimal(20,6) COMMENT '折扣税率'")
    private BigDecimal discountTaxRate;

    @ApiModelProperty(name = "discountShouldHandleAmount", notes = "折扣应处理金额")
    @Column(name = "discount_should_handle_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '折扣应处理金额'")
    private BigDecimal discountShouldHandleAmount;

    @ApiModelProperty(name = "discountDeductionTaxAmount", notes = "折扣扣税金额")
    @Column(name = "discount_deduction_tax_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '折扣扣税金额'")
    private BigDecimal discountDeductionTaxAmount;

    @ApiModelProperty(name = "inFeePoolAmount", notes = "入费用池金额")
    @Column(name = "in_fee_pool_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '入费用池金额'")
    private BigDecimal inFeePoolAmount;

    @ApiModelProperty(name = "invoiceCode", notes = "发票代码")
    @Column(name = "invoice_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票代码'")
    private String invoiceCode;

    @ApiModelProperty(name = "invoiceNumber", notes = "发票号码")
    @Column(name = "invoice_number", length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票号码'")
    private String invoiceNumber;

    @ApiModelProperty(name = "reimburseItemCode", notes = "报销项目编码")
    @Column(name = "reimburse_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '报销项目编码'")
    private String reimburseItemCode;

    @ApiModelProperty(name = "reimburseTaxRate", notes = "报销税率(%)")
    @Column(name = "reimburse_tax_rate", length = 20,  columnDefinition = "DECIMAL(20,6) COMMENT '报销税率(%)'")
    private BigDecimal reimburseTaxRate;

    @ApiModelProperty(name = "reimburseAmountTax", notes = "报销金额(含税)")
    @Column(name = "reimburse_amount_tax", length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '报销金额(含税)'")
    private BigDecimal reimburseAmountTax;

    @ApiModelProperty(name = "reimburseAmountNoTax", notes = "报销金额(未税)")
    @Column(name = "reimburse_amount_no_tax", length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '报销金额(未税)'")
    private BigDecimal reimburseAmountNoTax;

    @ApiModelProperty(name = "taxAmount", notes = "税额")
    @Column(name = "tax_amount", length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '税额'")
    private BigDecimal taxAmount;

    @ApiModelProperty(name = "personalTaxAmount", notes = "个人所得税")
    @Column(name = "personal_tax_amount", length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '个人所得税'")
    private BigDecimal personalTaxAmount;

    @ApiModelProperty(name = "costCenterCode", notes = "成本中心编码")
    @Column(name = "cost_center_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '成本中心编码'")
    private String costCenterCode;

    @ApiModelProperty(name = "costCenterName", notes = "成本中心名称")
    @Column(name = "cost_center_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '成本中心名称'")
    private String costCenterName;

    @ApiModelProperty(name = "profitCenterCode", notes = "利润中心编码")
    @Column(name = "profit_center_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '利润中心编码'")
    private String profitCenterCode;

    @ApiModelProperty(name = "profitCenterName", notes = "利润中心名称")
    @Column(name = "profit_center_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '利润中心名称'")
    private String profitCenterName;

    @ApiModelProperty(name = "payMethod", notes = "付款方式（分子）")
    @Column(name = "pay_method", length = 10, columnDefinition = "VARCHAR(10) COMMENT '付款方式'")
    private String payMethod;

    @ApiModelProperty(name = "upAccountCode", notes = "上账编码")
    @Column(name = "up_account_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '上账编码'")
    private String upAccountCode;

    @ApiModelProperty(name = "upAccountStatus", notes = "上账状态")
    @Column(name = "up_account_status", length = 10, columnDefinition = "VARCHAR(10) COMMENT '上账状态'")
    private String upAccountStatus;

    @ApiModelProperty(name = "upAccountMessage", notes = "上账信息")
    @Column(name = "up_account_message", length = 10, columnDefinition = "VARCHAR(10) COMMENT '上账信息'")
    private String upAccountMessage;

    @ApiModelProperty(name = "orgCode", notes = "HR组织（分子）")
    @Column(name = "org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT 'HR组织'")
    private String orgCode;

    @ApiModelProperty(name = "relationDataCode", notes = "关联数据编码（分子）")
    @Column(name = "relation_data_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '关联数据编码'")
    private String relationDataCode;

    @ApiModelProperty(name = "relationDataCode", notes = "总部承担金额")
    @Column(name = "headquarters_undertake_amount", length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '总部承担金额'")
    private BigDecimal headquartersUndertakeAmount;

    @ApiModelProperty(name = "regionUndertakeAmount", notes = "大区承担金额")
    @Column(name = "region_undertake_amount", length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '大区承担金额'")
    private BigDecimal regionUndertakeAmount;

    @ApiModelProperty(name = "供应商编码", notes = "供应商编码（分子）")
    @Column(name = "supplier_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码'")
    private String supplierCode;

    @ApiModelProperty(name = "供应商名称（分子）", notes = "供应商名称")
    @Column(name = "supplier_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '供应商名称'")
    private String supplierName;

    @ApiModelProperty("客商类型（分子）")
    @Column(name = "customer_supplier_type",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '客商类型'")
    private String customerSupplierType;

    /**
     * 2023-07-27
     * 以下为新增字段
     */

    @ApiModelProperty(name = "销售部门编码", notes = "销售部门编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售部门名称", notes = "销售部门名称")
    @Column(name = "sales_org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售部门名称'")
    private String salesOrgName;

    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    @Column(name = "sales_group_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码 '")
    private String salesGroupCode;

    @ApiModelProperty(name = "salesGroupName",value = "销售组",notes = "销售组")
    @Column(name = "sales_group_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组 '")
    private String salesGroupName;

    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道名称'")
    private String channelName;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", columnDefinition = "datetime COMMENT '费用所属年月'")
    private Date feeYearMonth;

    @ApiModelProperty(name = "年度预算编码")
    @Column(name = "year_budget_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度预算编码 '")
    private String yearBudgetCode;

    @ApiModelProperty(name = "年度预算名称")
    @Column(name = "year_budget_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '年度预算名称 '")
    private String yearBudgetName;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    @ApiModelProperty(value = "申请费用(申请金额)")
    @Column(name = "apply_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '申请费用'")
    private BigDecimal applyFee;

    @ApiModelProperty("其他扣款")
    @Column(name = "other_deduct_amount",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '其他扣款'")
    private BigDecimal otherDeductAmount;

    @ApiModelProperty("扣税金")
    @Column(name = "deduct_tax_amount",  length = 24, columnDefinition = "decimal(24,6) COMMENT '扣税金'")
    private BigDecimal deductTaxAmount;

    @ApiModelProperty("本次结案金额（未税）（本次实报费用）")
    @Column(name = "this_audit_amount_not_tax",  length = 24, columnDefinition = "decimal(24,6) COMMENT '本次结案金额（未税）（本次应报费用本次应报费用）'")
    private BigDecimal thisAuditAmountNotTax;

    @ApiModelProperty(name = "reimburseItemName", notes = "报销项目名称")
    @Column(name = "reimburse_item_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '报销项目名称'")
    private String reimburseItemName;

    @ApiModelProperty(name = "lookLikeSale", notes = "是否视同销售")
    @Column(name = "look_like_sale", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否视同销售'")
    private String lookLikeSale;

    @ApiModelProperty(name = "type", notes = "分类")
    @Column(name = "type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '分类'")
    private String type;

    @ApiModelProperty("本次结案金额（含税）（本次应报费用）")
    @Column(name = "this_audit_amount_tax",  length = 24, columnDefinition = "decimal(24,6) COMMENT '本本次结案金额（含税）（本次应报费用）'")
    private BigDecimal thisAuditAmountTax;

    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;
}
