package com.biz.crm.tpm.business.audit.handle.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.sdk.constant.AuditHandleConstant;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/6/13  14:19
 * @Description: 手动上账明细缓存helper
 */
@Component
public class AuditHandleCacheHelper extends MnPageCacheHelper<AuditHandleDetailVo, AuditHandleDetailDto> {

    @Autowired(required = false)
    private AuditHandleDetailRepository auditHandleDetailRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public String getCacheKeyPrefix() {
        return AuditHandleConstant.AUDIT_HANDLE_CACHE_KEY_PREFIX;
    }

    @Override
    public Class<AuditHandleDetailDto> getDtoClass() {
        return AuditHandleDetailDto.class;
    }

    @Override
    public Class<AuditHandleDetailVo> getVoClass() {
        return AuditHandleDetailVo.class;
    }

    @Override
    public List<AuditHandleDetailDto> findDtoListFromRepository(AuditHandleDetailDto dto, String cacheKey) {

        if(StringUtils.isEmpty(dto.getAuditHandleCode())){
            return Lists.newArrayList();
        }

        List<AuditHandleDetail> auditHandleDetails = auditHandleDetailRepository.findByAuditHandleCode(dto.getAuditHandleCode());
        if(CollectionUtils.isEmpty(auditHandleDetails)){
            return Lists.newArrayList();
        }
        Collection<AuditHandleDetailDto> auditHandleDetailDtos = this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleDetails, AuditHandleDetail.class, AuditHandleDetailDto.class, LinkedHashSet.class, ArrayList.class);
        return auditHandleDetailDtos.stream().sorted(Comparator.comparing(AuditHandleDetailDto::getAuditHandleDetailCode)).collect(Collectors.toList());
    }

    @Override
    public List<AuditHandleDetailDto> newItem(String cacheKey, List<AuditHandleDetailDto> itemList) {
        AuditHandleDetailDto newItem = new AuditHandleDetailDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList(newItem);
    }

    @Override
    public List<AuditHandleDetailDto> copyItem(String cacheKey, List<AuditHandleDetailDto> itemList) {
        List<AuditHandleDetailDto> newItemList = (List<AuditHandleDetailDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, AuditHandleDetailDto.class, AuditHandleDetailDto.class, HashSet.class, ArrayList.class);
        for (AuditHandleDetailDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setAuditHandleDetailCode(null);
        }
        return newItemList;
    }

    @Override
    public Object getDtoKey(AuditHandleDetailDto dto) {
        return dto.getId();
    }

    @Override
    public String getCheckedStatus(AuditHandleDetailDto dto) {
        return dto.getChecked();
    }
}
