package com.biz.crm.tpm.business.audit.handle.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.sdk.constant.AuditHandleConstant;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleInvoiceDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleInvoiceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @Author : dengwei
 * @Date :2023/10/8  21:58
 * @Description: 发票
 */
@Component
public class AuditHandleInvoiceCacheHelper extends MnPageCacheHelper<AuditHandleInvoiceVo, AuditHandleInvoiceDto> {

    @Autowired(required = false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public String getCacheKeyPrefix() {
        return AuditHandleConstant.AUDIT_HANDLE_INVOICE_CACHE_KEY_PREFIX;
    }

    @Override
    public Class<AuditHandleInvoiceDto> getDtoClass() {
        return AuditHandleInvoiceDto.class;
    }

    @Override
    public Class<AuditHandleInvoiceVo> getVoClass() {
        return AuditHandleInvoiceVo.class;
    }

    @Override
    public List<AuditHandleInvoiceDto> findDtoListFromRepository(AuditHandleInvoiceDto dto, String cacheKey) {
        if(StringUtils.isEmpty(dto.getAuditHandleCode())){
            return Lists.newArrayList();
        }

        List<AuditHandleInvoice> auditHandleInvoices = auditHandleInvoiceRepository.findByAuditHandleCode(dto.getAuditHandleCode());
        if(CollectionUtils.isEmpty(auditHandleInvoices)){
            return Lists.newArrayList();
        }
        Collection<AuditHandleInvoiceDto> auditHandleInvoiceDtos = this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleInvoices, AuditHandleInvoice.class, AuditHandleInvoiceDto.class, LinkedHashSet.class, ArrayList.class);
        return (List<AuditHandleInvoiceDto>) auditHandleInvoiceDtos;

    }

    @Override
    public List<AuditHandleInvoiceDto> newItem(String cacheKey, List<AuditHandleInvoiceDto> itemList) {
        
        if(CollectionUtils.isEmpty(itemList)) {
            AuditHandleInvoiceDto newItem = new AuditHandleInvoiceDto();
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            return Lists.newArrayList(newItem);
        }else {
            for (AuditHandleInvoiceDto item : itemList) {
                item.setId(UUID.randomUUID().toString().replace("-", ""));
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            return itemList;
        }
    }

    @Override
    public List<AuditHandleInvoiceDto> copyItem(String cacheKey, List<AuditHandleInvoiceDto> itemList) {
        List<AuditHandleInvoiceDto> newItemList = (List<AuditHandleInvoiceDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, AuditHandleInvoiceDto.class, AuditHandleInvoiceDto.class, HashSet.class, ArrayList.class);
        for (AuditHandleInvoiceDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return newItemList;
    }

    @Override
    public Object getDtoKey(AuditHandleInvoiceDto dto) {
        return dto.getId();
    }

    @Override
    public String getCheckedStatus(AuditHandleInvoiceDto dto) {
        return dto.getChecked();
    }
}
