package com.biz.crm.tpm.business.audit.handle.local.lisenter;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleRepository;
import com.biz.crm.tpm.business.audit.handle.sdk.constant.AuditHandleConstant;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDto;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName AuditHandleProcessCallBackListener
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/30 18:18
 **/
@Component
@Slf4j
public class AuditHandleProcessCallBackListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private AuditHandleRepository auditHandleRepository;

    @Autowired(required = false)
    private AuditHandleDetailRepository auditHandleDetailRepository;

    @Autowired(required = false)
    private AuditHandleSdkService auditHandleSdkService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Value("${rocketmq.environment}")
    private String rocketmqEnvironment;

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        Date curDate = DateUtil.getDate(DateUtil.date_yyyy_MM_dd_HH_mm_ss);
        log.info("直接上账审批流回调，参数【{}】", JSON.toJSONString(dto));
        List<String> ids = dto.getBusinessNoList();
        Validate.notEmpty(ids,"直接上账审批成功回调,提交数据为空");
        List<AuditHandle> auditHandles = this.auditHandleRepository.findByIds(ids);
        if (StringUtils.equals(dto.getProcessStatus(), ProcessStatusEnum.PASS.getDictCode())){
            Validate.notEmpty(auditHandles,"数据不存在或已被删除");
            List<String> auditHandleCodes = auditHandles.stream().map(o -> o.getAuditHandleCode()).filter(Objects::nonNull).collect(Collectors.toList());
            List<AuditHandleDetail> handleDetails = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);

            List<AuditHandleDetailDto> auditHandleDetailDtos = (ArrayList<AuditHandleDetailDto>)this.nebulaToolkitService.copyCollectionByWhiteList(handleDetails, AuditHandleDetail.class, AuditHandleDetailDto.class, HashSet.class, ArrayList.class);
            Map<String, List<AuditHandleDetailDto>> auditHandleCodeMap = auditHandleDetailDtos.stream().collect(Collectors.groupingBy(AuditHandleDetailDto::getAuditHandleCode));

            //扣减预算
            List<AuditHandleDto> auditHandleDtos = (ArrayList<AuditHandleDto>)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles, AuditHandle.class, AuditHandleDto.class, HashSet.class, ArrayList.class);
            Map<String, List<AuditHandleDto>> unitMap = auditHandleDtos.stream().filter(o -> StringUtils.isNotBlank(o.getBusinessUnitCode())).collect(Collectors.groupingBy(AuditHandleDto::getBusinessUnitCode));
            //分子公司扣减预算
            List<AuditHandleDto> handlesSon = unitMap.get(BusinessUnitEnum.SON_COMPANY.getCode());
            this.auditHandleSdkService.sonCompanyBudgetDeduction(handlesSon, auditHandleCodeMap);
            //主体扣减预算
            List<AuditHandleDto> handlesHead = unitMap.get(BusinessUnitEnum.HEADQUARTERS.getCode());
            this.auditHandleSdkService.headQuartersBudgetDeduction(handlesHead, auditHandleCodeMap);

//            //上账，发送消息队列
//            String idsMq = Joiner.on(",").join(auditHandleDtos.stream().map(AuditHandleDto::getId).collect(Collectors.toList()));
//
//            //异步推送数据
//            MqMessageVo mqMessage = new MqMessageVo();
//            //数据
//            mqMessage.setMsgBody(idsMq);
//            //MQ标签
//            mqMessage.setTag(AuditHandleConstant.TPM_AUDIT_HANDLE_PUSH_DATA_TAG);
//            mqMessage.setTopic(AuditHandleConstant.TPM_AUDIT_HANDLE_PUSH_DATA_TOPIC.concat(rocketmqEnvironment));
//            rocketMqProducer.sendMqMsg(mqMessage);

            this.auditHandleRepository.updateProcessStatusByIds(ids,dto.getProcessStatus(),curDate);
        }else if((StringUtils.equals(dto.getProcessStatus(), ProcessStatusEnum.REJECT.getDictCode()))
            ||StringUtils.equals(dto.getProcessStatus(), ProcessStatusEnum.RECOVER.getDictCode())){
            //扣减预算
            List<AuditHandleDto> auditHandleDtos = (ArrayList<AuditHandleDto>)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles, AuditHandle.class, AuditHandleDto.class, HashSet.class, ArrayList.class);
            Map<String, List<AuditHandleDto>> unitMap = auditHandleDtos.stream().filter(o -> StringUtils.isNotBlank(o.getBusinessUnitCode())).collect(Collectors.groupingBy(AuditHandleDto::getBusinessUnitCode));
            List<AuditHandleDto> handlesHead = unitMap.get(BusinessUnitEnum.HEADQUARTERS.getCode());
            //驳回预算
            rejectBudget(handlesHead);
            this.auditHandleRepository.updateProcessStatusByIds(ids,dto.getProcessStatus(),curDate);
        }
    }

    private void rejectBudget(List<AuditHandleDto> handlesHead) {
        if(CollectionUtils.isEmpty(handlesHead)){
            return;
        }
        for (AuditHandleDto auditHandleDto : handlesHead) {
            List<String> auditDetailCodes = new ArrayList<>();
            auditDetailCodes.add(auditHandleDto.getAuditHandleCode());
            monthBudgetService.auditUseRetrunOperateBudget(auditDetailCodes,auditHandleDto.getAuditHandleCode());
        }
    }

    @Override
    public String getBusinessCode(){
        return AuditHandleConstant.TPM_AUDIT_HANDLE_PROCESS;
    }
}
