package com.biz.crm.tpm.business.audit.handle.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.mapper.AuditHandleDetailMapper;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName AuditHandleRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/30 16:47
 **/
@Component
public class AuditHandleDetailRepository extends ServiceImpl<AuditHandleDetailMapper, AuditHandleDetail> {

    public List<AuditHandleDetail> findByAuditHandleCode(String auditHandleCode){
        if (StringUtils.isEmpty(auditHandleCode)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditHandleDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandleDetail::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditHandleDetail::getAuditHandleCode, auditHandleCode)
                .list();
    }

    public List<AuditHandleDetail> findByAuditHandleCodes(List<String> auditHandleCodes){
        if (CollectionUtils.isEmpty(auditHandleCodes)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditHandleDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandleDetail::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditHandleDetail::getAuditHandleCode, auditHandleCodes)
                .list();
    }

    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }

        this.lambdaUpdate()
                .in(AuditHandleDetail::getId,ids)
                .remove();

    }

    public void deleteByAuditHandleCodes(List<String> auditHandleCodes){
        if (CollectionUtils.isEmpty(auditHandleCodes)){
            return;
        }

        this.lambdaUpdate()
                .eq(AuditHandleDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandleDetail::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditHandleDetail::getAuditHandleCode,auditHandleCodes)
                .set(AuditHandleDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();

    }

    public List<AuditHandleDetail> findByAuditHandleDetailCodes(List<String> detailCodes){
        if (CollectionUtils.isEmpty(detailCodes)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditHandleDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandleDetail::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditHandleDetail::getAuditHandleDetailCode, detailCodes)
                .list();
    }

    public List<AuditHandleDetail> findByUpAccountCodes(List<String> accountCodes){
        if (CollectionUtils.isEmpty(accountCodes)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditHandleDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandleDetail::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditHandleDetail::getUpAccountCode, accountCodes)
                .list();
    }


    public Page<AuditHandleDetailVo> findByConditions(Pageable pageable, AuditHandleDetailDto dto) {
        Page<AuditHandleDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.getBaseMapper().findByConditions(page, dto);
    }

    public List<AuditHandleDetailVo> findListForReconciliation(AuditHandleDetailDto handleDetailDto) {
        return this.baseMapper.findListForReconciliation(handleDetailDto,TenantUtils.getTenantCode());
    }

    public List<String> auditHandleCustomerList(AuditHandleDetailDto handleDetailDto) {
        return this.baseMapper.auditHandleCustomerList(handleDetailDto);
    }
}
