package com.biz.crm.tpm.business.audit.handle.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.mapper.AuditHandleInvoiceMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author : dengwei
 * @Date :2023/10/8  21:50
 * @Description: 发票
 */
@Component
public class AuditHandleInvoiceRepository extends ServiceImpl<AuditHandleInvoiceMapper, AuditHandleInvoice> {
    public List<AuditHandleInvoice> findByAuditHandleCode(String auditHandleCode) {
        if(StringUtils.isEmpty(auditHandleCode)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery().eq(AuditHandleInvoice::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandleInvoice::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditHandleInvoice::getAuditHandleCode,auditHandleCode)
                .list();
    }

    public void deleteByAuditHandleCode(String auditHandleCode) {
        Validate.notBlank(auditHandleCode,"直接上账编码不能为空");
        this.remove(Wrappers.lambdaUpdate(AuditHandleInvoice.class).eq(AuditHandleInvoice::getAuditHandleCode,auditHandleCode));
    }

    public List<AuditHandleInvoice> findByAuditHandleCodes(List<String> auditHandleCodes) {
        if(CollectionUtils.isNotEmpty(auditHandleCodes)){
            List<AuditHandleInvoice> list = this.lambdaQuery().in(AuditHandleInvoice::getAuditHandleCode, auditHandleCodes)
                    .eq(AuditHandleInvoice::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .eq(AuditHandleInvoice::getTenantCode, TenantUtils.getTenantCode())
                    .list();
            return list;
        }
        return Lists.newArrayList();
    }

    public void deleteByAuditHandleCodes(List<String> auditHandleCodes) {
        if(CollectionUtils.isNotEmpty(auditHandleCodes)){
            this.remove(Wrappers.lambdaUpdate(AuditHandleInvoice.class).in(AuditHandleInvoice::getAuditHandleCode,auditHandleCodes));
        }
    }

    public void updateDelStatusByAuditHandleCode(String auditHandleCode) {
        if(StringUtils.isEmpty(auditHandleCode)){
            return;
        }
        this.lambdaUpdate().set(AuditHandleInvoice::getDelFlag,DelFlagStatusEnum.DELETE.getCode())
                .eq(AuditHandleInvoice::getAuditHandleCode,auditHandleCode)
                .update();
    }
}
