package com.biz.crm.tpm.business.audit.handle.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.mapper.AuditHandleMapper;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @ClassName AuditHandleRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/30 16:47
 **/
@Component
public class AuditHandleRepository extends ServiceImpl<AuditHandleMapper, AuditHandle> {

    public AuditHandle findById(String id){
        if (StringUtils.isEmpty(id)){
            return null;
        }
        return this.lambdaQuery()
                .eq(AuditHandle::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandle::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditHandle::getId,id)
                .one();
    }

    public List<AuditHandle> findByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditHandle::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandle::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditHandle::getId,ids)
                .list();
    }

    public AuditHandle findByAuditHandleCode(String auditHandleCode){
        if (StringUtils.isEmpty(auditHandleCode)){
            return new AuditHandle();
        }
        return this.lambdaQuery()
                .eq(AuditHandle::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandle::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditHandle::getAuditHandleCode,auditHandleCode)
                .one();
    }

    public List<AuditHandle> findByAuditHandleCodes(List<String> auditHandleCodes){
        if (CollectionUtils.isEmpty(auditHandleCodes)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(AuditHandle::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandle::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditHandle::getAuditHandleCode,auditHandleCodes)
                .list();
    }

    public void deleteByAuditHandleCodes(List<String> auditHandleCodes){
        if (CollectionUtils.isEmpty(auditHandleCodes)){
            return ;
        }
        this.lambdaUpdate()
                .eq(AuditHandle::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandle::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditHandle::getAuditHandleCode,auditHandleCodes)
                .set(AuditHandle::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    public void updateProcessStatusAndNoByIds(List<String> ids, ProcessStatusEnum statusEnum, String processNo){
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        this.lambdaUpdate()
                .eq(AuditHandle::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandle::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditHandle::getId, ids)
                .set(AuditHandle::getProcessStatus, statusEnum.getDictCode())
                .set(AuditHandle::getProcessNo, processNo)
                .update();
    }

    public void updateProcessStatusByIds(List<String> ids, String processStatus, Date processDate) {
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        if(StringUtils.isEmpty(processStatus)){
            return;
        }
        this.lambdaUpdate()
                .eq(AuditHandle::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditHandle::getTenantCode, TenantUtils.getTenantCode())
                .in(AuditHandle::getId, ids)
                .set(AuditHandle::getProcessStatus, processStatus)
                .set(AuditHandle::getProcessDate,processDate)
                .update();
    }

    public void updateAppendicesByAuditHandleCode(Integer appendices, String auditHandleCode) {
        if(Objects.isNull(appendices)){
            return;
        }
        if(StringUtils.isEmpty(auditHandleCode)){
            return;
        }
        this.lambdaUpdate().eq(AuditHandle::getAuditHandleCode,auditHandleCode)
                .set(AuditHandle::getAppendices,appendices)
                .update();
    }
}
