package com.biz.crm.tpm.business.audit.handle.local.service;

import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleInvoiceDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleSaveInvoiceCacheDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleInvoiceVo;

import java.util.List;

/**
 * @Author : dengwei
 * @Date :2023/10/8  21:53
 * @Description: 发票
 */
public interface AuditHandleInvoiceCacheService extends MnPageCacheService<AuditHandleInvoiceVo, AuditHandleInvoiceDto> {
    /**
     * 保存发票缓存
     * @param dto
     */
    void saveInvoiceCache(AuditHandleSaveInvoiceCacheDto dto);

    /**
     * 提交
     * @param cacheList
     * @param auditHandleCode
     */
    void invoiceSubmit(List<AuditHandleInvoiceDto> auditHandleInvoiceDtoList, String auditHandleCode);

    //清除发票关系
    void deleteAuditHandleCodeInvoiceRelation(String auditHandleCode);
}
