package com.biz.crm.tpm.business.audit.handle.local.service.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.handle.sdk.constant.AuditHandleConstant;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleEditExportsVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @Author : dengwei
 * @Date :2023/9/22  16:59
 * @Description: 直接上账导出编辑
 */
@Component
@Slf4j
public class AuditHandleEditExportsProcess implements ExportProcess<AuditHandleEditExportsVo> {


    @Autowired(required = false)
    private AuditHandleSdkService auditHandleSdkService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        Pageable pageable = PageRequest.of(1, 1);
        AuditHandleDetailDto dto = convertParams(params);
        Page<AuditHandleDetailVo> pageResult = this.auditHandleSdkService.findByConditions(pageable, dto);
        Validate.isTrue(pageResult.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);

        Pageable pageRequest = PageRequest.of(vo.getPageNo() + 1, getPageSize());
        AuditHandleDetailDto dto = convertParams(params);
        Page<AuditHandleDetailVo> page = auditHandleSdkService.findByConditions(pageRequest, dto);
        List<AuditHandleDetailVo> records = page.getRecords();
        if(CollectionUtils.isEmpty(records)){
            new JSONArray();
        }

        fillData(records);
        return JSON.parseArray(JSON.toJSONString(records));
    }

    private void fillData(List<AuditHandleDetailVo> records) {
        //  转换数据字典值
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(
                AuditHandleConstant.MDM_BUSINESS_FORMAT,
                AuditHandleConstant.MDM_BUSINESS_UNIT));
        for (AuditHandleDetailVo record : records) {
            record.setBusinessFormatCode(findDictValue(mapDict, AuditHandleConstant.MDM_BUSINESS_FORMAT, String.valueOf(record.getBusinessFormatCode())));
            record.setBusinessUnitCode(findDictValue(mapDict, AuditHandleConstant.MDM_BUSINESS_UNIT, String.valueOf(record.getBusinessUnitCode())));
            record.setEndCaseForm(EndCaseFormEnum.codeTransitionStr(record.getEndCaseForm()));
        }
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream()
                        .filter(a -> a.getDictCode().equals(code))
                        .map(DictDataVo::getDictValue)
                        .findFirst();
        return first.orElse(StringUtils.EMPTY);
    }

    private AuditHandleDetailDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        AuditHandleDetailDto dto = JSON.parseObject(JSON.toJSONString(params), AuditHandleDetailDto.class);
        List<String> processStatusList = new ArrayList<>();
        processStatusList.add(ProcessStatusEnum.PREPARE.getDictCode());
        processStatusList.add(ProcessStatusEnum.REJECT.getDictCode());
        processStatusList.add(ProcessStatusEnum.RECOVER.getDictCode());
        dto.setProcessStatusList(processStatusList);
        return dto;
    }

    @Override
    public String getBusinessCode() {
        return "audit_handle_edit_exports";
    }

    @Override
    public String getBusinessName() {
        return "直接上账导出编辑";
    }
}
