package com.biz.crm.tpm.business.audit.handle.local.service.imports;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleRepository;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleEditImportVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/9/22  18:27
 * @Description: TODO
 */
@Component
@Slf4j
public class AuditHandleEditImportsProcess implements ImportProcess<AuditHandleEditImportVo> {

    @Autowired(required = false)
    private AuditHandleRepository auditHandleRepository;

    @Autowired(required = false)
    private AuditHandleDetailRepository auditHandleDetailRepository;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;

    @Autowired(required = false)
    private YearBudgetSdkService yearBudgetSdkService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private CostCenterVoService costCenterVoService;

    @Autowired(required = false)
    private AccountSubjectService accountSubjectService;

    @Autowired(required = false)
    private AuditInvoiceManageService auditInvoiceManageService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditHandleEditImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {

        Map<Integer,String> errorMap = new HashMap<>();
        try {
            log.info("直接上账编辑导入+++++++++++++++++++++++++++");
            log.info("直接上账编辑导入,导入数据:{}", JsonUtils.obj2JsonString(data.values()));
            Validate.notEmpty(data, "导入数据不能为空！");
            List<AuditHandle> auditHandleList = Lists.newArrayList();
            List<AuditHandleDetail> auditHandleDetailList = Lists.newArrayList();
            List<AuditHandleInvoice> auditHandleInvoiceList = Lists.newArrayList();
            errorMap = this.validate(data, auditHandleList, auditHandleDetailList,auditHandleInvoiceList);
            if(CollectionUtils.isEmpty(errorMap.keySet())) {
                this.batchUpdate(auditHandleList, auditHandleDetailList,auditHandleInvoiceList);
            }
            log.info("直接上账编辑导入---------------------------");
        }catch (Exception e){
            log.error("批量编辑手动上账",e);
            throw e;
        }
        return errorMap;
    }

    private void batchUpdate(List<AuditHandle> auditHandleList, List<AuditHandleDetail> auditHandleDetailList, List<AuditHandleInvoice> auditHandleInvoiceList) {
        if(CollectionUtils.isNotEmpty(auditHandleList)){
            log.info("直接上账编辑导入,auditHandleList:{}", JsonUtils.obj2JsonString(auditHandleList));
            auditHandleList.forEach(item->{
                auditHandleRepository.lambdaUpdate()
                        .eq(AuditHandle::getAuditHandleCode,item.getAuditHandleCode())
                        .set(StringUtils.isNotEmpty(item.getDepartmentCode()),AuditHandle::getDepartmentCode,item.getDepartmentCode())
                        .set(StringUtils.isNotEmpty(item.getDepartmentName()),AuditHandle::getDepartmentName,item.getDepartmentName())
                        .set(Objects.nonNull(item.getAuditHandleName()),AuditHandle::getAuditHandleName,item.getAuditHandleName())
                        .set(Objects.nonNull(item.getAppendices()),AuditHandle::getAppendices,item.getAppendices())
                        .update();

            });
        }
        if(CollectionUtils.isNotEmpty(auditHandleDetailList)){
            log.info("直接上账编辑导入,auditHandleDetailList:{}", JsonUtils.obj2JsonString(auditHandleDetailList));
            auditHandleDetailList.forEach(item->{
                auditHandleDetailRepository.lambdaUpdate()
                        .eq(AuditHandleDetail::getAuditHandleCode,item.getAuditHandleCode())
                        .set(StringUtils.isNotEmpty(item.getChannelCode()),AuditHandleDetail::getChannelCode,item.getChannelCode())
                        .set(StringUtils.isNotEmpty(item.getChannelName()),AuditHandleDetail::getChannelName,item.getChannelName())
                        .set(Objects.nonNull(item.getFeeYearMonth()),AuditHandleDetail::getFeeYearMonth,item.getFeeYearMonth())
                        .set(StringUtils.isNotEmpty(item.getYearBudgetCode()),AuditHandleDetail::getYearBudgetCode,item.getYearBudgetCode())
                        .set(StringUtils.isNotEmpty(item.getYearBudgetName()),AuditHandleDetail::getYearBudgetName,item.getYearBudgetName())
                        .set(StringUtils.isNotEmpty(item.getActivityTypeCode()),AuditHandleDetail::getActivityTypeCode,item.getActivityTypeCode())
                        .set(StringUtils.isNotEmpty(item.getActivityTypeName()),AuditHandleDetail::getActivityTypeName,item.getActivityTypeName())
                        .set(StringUtils.isNotEmpty(item.getActivityFormCode()),AuditHandleDetail::getActivityFormCode,item.getActivityFormCode())
                        .set(StringUtils.isNotEmpty(item.getActivityFormName()),AuditHandleDetail::getActivityFormName,item.getActivityFormName())
                        .set(StringUtils.isNotEmpty(item.getProductBrandCode()),AuditHandleDetail::getProductBrandCode,item.getProductBrandCode())
                        .set(StringUtils.isNotEmpty(item.getProductBrandName()),AuditHandleDetail::getProductBrandName,item.getProductBrandName())
                        .set(StringUtils.isNotEmpty(item.getProductCategoryCode()),AuditHandleDetail::getProductCategoryCode,item.getProductCategoryCode())
                        .set(StringUtils.isNotEmpty(item.getProductCategoryName()),AuditHandleDetail::getProductCategoryName,item.getProductCategoryName())
                        .set(StringUtils.isNotEmpty(item.getProductItemCode()),AuditHandleDetail::getProductItemCode,item.getProductItemCode())
                        .set(StringUtils.isNotEmpty(item.getProductItemName()),AuditHandleDetail::getProductItemName,item.getProductItemName())
                        .set(StringUtils.isNotEmpty(item.getProductCode()),AuditHandleDetail::getProductCode,item.getProductCode())
                        .set(StringUtils.isNotEmpty(item.getProductName()),AuditHandleDetail::getProductName,item.getProductName())
                        .set(Objects.nonNull(item.getActivityBeginDate()),AuditHandleDetail::getActivityBeginDate,item.getActivityBeginDate())
                        .set(Objects.nonNull(item.getActivityEndDate()),AuditHandleDetail::getActivityEndDate,item.getActivityEndDate())
                        .set(Objects.nonNull(item.getApplyFee())&&item.getApplyFee().compareTo(BigDecimal.ZERO)!=0,AuditHandleDetail::getApplyFee,item.getApplyFee())
                        .set(Objects.nonNull(item.getThisAuditAmountNotTax())&&item.getThisAuditAmountNotTax().compareTo(BigDecimal.ZERO)!=0,AuditHandleDetail::getThisAuditAmountNotTax,item.getThisAuditAmountNotTax())
                        .set(Objects.nonNull(item.getOtherDeductAmount())&&item.getOtherDeductAmount().compareTo(BigDecimal.ZERO)!=0,AuditHandleDetail::getOtherDeductAmount,item.getOtherDeductAmount())
                        .set(Objects.nonNull(item.getDeductTaxAmount())&&item.getDeductTaxAmount().compareTo(BigDecimal.ZERO)!=0,AuditHandleDetail::getDeductTaxAmount,item.getDeductTaxAmount())
                        .set(Objects.nonNull(item.getThisAuditAmountTax())&&item.getThisAuditAmountTax().compareTo(BigDecimal.ZERO)!=0,AuditHandleDetail::getThisAuditAmountTax,item.getThisAuditAmountTax())
                        .set(StringUtils.isNotEmpty(item.getEndCaseForm()),AuditHandleDetail::getEndCaseForm,item.getEndCaseForm())
                        .set(StringUtils.isNotEmpty(item.getReimburseItemCode()),AuditHandleDetail::getReimburseItemCode,item.getReimburseItemCode())
                        .set(StringUtils.isNotEmpty(item.getReimburseItemName()),AuditHandleDetail::getReimburseItemName,item.getReimburseItemName())
                        .set(StringUtils.isNotEmpty(item.getCostCenterCode()),AuditHandleDetail::getCostCenterCode,item.getCostCenterCode())
                        .set(StringUtils.isNotEmpty(item.getCostCenterName()),AuditHandleDetail::getCostCenterName,item.getCostCenterName())
                        .set(StringUtils.isNotEmpty(item.getLookLikeSale()),AuditHandleDetail::getLookLikeSale,item.getLookLikeSale())
                        .set(StringUtils.isNotEmpty(item.getRemark()),AuditHandleDetail::getRemark,item.getRemark())
                        .set(Objects.nonNull(item.getAuditHandleName()),AuditHandleDetail::getAuditHandleName,item.getAuditHandleName())
                        .set(Objects.nonNull(item.getType()),AuditHandleDetail::getType,item.getType())
                        .update();
            });
        }
        if(CollectionUtils.isNotEmpty(auditHandleInvoiceList)){
            List<String> auditHandleCodes = auditHandleInvoiceList.stream().map(AuditHandleInvoice::getAuditHandleCode).distinct().collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(auditHandleCodes)){
                deleteInvoiceRelation(auditHandleCodes);
            }
            this.auditHandleInvoiceRepository.saveBatch(auditHandleInvoiceList);
            List<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<>();
            for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
                AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
                dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
                dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
                invoiceManageDtoList.add(dto);
            }
            String useDate = DateUtil.format(new Date(), "yyyy-MM");
            auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.YES.getCode(), useDate);
        }
    }

    private void deleteInvoiceRelation(List<String> auditHandleCodeList) {
        List<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<>();
        List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCodes(auditHandleCodeList);
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
            AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
            dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
            dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
            invoiceManageDtoList.add(dto);
        }
        auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.NO.getCode(), null);
        this.auditHandleInvoiceRepository.deleteByAuditHandleCodes(auditHandleCodeList);
    }

    private Map<Integer, String> validate(LinkedHashMap<Integer, AuditHandleEditImportVo> data, List<AuditHandle> auditHandleList, List<AuditHandleDetail> auditHandleDetailList,List<AuditHandleInvoice> auditHandleInvoiceList) {


        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");

        Validate.isTrue(CollectionUtils.isNotEmpty(data.values()),"导入的数据不能为空");
        Map<Integer,String> errorMap = new HashMap<>();

        Map<String, AuditHandle> auditHandleVoMap = this.getAuditHandleVoMap(data.values());

        Map<String,AuditHandleDetail> auditHandleDetailVoMap = this.getAuditHandleDetailVoMap(data.values());

        //部门
        Map<String, OrgVo> orgVoMap = this.getDepartmentVoMap(data.values());
        //渠道
        Map<String, CustomerChannelVo> channelVoMap = this.getChannelVoMap(data.values());
        // 年度预算
        Map<String,YearBudgetVo> yearBudgetVoMap = this.getYearBudgetVoMap(data.values());
        // 活动分类管理
        Map<String, ActivityTypeVo> activityTypeVoMap = this.getActivityTYpeVoMap(data.values());
        //活动形式
        Map<String, ActivityFormVo> activityFormVoMap = this.getActivityFormVoMap(data.values());
        // 产品信息
        Map<String, ProductVo> productVoMap = this.getProductVoMap(data.values());
        // 会计科目
        Map<String,AccountSubjectVo> accountSubjectVoMap = this.getAccountSubjectVoMap(data.values());
        // 成本中心
        Map<String,CostCenterVo> costCenterVoMap = this.getCostCenterVoMap(data.values());

        List<String> invoices = new ArrayList<>();
        data.forEach((key,value)->{

            List<String> errorList = new ArrayList<>();

            AuditHandle auditHandle1 = auditHandleVoMap.get(value.getAuditHandleCode());
            if(Objects.isNull(auditHandle1)){
                errorList.add("手动上账编码在系统中不存在");
            }else {
                if(ProcessStatusEnum.PREPARE.getDictCode().equals(auditHandle1.getProcessStatus())||
                        ProcessStatusEnum.REJECT.getDictCode().equals(auditHandle1.getProcessStatus())||
                        ProcessStatusEnum.RECOVER.getDictCode().equals(auditHandle1.getProcessStatus())
                    ){}else {
                    errorList.add("审批状态为待提交，驳回，追回的才允许编辑");
                }
            }
            List<AuditHandleInvoice> auditHandleInvoices = new ArrayList<>();
            // 填写发票号码和发票代码时，校验本次实报费用≤发票金额
            if(StringUtils.isNotEmpty(value.getInvoiceCode()) && StringUtils.isEmpty(value.getInvoiceNumber())){
                errorList.add("填写了发票代码，发票号码不能为空");
            }
            if(StringUtils.isEmpty(value.getInvoiceCode()) && StringUtils.isNotEmpty(value.getInvoiceNumber())){
                errorList.add("填写了发票号码，发票代码不能为空");
            }
            // 填写发票号码和发票代码时，校验本次实报费用≤发票金额
            if (StringUtils.isNotEmpty(value.getInvoiceCode()) && StringUtils.isNotEmpty(value.getInvoiceNumber())) {
                String[] invoiceCodes = value.getInvoiceCode().split(",");
                String[] invoiceNumbers = value.getInvoiceNumber().split(",");
                if(invoiceNumbers.length != invoiceNumbers.length){
                    errorList.add("发票号码和发票代码不匹配");
                }else {
                    List<AuditInvoiceManageDto> dtoList = new ArrayList<>();
                    for (int i = 0; i < invoiceCodes.length; i++) {
                        String invoiceCode = invoiceCodes[i];
                        String invoiceNumber = invoiceNumbers[i];
                        AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
                        auditInvoiceManageDto.setInvoiceCode(invoiceCode);
                        auditInvoiceManageDto.setInvoiceNo(invoiceNumber);
                        String invoice = StringUtils.isEmpty(invoiceCode)?invoiceNumber:invoiceCode+":"+invoiceNumber;
                        invoices.add(invoice);
                        dtoList.add(auditInvoiceManageDto);
                    }
                    List<AuditInvoiceItemVo> invoiceItemVos = auditInvoiceManageService.findByInvoiceNoCode(dtoList);
                    if (CollectionUtils.isEmpty(invoiceItemVos)){
                        errorList.add("未查询到对应的发票或者发票已经被使用");
                    }else {
                        if (CollUtil.isNotEmpty(invoiceItemVos)) {
                            auditHandleInvoices = (List<AuditHandleInvoice>) nebulaToolkitService.copyCollectionByWhiteList(invoiceItemVos, AuditInvoiceItemVo.class, AuditHandleInvoice.class, HashSet.class, ArrayList.class);
                        }
                    }
                }
            }
            AuditHandle auditHandle = new AuditHandle();
            AuditHandleDetail auditHandleDetail = new AuditHandleDetail();
            auditHandleDetail.setAuditHandleCode(value.getAuditHandleCode());
            auditHandle.setAuditHandleCode(value.getAuditHandleCode());
            auditHandleInvoices.forEach(item->{
                item.setAuditHandleCode(value.getAuditHandleCode());
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            //部门
            if(StringUtils.isNotEmpty(value.getDepartmentCode())) {
                OrgVo orgVo = orgVoMap.get(value.getDepartmentCode());
                if (Objects.isNull(orgVo)) {
                    errorList.add("未找到部门信息");
                } else {
                    auditHandle.setDepartmentName(orgVo.getOrgName());
                    auditHandle.setDepartmentCode(orgVo.getOrgCode());
                }
            }
            //渠道
            if(StringUtils.isNotEmpty(value.getChannelCode())) {
                CustomerChannelVo customerChannelVo = channelVoMap.get(value.getChannelCode());
                if (Objects.isNull(customerChannelVo)) {
                    errorList.add("未找到渠道信息");
                } else {
                    auditHandleDetail.setChannelName(customerChannelVo.getCustomerChannelName());
                    auditHandleDetail.setChannelCode(customerChannelVo.getCustomerChannelCode());
                }
            }
            auditHandleDetail.setFeeYearMonth(stringTransformDate(value.getFeeYearMonth(),"费用所属年月",sdf,errorList));
            // 年度预算
            if(StringUtils.isNotEmpty(value.getYearBudgetCode())) {
                YearBudgetVo yearBudgetVo = yearBudgetVoMap.get(value.getYearBudgetCode());
                if (Objects.isNull(yearBudgetVo)) {
                    errorList.add("未找到年度预算科目信息");
                } else {
                    auditHandleDetail.setYearBudgetName(yearBudgetVo.getBudgetItemName());
                    auditHandleDetail.setYearBudgetCode(yearBudgetVo.getBudgetItemCode());
                }
            }
            // 活动分类
            if(StringUtils.isNotEmpty(value.getActivityTypeCode())) {
                ActivityTypeVo activityTypeVo = activityTypeVoMap.get(value.getActivityTypeCode());
                if (Objects.isNull(activityTypeVo)) {
                    errorList.add("未找到活动分类信息");
                } else {
                    auditHandleDetail.setActivityTypeName(activityTypeVo.getActivityTypeName());
                    auditHandleDetail.setActivityTypeCode(activityTypeVo.getActivityTypeCode());
                }
            }

            if(StringUtils.isNotEmpty(value.getActivityFormCode())) {
                ActivityFormVo activityFormVo = activityFormVoMap.get(value.getActivityFormCode());
                if (Objects.isNull(activityFormVo)) {
                    errorList.add("未找到活动形式信息");
                } else {
                    auditHandleDetail.setActivityFormName(activityFormVo.getActivityFormName());
                    auditHandleDetail.setActivityFormCode(activityFormVo.getActivityFormCode());
                }
            }

            // 产品信息
            if(StringUtils.isNotEmpty(value.getProductCode())) {
                ProductVo productVo = productVoMap.get(value.getProductCode());
                if (Objects.isNull(productVo)) {
                    errorList.add("未找到年度预算科目产品信息");
                } else {
                    auditHandleDetail.setProductName(productVo.getProductName());
                    auditHandleDetail.setProductCode(productVo.getProductCode());
                    auditHandleDetail.setProductBrandCode(productVo.getProductBrandCode());
                    auditHandleDetail.setProductBrandName(productVo.getProductBrandName());
                    auditHandleDetail.setProductCategoryCode(productVo.getProductCategoryCode());
                    auditHandleDetail.setProductCategoryName(productVo.getProductCategoryName());
                    auditHandleDetail.setProductItemCode(productVo.getProductLevelCode());
                    auditHandleDetail.setProductItemName(productVo.getProductLevelName());
                }
            }
            if(StringUtils.isNotEmpty(value.getActivityBeginDate())) {
                auditHandleDetail.setActivityBeginDate(stringTransformDate(value.getActivityBeginDate(), "活动开始时间", sdf2, errorList));
            }
            if(StringUtils.isNotEmpty(value.getActivityEndDate())) {
                auditHandleDetail.setActivityEndDate(stringTransformDate(value.getActivityEndDate(), "活动开始时间", sdf2, errorList));
            }
            if(StringUtils.isNotEmpty(value.getActivityBeginDate())&&StringUtils.isEmpty(value.getActivityEndDate())){
                AuditHandleDetail auditHandleDetail1 = auditHandleDetailVoMap.get(value.getAuditHandleCode());
                String activityEndDate = sdf2.format(auditHandleDetail1.getActivityEndDate());
                verifyIsTwoMonth(value.getActivityBeginDate(),activityEndDate,errorList);
            }
            if(StringUtils.isEmpty(value.getActivityBeginDate())&&StringUtils.isNotEmpty(value.getActivityEndDate())){
                AuditHandleDetail auditHandleDetail1 = auditHandleDetailVoMap.get(value.getAuditHandleCode());
                String activityBeginDate = sdf2.format(auditHandleDetail1.getActivityBeginDate());
                verifyIsTwoMonth(activityBeginDate,value.getActivityEndDate(),errorList);
            }
            if(StringUtils.isNotEmpty(value.getActivityBeginDate())&&StringUtils.isNotEmpty(value.getActivityEndDate())){
                verifyIsTwoMonth(value.getActivityBeginDate(),value.getActivityEndDate(),errorList);
            }
            if(StringUtils.isNotEmpty(value.getApplyFee())) {
                auditHandleDetail.setApplyFee(stringTransformBigDecimal(value.getApplyFee(), "申请费用", errorList));
            }
            if(StringUtils.isNotEmpty(value.getThisAuditAmountTax())) {
                auditHandleDetail.setThisAuditAmountTax(stringTransformBigDecimal(value.getThisAuditAmountTax(), "本次应报费用", errorList));
            }
            if(StringUtils.isNotEmpty(value.getOtherDeductAmount())) {
                auditHandleDetail.setOtherDeductAmount(stringTransformBigDecimal(value.getOtherDeductAmount(), "其他扣款", errorList));
            }
            if(StringUtils.isNotEmpty(value.getDeductTaxAmount())) {
                auditHandleDetail.setDeductTaxAmount(stringTransformBigDecimal(value.getDeductTaxAmount(), "扣税金", errorList));
            }
            if(StringUtils.isNotEmpty(value.getThisAuditAmountNotTax())) {
                auditHandleDetail.setThisAuditAmountNotTax(stringTransformBigDecimal(value.getThisAuditAmountNotTax(), "本次实报费用", errorList));
            }
            if(StringUtils.isNotEmpty(value.getEndCaseForm())) {
                auditHandleDetail.setEndCaseForm(EndCaseFormEnum.transitionStr(value.getEndCaseForm()));
            }
            // 会计科目
            if(StringUtils.isNotEmpty(value.getReimburseItemCode())) {
                if (auditHandleDetail.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())) {
                    AccountSubjectVo accountSubjectVo = accountSubjectVoMap.get(value.getReimburseItemCode());
                    if (Objects.isNull(accountSubjectVo)) {
                        errorList.add("未找到会计科目信息");
                    } else {
                        auditHandleDetail.setReimburseItemName(accountSubjectVo.getAccountSubjectName());
                        auditHandleDetail.setReimburseItemCode(accountSubjectVo.getAccountSubjectCode());
                    }
                }
            }
            // 利润中心
            if(StringUtils.isNotEmpty(value.getCostCenterCode())) {
                if (StringUtils.isNotEmpty(value.getCostCenterCode())) {
                    CostCenterVo costCenterVo = costCenterVoMap.get(value.getCostCenterCode());
                    if (Objects.isNull(costCenterVo)) {
                        errorList.add("未找到成本中心信息");
                    } else {
                        auditHandleDetail.setCostCenterName(costCenterVo.getCostCenterName());
                        auditHandleDetail.setCostCenterCode(costCenterVo.getCostCenterCode());
                        auditHandleDetail.setProfitCenterCode(costCenterVo.getProfitCenterCode());
                        auditHandleDetail.setProfitCenterName(costCenterVo.getProfitCenterName());
                    }
                }
            }
            if(StringUtils.isNotEmpty(value.getCostCenterCode())) {
                auditHandleDetail.setLookLikeSale(YesOrNoEnum.getByValue(value.getLookLikeSale()));
            }
            if(StringUtils.isNotEmpty(value.getRemark())){
                auditHandleDetail.setRemark(value.getRemark());
            }
            if(StringUtils.isNotEmpty(value.getAppendices())) {
                auditHandle.setAppendices(stringTransformInter(value.getAppendices(), "附单据张数", errorList));
            }
            if(StringUtils.isNotEmpty(value.getAuditHandleName())){
                auditHandle.setAuditHandleName(value.getAuditHandleName());
            }
            if(StringUtils.isNotEmpty(value.getType())){
                auditHandleDetail.setType(value.getType());
            }

            auditHandleList.add(auditHandle);
            auditHandleDetailList.add(auditHandleDetail);
            auditHandleInvoiceList.addAll(auditHandleInvoices);
            if(CollectionUtils.isNotEmpty(errorList)) {
                errorMap.put(key, String.join(",", errorList));
            }
        });
        if(CollectionUtils.isNotEmpty(invoices)) {
            Map<String, List<String>> invoicesMap = invoices.stream().collect(Collectors.groupingBy(o -> o));
            invoicesMap.forEach((key,value)->{
                Validate.isTrue(value.size()<=1,"发票【%s】存在多行，不能重复导入",key);
            });
        }
        return errorMap;
    }

    private void verifyIsTwoMonth(String activityBeginDate, String activityEndDate, List<String> errorList) {
        //2023-10
        if(!activityBeginDate.substring(0,7).equals(activityEndDate.substring(0,7))){
            errorList.add("活动开始结束时间不允许跨月");
        }
    }

    private Map<String, AuditHandleDetail> getAuditHandleDetailVoMap(Collection<AuditHandleEditImportVo> values) {
        List<String> auditHandleCodes = values.stream().map(AuditHandleEditImportVo::getAuditHandleCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(auditHandleCodes)){
            List<AuditHandleDetail> auditHandleDetailList = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
            if(CollectionUtils.isNotEmpty(auditHandleDetailList)){
                Map<String, AuditHandleDetail> auditHandleDetailMap = auditHandleDetailList.stream().collect(Collectors.toMap(AuditHandleDetail::getAuditHandleCode, Function.identity()));
                return auditHandleDetailMap;
            }
        }
        return Maps.newHashMap();
    }

    private Map<String, AuditHandle> getAuditHandleVoMap(Collection<AuditHandleEditImportVo> values) {
        List<String> auditHandleCodes = values.stream().map(AuditHandleEditImportVo::getAuditHandleCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(auditHandleCodes)){
            List<AuditHandle> auditHandleList = this.auditHandleRepository.findByAuditHandleCodes(auditHandleCodes);
            if(CollectionUtils.isNotEmpty(auditHandleList)){
                Map<String, AuditHandle> auditHandleMap = auditHandleList.stream().collect(Collectors.toMap(AuditHandle::getAuditHandleCode, Function.identity()));
                return auditHandleMap;
            }
        }
        return Maps.newHashMap();
    }

    private Integer stringTransformInter(String orderNumber, String msg, List<String> errorList) {
        if(StringUtils.isEmpty(orderNumber)){
            return 0;
        }
        int i = 0;
        try {
            i = Integer.parseInt(orderNumber);
        }catch (Exception e){
            errorList.add(msg+"不是数字");
        }
        return i;
    }

    private Date stringTransformDate(String feeYearMonth, String msg, SimpleDateFormat sdf, List<String> errorList) {
        if(StringUtils.isEmpty(feeYearMonth)){
            return null;
        }
        Date result = null;
        try {
            result = sdf.parse(feeYearMonth);
        }catch (Exception e){
            errorList.add(msg+"时间格式不对");
        }
        return result;
    }

    private BigDecimal stringTransformBigDecimal(String arguments, String msg, List<String> errorList) {
        if(StringUtils.isEmpty(arguments)){
            return BigDecimal.ZERO;
        }
        if(!isValidNumber(arguments)){
            errorList.add(msg+"不是数字,请检查");
            return BigDecimal.ZERO;
        }else {
            if(!isValidDecimals(arguments)){
                errorList.add(msg+"请保留两位小数");
                return BigDecimal.ZERO;
            }else {
                return new BigDecimal(arguments);
            }
        }
    }

    private static boolean isValidNumber(String str) {
        String reg = "^-?[0-9]+(.[0-9]+)?$";
        return str.matches(reg);
    }

    private boolean isValidDecimals(String str) {
        String reg = "^(\\-)?[0-9]+(\\.[0-9]{0,2})?$";
        return str.matches(reg);
    }

    private Map<String, OrgVo> getDepartmentVoMap(Collection<AuditHandleEditImportVo> values) {
        List<String> departmentCodes = values.stream().map(AuditHandleEditImportVo::getDepartmentCode).collect(Collectors.toList());
        Map<String, OrgVo> orgVoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(departmentCodes)){
            List<OrgVo> orgVos = orgVoService.findByOrgCodes(departmentCodes);
            orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        }
        return orgVoMap;
    }

    private Map<String, CustomerChannelVo> getChannelVoMap(Collection<AuditHandleEditImportVo> values) {

        Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
        List<String> channelCodes = values.stream().map(AuditHandleEditImportVo::getChannelCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(channelCodes)){
            List<CustomerChannelVo> customerChannelVos = customerChannelVoService.findByCodes(channelCodes);
            customerChannelVoMap = customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
        }
        return customerChannelVoMap;
    }

    /**
     * 年度预算
     * @param values
     * @return
     */
    private Map<String, YearBudgetVo> getYearBudgetVoMap(Collection<AuditHandleEditImportVo> values) {
        List<String> yearBudgetCodes =values.stream().map(AuditHandleEditImportVo::getYearBudgetCode).collect(Collectors.toList());
        List<YearBudgetVo> yearBudgetVos = this.yearBudgetSdkService.findByYearBudgetCodes(yearBudgetCodes);
        return CollectionUtils.isNotEmpty(yearBudgetVos)
                ? yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 活动分类
     * @param values
     * @return
     */
    private Map<String, ActivityTypeVo> getActivityTYpeVoMap(Collection<AuditHandleEditImportVo> values) {
        List<String> activityTypeCodes = values.stream().map(AuditHandleEditImportVo::getActivityTypeCode).collect(Collectors.toList());
        List<ActivityTypeVo> activityTypeVos = activityTypeService.findByCodes(activityTypeCodes);
        return CollectionUtils.isNotEmpty(activityTypeVos)
                ? activityTypeVos.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode,Function.identity()))
                : Maps.newHashMap();
    }

    private Map<String, ActivityFormVo> getActivityFormVoMap(Collection<AuditHandleEditImportVo> values) {

        List<String> activityFormCodes = values.stream().map(AuditHandleEditImportVo::getActivityFormCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(activityFormCodes)){
            List<ActivityFormVo> activityFormVoList = this.activityFormService.findByCodes(activityFormCodes);
            if(CollectionUtils.isNotEmpty(activityFormVoList)){
                Map<String, ActivityFormVo> activityFormVoMap = activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
                return activityFormVoMap;
            }
        }
        return Maps.newHashMap();
    }

    /**
     * 产品信息
     * @param values
     * @return
     */
    private Map<String, ProductVo> getProductVoMap(Collection<AuditHandleEditImportVo> values) {
        List<String> productCodes =values.stream().map(AuditHandleEditImportVo::getProductCode).collect(Collectors.toList());
        List<ProductVo> productVos = productVoService.findByProductCodes(productCodes);
        return CollectionUtils.isNotEmpty(productVos)
                ? productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 陈本中心
     * @param values
     * @return
     */
    private Map<String, CostCenterVo> getCostCenterVoMap(Collection<AuditHandleEditImportVo> values) {
        List<String> costCenterCodes =values.stream().filter(a-> StringUtils.isNotEmpty(a.getCostCenterCode())).map(AuditHandleEditImportVo::getCostCenterCode).collect(Collectors.toList());
        List<CostCenterVo> costCenterVos = CollectionUtils.isNotEmpty(costCenterCodes)
                ? this.costCenterVoService.findByCodeList(costCenterCodes)
                : Lists.newArrayList();
        return CollectionUtils.isNotEmpty(costCenterVos)
                ? costCenterVos.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 会计科目
     * @param values
     * @return
     */
    private Map<String, AccountSubjectVo> getAccountSubjectVoMap(Collection<AuditHandleEditImportVo> values) {
        List<String> accountSubjectCodes =values.stream().map(AuditHandleEditImportVo::getReimburseItemCode).collect(Collectors.toList());
        List<AccountSubjectVo> accountSubjectVos = this.accountSubjectService.findListByCode(accountSubjectCodes);
        return CollectionUtils.isNotEmpty(accountSubjectVos)
                ? accountSubjectVos.stream().collect(Collectors.toMap(AccountSubjectVo::getAccountSubjectCode,Function.identity()))
                : Maps.newHashMap();
    }

    @Override
    public Class<AuditHandleEditImportVo> findCrmExcelVoClass() {
        return AuditHandleEditImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "audit_handle_edit_imports";
    }

    @Override
    public String getTemplateName() {
        return "直接上账编辑导入";
    }

    @Override
    public Integer getBatchCount() {
        return 10000;
    }
}
