package com.biz.crm.tpm.business.audit.handle.local.service.imports;

import cn.hutool.core.collection.CollUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.businessunit.sdk.service.MdmBusinessUnitVoService;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.constant.AuditHandleConstant;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleImportVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName AuditHandleImportProcess
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/31 16:41
 **/
@Component
@Slf4j
public class AuditHandleImportProcess implements ImportProcess<AuditHandleImportVo> {


    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    AuditHandleSdkService auditHandleSdkService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private MdmBusinessUnitVoService mdmBusinessUnitVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private YearBudgetSdkService yearBudgetSdkService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired
    private AccountSubjectService accountSubjectService;

    @Autowired
    private AuditInvoiceManageService auditInvoiceManageService;

    @Autowired
    private CostCenterVoService costCenterVoService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private CustomerChannelVoService customerChannelVoService;

    @Autowired(required = false)
    private AuditHandleCacheService auditHandleCacheService;



    /**
     * 单次缓存的数量
     *
     * @return
     */
    @Override
    public Integer getBatchCount() {
        return 5000;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditHandleImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {

        Map<Integer,String> errorMap = new HashMap<>();
        try {
            log.info("批量导入手动上账++++++++++++++++++++++++++++");
            log.info("批量导入手动上账导入数据：{}", JsonUtils.obj2JsonString(data.values()));
            Validate.notNull(data, "导入数据不能为空！");
            Validate.isTrue(data.values().size() <= getBatchCount(), "单次导入数据不能超过%s条", getBatchCount());

            List<AuditHandle> auditHandleList = Lists.newArrayList();
            List<AuditHandleDetail> auditHandleDetailList = Lists.newArrayList();
            List<AuditHandleInvoice> auditHandleInvoiceList = Lists.newArrayList();
            errorMap = this.validate(data,auditHandleList,auditHandleDetailList,auditHandleInvoiceList);

            if(CollectionUtils.isEmpty(errorMap.keySet())) {
                auditHandleCacheService.saveBatch(auditHandleList,auditHandleDetailList,auditHandleInvoiceList);
            }
        }catch (Exception e){
            log.info("批量导入手动上账报错", e);
            throw e;
        }
        log.info("批量导入手动上账--------------------------");
        log.info("批量导入手动上账errorMap.key:{},value:{}",JsonUtils.obj2JsonString(errorMap.keySet()),JsonUtils.obj2JsonString(errorMap.values()));
        return errorMap;
    }

    private Map<Integer, String> validate(LinkedHashMap<Integer, AuditHandleImportVo> data, List<AuditHandle> auditHandleList, List<AuditHandleDetail> auditHandleDetailList,List<AuditHandleInvoice> auditHandleInvoiceList) {

        Map<Integer,String> errorMap = new HashMap<>();

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");

        // 获取业态字典信息
        Map<String,String> businessFormatMap = this.getBusinessFormatDict();
        // 业务单元
        Map<String,MdmBusinessUnitVo> businessUnitVoMap = this.getBusinessUnitVoMap(data.values());

        data.forEach((key,value)->{
            // 业态信息
            String businessFormatCode = businessFormatMap.get(value.getBusinessFormatCode());
            if(StringUtils.isNotEmpty(businessFormatCode)){
                value.setBusinessFormatCode(businessFormatCode);
            }
            // 业务单元
            MdmBusinessUnitVo mdmBusinessUnitVo = businessUnitVoMap.get(value.getBusinessUnitCode());
            if(Objects.nonNull(mdmBusinessUnitVo)){
                value.setBusinessUnitCode(mdmBusinessUnitVo.getBusinessUnitCode());
            }
        });

        //部门
        Map<String,OrgVo> orgVoMap = this.getDepartmentVoMap(data.values());
        //渠道
        Map<String, CustomerChannelVo> channelVoMap = this.getChannelVoMap(data.values());
        // 销售组织信息
        Map<String,SalesOrgVo> salesOrgVoMap = this.getSalesOrgVoMap(data.values());
        // 客户信息
        Map<String,CustomerVo> customerVoMap = this.getCustomerVoMap(data.values());
        // 年度预算
        Map<String,YearBudgetVo> yearBudgetVoMap = this.getYearBudgetVoMap(data.values());
        // 活动分类管理
        Map<String,ActivityTypeVo> activityTypeVoMap = this.getActivityTYpeVoMap(data.values());
        //活动形式
        Map<String, ActivityFormVo> activityFormVoMap = this.getActivityFormVoMap(data.values());
        // 产品信息
        Map<String,ProductVo> productVoMap = this.getProductVoMap(data.values());
        // 会计科目
        Map<String,AccountSubjectVo> accountSubjectVoMap = this.getAccountSubjectVoMap(data.values());
        // 成本中心
        Map<String,CostCenterVo> costCenterVoMap = this.getCostCenterVoMap(data.values());

        List<String> invoices = new ArrayList<>();
        data.forEach((key,value)->{
            List<String> errorList = validate2(value);

            List<AuditHandleInvoice> auditHandleInvoices = new ArrayList<>();
            // 填写发票号码和发票代码时，校验本次实报费用≤发票金额
            if(StringUtils.isNotEmpty(value.getInvoiceCode()) && StringUtils.isEmpty(value.getInvoiceNumber())){
                errorList.add("填写了发票代码，发票号码不能为空");
            }
            if(StringUtils.isEmpty(value.getInvoiceCode()) && StringUtils.isNotEmpty(value.getInvoiceNumber())){
                errorList.add("填写了发票号码，发票代码不能为空");
            }
            if (StringUtils.isNotEmpty(value.getInvoiceCode()) && StringUtils.isNotEmpty(value.getInvoiceNumber())) {
                String[] invoiceCodes = value.getInvoiceCode().split(",");
                String[] invoiceNumbers = value.getInvoiceNumber().split(",");
                if(invoiceNumbers.length != invoiceNumbers.length){
                    errorList.add("发票号码和发票代码不匹配");
                }else {
                    List<AuditInvoiceManageDto> dtoList = new ArrayList<>();
                    for (int i = 0; i < invoiceCodes.length; i++) {
                        String invoiceCode = invoiceCodes[i];
                        String invoiceNumber = invoiceNumbers[i];
                        AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
                        auditInvoiceManageDto.setInvoiceCode(invoiceCode);
                        auditInvoiceManageDto.setInvoiceNo(invoiceNumber);
                        String invoice = StringUtils.isEmpty(invoiceCode)?invoiceNumber:invoiceCode+":"+invoiceNumber;
                        invoices.add(invoice);
                        dtoList.add(auditInvoiceManageDto);
                    }
                    List<AuditInvoiceItemVo> invoiceItemVos = auditInvoiceManageService.findByInvoiceNoCode(dtoList);
                    if (CollectionUtils.isEmpty(invoiceItemVos)){
                        errorList.add("未查询到对应的发票或者发票已经被使用");
                    }else {
                        if (CollUtil.isNotEmpty(invoiceItemVos)) {
                            auditHandleInvoices = (List<AuditHandleInvoice>) nebulaToolkitService.copyCollectionByWhiteList(invoiceItemVos, AuditInvoiceItemVo.class, AuditHandleInvoice.class, HashSet.class, ArrayList.class);
                        }
                    }
                }
            }

            AuditHandle auditHandle = new AuditHandle();
            AuditHandleDetail auditHandleDetail = new AuditHandleDetail();
            // 新增
            BeanUtils.copyProperties(value,auditHandle);

            auditHandle.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            auditHandle.setTenantCode(TenantUtils.getTenantCode());
            auditHandle.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            auditHandle.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            BeanUtils.copyProperties(value,auditHandleDetail);
//            auditHandleDetail.setActivityPrice(stringTransformBigDecimal(value.getActivityPrice(),"活动价",errorList));
//            auditHandleDetail.setProductPrice(stringTransformBigDecimal(value.getProductPrice(),"产品单价",errorList));
//            auditHandleDetail.setDiscountTaxRate(stringTransformBigDecimal(value.getDiscountTaxRate(),"折扣税率",errorList));
//            auditHandleDetail.setDiscountShouldHandleAmount(stringTransformBigDecimal(value.getDiscountShouldHandleAmount(),"折扣应处理金额",errorList));
//            auditHandleDetail.setDiscountDeductionTaxAmount(stringTransformBigDecimal(value.getDiscountDeductionTaxAmount(),"折扣扣税金额",errorList));
//            auditHandleDetail.setInFeePoolAmount(stringTransformBigDecimal(value.getInFeePoolAmount(),"入费用池金额",errorList));
//            auditHandleDetail.setReimburseTaxRate(stringTransformBigDecimal(value.getReimburseTaxRate(),"报销税率",errorList));
//            auditHandleDetail.setReimburseAmountTax(stringTransformBigDecimal(value.getReimburseAmountTax(),"报销金额(含税)",errorList));
//            auditHandleDetail.setReimburseAmountNoTax(stringTransformBigDecimal(value.getReimburseAmountNoTax(),"报销金额(未税)",errorList));
//            auditHandleDetail.setTaxAmount(stringTransformBigDecimal(value.getTaxAmount(),"税额",errorList));
//            auditHandleDetail.setPersonalTaxAmount(stringTransformBigDecimal(value.getPersonalTaxAmount(),"个人所得税",errorList));
//            auditHandleDetail.setHeadquartersUndertakeAmount(stringTransformBigDecimal(value.getHeadquartersUndertakeAmount(),"总部承担金额",errorList));
//            auditHandleDetail.setRegionUndertakeAmount(stringTransformBigDecimal(value.getRegionUndertakeAmount(),"大区承担金额",errorList));
            auditHandleDetail.setApplyFee(stringTransformBigDecimal(value.getApplyFee(),"申请费用",errorList));
            auditHandleDetail.setDeductTaxAmount(stringTransformBigDecimal(value.getDeductTaxAmount(),"扣税金",errorList));
            auditHandleDetail.setThisAuditAmountNotTax(stringTransformBigDecimal(value.getThisAuditAmountNotTax(),"本次实报费用",errorList));
            auditHandleDetail.setThisAuditAmountTax(stringTransformBigDecimal(value.getThisAuditAmountTax(),"本次应报费用",errorList));
            auditHandleDetail.setOtherDeductAmount(stringTransformBigDecimal(value.getOtherDeductAmount(),"其他扣款",errorList));
            auditHandleDetail.setFeeYearMonth(stringTransformDate(value.getFeeYearMonth(),"费用所属年月",sdf,errorList));
            auditHandleDetail.setActivityBeginDate(stringTransformDate(value.getActivityBeginDate(),"活动开始时间",sdf2,errorList));
            auditHandleDetail.setActivityEndDate(stringTransformDate(value.getActivityEndDate(),"活动开始时间",sdf2,errorList));
            if(StringUtils.isNotEmpty(value.getActivityBeginDate())&&StringUtils.isNotEmpty(value.getActivityEndDate())) {
                verifyIsTwoMonth(value.getActivityBeginDate(), value.getActivityEndDate(), errorList);
            }
            auditHandle.setAppendices(stringTransformInter(value.getAppendices(),"附单据张数",errorList));
            auditHandleDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            auditHandleDetail.setTenantCode(TenantUtils.getTenantCode());
            auditHandleDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());

            if(EndCaseFormEnum.DISCOUNT.getCode().equals(auditHandleDetail.getEndCaseForm())){
                auditHandleDetail.setUpAccountStatus(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode());
            }
            if(EndCaseFormEnum.REIMBURSE.getCode().equals(auditHandleDetail.getEndCaseForm())){
                auditHandle.setUpAccountStatusReimburse(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode());
            }

            //部门
            OrgVo orgVo = orgVoMap.get(value.getDepartmentCode());
            if(Objects.isNull(orgVo)){
                errorList.add("未找到部门信息");
            }else {
                auditHandle.setDepartmentName(orgVo.getOrgName());
            }
            //渠道
            CustomerChannelVo customerChannelVo = channelVoMap.get(value.getChannelCode());
            if(Objects.isNull(customerChannelVo)){
                errorList.add("未找到渠道信息");
            }else {
                auditHandleDetail.setChannelName(customerChannelVo.getCustomerChannelName());
            }
            // 销售组织
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(value.getChannelCode());
            salesOrgCode.append(auditHandle.getBusinessFormatCode());
            salesOrgCode.append(value.getCompanyCode());
            SalesOrgVo salesOrgVo = salesOrgVoMap.get(salesOrgCode.toString());
            if(Objects.isNull(salesOrgVo)){
                errorList.add("未找到销售组织信息");
            }else {
                auditHandle.setCompanyName(salesOrgVo.getSalesOrgName());
            }
            // 销售部门
            salesOrgCode.append(value.getSalesOrgCode());
            SalesOrgVo salesOrgDepartmentVo = salesOrgVoMap.get(salesOrgCode.toString());
            if(Objects.isNull(salesOrgDepartmentVo)){
                errorList.add("销售部门不属于销售机构");
            }else {
                auditHandleDetail.setSalesOrgName(salesOrgDepartmentVo.getSalesOrgName());
            }

            // 销售组
            salesOrgCode.append(value.getSalesGroupCode());
            SalesOrgVo salesOrgGroupVo = salesOrgVoMap.get(salesOrgCode.toString());
            if(Objects.isNull(salesOrgGroupVo)){
                errorList.add("销售组不属于销售部门");
            }else {
                auditHandleDetail.setSalesGroupName(salesOrgGroupVo.getSalesOrgName());
            }
            // 客户信息
            StringBuffer customerCode = new StringBuffer();
            customerCode.append(value.getCustomerCode());
            customerCode.append(value.getCompanyCode());
            customerCode.append(value.getChannelCode());
            customerCode.append(value.getBusinessFormatCode());
            CustomerVo customerVo = customerVoMap.get(customerCode.toString());
            if(Objects.isNull(customerVo)){
                errorList.add("未找到客户信息");
            }else {
                auditHandleDetail.setCustomerName(customerVo.getCustomerName());
            }
            // 年度预算
            YearBudgetVo yearBudgetVo = yearBudgetVoMap.get(value.getYearBudgetCode());
            if(Objects.isNull(yearBudgetVo)){
                errorList.add("未找到年度预算科目信息");
            }else {
                auditHandleDetail.setYearBudgetName(yearBudgetVo.getBudgetItemName());
            }

            // 活动分类
            ActivityTypeVo activityTypeVo = activityTypeVoMap.get(value.getActivityTypeCode());
            if(Objects.isNull(activityTypeVo)){
                errorList.add("未找到活动分类信息");
            }else {
                auditHandleDetail.setActivityTypeName(activityTypeVo.getActivityTypeName());
            }

            ActivityFormVo activityFormVo = activityFormVoMap.get(value.getActivityFormCode());
            if(Objects.isNull(activityFormVo)){
                errorList.add("未找到活动形式信息");
            }else {
                auditHandleDetail.setActivityFormName(activityFormVo.getActivityFormName());
            }

            // 产品信息
            ProductVo productVo = productVoMap.get(value.getProductCode());
            if(Objects.isNull(productVo)) {
                errorList.add("未找到年度预算科目产品信息");
            }else {
                auditHandleDetail.setProductName(productVo.getProductName());
                auditHandleDetail.setProductBrandCode(productVo.getProductBrandCode());
                auditHandleDetail.setProductBrandName(productVo.getProductBrandName());
                auditHandleDetail.setProductCategoryCode(productVo.getProductCategoryCode());
                auditHandleDetail.setProductCategoryName(productVo.getProductCategoryName());
                auditHandleDetail.setProductItemCode(productVo.getProductLevelCode());
                auditHandleDetail.setProductItemName(productVo.getProductLevelName());
            }

            // 会计科目
            if (value.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())) {
                AccountSubjectVo accountSubjectVo = accountSubjectVoMap.get(value.getReimburseItemCode());
                if(Objects.isNull(accountSubjectVo)) {
                    errorList.add("未找到会计科目信息");
                }else {
                    auditHandleDetail.setReimburseItemName(accountSubjectVo.getAccountSubjectName());
                }
            }
            // 利润中心
            if (StringUtils.isNotEmpty(value.getCostCenterCode())) {
                CostCenterVo costCenterVo = costCenterVoMap.get(value.getCostCenterCode());
                if(Objects.isNull(costCenterVo)) {
                    errorList.add("未找到成本中心信息");
                }else {
                    auditHandleDetail.setCostCenterName(costCenterVo.getCostCenterName());
                    auditHandleDetail.setProfitCenterCode(costCenterVo.getProfitCenterCode());
                    auditHandleDetail.setProfitCenterName(costCenterVo.getProfitCenterName());
                }
            }
            String auditHandleCode = this.generateCodeService.generateCode(AuditHandleConstant.AUDIT_HANDLE_PREFIX, 1, 9, 0, TimeUnit.DAYS).get(0);
            //去掉年
            auditHandle.setAuditHandleCode(auditHandleCode);
            for (AuditHandleInvoice item : auditHandleInvoices) {
                item.setAuditHandleCode(auditHandleCode);
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            }
            // 明细信息
//            String auditHandleDetailCode = this.generateCodeService.generateCode(AuditHandleConstant.AUDIT_HANDLE_DETAIL_PREFIX, 1, 8, 0, TimeUnit.DAYS).get(0);
            auditHandleDetail.setAuditHandleCode(auditHandleCode);
            auditHandleDetail.setAuditHandleDetailCode(auditHandleCode);
            auditHandleList.add(auditHandle);
            auditHandleDetail.setInvoiceNumber(null);
            auditHandleDetail.setInvoiceCode(null);
            auditHandleDetailList.add(auditHandleDetail);
            auditHandleInvoiceList.addAll(auditHandleInvoices);
            if(CollectionUtils.isNotEmpty(errorList)) {
                errorMap.put(key, String.join(",", errorList));
            }
        });
        if(CollectionUtils.isNotEmpty(invoices)) {
            Map<String, List<String>> invoicesMap = invoices.stream().collect(Collectors.groupingBy(o -> o));
            invoicesMap.forEach((key,value)->{
                Validate.isTrue(value.size()<=1,"发票【%s】存在多行，不能重复导入",key);
            });
        }
        return errorMap;
    }

    private String disposeYear(String auditHandleCode) {
        return AuditHandleConstant.AUDIT_HANDLE_PREFIX + auditHandleCode.substring(AuditHandleConstant.AUDIT_HANDLE_PREFIX.length()+4);
    }

    private void verifyIsTwoMonth(String activityBeginDate, String activityEndDate, List<String> errorList) {
        //2023-10
        if(!activityBeginDate.substring(0,7).equals(activityEndDate.substring(0,7))){
            errorList.add("活动开始结束时间不允许跨月");
        }
    }

    private Integer stringTransformInter(String orderNumber, String msg, List<String> errorList) {
        if(StringUtils.isEmpty(orderNumber)){
            return 0;
        }
        int i = 0;
        try {
            i = Integer.parseInt(orderNumber);
        }catch (Exception e){
            errorList.add(msg+"不是数字");
        }
        return i;
    }

    private Date stringTransformDate(String feeYearMonth, String msg, SimpleDateFormat sdf, List<String> errorList) {
        if(StringUtils.isEmpty(feeYearMonth)){
            return null;
        }
        Date result = null;
        try {
             result = sdf.parse(feeYearMonth);
        }catch (Exception e){
            errorList.add(msg+"时间格式不对");
        }
        return result;
    }

    private Map<String, CustomerChannelVo> getChannelVoMap(Collection<AuditHandleImportVo> values) {

        Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
        List<String> channelCodes = values.stream().map(AuditHandleImportVo::getChannelCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(channelCodes)){
            List<CustomerChannelVo> customerChannelVos = customerChannelVoService.findByCodes(channelCodes);
            customerChannelVoMap = customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
        }
        return customerChannelVoMap;
    }

    private Map<String, OrgVo> getDepartmentVoMap(Collection<AuditHandleImportVo> values) {
        List<String> departmentCodes = values.stream().map(AuditHandleImportVo::getDepartmentCode).collect(Collectors.toList());
        Map<String, OrgVo> orgVoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(departmentCodes)){
            List<OrgVo> orgVos = orgVoService.findByOrgCodes(departmentCodes);
            orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        }
        return orgVoMap;
    }

    private BigDecimal stringTransformBigDecimal(String arguments, String msg, List<String> errorList) {
        if(StringUtils.isEmpty(arguments)){
            return BigDecimal.ZERO;
        }
        if(!isValidNumber(arguments)){
            errorList.add(msg+"不是数字,请检查");
            return BigDecimal.ZERO;
        }else {
            if(!isValidDecimals(arguments)){
                errorList.add(msg+"请保留两位小数");
                return BigDecimal.ZERO;
            }else {
                return new BigDecimal(arguments);
            }
        }
    }

    private static boolean isValidNumber(String str) {
        String reg = "^-?[0-9]+(.[0-9]+)?$";
        return str.matches(reg);
    }

    private boolean isValidDecimals(String str) {
        String reg = "^(\\-)?[0-9]+(\\.[0-9]{0,2})?$";
        return str.matches(reg);
    }

    private Map<String, ActivityFormVo> getActivityFormVoMap(Collection<AuditHandleImportVo> values) {

        List<String> activityFormCodes = values.stream().map(AuditHandleImportVo::getActivityFormCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(activityFormCodes)){
            List<ActivityFormVo> activityFormVoList = this.activityFormService.findByCodes(activityFormCodes);
            if(CollectionUtils.isNotEmpty(activityFormVoList)){
                Map<String, ActivityFormVo> activityFormVoMap = activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
                return activityFormVoMap;
            }
        }
        return Maps.newHashMap();
    }

    /**
     * 陈本中心
     * @param values
     * @return
     */
    private Map<String, CostCenterVo> getCostCenterVoMap(Collection<AuditHandleImportVo> values) {
        List<String> costCenterCodes =values.stream().filter(a-> StringUtils.isNotEmpty(a.getCostCenterCode())).map(AuditHandleImportVo::getCostCenterCode).collect(Collectors.toList());
        List<CostCenterVo> costCenterVos = CollectionUtils.isNotEmpty(costCenterCodes)
                ? this.costCenterVoService.findByCodeList(costCenterCodes)
                : Lists.newArrayList();
        return CollectionUtils.isNotEmpty(costCenterVos)
                ? costCenterVos.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 会计科目
     * @param values
     * @return
     */
    private Map<String, AccountSubjectVo> getAccountSubjectVoMap(Collection<AuditHandleImportVo> values) {
        List<String> accountSubjectCodes =values.stream().map(AuditHandleImportVo::getReimburseItemCode).collect(Collectors.toList());
        List<AccountSubjectVo> accountSubjectVos = this.accountSubjectService.findListByCode(accountSubjectCodes);
        return CollectionUtils.isNotEmpty(accountSubjectVos)
                ? accountSubjectVos.stream().collect(Collectors.toMap(AccountSubjectVo::getAccountSubjectCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 产品信息
     * @param values
     * @return
     */
    private Map<String, ProductVo> getProductVoMap(Collection<AuditHandleImportVo> values) {
        List<String> productCodes =values.stream().map(AuditHandleImportVo::getProductCode).collect(Collectors.toList());
        List<ProductVo> productVos = productVoService.findByProductCodes(productCodes);
        return CollectionUtils.isNotEmpty(productVos)
                ? productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 活动分类
     * @param values
     * @return
     */
    private Map<String, ActivityTypeVo> getActivityTYpeVoMap(Collection<AuditHandleImportVo> values) {
        List<String> activityTypeCodes = values.stream().map(AuditHandleImportVo::getActivityTypeCode).collect(Collectors.toList());
        List<ActivityTypeVo> activityTypeVos = activityTypeService.findByCodes(activityTypeCodes);
        return CollectionUtils.isNotEmpty(activityTypeVos)
                ? activityTypeVos.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 年度预算
     * @param values
     * @return
     */
    private Map<String, YearBudgetVo> getYearBudgetVoMap(Collection<AuditHandleImportVo> values) {
        List<String> yearBudgetCodes =values.stream().map(AuditHandleImportVo::getYearBudgetCode).collect(Collectors.toList());
        List<YearBudgetVo> yearBudgetVos = this.yearBudgetSdkService.findByYearBudgetCodes(yearBudgetCodes);
        return CollectionUtils.isNotEmpty(yearBudgetVos)
                ? yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 客户信息
     * @param values
     * @return
     */
    private Map<String, CustomerVo> getCustomerVoMap(Collection<AuditHandleImportVo> values) {
        List<String> customerCodes = values.stream().map(a -> {
            StringBuffer customerCode = new StringBuffer();
            customerCode.append(a.getCustomerCode());
            customerCode.append(a.getCompanyCode());
            customerCode.append(a.getChannelCode());
            customerCode.append(a.getBusinessFormatCode());
            return customerCode.toString();
        }).collect(Collectors.toList());
        List<CustomerVo> customerVos = this.customerVoService.findByCustomerCodes(customerCodes);
        return CollectionUtils.isNotEmpty(customerVos)
                ? customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 销售组织信息
     * @param values
     * @return
     */
    private Map<String, SalesOrgVo> getSalesOrgVoMap(Collection<AuditHandleImportVo> values) {
        List<String> salesOrgCodes = values.stream().map(a -> {
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(a.getChannelCode());
            salesOrgCode.append(a.getBusinessFormatCode());
            salesOrgCode.append(a.getCompanyCode());
            return salesOrgCode.toString();
        }).collect(Collectors.toList());
        List<String> salesOrgDepartmentCodes = values.stream().map(a -> {
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(a.getChannelCode());
            salesOrgCode.append(a.getBusinessFormatCode());
            salesOrgCode.append(a.getCompanyCode());
            salesOrgCode.append(a.getSalesOrgCode());
            return salesOrgCode.toString();
        }).collect(Collectors.toList());
        List<String> salesOrgGroupCodes = values.stream().map(a -> {
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(a.getChannelCode());
            salesOrgCode.append(a.getBusinessFormatCode());
            salesOrgCode.append(a.getCompanyCode());
            salesOrgCode.append(a.getSalesOrgCode());
            salesOrgCode.append(a.getSalesGroupCode());
            return salesOrgCode.toString();
        }).collect(Collectors.toList());
        List<String> list = Lists.newArrayList();
        list.addAll(salesOrgCodes);
        list.addAll(salesOrgDepartmentCodes);
        list.addAll(salesOrgGroupCodes);
        List<SalesOrgVo> salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(list);
        return CollectionUtils.isNotEmpty(salesOrgVos)
                ? salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode,Function.identity()))
                : Maps.newHashMap();
    }

    /**
     * 业务单元
     * @param values
     * @return
     */
    private Map<String, MdmBusinessUnitVo> getBusinessUnitVoMap(Collection<AuditHandleImportVo> values) {
        List<String> businessUnitCodes = values.stream().map(AuditHandleImportVo::getBusinessUnitCode).collect(Collectors.toList());
        List<MdmBusinessUnitVo> businessUnitVos = this.mdmBusinessUnitVoService.findByNames(businessUnitCodes);
        return CollectionUtils.isNotEmpty(businessUnitVos)
                ? businessUnitVos.stream().collect(Collectors.toMap(MdmBusinessUnitVo::getBusinessUnitName,Function.identity()))
                : Maps.newHashMap();
    }


    @Override
    public Class<AuditHandleImportVo> findCrmExcelVoClass() {
        return AuditHandleImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_AUDIT_HANDLE_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-手动上账导入";
    }

    /**
     * 导入验证
     * @param o     导入数据
     */
    private List<String> validate2(AuditHandleImportVo o){

        List<String> errorList = new ArrayList<>();
        if(StringUtils.isEmpty(o.getBusinessFormatCode())){
            errorList.add("数据导入数据时，业态不能为空");
        }
        if(StringUtils.isEmpty(o.getBusinessUnitCode())){
            errorList.add("数据导入数据时，业务单元不能为空");
        }
        if(StringUtils.isEmpty(o.getDepartmentCode())) {
            errorList.add("数据导入数据时，所属部门编码不能为空");
        }
        if(StringUtils.isEmpty(o.getCompanyCode())) {
            errorList.add("数据导入数据时，公司编码不能为空");
        }
        if(StringUtils.isEmpty(o.getSalesOrgCode())) {
            errorList.add("数据导入数据时，销售部门编码不能为空");
        }
        if(StringUtils.isEmpty(o.getChannelCode())) {
            errorList.add("数据导入数据时，渠道编码不能为空");
        }
        if(StringUtils.isEmpty(o.getCustomerCode())) {
            errorList.add("数据导入数据时，客户编码不能为空");
        }
        if(StringUtils.isEmpty(o.getFeeYearMonth())) {
            errorList.add("数据导入数据时，费用所属年月不能为空");
        }
        if(StringUtils.isEmpty(o.getYearBudgetCode())) {
            errorList.add("数据导入数据时，年度预算编码不能为空");
        }
        if(StringUtils.isEmpty(o.getActivityTypeCode())) {
            errorList.add("数据导入数据时，活动分类编码不能为空");
        }
        if(StringUtils.isEmpty(o.getActivityFormCode())) {
            errorList.add("数据导入数据时，活动形式编码不能为空");
        }
        if(StringUtils.isEmpty(o.getProductBrandCode())) {
            errorList.add("数据导入数据时，品牌编码不能为空");
        }
        if(StringUtils.isEmpty(o.getProductCode())) {
            errorList.add("数据导入数据时，产品编码不能为空");
        }
        if(StringUtils.isEmpty(o.getActivityBeginDate())) {
            errorList.add("数据导入数据时，活动开始时间不能为空");
        }
        if(StringUtils.isEmpty(o.getActivityEndDate())) {
            errorList.add("数据导入数据时活动结束时间不能为空");
        }
        if(StringUtils.isEmpty(o.getApplyFee())) {
            errorList.add("数据导入数据时，申请费用不能为空");
        }
        if(StringUtils.isEmpty(o.getThisAuditAmountTax())) {
            errorList.add("数据导入数据时，本次应报费用不能为空");
        }
        if(StringUtils.isEmpty(o.getThisAuditAmountNotTax())) {
            errorList.add("数据导入数据时，本次实报费用不能为空");
        }
        if(StringUtils.isEmpty(o.getLookLikeSale())) {
            errorList.add("数据导入数据时，是否视同销售不能为空");
        }else {
            o.setLookLikeSale(YesOrNoEnum.getByValue(o.getLookLikeSale()));
        }
        if(StringUtils.isEmpty(o.getEndCaseForm())) {
            errorList.add("数据导入数据时，结案方式不能为空");
        }else {
            o.setEndCaseForm(EndCaseFormEnum.transitionStr(o.getEndCaseForm()));
        }
        if (o.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())) {
            if(StringUtils.isEmpty(o.getReimburseItemCode())) {
                errorList.add("结案方式含有报销时,报销项目编码不能为空");
            }
            if(StringUtils.isEmpty(o.getCostCenterCode())) {
                errorList.add("结案方式含有报销时,成本中心编码不能为空");
            }
            if(StringUtils.isEmpty(o.getInvoiceCode())&&StringUtils.isEmpty(o.getInvoiceNumber())){
                errorList.add("结案方式含有报销时,发票信息不能为空");
            }
        }
        return errorList;
    }

    /**
     * 获取业态数据字典：mdm_business_format
     * @return Map key:编码，value:名称
     */
    private Map<String, String> getBusinessFormatDict() {
        List<DictDataVo> dictDataVoList = this.dictDataVoService.findByDictTypeCode(AuditHandleConstant.BUSINESS_FORMAT_CODE_DICT_CODE);
        if (CollectionUtils.isEmpty(dictDataVoList)) {
            return Maps.newHashMap();
        }
        return dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictValue,DictDataVo::getDictCode));
    }




}
