package com.biz.crm.tpm.business.audit.handle.local.service.internal.impl;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleRepository;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @ClassName AuditHandleCacheServiceImpl
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/3 15:57
 **/
@Service
@Slf4j
public class AuditHandleCacheServiceImpl extends MnPageCacheServiceImpl<AuditHandleDetailVo, AuditHandleDetailDto> implements AuditHandleCacheService {

    @Autowired(required = false)
    private AuditHandleRepository auditHandleRepository;

    @Autowired(required = false)
    private AuditHandleDetailRepository auditHandleDetailRepository;

    @Autowired(required = false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;

    @Autowired
    private AuditInvoiceManageService auditInvoiceManageService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBatch(List<AuditHandle> auditHandleList, List<AuditHandleDetail> auditHandleDetailList, List<AuditHandleInvoice> auditHandleInvoiceList) {
        if(CollectionUtils.isNotEmpty(auditHandleList)) {
            log.info("批量导入手动上账，保存抬头：{}", JsonUtils.obj2JsonString(auditHandleList));
            this.auditHandleRepository.saveBatch(auditHandleList);
        }
        if(CollectionUtils.isNotEmpty(auditHandleDetailList)) {
//            List<String> upAccountCodes = new ArrayList<>();
//            upAccountCodes = this.generateCodeService.generateCode(AuditHandleConstant.UP_ACCOUNT_CODE, auditHandleDetailList.size(), 8, 2, TimeUnit.DAYS);
//            for (int i = 0; i < auditHandleDetailList.size(); i++) {
//                AuditHandleDetail o = auditHandleDetailList.get(i);
//                o.setUpAccountCode(upAccountCodes.get(i));
//            }
            log.info("批量导入手动上账，保存明细：{}",JsonUtils.obj2JsonString(auditHandleDetailList));
            this.auditHandleDetailRepository.saveBatch(auditHandleDetailList);
        }
        if(CollectionUtils.isNotEmpty(auditHandleInvoiceList)){
            this.auditHandleInvoiceRepository.saveBatch(auditHandleInvoiceList);
            List<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<>();
            for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
                AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
                dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
                dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
                invoiceManageDtoList.add(dto);
            }
            String useDate = DateUtil.format(new Date(), "yyyy-MM");
            auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.YES.getCode(), useDate);
        }
    }
}
