package com.biz.crm.tpm.business.audit.handle.local.service.internal.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleInvoiceCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleInvoiceDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleSaveInvoiceCacheDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleInvoiceVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Author : dengwei
 * @Date :2023/10/8  21:54
 * @Description: 发票
 */
@Service
@Slf4j
public class AuditHandleInvoiceCacheServiceImpl extends MnPageCacheServiceImpl<AuditHandleInvoiceVo, AuditHandleInvoiceDto> implements AuditHandleInvoiceCacheService {

    @Autowired(required = false)
    private AuditInvoiceManageService auditInvoiceManageService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;
    @Override
    public void saveInvoiceCache(AuditHandleSaveInvoiceCacheDto dto) {
        Validate.notNull(dto, "输入参数不能为空");
        String cacheKey = dto.getCacheKey();
        Validate.notBlank(cacheKey, "缓存key不能为空");
        String auditHandleCode = dto.getAuditHandleCode();
        Validate.notBlank(auditHandleCode,"直接上账编码");
        if(CollectionUtils.isEmpty(dto.getAuditHandleInvoiceDtoList())){
            return;
        }
        List<AuditInvoiceManageDto> invoiceManageDtos = new ArrayList<>();
        for (AuditHandleInvoiceDto auditHandleDto : dto.getAuditHandleInvoiceDtoList()) {
            String invoiceCode = auditHandleDto.getInvoiceCode();
            String invoiceNumber = auditHandleDto.getInvoiceNumber();
            AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
            auditInvoiceManageDto.setInvoiceNo(invoiceNumber);
            auditInvoiceManageDto.setInvoiceCode(invoiceCode);
            invoiceManageDtos.add(auditInvoiceManageDto);
        }
        List<AuditHandleInvoiceDto> auditHandleInvoiceDtoList = new ArrayList<>();
        List<AuditInvoiceItemVo> invoiceItemVos = auditInvoiceManageService.findByInvoiceNoCode(invoiceManageDtos);
        log.info("直接上账保存缓存:invoiceItemVos:{}", JsonUtils.obj2JsonString(invoiceItemVos));
        if (CollUtil.isNotEmpty(invoiceItemVos)) {
            Collection<AuditHandleInvoiceDto> auditHandleInvoiceDtos = nebulaToolkitService.copyCollectionByWhiteList(invoiceItemVos, AuditInvoiceItemVo.class, AuditHandleInvoiceDto.class, HashSet.class, ArrayList.class);
            auditHandleInvoiceDtos.forEach(item->item.setAuditHandleCode(auditHandleCode));
            auditHandleInvoiceDtoList.addAll(auditHandleInvoiceDtos);
        }
        log.info("直接上账保存缓存:auditHandleInvoiceDtoList:{}", JsonUtils.obj2JsonString(auditHandleInvoiceDtoList));
        if(CollectionUtils.isNotEmpty(auditHandleInvoiceDtoList)) {
            this.addItemCache(cacheKey, auditHandleInvoiceDtoList);
        }
    }

    @Override
    public void invoiceSubmit(List<AuditHandleInvoiceDto> auditHandleInvoiceDtoList, String auditHandleCode) {
        if(CollectionUtils.isNotEmpty(auditHandleInvoiceDtoList)){
            for (AuditHandleInvoiceDto auditHandleInvoiceDto : auditHandleInvoiceDtoList) {
                auditHandleInvoiceDto.setId(null);
                auditHandleInvoiceDto.setTenantCode(TenantUtils.getTenantCode());
            }
            Collection<AuditHandleInvoice> auditHandleInvoices = this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleInvoiceDtoList, AuditHandleInvoiceDto.class, AuditHandleInvoice.class, LinkedHashSet.class, ArrayList.class);
            this.auditHandleInvoiceRepository.deleteByAuditHandleCode(auditHandleCode);
            this.auditHandleInvoiceRepository.saveBatch(auditHandleInvoices);

            List<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<>();
            for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices) {
                AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
                dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
                dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
                invoiceManageDtoList.add(dto);
            }
            String useDate = DateUtil.format(new Date(), "yyyy-MM");
            auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.YES.getCode(), useDate);
        }
    }

    @Override
    public void deleteAuditHandleCodeInvoiceRelation(String auditHandleCode) {
        if(StringUtils.isEmpty(auditHandleCode)){
            return;
        }
        List<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<>();
        List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCode(auditHandleCode);
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
            AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
            dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
            dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
            invoiceManageDtoList.add(dto);
        }
        auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.NO.getCode(), null);
        this.auditHandleInvoiceRepository.deleteByAuditHandleCode(auditHandleCode);
    }
}
