package com.biz.crm.tpm.business.audit.handle.local.service.internal.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.AccountingVoucherDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.ChargeAgainstAccountingVoucherDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.service.SapFiService;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.ChargeAgainstAccountingVoucherVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.SapAccountingVoucherVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.*;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleRepository;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.constant.AuditHandleConstant;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleProcessSubmitDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.log.AuditHandleLogEventDto;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.*;
import com.biz.crm.tpm.business.audit.handle.sdk.event.log.AuditHandleLogEventListener;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.*;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.UndertakeTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.AuditUseBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.FeeSourceEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditBudgetHeadVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditBudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.service.PaymentReceiptSdkService;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptPayVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptShouldVo;
import com.biz.crm.tpm.business.third.system.sdk.service.SAPCenterService;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName AuditHandleSdkServiceImpl
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/30 17:05
 **/
@Service
@Slf4j
public class AuditHandleSdkServiceImpl implements AuditHandleSdkService {

    @Autowired(required = false)
    private AuditHandleRepository auditHandleRepository;

    @Autowired(required = false)
    private AuditHandleDetailRepository auditHandleDetailRepository;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private RedisTemplate redisTemplate;

    @Autowired(required = false)
    private ProcessBatchBusinessService processBatchBusinessService;

    @Autowired(required = false)
    private SubComBudgetForecastService subComBudgetForecastService;

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private BudgetItemService budgetItemService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private SapSdApiService sapSdApiService;

    @Autowired
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private SapFiService sapFiService;

    @Autowired(required = false)
    private AuditHandleCacheService auditHandleCacheService;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;

    @Autowired(required = false)
    private AuditInvoiceManageService auditInvoiceManageService;
    @Autowired(required = false)
    private ApplicationContext applicationContext;

    @Autowired(required = false)
    private SAPCenterService sapCenterService;

    @Autowired(required = false)
    private PaymentReceiptSdkService paymentReceiptSdkService;





    @Override
    @Transactional
    public AuditHandleVo create(AuditHandleDto dto) {

        if(!SaveTypeEnum.temporary.getValue().equals(dto.getSaveType())){
            //表头校验
            this.createValidation(dto);
        }

        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());

        String auditHandleCode = this.generateCodeService.generateCode(AuditHandleConstant.AUDIT_HANDLE_PREFIX, 1, 5, 2, TimeUnit.DAYS).get(0);
        dto.setAuditHandleCode(auditHandleCode);

        //明细处理,从缓存种获取明细
//        List<AuditHandleDetailVo> detailVos = this.getDetailVosFromCache(dto.getCacheKey());
        List<AuditHandleDetailDto> detailDtos = auditHandleCacheService.findCacheList(dto.getCacheKey());
//        //验证明细
//        this.createDetailValidation(detailVos);

        List<String> auditHandleDetailCodes = this.generateCodeService.generateCode(AuditHandleConstant.AUDIT_HANDLE_PREFIX, detailDtos.size(), 8, 2, TimeUnit.DAYS);
        List<String> upAccountCodes = new ArrayList<>();
        if (StringUtils.equals(BusinessUnitEnum.HEADQUARTERS.getCode(),dto.getBusinessUnitCode())){
            upAccountCodes = this.generateCodeService.generateCode(AuditHandleConstant.UP_ACCOUNT_CODE, detailDtos.size(), 10, 2, TimeUnit.DAYS);
        }
        for (int i = 0; i < detailDtos.size(); i++) {
            String code = auditHandleDetailCodes.get(i);
            AuditHandleDetailDto detail = detailDtos.get(i);
            if (StringUtils.equals(BusinessUnitEnum.HEADQUARTERS.getCode(),dto.getBusinessUnitCode())){
                detail.setUpAccountCode(upAccountCodes.get(i));
            }

            detail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detail.setTenantCode(TenantUtils.getTenantCode());
            detail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detail.setAuditHandleDetailCode(code);
            detail.setAuditHandleCode(dto.getAuditHandleCode());
            detail.setAuditHandleName(dto.getAuditHandleName());
            detail.setUpAccountStatus(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode());
            if(CollectionUtils.isNotEmpty(detail.getEndCaseForms())) {
                detail.setEndCaseForm(Joiner.on(",").join(detail.getEndCaseForms()));
            }
        }

        List<AuditHandleDetail> auditHandleDetails = (ArrayList<AuditHandleDetail>)this.nebulaToolkitService.copyCollectionByWhiteList(detailDtos, AuditHandleDetailDto.class, AuditHandleDetail.class, HashSet.class, ArrayList.class);
        AuditHandle auditHandle = this.nebulaToolkitService.copyObjectByWhiteList(dto, AuditHandle.class, HashSet.class, ArrayList.class);


        //保存数据
        this.auditHandleRepository.save(auditHandle);
        this.auditHandleDetailRepository.saveBatch(auditHandleDetails);

        if(SaveTypeEnum.submit.getValue().equals(dto.getSaveType())){
            dto.setId(auditHandle.getId());
            this.submitApproval(dto);
        }

        //发送新增通知
        AuditHandleLogEventDto logEventDto = new AuditHandleLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<AuditHandleLogEventListener, AuditHandleLogEventDto> onCreate =
                AuditHandleLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto,AuditHandleLogEventListener.class,onCreate);

        //构建返回参数
        List<AuditHandleDetailVo> auditHandleDetailVoList = (ArrayList<AuditHandleDetailVo>)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleDetails, AuditHandleDetail.class, AuditHandleDetailVo.class, HashSet.class, ArrayList.class);
        AuditHandleVo auditHandleVo = this.nebulaToolkitService.copyObjectByWhiteList(auditHandle, AuditHandleVo.class, HashSet.class, ArrayList.class);
        auditHandleVo.setAuditHandleDetailVoList(auditHandleDetailVoList);

        return auditHandleVo;
    }

    private void submitApproval(AuditHandleDto dto) {

        ProcessBusinessDto processBusiness = dto.getProcessBusiness();

        processBusiness.setBusinessNo(dto.getId());
        processBusiness.setProcessTitle("手动上账[" + dto.getAuditHandleName() + "]发起审批流");
        JSONObject jsonObject = JsonUtils.toJSONObject(dto);

        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode(AuditHandleConstant.TPM_AUDIT_HANDLE_PROCESS);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);

        this.auditHandleRepository.updateProcessStatusAndNoByIds(Collections.singletonList(dto.getId()), ProcessStatusEnum.COMMIT, processBusinessVo.getProcessNo());
    }


    private void createValidation(AuditHandleDto dto){
        //验证表头
        Validate.notNull(dto,"新增数据时，请求参数不能为空");
        Validate.notBlank(dto.getBusinessUnitCode(),"新增数据时，业务单元不能为空");
        Validate.notBlank(dto.getBusinessFormatCode(),"新增数据时，业态不能为空");
        Validate.notBlank(dto.getCompanyName(),"新增数据时，公司名称不能为空");
        Validate.notBlank(dto.getCompanyCode(),"新增数据时，公司编码不能为空");
        Validate.notBlank(dto.getDepartmentCode(),"新增数据时，部门编码不能为空");
        Validate.notBlank(dto.getDepartmentName(),"新增数据时，部门名称不能为空");
        Validate.notBlank(dto.getAuditHandleName(),"新增数据时，手动上账名称不能为空");

        //验证明细
        Validate.notEmpty(dto.getCacheKey(),"新增数据时，缓存key不能为空");
    }

    private void detailValidation(List<AuditHandleDetailVo> detailVos){
        Validate.notEmpty(detailVos,"新增数据时，明细数据不能为空");
        detailVos.forEach(o -> {
            Validate.notBlank(o.getUndertakingType(),"新增数据时，承接类型不能为空");
            Validate.notBlank(o.getRelationType(),"新增数据时，关联类型不能为空");
            Validate.notBlank(o.getCostManage(),"新增数据时，费用归口不能为空");
            Validate.notBlank(o.getBudgetCode(),"新增数据时，预算编码不能为空");
            Validate.notBlank(o.getCostYearMonth(),"新增数据时，费用年月不能为空");
            Validate.notBlank(o.getActivityTypeCode(),"新增数据时，活动分类编码不能为空");
            Validate.notBlank(o.getActivityTypeName(),"新增数据时，活动分类名称不能为空");
            Validate.notBlank(o.getActivityFormCode(),"新增数据时，活动形式编码不能为空");
            Validate.notBlank(o.getActivityFormName(),"新增数据时，活动形式名称不能为空");
            Validate.notBlank(o.getProductBrandCode(),"新增数据时，品牌编码不能为空");
            Validate.notBlank(o.getProductCategoryCode(),"新增数据时，品类编码不能为空");
            Validate.notBlank(o.getProductItemCode(),"新增数据时，品项编码不能为空");
            Validate.notBlank(o.getProductCode(),"新增数据时，产品编码不能为空");
            Validate.notBlank(o.getProductName(),"新增数据时，产品名称不能为空");
            Validate.notNull(o.getProductPrice(),"新增数据时，产品单价不能为空");
            Validate.notNull(o.getActivityPrice(),"新增数据时，活动价不能为空");
            Validate.notBlank(o.getCustomerCode(),"新增数据时，客户编码不能为空");
            Validate.notBlank(o.getCustomerName(),"新增数据时，客户名称不能为空");
            Validate.notBlank(o.getWhetherDeductionFeePool(),"新增数据时，是否扣减费用池不能为空");
            Validate.notBlank(o.getEndCaseForm(),"新增数据时，结案形式不能为空");

            AuditFormEnum formEnum = AuditFormEnum.findEnumByCode(o.getEndCaseForm());
            switch (formEnum){
                case DISCOUNT:
                    Validate.notNull(o.getDiscountTaxRate(),"新增数据时，折扣税率不能为空");
                    Validate.notNull(o.getDiscountShouldHandleAmount(),"新增数据时，折扣应处理金额不能为空");
                    Validate.notNull(o.getDiscountDeductionTaxAmount(),"新增数据时，折扣扣税金额不能为空");
                    Validate.notNull(o.getInFeePoolAmount(),"新增数据时，入费用池金额不能为空");
                    break;
                case REIMBURSE:
                    Validate.notBlank(o.getInvoiceCode(),"新增数据时，发票代码不能为空");
                    Validate.notBlank(o.getInvoiceNumber(),"新增数据时，发票号码不能为空");
                    Validate.notBlank(o.getReimburseItemCode(),"新增数据时，报销项目编码不能为空");
                    Validate.notNull(o.getReimburseTaxRate(),"新增数据时，报销税率不能为空");
                    Validate.notNull(o.getReimburseAmountTax(),"新增数据时，报销金额（含税）不能为空");
                    Validate.notNull(o.getReimburseAmountNoTax(),"新增数据时，报销金额（未税）不能为空");
                    Validate.notNull(o.getTaxAmount(),"新增数据时，税额不能为空");
                    Validate.notNull(o.getPersonalTaxAmount(),"新增数据时，个人所得税不能为空");
                    Validate.notNull(o.getCostCenterCode(),"新增数据时，成本中心编码不能为空");
                    Validate.notNull(o.getCostCenterName(),"新增数据时，成本中心名称不能为空");
                    Validate.notNull(o.getProfitCenterName(),"新增数据时，利润中心名称不能为空");
                    break;
                case RED_WORD_INVOICE:
                    Validate.notBlank(o.getImpulseDifferenceProductCode(),"新增数据时，冲差产品编码不能为空！");
                    Validate.notBlank(o.getImpulseDifferenceProductName(),"新增数据时，冲差产品名称不能为空！");
                    Validate.notBlank(o.getUnit(),"新增数据时，单位不能为空！");
                    Validate.notNull(o.getQuantity(),"新增数据时，数量不能为空！");
                    Validate.notBlank(o.getFactoryName(),"新增数据时，工厂不能为空！");
                    break;
            }
//            Validate.notNull(o.getCurrentAuditAmountTax(),"新增数据时，本次结案金额(含税)不能为空");
            Validate.notBlank(o.getWhetherWholeAudit(),"新增数据时，是否完全结案不能为空");
        });
    }

    @Override
    @Transactional
    public AuditHandleVo update(AuditHandleDto dto) {

        if(!SaveTypeEnum.temporary.getValue().equals(dto.getSaveType())) {
            //编辑校验
            this.updateValidation(dto);
        }

        //获取详情
        List<AuditHandleDetailDto> detailDtos = this.auditHandleCacheService.findCacheList(dto.getCacheKey());
        //校验详情
//        this.updateDetailValidation(detailDtos);

        AuditHandle old = this.auditHandleRepository.findById(dto.getId());
        Validate.notNull(old,"该数据不存在或已被删除");
        Validate.isTrue(StringUtils.equals(ProcessStatusEnum.PREPARE.getDictCode(), old.getProcessStatus()) || StringUtils.equals(ProcessStatusEnum.REJECT.getDictCode(), old.getProcessStatus()),"只能修改待提交或被驳回的数据");
        List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleCode(old.getAuditHandleCode());

        AuditHandleDto oldDto = this.nebulaToolkitService.copyObjectByWhiteList(old, AuditHandleDto.class, HashSet.class, ArrayList.class);
        List<AuditHandleDetailDto> handleDetailOldDtos = (ArrayList<AuditHandleDetailDto>)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleDetails, AuditHandleDetail.class, AuditHandleDetailDto.class, HashSet.class, ArrayList.class);
        oldDto.setAuditHandleDetailDtoList(handleDetailOldDtos);

        //删除旧明细数据
        if (CollectionUtils.isNotEmpty(auditHandleDetails)){
            List<String> ids = auditHandleDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
            this.auditHandleDetailRepository.deleteByIds(ids);
        }

        //明细处理
        List<String> auditHandleDetailCodes = this.generateCodeService.generateCode(AuditHandleConstant.AUDIT_HANDLE_PREFIX, detailDtos.size(), 8, 2, TimeUnit.DAYS);
        List<String> upAccountCodes = this.generateCodeService.generateCode(AuditHandleConstant.UP_ACCOUNT_CODE, detailDtos.size(), 10, 2, TimeUnit.DAYS);
        for (int i = 0; i < detailDtos.size(); i++) {
            String code = auditHandleDetailCodes.get(i);
            String upAccountCode = upAccountCodes.get(i);
            AuditHandleDetailDto detail = detailDtos.get(i);

            detail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detail.setTenantCode(TenantUtils.getTenantCode());
            detail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detail.setAuditHandleDetailCode(code);
            detail.setAuditHandleCode(dto.getAuditHandleCode());
            detail.setAuditHandleName(dto.getAuditHandleName());
            detail.setUpAccountCode(upAccountCode);
            detail.setUpAccountStatus(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode());
        }

        AuditHandle auditHandle = this.nebulaToolkitService.copyObjectByWhiteList(dto, AuditHandle.class, HashSet.class, ArrayList.class);
        List<AuditHandleDetail> handleDetailsNew = (ArrayList<AuditHandleDetail>)this.nebulaToolkitService.copyCollectionByWhiteList(detailDtos, AuditHandleDetailDto.class, AuditHandleDetail.class, HashSet.class, ArrayList.class);

        //更新头信息
        this.auditHandleRepository.updateById(auditHandle);
        //新增明细信息
        this.auditHandleDetailRepository.saveBatch(handleDetailsNew);

        if(SaveTypeEnum.submit.getValue().equals(dto.getSaveType())){
            this.submitApproval(dto);
        }

        //发送更新通知
        AuditHandleLogEventDto logEventDto = new AuditHandleLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<AuditHandleLogEventListener, AuditHandleLogEventDto> onUpdate =
                AuditHandleLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto,AuditHandleLogEventListener.class,onUpdate);

        //构建反参
        AuditHandleVo auditHandleVo = this.nebulaToolkitService.copyObjectByWhiteList(dto, AuditHandleVo.class, HashSet.class, ArrayList.class);
        if(CollectionUtils.isNotEmpty(detailDtos)){
            Collection<AuditHandleDetailVo> auditHandleDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(detailDtos, AuditHandleDetailDto.class, AuditHandleDetailVo.class, LinkedHashSet.class, ArrayList.class);
            auditHandleVo.setAuditHandleDetailVoList((List<AuditHandleDetailVo>) auditHandleDetailVos);
        }

        return auditHandleVo;
    }

    private void updateValidation(AuditHandleDto dto){
        //验证表头
        Validate.notNull(dto,"编辑数据时，请求参数不能为空");
        Validate.notBlank(dto.getId(),"编辑数据时，ID不能为空");
        Validate.notBlank(dto.getBusinessUnitCode(),"编辑数据时，业务单元不能为空");
        Validate.notBlank(dto.getBusinessFormatCode(),"编辑数据时，业态不能为空");
        Validate.notBlank(dto.getCompanyName(),"编辑数据时，公司名称不能为空");
        Validate.notBlank(dto.getCompanyCode(),"编辑数据时，公司编码不能为空");
        Validate.notBlank(dto.getDepartmentCode(),"编辑数据时，部门编码不能为空");
        Validate.notBlank(dto.getDepartmentName(),"编辑数据时，部门名称不能为空");
        Validate.notBlank(dto.getAuditHandleName(),"编辑数据时，手动上账名称不能为空");
        Validate.notBlank(dto.getCacheKey(),"编辑数据时，缓存key不能为空");
    }

    private void updateDetailValidation(List<AuditHandleDetailVo> detailVos){
        //验证明细
        Validate.notEmpty(detailVos,"编辑数据时，明细数据不能为空");
        detailVos.forEach(o -> {
            Validate.notBlank(o.getUndertakingType(),"编辑数据时，承接类型不能为空");
            Validate.notBlank(o.getRelationType(),"编辑数据时，关联类型不能为空");
            Validate.notBlank(o.getCostManage(),"编辑数据时，费用归口不能为空");
            Validate.notBlank(o.getBudgetCode(),"编辑数据时，预算编码不能为空");
            Validate.notBlank(o.getCostYearMonth(),"编辑数据时，费用年月不能为空");
            Validate.notBlank(o.getActivityTypeCode(),"编辑数据时，活动分类编码不能为空");
            Validate.notBlank(o.getActivityTypeName(),"编辑数据时，活动分类名称不能为空");
            Validate.notBlank(o.getActivityFormCode(),"编辑数据时，活动形式编码不能为空");
            Validate.notBlank(o.getActivityFormName(),"编辑数据时，活动形式名称不能为空");
            Validate.notBlank(o.getProductBrandCode(),"编辑数据时，品牌编码不能为空");
            Validate.notBlank(o.getProductCategoryCode(),"编辑数据时，品类编码不能为空");
            Validate.notBlank(o.getProductItemCode(),"编辑数据时，品项编码不能为空");
            Validate.notBlank(o.getProductCode(),"编辑数据时，产品编码不能为空");
            Validate.notBlank(o.getProductName(),"编辑数据时，产品名称不能为空");
            Validate.notNull(o.getProductPrice(),"编辑数据时，产品单价不能为空");
            Validate.notNull(o.getActivityPrice(),"编辑数据时，活动价不能为空");
            Validate.notBlank(o.getCustomerCode(),"编辑数据时，客户编码不能为空");
            Validate.notBlank(o.getCustomerName(),"编辑数据时，客户名称不能为空");
            Validate.notBlank(o.getWhetherDeductionFeePool(),"编辑数据时，是否扣减费用池不能为空");
            Validate.notBlank(o.getEndCaseForm(),"编辑数据时，结案形式不能为空");

            AuditFormEnum formEnum = AuditFormEnum.findEnumByCode(o.getEndCaseForm());
            switch (formEnum){
                case DISCOUNT:
                    Validate.notNull(o.getDiscountTaxRate(),"编辑数据时，折扣税率不能为空");
                    Validate.notNull(o.getDiscountShouldHandleAmount(),"编辑数据时，折扣应处理金额不能为空");
                    Validate.notNull(o.getDiscountDeductionTaxAmount(),"编辑数据时，折扣扣税金额不能为空");
                    Validate.notNull(o.getInFeePoolAmount(),"编辑数据时，入费用池金额不能为空");
                    break;
                case REIMBURSE:
                    Validate.notBlank(o.getInvoiceCode(),"编辑数据时，发票代码不能为空");
                    Validate.notBlank(o.getInvoiceNumber(),"编辑数据时，发票号码不能为空");
                    Validate.notBlank(o.getReimburseItemCode(),"编辑数据时，报销项目编码不能为空");
                    Validate.notNull(o.getReimburseTaxRate(),"编辑数据时，报销税率不能为空");
                    Validate.notNull(o.getReimburseAmountTax(),"编辑数据时，报销金额（含税）不能为空");
                    Validate.notNull(o.getReimburseAmountNoTax(),"编辑数据时，报销金额（未税）不能为空");
                    Validate.notNull(o.getTaxAmount(),"编辑数据时，税额不能为空");
                    Validate.notNull(o.getPersonalTaxAmount(),"编辑数据时，个人所得税不能为空");
                    Validate.notNull(o.getCostCenterCode(),"编辑数据时，成本中心编码不能为空");
                    Validate.notNull(o.getCostCenterName(),"编辑数据时，成本中心名称不能为空");
                    Validate.notNull(o.getProfitCenterName(),"编辑数据时，利润中心名称不能为空");
                    break;
                case RED_WORD_INVOICE:
                    Validate.notBlank(o.getImpulseDifferenceProductCode(),"编辑数据时，冲差产品编码不能为空！");
                    Validate.notBlank(o.getImpulseDifferenceProductName(),"编辑数据时，冲差产品名称不能为空！");
                    Validate.notBlank(o.getUnit(),"编辑数据时，单位不能为空！");
                    Validate.notNull(o.getQuantity(),"编辑数据时，数量不能为空！");
                    Validate.notBlank(o.getFactoryName(),"编辑数据时，工厂不能为空！");
                    break;
            }
//            Validate.notNull(o.getCurrentAuditAmountTax(),"编辑数据时，本次结案金额(含税)不能为空");
            Validate.notBlank(o.getWhetherWholeAudit(),"编辑数据时，是否完全结案不能为空");
        });

    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.notEmpty(ids,"核销编码不能为空");
        List<AuditHandle> auditHandles = this.auditHandleRepository.findByIds(ids);
        List<String> auditHandleCodeList = auditHandles.stream().map(AuditHandle::getAuditHandleCode).collect(Collectors.toList());
        auditHandles.forEach(o -> {
            Validate.isTrue(StringUtils.equals(ProcessStatusEnum.PREPARE.getDictCode(), o.getProcessStatus())
                    || StringUtils.equals(ProcessStatusEnum.REJECT.getDictCode(), o.getProcessStatus()),"只能删除待提交或被驳回的数据,请检查【%s】",o.getAuditHandleCode());
        });

        List<AuditHandleDetail> detailList = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodeList);

        //删除表头
        this.auditHandleRepository.deleteByAuditHandleCodes(auditHandleCodeList);

        //删除明细
        this.auditHandleDetailRepository.deleteByAuditHandleCodes(auditHandleCodeList);
        //删除发票
        deleteInvoiceRelation(auditHandleCodeList);
        //发送删除通知
        List<AuditHandleDto> auditHandleDtos = (ArrayList<AuditHandleDto>)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles, AuditHandle.class, AuditHandleDto.class, HashSet.class, ArrayList.class);
        List<AuditHandleDetailDto> auditHandleDetailDtos = (ArrayList<AuditHandleDetailDto>)this.nebulaToolkitService.copyCollectionByWhiteList(detailList, AuditHandleDetail.class, AuditHandleDetailDto.class, HashSet.class, ArrayList.class);
        Map<String, List<AuditHandleDetailDto>> handleDetailMap = auditHandleDetailDtos.stream().collect(Collectors.groupingBy(AuditHandleDetailDto::getAuditHandleCode));

        for (AuditHandleDto handleDto : auditHandleDtos) {
            List<AuditHandleDetailDto> detailDtos = handleDetailMap.get(handleDto.getAuditHandleCode());
            handleDto.setAuditHandleDetailDtoList(detailDtos);
            handleDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());

            AuditHandleLogEventDto logEventDto = new AuditHandleLogEventDto();
            logEventDto.setNewest(handleDto);
            SerializableBiConsumer<AuditHandleLogEventListener, AuditHandleLogEventDto> onDelete =
                    AuditHandleLogEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto,AuditHandleLogEventListener.class,onDelete);
        }

    }

    private void deleteInvoiceRelation(List<String> auditHandleCodeList) {
        List<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<>();
        List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCodes(auditHandleCodeList);
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
            AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
            dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
            dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
            invoiceManageDtoList.add(dto);
        }
        auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.NO.getCode(), null);
        this.auditHandleInvoiceRepository.deleteByAuditHandleCodes(auditHandleCodeList);
    }

    @Override
    public void deleteByDetailCodes(List<String> auditHandleDetailCodes) {

    }

    @Override
    @Transactional
    public AuditHandleVo submitApprove(AuditHandleProcessSubmitDto submitDto) {
        Validate.notNull(submitDto,"请求参数不能为空");
        Validate.isTrue(CollectionUtils.isNotEmpty(submitDto.getIds()),"请选择提交数据");
        List<AuditHandle> auditHandles = this.auditHandleRepository.findByIds(submitDto.getIds());
        auditHandles.forEach(o -> {
            Validate.isTrue(StringUtils.equals(ProcessStatusEnum.PREPARE.getDictCode(), o.getProcessStatus())
                    || StringUtils.equals(ProcessStatusEnum.REJECT.getDictCode(), o.getProcessStatus())
                    || StringUtils.equals(ProcessStatusEnum.RECOVER.getDictCode(), o.getProcessStatus()),"只能提交待提交或被驳回或追回的数据,请检查【%s】",o.getAuditHandleCode());
        });
        List<String> auditHandleCodes = auditHandles.stream().map(AuditHandle::getAuditHandleCode).collect(Collectors.toList());
        submitVerify(auditHandleCodes,auditHandles);

        Map<String,Boolean> auditHandleLocks = new HashMap<>();

        try {
            for (AuditHandle auditHandle : auditHandles) {
                String key = AuditHandleConstant.REDIS_SUBMIT_LOCK_KEY_PREFIX + auditHandle.getAuditHandleCode();
                boolean isLock = redisLockService.tryLock(key, TimeUnit.HOURS, 1);
                Validate.isTrue(isLock, "手动上账单号：【%s】,正在处理中，请稍后重试");
                auditHandleLocks.put(key,isLock);
            }

            //占用预算
            List<AuditHandleDto> auditHandleDtos = (List<AuditHandleDto>)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles,AuditHandle.class, AuditHandleDto.class, LinkedHashSet.class, ArrayList.class);
            useBudget(auditHandleDtos, AuditUseBudgetTypeEnum.USE);

            //批量提交审批流
            List<String> ids = auditHandles.stream().map(UuidEntity::getId).collect(Collectors.toList());
            ProcessBusinessDto processBusiness = submitDto.getProcessBusiness();
            processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString(submitDto));
            processBusiness.setBusinessCode(AuditHandleConstant.TPM_AUDIT_HANDLE_PROCESS);
            processBusiness.setBusinessNoList(ids);
            processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
            ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);

            //更新审批状态
            this.auditHandleRepository.updateProcessStatusAndNoByIds(ids, ProcessStatusEnum.COMMIT, processBusinessVo.getProcessNo());
        }finally {
            auditHandleLocks.forEach((key,value)->{
                if(value) {
                    redisLockService.unlock(key);
                }
            });
        }
        return null;
    }

    private void submitVerify(List<String> auditHandleCodes, List<AuditHandle> auditHandles) {

        if(CollectionUtils.isNotEmpty(auditHandleCodes)){
            List<AuditHandleDetail> auditHandleDetailList = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
            Map<String, List<AuditHandleDetail>> auditHandleDetailMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(auditHandleDetailList)){
                auditHandleDetailMap = auditHandleDetailList.stream().collect(Collectors.groupingBy(AuditHandleDetail::getAuditHandleCode));
            }
            List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCodes(auditHandleCodes);
            Map<String, List<AuditHandleInvoice>> auditHandleInvoiceMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(auditHandleInvoiceList)){
                auditHandleInvoiceMap = auditHandleInvoiceList.stream().collect(Collectors.groupingBy(AuditHandleInvoice::getAuditHandleCode));
            }
            for (AuditHandle auditHandle : auditHandles) {
                List<AuditHandleDetail> auditHandleDetailList1 = auditHandleDetailMap.get(auditHandle.getAuditHandleCode());
                auditHandleDetailList1 = auditHandleDetailList1.stream().filter(o->o.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())).collect(Collectors.toList());
                if(CollectionUtils.isNotEmpty(auditHandleDetailList1)){
                    BigDecimal thisAuditAmountTax = auditHandleDetailList1.stream().map(AuditHandleDetail::getThisAuditAmountTax).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    List<AuditHandleInvoice> auditHandleInvoiceList1 = auditHandleInvoiceMap.get(auditHandle.getAuditHandleCode());
                    Validate.isTrue(CollectionUtils.isNotEmpty(auditHandleInvoiceList1),"直接上账编码【%s】未保存发票",auditHandle.getAuditHandleCode());
                    BigDecimal invoiceTaxAmount = auditHandleInvoiceList1.stream().map(AuditHandleInvoice::getInvoiceTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    Validate.isTrue(thisAuditAmountTax.compareTo(invoiceTaxAmount)<=0,"发票金额不能大于报销金额");
                }
            }
        }
    }

    private void useBudget(List<AuditHandleDto> auditHandles, AuditUseBudgetTypeEnum useType) {

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        if(CollectionUtils.isNotEmpty(auditHandles)) {
            List<String> auditHandleCodes = auditHandles.stream().map(AuditHandleDto::getAuditHandleCode).collect(Collectors.toList());
            List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
            Map<String, List<AuditHandleDetail>> auditHandleDetailsMap = auditHandleDetails.stream().collect(Collectors.groupingBy(AuditHandleDetail::getAuditHandleCode));
            for (AuditHandleDto auditHandle : auditHandles) {
                List<AuditHandleDetail> auditHandleDetails1 = auditHandleDetailsMap.get(auditHandle.getAuditHandleCode());
                AuditHandleDetail auditHandleDetail = auditHandleDetails1.get(0);
                AuditBudgetHeadVo auditBudgetHeadVo = new AuditBudgetHeadVo();
                auditBudgetHeadVo.setAuditCode(auditHandle.getAuditHandleCode());
                auditBudgetHeadVo.setBusinessUnitCode(auditHandle.getBusinessUnitCode());
                List<AuditBudgetVo> auditBudgetVoList = new ArrayList<>();
                AuditBudgetVo auditBudgetVo = new AuditBudgetVo();
                auditBudgetVo.setAuditDetailCode(auditHandle.getAuditHandleCode());
                BigDecimal thisAuditAmountTax = Optional.ofNullable(auditHandleDetail.getThisAuditAmountTax()).orElse(BigDecimal.ZERO);
                if(AuditUseBudgetTypeEnum.USE.equals(useType)&&thisAuditAmountTax.compareTo(BigDecimal.ZERO)>0){
                    auditBudgetVo.setAmount(thisAuditAmountTax.abs());
                    auditBudgetVo.setType(AuditUseBudgetTypeEnum.USE);
                }else if(AuditUseBudgetTypeEnum.RETURN.equals(useType)&&thisAuditAmountTax.compareTo(BigDecimal.ZERO)<0){
                    auditBudgetVo.setAmount(thisAuditAmountTax.abs());
                    auditBudgetVo.setType(AuditUseBudgetTypeEnum.RETURN);
                }else {
                    continue;
                }
                String feeYearMonth = df.format(auditHandleDetail.getFeeYearMonth());
                MonthBudgetVo monthBudgetVo = monthBudgetService.getOneByYearBudgetCodeAndMonth(auditHandleDetail.getYearBudgetCode(), feeYearMonth);
                List<AuditBudgetItemVo> auditBudgetItemVos = new ArrayList<>();
                AuditBudgetItemVo auditBudgetItemVo = this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetVo, AuditBudgetItemVo.class, null, null);
                auditBudgetItemVos.add(auditBudgetItemVo);
                auditBudgetVo.setBudgetItems(auditBudgetItemVos);
                auditBudgetVoList.add(auditBudgetVo);
                auditBudgetHeadVo.setAuditBudgetVoList(auditBudgetVoList);
                monthBudgetService.auditUseBudget(auditBudgetHeadVo);
            }
        }
    }

    /**
     * 分子公司预算扣减
     */
    public void sonCompanyBudgetDeduction(List<AuditHandleDto> auditHandles, Map<String, List<AuditHandleDetailDto>> auditHandleCodeMap){
        if (CollectionUtils.isEmpty(auditHandles)){
            return;
        }
        for (AuditHandleDto auditHandle : auditHandles) {
            List<AuditHandleDetailDto> auditHandleDetails = auditHandleCodeMap.get(auditHandle.getAuditHandleCode());
            List<String> budgeItemCodes = auditHandleDetails.stream().map(o -> o.getBudgetCode()).filter(Objects::nonNull).collect(Collectors.toList());
            List<SubComBudgetForecastVo> budgetForecastVoList = this.subComBudgetForecastService.findByBudgetItemCodes(budgeItemCodes);
            for (AuditHandleDetailDto detail : auditHandleDetails) {

                /**
                 *  不承接、不关联时，用（预算编码、年月、组织）直接去【分子预算预测】查找关联预算；
                 */
                if (StringUtils.equals(detail.getUndertakingType(), AcceptTypeEnum.NO_ACCEPT.getCode())
                        && StringUtils.equals(detail.getRelationType(), SubComActivityAssociationTypeEnum.NON.getCode())){
                    this.sonCompanyDeductionBudgetAmount(budgetForecastVoList, detail, null);
                }


                /**
                 * 部分承接，完全承接，的时候，通过关联数据编码（活动细案中的，活动细案明细编码：Z-00000086），在活动细案找到【总部统筹预算编码/总部统筹预算名称】
                 * 或者【大区自控预算编码/大区自控预算名称】，在通过【总部统筹预算编码/总部统筹预算名称】或者【大区自控预算编码/大区自控预算名称】的编码，在月度预算
                 * 管理找到主体的【预算项目编码】，在通过【预算项目编码】在预算项目配置（分子是一级）中的【关联预算主体项目】找到，匹配分子的【预算项目编码】，最后用
                 * （预算编码、年月、组织）直接去【分子预算预测】查找到关联预算；
                 */
                if (StringUtils.equals(UndertakeTypeEnum.WHOLE_UNDERTAKE.getCode(),detail.getUndertakingType())
                        || StringUtils.equals(UndertakeTypeEnum.PART_UNDERTAKE.getCode(),detail.getUndertakingType())){
                    String relationDataCode = detail.getRelationDataCode();

                    List<ActivityPlanItemVo> activityPlanItemVos = activityPlanItemSdkService.listByItemCodeList(Lists.newArrayList(relationDataCode));
                    Validate.notEmpty(activityPlanItemVos,"未找到对应的活细案【%s】",relationDataCode);
                    ActivityPlanItemVo activityPlanItemVo = activityPlanItemVos.get(0);
                    List<String> itemCodes = Lists.newArrayList();
                    if (StringUtils.isNotBlank(activityPlanItemVo.getHeadBudgetItemCode())){
                        itemCodes.add(activityPlanItemVo.getHeadBudgetItemCode());
                    }
                    if (StringUtils.isNotBlank(activityPlanItemVo.getMonthBudgetCode())){
                        itemCodes.add(activityPlanItemVo.getMonthBudgetCode());
                    }
                    List<MonthBudgetVo> monthBudgetVos = this.monthBudgetService.findByCodes(itemCodes, EnableStatusEnum.ENABLE.getCode());
                    Map<String, MonthBudgetVo> monthBudgetVoMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
                    List<String> budgetItemCodes = monthBudgetVos.stream().map(o -> o.getBudgetItemCode()).filter(Objects::nonNull).collect(Collectors.toList());
                    List<BudgetItemVo> budgetItemVos = this.budgetItemService.listByMainBudgetItem(budgetItemCodes);

                    for (BudgetItemVo budgetItemVo : budgetItemVos) {
                        detail.setBudgetCode(budgetItemVo.getBudgetItemCode());
                        if (Objects.nonNull(monthBudgetVoMap.get(activityPlanItemVo.getHeadBudgetItemCode()))){
                            this.sonCompanyDeductionBudgetAmount(budgetForecastVoList, detail, detail.getHeadquartersUndertakeAmount());
                        }
                        if (Objects.nonNull(monthBudgetVoMap.get(activityPlanItemVo.getMonthBudgetCode()))){
                            this.sonCompanyDeductionBudgetAmount(budgetForecastVoList, detail, detail.getRegionUndertakeAmount());
                        }
                    }

                }

            }
        }
    }

    public void sonCompanyDeductionBudgetAmount(List<SubComBudgetForecastVo> budgetForecastVoList, AuditHandleDetailDto detail, BigDecimal currentAuditAmountTax){
        List<SubComBudgetForecastVo> forecastVos = budgetForecastVoList.stream().filter(o -> {
            if (StringUtils.equals(detail.getBudgetCode(), o.getBudgetItemCode())) {
                if (StringUtils.equals(detail.getCostYearMonth(), o.getYearMonthLy())) {
                    if (StringUtils.equals(detail.getOrgCode(), o.getOrgCode())) {
                        return Boolean.TRUE;
                    }
                }
            }
            return Boolean.FALSE;
        }).collect(Collectors.toList());
        Validate.notEmpty(forecastVos,"分子预算预测查询失败，请检查预算预测是否启用或是否存在！");
        Map<String, SubComBudgetForecastVo> forecastVoMap = forecastVos.stream()
                .filter(o -> StringUtils.isNotBlank(o.getFeeSourceCode()))
                .filter(o -> Objects.nonNull(o.getRemainderAmount()))
                .collect(Collectors.toMap(SubComBudgetForecastVo::getFeeSourceCode, Function.identity()));
        if (Objects.isNull(forecastVoMap) || forecastVoMap.isEmpty()){
            throw new IllegalArgumentException("未能获取到满足条件的分子预算预测信息");
        }

        /**
         * 先扣点外费用，再扣点内费用，最后扣自投（自投可以扣成负数）
         */
        if (forecastVoMap.containsKey(FeeSourceEnum.OFF_POINT_FEE.getCode())
                && currentAuditAmountTax.compareTo(BigDecimal.ZERO) > 0){
            //点外费用扣减
            SubComBudgetForecastVo forecastVo = forecastVoMap.get(FeeSourceEnum.OFF_POINT_FEE.getCode());
            BigDecimal sub = NumberUtil.sub(currentAuditAmountTax, forecastVo.getRemainderAmount());
            if (sub.compareTo(BigDecimal.ZERO) >= 0){
                currentAuditAmountTax = sub;
                forecastVo.setRemainderAmount(BigDecimal.ZERO);
            }else {
                forecastVo.setRemainderAmount(sub.negate());
            }
            this.subComBudgetForecastService.updateForecastRemainderAmount(forecastVo.getId(), forecastVo.getRemainderAmount());
        }

        if (forecastVoMap.containsKey(FeeSourceEnum.INTERNAL_POINT_FEE.getCode())
                && currentAuditAmountTax.compareTo(BigDecimal.ZERO) > 0){
            //点内费用扣减
            SubComBudgetForecastVo forecastVo = forecastVoMap.get(FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
            BigDecimal sub = NumberUtil.sub(currentAuditAmountTax, forecastVo.getRemainderAmount());
            if (sub.compareTo(BigDecimal.ZERO) >= 0){
                currentAuditAmountTax = sub;
                forecastVo.setRemainderAmount(BigDecimal.ZERO);
            }else {
                forecastVo.setRemainderAmount(sub.negate());
            }
            this.subComBudgetForecastService.updateForecastRemainderAmount(forecastVo.getId(), forecastVo.getRemainderAmount());
        }

        if (forecastVoMap.containsKey(FeeSourceEnum.AUTO_FEE.getCode())
                && currentAuditAmountTax.compareTo(BigDecimal.ZERO) > 0){
            //自投费用扣减
            SubComBudgetForecastVo forecastVo = forecastVoMap.get(FeeSourceEnum.AUTO_FEE.getCode());
            BigDecimal sub = NumberUtil.sub(currentAuditAmountTax, forecastVo.getRemainderAmount());
            forecastVo.setRemainderAmount(sub.negate());
            this.subComBudgetForecastService.updateForecastRemainderAmount(forecastVo.getId(), forecastVo.getRemainderAmount());
        }
    }

    /**
     * 主体预算扣减
     */
    public void headQuartersBudgetDeduction(List<AuditHandleDto> auditHandles, Map<String, List<AuditHandleDetailDto>> auditHandleCodeMap){
        if (CollectionUtils.isEmpty(auditHandles)){
            return;
        }

        useBudget(auditHandles,AuditUseBudgetTypeEnum.RETURN);

    }

    @Override
    public void sonCompanyDiscountCallBack(SonAuditCostPostingCallbackDto dto) {
        log.info("直接上帐 折扣上账 分子公司回调 【{}】", JSON.toJSONString(dto));
        List<SonAuditCostPostingCallbackDataDto> data = dto.getData();
        if (CollectionUtils.isNotEmpty(data)){
            String zftpmhxd = data.get(0).getZftpmhxd();
            Map<String, SonAuditCostPostingCallbackDataDto> callBackDataMap = data.stream().collect(Collectors.toMap(SonAuditCostPostingCallbackDataDto::getZftpmhxd, Function.identity()));
            List<String> zftpmhxdCodes = data.stream().map(o -> o.getZftpmhxd()).filter(Objects::nonNull).collect(Collectors.toList());
            List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleDetailCodes(zftpmhxdCodes);
            if(CollectionUtils.isNotEmpty(auditHandleDetails)) {
                for (AuditHandleDetail auditHandleDetail : auditHandleDetails) {
                    SonAuditCostPostingCallbackDataDto callbackDataDto = callBackDataMap.get(auditHandleDetail.getAuditHandleDetailCode());
                    if (StringUtils.equals(SucessOrFailEnum.SUCESS.getCode(), callbackDataDto.getFlag())) {
                        auditHandleDetail.setUpAccountStatus(UpAccountStatusEnum.COMMIT_SUCCESS.getCode());
                        auditHandleDetail.setUpAccountMessage(UpAccountStatusEnum.COMMIT_SUCCESS.getDesc());
                    } else {
                        auditHandleDetail.setUpAccountStatus(UpAccountStatusEnum.COMMIT_FAIL.getCode());
                        auditHandleDetail.setUpAccountMessage(UpAccountStatusEnum.COMMIT_FAIL.getDesc());
                    }
                }

                //更新状态
                this.auditHandleDetailRepository.updateBatchById(auditHandleDetails);
            }

        }
    }

    @Override
    public void headquartersDiscountCallBack(AuditCostPostingCallbackDto dto) {
        log.info("直接上帐折扣上账总公司回调【{}】", JSON.toJSONString(dto));
        List<AuditCostPostingCallbackDataDto> data = dto.getData();
        if (CollectionUtils.isNotEmpty(data)){

            Map<String, AuditCostPostingCallbackDataDto> callBackDataMap = data.stream().collect(Collectors.toMap(key->"D-" + key.getCamp_id(), Function.identity()));
            log.info("直接上帐折扣上账总公司回调,key:{},values:{}", JsonUtils.obj2JsonString(callBackDataMap.keySet()),JsonUtils.obj2JsonString(callBackDataMap.values()));
            List<String> campIds = data.stream().map(o -> "D-"+o.getCamp_id()).collect(Collectors.toList());
            List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleCodes(campIds);
            log.info("直接上帐折扣上账总公司回调,auditHandleDetails:{}", JsonUtils.obj2JsonString(auditHandleDetails));

            List<AuditHandleDetail> updateList = new ArrayList<>();
            for (AuditHandleDetail auditHandleDetail : auditHandleDetails) {
                AuditHandleDetail auditHandleDetail1 = new AuditHandleDetail();
                auditHandleDetail1.setId(auditHandleDetail.getId());
                AuditCostPostingCallbackDataDto callbackDataDto = callBackDataMap.get(auditHandleDetail.getAuditHandleDetailCode());
                if (StringUtils.equals(SucessOrFailEnum.SUCESS.getCode(),callbackDataDto.getFlag())){
                    auditHandleDetail1.setUpAccountStatus(UpAccountStatusEnum.COMMIT_SUCCESS.getCode());
                    auditHandleDetail1.setUpAccountMessage(UpAccountStatusEnum.COMMIT_SUCCESS.getDesc());
                }else {
                    auditHandleDetail1.setUpAccountStatus(UpAccountStatusEnum.COMMIT_FAIL.getCode());
                    auditHandleDetail1.setUpAccountMessage(UpAccountStatusEnum.COMMIT_FAIL.getDesc());
                }
                updateList.add(auditHandleDetail1);
            }
            log.info("直接上帐折扣上账总公司回调,updateList:{}", JsonUtils.obj2JsonString(updateList));

            //更新状态
            this.auditHandleDetailRepository.updateBatchById(updateList);

        }
    }

    @Override
    public List<AuditHandleDetailVo> findDetailListByAuditHandleCode(String auditDetailCode) {
        if (StringUtils.isEmpty(auditDetailCode)){
            return Lists.newArrayList();
        }
        List<AuditHandleDetail> detailList = this.auditHandleDetailRepository.findByAuditHandleCode(auditDetailCode);
        List<AuditHandleDetailVo> auditHandleDetailVos = (ArrayList<AuditHandleDetailVo>)this.nebulaToolkitService.copyCollectionByWhiteList(detailList, AuditHandleDetail.class, AuditHandleDetailVo.class, HashSet.class, ArrayList.class);
        return auditHandleDetailVos;
    }



    @Override
    public AuditHandleVo findById(String id) {
        Validate.notBlank(id,"ID不能为空");
        AuditHandle byId = this.auditHandleRepository.findById(id);
        Validate.notNull(byId,"数据不存在或已被删除!");
        AuditHandleVo handleVo = this.nebulaToolkitService.copyObjectByWhiteList(byId, AuditHandleVo.class, HashSet.class, ArrayList.class);
        return handleVo;
    }

    @Override
    public AuditHandleVo findByAuditHandleCode(String auditHandleCode) {
        Validate.notBlank(auditHandleCode,"ID不能为空");
        AuditHandle auditHandle = this.auditHandleRepository.findByAuditHandleCode(auditHandleCode);
        Validate.notNull(auditHandle,"数据不存在或已被删除!");
        AuditHandleVo handleVo = this.nebulaToolkitService.copyObjectByWhiteList(auditHandle, AuditHandleVo.class, HashSet.class, ArrayList.class);
        return handleVo;
    }

    @Override
    public List<AuditHandleVo> findByIds(List<String> ids) {
        Validate.notEmpty(ids,"ID集合不能为空");
        List<AuditHandle> byIds = this.auditHandleRepository.findByIds(ids);
        Validate.notEmpty(byIds,"查询数据不存在或已被删除");
        List<String> auditHandleCodes = byIds.stream().map(o -> o.getAuditHandleCode()).collect(Collectors.toList());
        List<AuditHandleVo> auditHandleVos = (ArrayList<AuditHandleVo>)this.nebulaToolkitService.copyCollectionByWhiteList(byIds, AuditHandle.class, AuditHandleVo.class, HashSet.class, ArrayList.class);

        List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
        if (CollectionUtils.isNotEmpty(auditHandleDetails)){
            Collection<AuditHandleDetailVo> handleDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleDetails, AuditHandleDetail.class, AuditHandleDetailVo.class, HashSet.class, ArrayList.class);
            Map<String, List<AuditHandleDetailVo>> detailVoMap = handleDetailVos.stream().collect(Collectors.groupingBy(AuditHandleDetailVo::getAuditHandleCode));
            for (AuditHandleVo handleVo : auditHandleVos) {
                List<AuditHandleDetailVo> auditHandleDetailVos = detailVoMap.get(handleVo.getAuditHandleCode());
                auditHandleDetailVos.forEach(item->{
                    item.setCompanyCode(handleVo.getCompanyCode());
                    item.setCompanyName(handleVo.getCompanyName());
                    item.setBusinessFormatCode(handleVo.getBusinessFormatCode());
                    item.setBusinessUnitCode(handleVo.getBusinessUnitCode());
                });
                handleVo.setAuditHandleDetailVoList(auditHandleDetailVos);
            }
        }
        return auditHandleVos;
    }

    @Override
    @Transactional
    public void upAccount(String body) {
        log.info("直接上账 参数【{}】", body);

        if (StringUtils.isEmpty(body)){
            return;
        }
        List<String> ids = Lists.newArrayList(body.split(","));

        boolean hasLock = false;
        try {
            hasLock = redisLockService.batchLock(AuditHandleConstant.AUDIT_HANDLE_UP_ACCOUNT_BATCH, ids, TimeUnit.MINUTES, 30);
            if (!hasLock) {
                throw new RuntimeException("正在上账中,请勿重复推送");
            }
            List<AuditHandleVo> handleVos = this.findByIds(ids);

            for (AuditHandleVo handleVo : handleVos) {

                /**
                 * 目前只支持两个主体和分子公司业务单元 --- 0602
                 */
                BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum(handleVo.getBusinessUnitCode());
                switch (businessUnitEnum) {
                    case HEADQUARTERS:
                        this.headquartersUpAccount(handleVo);
                        break;
                    case SON_COMPANY:
                        this.sonCompanyUpAccount(handleVo);
                        break;
                    default:
                        throw new IllegalArgumentException("不支持的业务单元类型【" + businessUnitEnum + "】");
                }

            }
        }finally {
            if(hasLock) {
                redisLockService.batchUnLock(AuditHandleConstant.AUDIT_HANDLE_UP_ACCOUNT_BATCH, ids);
            }
        }

    }

    private void sonCompanyUpAccount(AuditHandleVo auditHandleVo){
        log.info("直接上账 【分子公司接口】参数【{}】", JSON.toJSONString(auditHandleVo));

        List<AuditHandleDetailVo> auditHandleDetailVoList = auditHandleVo.getAuditHandleDetailVoList();
        List<AuditHandleDetailVo> discountDetailVo = auditHandleDetailVoList.stream().filter(o -> StringUtils.isNotBlank(o.getEndCaseForm())).filter(o->o.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())).filter(o->StringUtils.isEmpty(o.getUpAccountStatus())||UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(o.getUpAccountStatus())).collect(Collectors.toList());
        List<AuditHandleDetailVo> reimburseDetailVo = null;
        if(UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(auditHandleVo.getUpAccountStatusReimburse())||StringUtils.isEmpty(auditHandleVo.getUpAccountStatusReimburse())) {
            reimburseDetailVo = auditHandleDetailVoList.stream().filter(o -> StringUtils.isNotBlank(o.getEndCaseForm())).filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(discountDetailVo)){
            //折扣上账
            this.sonCompanyDiscountUpAccount(auditHandleVo, discountDetailVo);
        }

        if (CollectionUtils.isNotEmpty(reimburseDetailVo)){
            //报销上账
            this.sonCompanyReimburseAccount(auditHandleVo, reimburseDetailVo);
        }

    }

    /**
     * 分子公司折扣上账
     * @param handleVo
     * @param auditHandleDetailVoList
     */
    private void sonCompanyDiscountUpAccount(AuditHandleVo handleVo, List<AuditHandleDetailVo> auditHandleDetailVoList){

        List<String> formCodes = auditHandleDetailVoList.stream().map(o -> o.getActivityFormCode()).filter(Objects::nonNull).collect(Collectors.toList());
        List<ActivityFormVo> activityFormVos = this.activityFormService.findByCodes(formCodes);
        Map<String, ActivityFormVo> formVoMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));

        //分子公司
        AuditFeeUpAccountSonCompanyDto auditFeeUpAccountSonCompanyDto = new AuditFeeUpAccountSonCompanyDto();
        AuditFeeUpAccountSonCompanyDto.MessageHeader messageHeader = new AuditFeeUpAccountSonCompanyDto.MessageHeader();
        //抬头
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE(AuditHandleConstant.AUDIT_FEE_UP_ACCOUNT_SON);
        messageHeader.setSENDER(AuditHandleConstant.SENDER_TPM);
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER(AuditHandleConstant.RECEIVER_ECC);
        auditFeeUpAccountSonCompanyDto.setMessageHeader(messageHeader);

        List<AuditFeeUpAccountSonCompanyDto.Item1> item1List = new ArrayList<>();


        for (AuditHandleDetailVo detailVo : auditHandleDetailVoList) {
            AuditFeeUpAccountSonCompanyDto.Item1 item1 = new AuditFeeUpAccountSonCompanyDto.Item1();
            // TPM核销单号
            item1.setZFTPMHXD(detailVo.getAuditHandleCode());

            // 核销单类型
            item1.setZFHXDLX(detailVo.getDiscountShouldHandleAmount().compareTo(BigDecimal.ZERO) >= 0 ? AuditHandleConstant.ZFHXDLX_1 : AuditHandleConstant.ZFHXDLX_2);
            //客户编号
            item1.setKUNNR(detailVo.getCustomerCode());
            //原始金额
            item1.setZFAMT1(Optional.ofNullable(detailVo.getDiscountShouldHandleAmount()).orElse(BigDecimal.ZERO).toPlainString());

            item1.setMATNR(detailVo.getProductCode());

            Calendar now = Calendar.getInstance();
            // 财年
            item1.setGJAHR(String.valueOf(now.get(Calendar.YEAR)));
            // 会计期间
            item1.setMONAT(String.valueOf(now.get(Calendar.MONTH) + 1));

            //客户所属销售机构
            item1.setVKORG(handleVo.getCompanyCode());
            //分销渠道
            item1.setVTWEG(detailVo.getChannelCode());
            // 促销形式
            if (Objects.nonNull(formVoMap.get(detailVo.getEndCaseForm()))) {
                item1.setZFCXXS(formVoMap.get(detailVo.getEndCaseForm()).getSapCode());
            }

            //业态
            DictDataVo businessFormatCodeVo = dictDataVoService.findByDictTypeCodeAndDictCode(AuditHandleConstant.MDM_BUSINESS_FORMAT, handleVo.getBusinessFormatCode());
            Validate.notNull(businessFormatCodeVo, "未查询到业态【%s】的数据字典", handleVo.getBusinessFormatCode());
            Map<String, String> extendMap = businessFormatCodeVo.getExtendMap();
            if (extendMap != null) {
                String zfyt = extendMap.get(AuditHandleConstant.MDM_BUSINESS_FORMAT_ZFYT);
                // 业态
                item1.setZFYT(zfyt);
            }
            item1List.add(item1);
        }
        this.sapSdApiService.auditFeeUpAccountSonCompany(auditFeeUpAccountSonCompanyDto);
    }

    /**
     * 分子报销上账
     * @param handleVo
     * @param auditHandleDetailVoList
     */
    private void sonCompanyReimburseAccount(AuditHandleVo handleVo, List<AuditHandleDetailVo> auditHandleDetailVoList){
        List<AuditHandleInvoice> auditHandleInvoices = this.auditHandleInvoiceRepository.findByAuditHandleCode(handleVo.getAuditHandleCode());
        AuditHandleVo auditHandleVo = this.reimburseUpAccountAll(auditHandleDetailVoList, auditHandleInvoices, handleVo);

        // 更新报销上账状态
        AuditHandle auditHandle = this.nebulaToolkitService.copyObjectByWhiteList(auditHandleVo, AuditHandle.class, HashSet.class, ArrayList.class);
        this.auditHandleRepository.updateById(auditHandle);
    }

    private void headquartersUpAccount(AuditHandleVo auditHandleVo){
        log.info("直接上账 【总公司接口】参数【{}】", JSON.toJSONString(auditHandleVo));

        List<AuditHandleDetailVo> auditHandleDetailVoList = auditHandleVo.getAuditHandleDetailVoList();
        List<AuditHandleDetailVo> discountDetailVo = auditHandleDetailVoList.stream().filter(o -> StringUtils.isNotBlank(o.getEndCaseForm())).filter(o->o.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())).filter(o->StringUtils.isEmpty(o.getUpAccountStatus())||UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(o.getUpAccountStatus())).collect(Collectors.toList());
        List<AuditHandleDetailVo> reimburseDetailVo = null;
        if(UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(auditHandleVo.getUpAccountStatusReimburse())||StringUtils.isEmpty(auditHandleVo.getUpAccountStatusReimburse())) {
            reimburseDetailVo = auditHandleDetailVoList.stream().filter(o -> StringUtils.isNotBlank(o.getEndCaseForm())).filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())).collect(Collectors.toList());
        }


        if (CollectionUtils.isNotEmpty(discountDetailVo)){
            //折扣上账
            this.headquartersDiscountAccount(auditHandleVo, discountDetailVo);
        }

        if (CollectionUtils.isNotEmpty(reimburseDetailVo)){
            //报销上账
            this.headquartersReimburseAccount(auditHandleVo, reimburseDetailVo);
        }

    }

    /**
     * 主体折扣上账
     * @param handleVo
     * @param auditHandleDetailVoList
     */
    private void headquartersDiscountAccount(AuditHandleVo handleVo, List<AuditHandleDetailVo> auditHandleDetailVoList){
        log.info("直接上账 折扣上账 【总公司接口】参数1：【{}】，参数2：【{}】", JSON.toJSONString(handleVo), JSON.toJSONString(auditHandleDetailVoList));

        AuditFeeUpAccountDto auditFeeUpAccountDto = new AuditFeeUpAccountDto();
        AuditFeeUpAccountDto.MessageHeader messageHeader = new AuditFeeUpAccountDto.MessageHeader();
        //抬头
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE(AuditHandleConstant.AUDIT_FEE_UP_ACCOUNT);
        messageHeader.setSENDER(AuditHandleConstant.SENDER_TPM);
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER(AuditHandleConstant.RECEIVER_ECC);

        auditFeeUpAccountDto.setMessageHeader(messageHeader);

        List<AuditFeeUpAccountDto.Item1> item1List = new ArrayList<>();

        //活动形式编码
        List<String> activityFormCodes = auditHandleDetailVoList.stream().map(AuditHandleDetailVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        List<ActivityFormVo> activityFormVos = activityFormService.findByCodes(activityFormCodes);
        Map<String, ActivityFormVo> formVoMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));

        //客户编码
        List<String> customerCodes = auditHandleDetailVoList.stream().map(AuditHandleDetailVo::getLongCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        List<CustomerVo> customerVoList = customerVoService.findByCustomerCodes(customerCodes);
        Map<String, CustomerVo> customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode,Function.identity()));

        List<AuditHandleDetail> auditHandleDetailList = new ArrayList<>();
        for (AuditHandleDetailVo handleDetailVo : auditHandleDetailVoList) {

            CustomerVo customerVo = customerVoMap.get(handleDetailVo.getLongCustomerCode());
            Validate.notNull(customerVo,"客户编码【%s】不存在",handleDetailVo.getLongCustomerCode());

            AuditFeeUpAccountDto.Item1 item1 = new AuditFeeUpAccountDto.Item1();
            //客户编码
            item1.setKUNNR(customerVo.getErpCode());
            //促销活动号
            String[] split = handleDetailVo.getAuditHandleCode().split("-");
            item1.setCAMP_ID(split[1]);
            //物料编码
            item1.setMATNR(handleDetailVo.getProductCode());
            //单据类型
            if (Objects.nonNull(formVoMap.get(handleDetailVo.getActivityFormCode()))) {
                item1.setCAMP_DES(formVoMap.get(handleDetailVo.getActivityFormCode()).getSapCode());
            }
            // 客户所属销售部门
            item1.setVKBUR(customerVo.getSalesRegionErpCode());
            // 客户所属销售机构
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            // 起始日期
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            item1.setZFQSRQ(Objects.isNull(handleDetailVo.getActivityBeginDate()) ? null : sdf.format(handleDetailVo.getActivityBeginDate()));
            // 结束日期
            item1.setZFJSRQ(Objects.isNull(handleDetailVo.getActivityEndDate()) ? null : sdf.format(handleDetailVo.getActivityEndDate()));
            //条件类型
            item1.setKSCHL(null);
            // 金额
            item1.setDMBTR(handleDetailVo.getThisAuditAmountTax().toPlainString());
            // 批复类型
            item1.setZFLAG("A");
            // 货币码
            item1.setWAERS(AuditHandleConstant.WAERS);

            //销售组
            item1.setVKGRP(customerVo.getSalesOrgErpCode());

            item1List.add(item1);

            AuditHandleDetail auditHandleDetail = new AuditHandleDetail();
            auditHandleDetail.setId(handleDetailVo.getId());
            auditHandleDetail.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTING.getCode());
            auditHandleDetailList.add(auditHandleDetail);
        }

        auditFeeUpAccountDto.setITEM1(item1List);
        sapSdApiService.auditFeeUpAccount(auditFeeUpAccountDto);

        this.auditHandleDetailRepository.updateBatchById(auditHandleDetailList);

        log.info("总公司 直接上账折扣上账结束");
    }

    /**
     * 主体报销上账
     * @param handleVo
     * @param auditHandleDetailVoList
     */
    private void headquartersReimburseAccount(AuditHandleVo handleVo, List<AuditHandleDetailVo> auditHandleDetailVoList){
        List<AuditHandleInvoice> auditHandleInvoices = this.auditHandleInvoiceRepository.findByAuditHandleCode(handleVo.getAuditHandleCode());
        AuditHandleVo auditHandleVo = this.reimburseUpAccountAll(auditHandleDetailVoList, auditHandleInvoices, handleVo);

        // 更新报销上账状态
        AuditHandle auditHandle = this.nebulaToolkitService.copyObjectByWhiteList(auditHandleVo, AuditHandle.class, HashSet.class, ArrayList.class);
        this.auditHandleRepository.updateById(auditHandle);

        //更新发票的进转出金额
        List<AuditHandleInvoice> auditHandleInvoiceUpdates = new ArrayList<>();
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices) {
            AuditHandleInvoice auditHandleInvoice1 = new AuditHandleInvoice();
            auditHandleInvoice1.setId(auditHandleInvoice.getId());
            auditHandleInvoice1.setChangeAmount(auditHandleInvoice.getChangeAmount());
            auditHandleInvoiceUpdates.add(auditHandleInvoice1);
        }
        if(CollectionUtils.isNotEmpty(auditHandleInvoiceUpdates)){
            this.auditHandleInvoiceRepository.updateBatchById(auditHandleInvoiceUpdates);
        }
    }

    private AuditHandleVo reimburseUpAccountAll(List<AuditHandleDetailVo> reimburseUpAccountList, List<AuditHandleInvoice> auditHandleInvoices, AuditHandleVo auditHandleVo) {

        //发票数量
        int invoiceNum = auditHandleVo.getAppendices();
        String[] split = auditHandleVo.getAuditHandleCode().split("-");
        String auditHandleCode = split[1];
        Integer accId = 1;
        if (redisTemplate.hasKey(AuditHandleConstant.AUDIT_HANDLE_ACC_ID)) {
            Object o = redisTemplate.opsForValue().get(AuditHandleConstant.AUDIT_HANDLE_ACC_ID);
            accId = (Integer) o;
            accId = accId + 1;
            redisTemplate.opsForValue().set(AuditHandleConstant.AUDIT_HANDLE_ACC_ID, accId);
        } else {
            redisTemplate.opsForValue().set(AuditHandleConstant.AUDIT_HANDLE_ACC_ID, accId);
        }
        auditHandleVo.setAccId(Integer.toString(accId));

        boolean isSpecial = false;

        Validate.isTrue(CollectionUtils.isNotEmpty(auditHandleInvoices), "发票不能位空");

        //现在一个核销单只有一个客户或者供应商，一个报销项目，专票和普票不会同时存在
        List<DictDataVo> dictDataVoList = dictDataVoService.findByDictTypeCode(AuditHandleConstant.TPM_AUDIT_INVOICE_TYPE);
        Map<String, DictDataVo> dictDataVoMap = dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        DictDataVo dictDataVo = dictDataVoMap.get(auditHandleInvoices.get(0).getInvoiceType());

        if (dictDataVo != null) {
            Map<String, String> extendMap = dictDataVo.getExtendMap();
            //是否专票 （Y/N）
            String ext1 = extendMap.get(AuditHandleConstant.EXT1);
            if (YesOrNoEnum.YES.getCode().equals(ext1)) {
                isSpecial = true;
            } else {
                isSpecial = false;
            }
        }


        //报销含税
        BigDecimal reimburseTaxAmount = reimburseUpAccountList.stream().map(AuditHandleDetailVo::getThisAuditAmountTax).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);

        AbstractCrmUserIdentity user = this.loginUserService.getAbstractLoginUser();

        CustomerVo customerVo = new CustomerVo();
        if (StringUtils.isNotEmpty(reimburseUpAccountList.get(0).getCustomerCode())) {
            customerVo = customerVoService.findDetailsByIdOrCode(null, reimburseUpAccountList.get(0).getLongCustomerCode());
        }
        //主体
        AccountingVoucherDto accountingVoucherDto = new AccountingVoucherDto();
        AccountingVoucherDto.ItData itData = new AccountingVoucherDto.ItData();
        accountingVoucherDto.setIT_DATA(itData);
        List<AccountingVoucherDto.ItData.Item> itemList = new ArrayList<>();
        //item1 费用
        AccountingVoucherDto.ItData.Item item1 = new AccountingVoucherDto.ItData.Item();
        //SAP使用此字段删重
        item1.setACC_ID(auditHandleVo.getAccId());
        item1.setTPID(auditHandleCode);
        item1.setOBJECT_ID(auditHandleCode);
        //sap公司代码
        item1.setBUKRS(auditHandleVo.getCompanyCode());
        //发票张数
        item1.setINVOCE_NUM(String.valueOf(invoiceNum));
        //用户名
        item1.setUSNAM(user.getAccount());
        //FLH的规则：费用传1 进项税传2 客户传3
        item1.setFLH("1");
        //记账代码 40
        item1.setBSCHL("40");
        //总账科目编号
        item1.setSAKNR(reimburseUpAccountList.get(0).getReimburseItemCode());

        //金额 (报销含税)
        item1.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).toPlainString());
        // 利润中心
        item1.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
        //成本中心
        item1.setKOSTL(reimburseUpAccountList.get(0).getCostCenterCode());
        //销售部门
        item1.setSALESOFFICE(customerVo.getSalesRegionErpCode());
        //销售组
        item1.setSALESGROUP(customerVo.getSalesOrgErpCode());
        //erp客户
        item1.setKUNNR(customerVo.getErpCode());

        itemList.add(item1);

        if (isSpecial) {

            //发票总额含税
            BigDecimal invoiceTaxAmount = auditHandleInvoices.stream().map(AuditHandleInvoice::getInvoiceTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            //是否转出
            boolean changeFlag = false;
            if(reimburseTaxAmount.compareTo(invoiceTaxAmount)!=0){
                changeFlag = true;
            }

            BigDecimal invoiceTaxAmount2 = BigDecimal.ZERO;

            //进转出金额
            BigDecimal changeAmount = BigDecimal.ZERO;
            for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices) {
                //item3 税额
                AccountingVoucherDto.ItData.Item item3 = new AccountingVoucherDto.ItData.Item();
                //SAP使用此字段删重
                item3.setACC_ID(auditHandleVo.getAccId());
                item3.setTPID(auditHandleCode);
                item3.setOBJECT_ID(auditHandleCode);
                //sap公司代码
                item3.setBUKRS(auditHandleVo.getCompanyCode());
                //发票张数
                item3.setINVOCE_NUM(String.valueOf(invoiceNum));
                //发票号
                item3.setINVOICE_NO(auditHandleInvoice.getInvoiceNumber());
                //用户名
                item3.setUSNAM(user.getAccount());
                //FLH的规则：费用传1 进项税传2 客户传3
                item3.setFLH("2");
                //记账代码 40
                item3.setBSCHL("40");
                //总账科目编号
                item3.setSAKNR(auditHandleInvoice.getTaxSubject());
                //金额 (税额)
                item3.setAMOUNT(auditHandleInvoice.getTaxAmount().setScale(2, RoundingMode.HALF_UP).toPlainString());

                invoiceTaxAmount2 = invoiceTaxAmount2.add(auditHandleInvoice.getTaxAmount().setScale(2, RoundingMode.HALF_UP));
                // 利润中心
                item3.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
//                //成本中心
//                item3.setKOSTL(reimburseUpAccountList.get(0).getCostCenterCode());
//                //销售部门
//                item3.setSALESOFFICE(customerVo.getSalesRegionErpCode());
//                //销售组
//                item3.setSALESGROUP(customerVo.getSalesOrgErpCode());

                itemList.add(item3);
            }
            if(changeFlag){

                auditHandleInvoices = auditHandleInvoices.stream().sorted(Comparator.comparing(AuditHandleInvoice::getTaxRate).thenComparing(AuditHandleInvoice::getTaxAmount).reversed()).collect(Collectors.toList());

                //item3 税额
                AccountingVoucherDto.ItData.Item item6 = new AccountingVoucherDto.ItData.Item();
                //SAP使用此字段删重
                item6.setACC_ID(auditHandleVo.getAccId());
                item6.setTPID(auditHandleCode);
                item6.setOBJECT_ID(auditHandleCode);
                //sap公司代码
                item6.setBUKRS(auditHandleVo.getCompanyCode());
                //发票张数
                item6.setINVOCE_NUM(String.valueOf(invoiceNum));
                //用户名
                item6.setUSNAM(user.getAccount());
                //FLH的规则：费用传1 进项税传2 客户传3
                item6.setFLH("2");
                //记账代码 50
                item6.setBSCHL("50");
                //总账科目编号
                item6.setSAKNR("2221010701");
                //金额 (进转出)
                //要转出的含税额
                BigDecimal changeTaxAmount = invoiceTaxAmount.subtract(reimburseTaxAmount);
                for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices) {
                    if(changeTaxAmount.compareTo(auditHandleInvoice.getInvoiceTaxAmount())>0){
                        changeTaxAmount = changeTaxAmount.subtract(auditHandleInvoice.getInvoiceTaxAmount());
                        changeAmount = changeAmount.add(auditHandleInvoice.getTaxAmount());
                        auditHandleInvoice.setChangeAmount(auditHandleInvoice.getTaxAmount());
                    }else {
                        BigDecimal thisChangeAmount = changeTaxAmount.divide(new BigDecimal(auditHandleInvoice.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.UP).add(BigDecimal.ONE),6,RoundingMode.HALF_UP).multiply(new BigDecimal(auditHandleInvoice.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.UP));
                        changeAmount = changeAmount.add(thisChangeAmount);
                        auditHandleInvoice.setChangeAmount(thisChangeAmount);
                        break;
                    }
                }
                item6.setAMOUNT(changeAmount.setScale(2, RoundingMode.HALF_UP).negate().toPlainString());

                // 利润中心
                item6.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
//                //成本中心
//                item6.setKOSTL(reimburseUpAccountList.get(0).getCostCenterCode());
//                //销售部门
//                item6.setSALESOFFICE(customerVo.getSalesRegionErpCode());
//                //销售组
//                item6.setSALESGROUP(customerVo.getSalesOrgErpCode());

                itemList.add(item6);
            }
            if(changeFlag) {
                //报销未税 = 报销含税 + 进转出 - 发票税额
                item1.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).add(changeAmount).subtract(invoiceTaxAmount2).setScale(2, RoundingMode.HALF_UP).toPlainString());
            }else {
                //没有转出，报销未税 = 报销含税 - 发票税额
                item1.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).subtract(invoiceTaxAmount2).setScale(2, RoundingMode.HALF_UP).toPlainString());
            }
        }

        //item2 客户
        AccountingVoucherDto.ItData.Item item2 = new AccountingVoucherDto.ItData.Item();
        //SAP使用此字段删重
        item2.setACC_ID(auditHandleVo.getAccId());
        item2.setTPID(auditHandleCode);
        item2.setOBJECT_ID(auditHandleCode);
        //sap公司代码
        item2.setBUKRS(auditHandleVo.getCompanyCode());
        //发票张数
        item2.setINVOCE_NUM(String.valueOf(invoiceNum));
        //用户名
        item2.setUSNAM(user.getAccount());
        //FLH的规则：费用传1 进项税传2 客户传3
        item2.setFLH("3");
        //记账代码
        item2.setBSCHL("11");
        //客户编号
        item2.setKUNNR(customerVo.getErpCode());
        //销售部门
        item2.setSALESOFFICE(customerVo.getSalesRegionErpCode());
        //销售组
        item2.setSALESGROUP(customerVo.getSalesOrgErpCode());
//        if(CustomerSupplierTypeEnum.CUSTOMER.getValue().equals(reimburseUpAccountList.get(0).getCustomerSupplierType())) {
//            item2.setBSCHL("11");
//            //客户编号
//            item2.setKUNNR(customerVo.getErpCode());
//            //销售部门
//            item2.setSALESOFFICE(customerVo.getSalesRegionErpCode());
//            //销售组
//            item2.setSALESGROUP(customerVo.getSalesOrgErpCode());
//        }else {
//            item2.setBSCHL("31");
//            item2.setKUNNR(reimburseUpAccountList.get(0).getSupplierCode());
//        }
        //总账科目编号
        item2.setSAKNR(null);
        //金额 (报销含税)
        item2.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).negate().toPlainString());
        // 利润中心
        item2.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
        //成本中心
        item2.setKOSTL(null);
        //销售部门
        item2.setSALESOFFICE(customerVo.getSalesRegionErpCode());
        //销售组
        item2.setSALESGROUP(customerVo.getSalesOrgErpCode());

        BigDecimal individualIncomeTax = reimburseUpAccountList.stream().map(AuditHandleDetailVo::getPersonalTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);

//        if(individualIncomeTax.compareTo(BigDecimal.ZERO)!=0){
//            //贷：应交税费-应交个人所得税
//            AccountingVoucherDto.ItData.Item item4 = new AccountingVoucherDto.ItData.Item();
//
//            //SAP使用此字段删重
//            item4.setACC_ID(auditHandleVo.getAccId());
//            item4.setTPID(auditHandleVo.getAuditHandleCode());
//            item4.setOBJECT_ID(auditHandleVo.getAuditHandleCode());
//            //sap公司代码
//            item4.setBUKRS(auditHandleVo.getCompanyCode());
//            //FLH的规则：费用传1 进项税传2 客户传3
//            item4.setFLH("1");
//            //记账代码 50
//            item4.setBSCHL("50");
//            //总账科目编号
//            item4.setSAKNR("2221120500");
//            //金额
//            item4.setAMOUNT(individualIncomeTax.setScale(2, RoundingMode.HALF_UP).negate().toPlainString());
//            //用户名
//            item4.setUSNAM(user.getAccount());
//            // 利润中心
//            item4.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
//            //成本中心
//            item4.setKOSTL(reimburseUpAccountList.get(0).getCostCenterCode());
//
//            itemList.add(item4);
//
//            //借：报销项目  个人所得税金额
//            AccountingVoucherDto.ItData.Item item5 = new AccountingVoucherDto.ItData.Item();
//
//            //SAP使用此字段删重
//            item5.setACC_ID(auditHandleVo.getAccId());
//            item5.setTPID(auditHandleVo.getAuditHandleCode());
//            item5.setOBJECT_ID(auditHandleVo.getAuditHandleCode());
//            //sap公司代码
//            item5.setBUKRS(auditHandleVo.getCompanyCode());
//            //FLH的规则：费用传1 进项税传2 客户传3
//            item5.setFLH("1");
//            //记账代码 40
//            item5.setBSCHL("40");
//            //金额
//            item5.setAMOUNT(individualIncomeTax.setScale(2, RoundingMode.HALF_UP).toPlainString());
//            //总账科目编号
//            item5.setSAKNR(reimburseUpAccountList.get(0).getReimburseItemCode());
//            //用户名
//            item5.setUSNAM(user.getAccount());
//            // 利润中心
//            item5.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
//            //成本中心
//            item5.setKOSTL(reimburseUpAccountList.get(0).getCostCenterCode());
//
//            itemList.add(item5);
//        }

        itemList.add(item2);

        itData.setItem(itemList);
        SapAccountingVoucherVo sapAccountingVoucherVo = sapFiService.pushSapAccountingVoucher(accountingVoucherDto);

        String message = null;
        AuditHandleVo auditHandleVo1 = new AuditHandleVo();
        auditHandleVo1.setId(auditHandleVo.getId());
        if (Objects.nonNull(sapAccountingVoucherVo)) {
            if (Objects.nonNull(sapAccountingVoucherVo.getET_BELNR())&&CollectionUtils.isNotEmpty(sapAccountingVoucherVo.getET_BELNR().getItem())) {
                for (SapAccountingVoucherVo.EtBelnr.Item item : sapAccountingVoucherVo.getET_BELNR().getItem()) {
                    auditHandleVo1.setBelnr(item.getBELNR());
                    auditHandleVo1.setBukrs(item.getBUKRS());
                    auditHandleVo1.setGjahr(item.getGJAHR());
                }
            }
            if (Objects.nonNull(sapAccountingVoucherVo.getET_MESSAGE())&&CollectionUtils.isNotEmpty(sapAccountingVoucherVo.getET_MESSAGE().getItem())) {
                for (SapAccountingVoucherVo.EtMessage.Item item : sapAccountingVoucherVo.getET_MESSAGE().getItem()) {
                    if (SuccessAndFailEnum.FAIL.getCode().equals(item.getTYPE())) {
                        message = item.getMESSAGE() + "||" + message;
                    }
                }
                if (StringUtils.isNotEmpty(message)) {
                    auditHandleVo1.setUpAccountStatusReimburse(UpAccountStatusEnum.COMMIT_FAIL.getCode());
                    auditHandleVo1.setUpAccountMessageReimburse(message);
                }else {
                    auditHandleVo1.setUpAccountStatusReimburse(UpAccountStatusEnum.COMMIT_SUCCESS.getCode());
                    auditHandleVo1.setUpAccountMessageReimburse(UpAccountStatusEnum.COMMIT_SUCCESS.getDesc());
                }
            }
        }
        return auditHandleVo1;
    }


    @Override
    public Map<Integer, String> auditHandleImportSave(LinkedHashMap<Integer, AuditHandleImportVo> data, Map<String, Object> params) {
        String businessCode = this.getBusinessUnitCode(params);
        String cacheKey = this.getCacheKey(params);
//        Validate.notBlank(businessCode,"业务单元编码不能为空");
        Validate.notBlank(cacheKey,"缓存key不能为空");
        cacheKey = AuditHandleConstant.AUDIT_HANDLE_CACHE_KEY + cacheKey;

        Map<Integer, String> errorMap = new HashMap<>();

        //文字转编码
//        this.descToCode(data);

        //导入数据校验
        this.auditHandleImportValidation(data);

        //导入数据存入缓存
        this.detailImportCacheSave(data, cacheKey);

        return errorMap;
    }

    /**
     * 导入批量新增或编码
     * 此处抬头信息和明显信息只会 一对一
     * @param importVos
     */
    @Override
    public void createOrUpdateBatchImport(Collection<AuditHandleImportVo> importVos) {
        Validate.notEmpty(importVos,"导入数据不能为空");

    }

    /**
     * 批量上账
     * @param ids
     */
    @Override
    public void upAccountBatch(List<String> ids) {
        List<AuditHandleVo> handleVos = this.findByIds(ids);
        for (AuditHandleVo handleVo : handleVos) {
            // 1、结案方式为折扣时，如果行明细到单产品，则推送“本次实报费用”到SAP费用池，如果行明细“本次实报费用”不是到单品的，则根据费用分摊规则进行分摊（逻辑同结案核销），分摊后推送“本次实报费用”分摊到单品的金额至SAP的费用池，返回上账状态；
            // 2、结案方式为报销时，推送“本次实报费用”、“物料编码”、“报销项目”、“成本中心”、“利润中心”、“发票号码”、“发票金额”、“税额”等至SAP，返回上账状态及会计凭证
            // 导入数据只有一条明细只有一条明细

            Validate.isTrue(ProcessStatusEnum.PASS.getDictCode().equals(handleVo.getProcessStatus()),"上账单号【%s】非审批通过的核销单不允许上账",handleVo.getAuditHandleCode());

            AuditHandleDetailVo auditHandleDetailVo = handleVo.getAuditHandleDetailVoList().get(0);
            if(EndCaseFormEnum.DISCOUNT.getCode().equals(auditHandleDetailVo.getEndCaseForm())){
                Validate.isTrue(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode().equals(auditHandleDetailVo.getUpAccountStatus())
                || UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(auditHandleDetailVo.getUpAccountStatus()),"上账单号【%s】状态的包含不允许上账的数据，请检查",handleVo.getAuditHandleCode());
            }
            if(EndCaseFormEnum.REIMBURSE.getCode().equals(auditHandleDetailVo.getEndCaseForm())){
                Validate.isTrue(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode().equals(handleVo.getUpAccountStatusReimburse())
                        || UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(handleVo.getUpAccountStatusReimburse()),"上账单号【%s】状态的包含不允许上账的数据，请检查",handleVo.getAuditHandleCode());
            }

            BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum(handleVo.getBusinessUnitCode());
            switch (businessUnitEnum){
                case HEADQUARTERS:
                    this.headquartersUpAccount(handleVo);
                    break;
                case SON_COMPANY:
                    this.sonCompanyUpAccount(handleVo);
                    break;
                default:
                    throw new IllegalArgumentException("不支持的业务单元类型【" + businessUnitEnum + "】");
            }

        }
    }

    @Override
    public Page<AuditHandleDetailVo> findByConditions(Pageable pageable, AuditHandleDetailDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new AuditHandleDetailDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<AuditHandleDetailVo> page = this.auditHandleDetailRepository.findByConditions(pageable, dto);
        List<AuditHandleDetailVo> records = page.getRecords();
        fillData(records);
        return page;
    }

    @Override
    public void updateAppendicesByAuditHandleCode(Integer appendices, String auditHandleCode) {
        if(StringUtils.isEmpty(auditHandleCode)){
            return;
        }
        if(Objects.isNull(appendices)){
            return;
        }
        this.auditHandleRepository.updateAppendicesByAuditHandleCode(appendices,auditHandleCode);
    }

    @Override
    public void reimburseChargeAgainst(List<String> ids) {

        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        List<AuditHandle> auditHandleList = this.auditHandleRepository.findByIds(ids);
        List<AuditHandleDto> auditHandleDtos = (List<AuditHandleDto>)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleList, AuditHandle.class, AuditHandleDto.class, LinkedHashSet.class, ArrayList.class);
        auditHandleDtos.forEach(item->{
            Validate.isTrue(ProcessStatusEnum.PASS.getDictCode().equals(item.getProcessStatus())&&UpAccountStatusEnum.COMMIT_SUCCESS.getCode().equals(item.getUpAccountStatusReimburse()),"手动上账编码"+item.getAuditHandleCode()+"不能冲销");
        });

        this.doChargeAgainst(auditHandleDtos);
    }

    @Override
    public List<AuditPrintVo> batchPrint(List<String> ids) {

        if(CollectionUtils.isEmpty(ids)){
            return Lists.newArrayList();
        }

        List<AuditHandle> auditHandles = this.auditHandleRepository.findByIds(ids);
        List<AuditHandleVo> auditHandleVos = (List<AuditHandleVo>)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles, AuditHandle.class, AuditHandleVo.class, LinkedHashSet.class, ArrayList.class);
        List<String> auditHandleCodes = auditHandleVos.stream().map(AuditHandleVo::getAuditHandleCode).collect(Collectors.toList());
        List<AuditHandleDetail> auditHandleDetailList = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
        List<AuditHandleDetailVo> auditHandleDetailVos = (List<AuditHandleDetailVo>)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleDetailList, AuditHandleDetail.class, AuditHandleDetailVo.class, LinkedHashSet.class, ArrayList.class);

        Map<String, AuditHandleDetailVo> auditHandleDetailVoMap = auditHandleDetailVos.stream().collect(Collectors.toMap(AuditHandleDetailVo::getAuditHandleCode, Function.identity()));

        List<AuditPrintVo> auditPrintVos = new ArrayList<>();
        for (AuditHandleVo auditHandleVo : auditHandleVos) {
            AuditHandleDetailVo auditHandleDetailVo = auditHandleDetailVoMap.get(auditHandleVo.getAuditHandleCode());
            AuditPrintVo auditPrintVo = new AuditPrintVo();
            //1.组装抬头数据
            buildHeadInfo(auditPrintVo,auditHandleVo,auditHandleDetailVo);
            //1.1
            Set<String> auditCodes = new HashSet<>();
            auditCodes.add(auditHandleVo.getAuditHandleCode());
            getPaymentReceiptShould(auditCodes, auditPrintVo);
            //2.组装
            auditPrintVos.add(auditPrintVo);
        }
        return auditPrintVos;
    }

    private void getPaymentReceiptShould(Set<String> auditCodes, AuditPrintVo auditPrintVo) {
        List<PaymentReceiptShouldVo> paymentReceiptShouldVos = paymentReceiptSdkService.findPaymentReceiptShouldByAuditCode(auditCodes);
        if (CollectionUtils.isNotEmpty(paymentReceiptShouldVos)) {
            auditPrintVo.setPaymentReceiptShouldVos((List<PaymentReceiptShouldSdkVo>) nebulaToolkitService.copyCollectionByWhiteList(paymentReceiptShouldVos, PaymentReceiptShouldVo.class, PaymentReceiptShouldSdkVo.class, HashSet.class, ArrayList.class));
            Set<String> paymentReceiptCodes = paymentReceiptShouldVos.stream().map(PaymentReceiptShouldVo::getPaymentReceiptCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            List<PaymentReceiptPayVo> receiptPayVos = paymentReceiptSdkService.findByPaymentReceiptCodes(paymentReceiptCodes);
            if (CollectionUtils.isNotEmpty(receiptPayVos)) {
                auditPrintVo.setReceiptPayVos((List<PaymentReceiptPaySdkVo>) nebulaToolkitService.copyCollectionByWhiteList(receiptPayVos, PaymentReceiptPayVo.class, PaymentReceiptPaySdkVo.class, HashSet.class, ArrayList.class));
            }
        }
    }

    private void buildHeadInfo(AuditPrintVo auditPrintVo, AuditHandleVo auditHandleVo, AuditHandleDetailVo auditHandleDetailVo) {

        String belnr = auditHandleVo.getBelnr();
        String gjahr = auditHandleVo.getGjahr();
        String companyCode = auditHandleVo.getCompanyCode();


        BeanUtils.copyProperties(auditHandleVo,auditPrintVo);

        auditPrintVo.setFiscalYear(gjahr);
        Date date = auditHandleVo.getCreateTime();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int month = localDate.getMonthValue();
        auditPrintVo.setPeriod(String.valueOf(month));
        String documentCode = (StringUtils.isNotBlank(belnr) ? belnr : "") + (StringUtils.isNotBlank(companyCode) ? companyCode : "") + (StringUtils.isNotBlank(gjahr) ? gjahr : "");
        auditPrintVo.setDocumentCode(documentCode);
        auditPrintVo.setCertificateCode(belnr);
        auditPrintVo.setCertificateTitleText(auditHandleDetailVo.getCostCenterName());
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        if (Objects.nonNull(loginDetails)) {
            auditPrintVo.setPreparedBy(auditHandleVo.getCreateAccount() + "-" + auditHandleVo.getCreateName());
        }
        String preparedBy = auditPrintVo.getPreparedBy();
        if (StringUtils.isBlank(preparedBy) || preparedBy.contains("admin")) {
            auditPrintVo.setPreparedBy(auditHandleVo.getModifyAccount() + "-" + auditHandleVo.getModifyName());
        }
        auditPrintVo.setAppendices(auditHandleVo.getAppendices());
        auditPrintVo.setReference(auditHandleVo.getAuditHandleCode());
        auditPrintVo.setPaymentReference(auditHandleDetailVo.getCustomerCode());
        try {
            auditPrintVo.setBarCode(Base64.getEncoder().encodeToString(documentCode.getBytes("utf-8")));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        auditPrintVo.setCustomerSupplierName(auditHandleDetailVo.getCustomerName());
        auditPrintVo.setReimburseItem(auditHandleDetailVo.getReimburseItemName());
        auditPrintVo.setThisEndCaseTaxTotalAmount(auditHandleDetailVo.getThisAuditAmountTax());
        auditPrintVo.setReimburseTaxRate(Optional.ofNullable(auditHandleDetailVo.getDiscountTaxRate()).orElse(BigDecimal.ZERO).toPlainString());
        auditPrintVo.setAuditTaxTotalAmount(auditHandleDetailVo.getThisAuditAmountTax());
        auditPrintVo.setTaxTotalAmount(auditHandleDetailVo.getTaxAmount());
        auditPrintVo.setAuditTotalAmount(auditHandleDetailVo.getThisAuditAmountNotTax());
    }

    private void doChargeAgainst(List<AuditHandleDto> auditHandleList) {

        AuditHandleSdkServiceImpl bean = applicationContext.getBean(AuditHandleSdkServiceImpl.class);
        for (AuditHandleDto auditHandle : auditHandleList) {
            bean.chargeAgainstOne(auditHandle);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void chargeAgainstOne(AuditHandleDto auditHandle) {
        //1.推送sap
        pushSap(auditHandle);
        //2.清理发票
        clearInvoice(auditHandle.getAuditHandleCode());
        //3.回退预算
        useBudget(Collections.singletonList(auditHandle),AuditUseBudgetTypeEnum.RETURN);
    }

    private void pushSap(AuditHandleDto auditHandle) {
        ChargeAgainstAccountingVoucherDto chargeAgainstAccountingVoucherDto = new ChargeAgainstAccountingVoucherDto();
        ChargeAgainstAccountingVoucherDto.ItData itData = new ChargeAgainstAccountingVoucherDto.ItData();
        List<ChargeAgainstAccountingVoucherDto.ItData.Item> itemList = new ArrayList<>();

        ChargeAgainstAccountingVoucherDto.ItData.Item item = new ChargeAgainstAccountingVoucherDto.ItData.Item();
        String[] split = auditHandle.getAuditHandleCode().split("-");
        item.setTPID(split[1]);
        item.setOBJECT_ID(split[1]);
        item.setBELNR(auditHandle.getBelnr());
        item.setBUKRS(auditHandle.getBukrs());
        item.setGJAHR(auditHandle.getGjahr());
        itemList.add(item);
        itData.setItem(itemList);
        chargeAgainstAccountingVoucherDto.setIT_DATA(itData);
        ChargeAgainstAccountingVoucherVo chargeAgainstAccountingVoucherVo = sapCenterService.pushSapChargeAgainstAccountingVoucher(chargeAgainstAccountingVoucherDto);
        String message = null;
        AuditHandle auditHandle1 = new AuditHandle();
        auditHandle1.setId(auditHandle.getId());
        if (Objects.nonNull(chargeAgainstAccountingVoucherVo)) {
            if (Objects.nonNull(chargeAgainstAccountingVoucherVo.getET_BELNR())&&CollectionUtils.isNotEmpty(chargeAgainstAccountingVoucherVo.getET_BELNR().getItem())) {
                for (ChargeAgainstAccountingVoucherVo.EtBelnr.Item item2 : chargeAgainstAccountingVoucherVo.getET_BELNR().getItem()) {
                    auditHandle1.setBelnr2(item2.getBELNR());
                    auditHandle1.setBukrs2(item2.getBUKRS());
                    auditHandle1.setGjahr2(item2.getGJAHR());
                    auditHandle1.setUpAccountStatusReimburse(UpAccountStatusEnum.WRITE_OFF.getCode());
                }
            }
            if (Objects.nonNull(chargeAgainstAccountingVoucherVo.getET_MESSAGE())&&CollectionUtils.isNotEmpty(chargeAgainstAccountingVoucherVo.getET_MESSAGE().getItem())) {
                for (ChargeAgainstAccountingVoucherVo.EtMessage.Item item2 : chargeAgainstAccountingVoucherVo.getET_MESSAGE().getItem()) {
                    if (SuccessAndFailEnum.FAIL.getCode().equals(item2.getTYPE())) {
                        message = item2.getMESSAGE() + "||" + message;
                    }
                }
                if (StringUtils.isNotEmpty(message)) {
                    throw new RuntimeException(message);
                }
            }
        }
        this.auditHandleRepository.updateById(auditHandle1);
    }

    private void clearInvoice(String auditHandleCode) {
        if(StringUtils.isEmpty(auditHandleCode)){
            return;
        }

        List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCode(auditHandleCode);
        //1.删除上账的发票
        this.auditHandleInvoiceRepository.updateDelStatusByAuditHandleCode(auditHandleCode);

        //2.发票管理的发票清理状态
        List<AuditInvoiceManageDto> auditInvoiceManageDtoList = new ArrayList<>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
            AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
            auditInvoiceManageDto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
            auditInvoiceManageDto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
            auditInvoiceManageDtoList.add(auditInvoiceManageDto);
        }
        auditInvoiceManageService.updateByNoAndCode(auditInvoiceManageDtoList,YesOrNoEnum.NO.getCode(),df.format(new Date()));
    }

    private void fillData(List<AuditHandleDetailVo> records) {
        List<String> auditHandleCodes = records.stream().map(AuditHandleDetailVo::getAuditHandleCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(auditHandleCodes)){
            List<AuditHandleInvoice> auditHandleInvoices = this.auditHandleInvoiceRepository.findByAuditHandleCodes(auditHandleCodes);
            Map<String, List<AuditHandleInvoice>> auditHandleInvoicesMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(auditHandleInvoices)){
                auditHandleInvoicesMap = auditHandleInvoices.stream().collect(Collectors.groupingBy(AuditHandleInvoice::getAuditHandleCode));
            }
            for (AuditHandleDetailVo record : records) {
                List<AuditHandleInvoice> auditHandleInvoices2 = auditHandleInvoicesMap.get(record.getAuditHandleCode());
                if(CollectionUtils.isNotEmpty(auditHandleInvoices2)) {
                    String invoiceCode = null;
                    String invoiceNumber = null;
                    for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices2) {
                        String invoiceCode2 = auditHandleInvoice.getInvoiceCode();
                        String invoiceNumber2 = auditHandleInvoice.getInvoiceNumber();
                        if (StringUtils.isNotEmpty(invoiceNumber2)) {
                            if (StringUtils.isEmpty(invoiceCode2)) {
                                invoiceCode2 = "0";
                            }
                            if (StringUtils.isEmpty(invoiceCode)) {
                                invoiceCode = invoiceCode2;
                            } else {
                                invoiceCode = invoiceCode + "," + invoiceCode2;
                            }
                            if (StringUtils.isEmpty(invoiceNumber)) {
                                invoiceNumber = invoiceNumber + "," + invoiceNumber2;
                            } else {
                                invoiceNumber = invoiceNumber2;
                            }
                        }
                    }
                    record.setInvoiceCode(invoiceCode);
                    record.setInvoiceNumber(invoiceNumber);
                }
            }
        }
    }

    /**
     * 获取业态数据字典：mdm_business_format
     * @return
     */
    private Map<String, String> getBusinessFormatDict() {
        List<DictDataVo> dictDataVoList = this.dictDataVoService.findByDictTypeCode(AuditHandleConstant.BUSINESS_FORMAT_CODE_DICT_CODE);
        if (CollectionUtils.isEmpty(dictDataVoList)) {
            return Maps.newHashMap();
        }
        return dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictValue,DictDataVo::getDictCode));
    }

    /**
     * 编辑时处理明细表信息
     * 此处可控制编辑导入时可编辑信息
     * @param auditHandleDetail
     * @param e
     */
    private void handleDetailData(AuditHandleDetail auditHandleDetail, AuditHandleImportVo e) {
        auditHandleDetail.setSalesOrgCode(e.getSalesOrgCode());
        auditHandleDetail.setSalesGroupCode(e.getSalesGroupCode());
        auditHandleDetail.setChannelCode(e.getChannelCode());
        auditHandleDetail.setCustomerCode(e.getCustomerCode());
//        auditHandleDetail.setFeeYearMonth(e.getFeeYearMonth());
        auditHandleDetail.setYearBudgetCode(e.getYearBudgetCode());
        auditHandleDetail.setActivityTypeCode(e.getActivityTypeCode());
        auditHandleDetail.setActivityFormCode(e.getActivityFormCode());
        auditHandleDetail.setProductBrandCode(e.getProductBrandCode());
        auditHandleDetail.setProductCode(e.getProductCode());
//        auditHandleDetail.setActivityBeginDate(e.getActivityBeginDate());
//        auditHandleDetail.setActivityEndDate(e.getActivityEndDate());
//        auditHandleDetail.setApplyFee(e.getApplyFee());
//        auditHandleDetail.setThisAuditAmountTax(e.getThisAuditAmountTax());
//        auditHandleDetail.setThisAuditAmountNotTax(e.getThisAuditAmountNotTax());
//        auditHandleDetail.setThisAuditAmountNotTax(e.getThisAuditAmountNotTax());
        auditHandleDetail.setEndCaseForm(e.getEndCaseForm());
        auditHandleDetail.setLookLikeSale(e.getLookLikeSale());
    }

    /**
     * 编辑时处理抬头表信息
     * 此处可控制编辑导入时可编辑信息
     * @param auditHandle
     * @param e
     */
    private void handleData(AuditHandle auditHandle, AuditHandleImportVo e) {
        //auditHandle.setBusinessFormatName(e.getBusinessFormatName());
        auditHandle.setBusinessFormatCode(e.getBusinessFormatCode());
        auditHandle.setBusinessUnitCode(e.getBusinessUnitCode());
        auditHandle.setDepartmentCode(e.getDepartmentCode());
        auditHandle.setCompanyCode(e.getCompanyCode());
//        auditHandle.setThisAuditAmountTotalTax(e.getThisAuditAmountTax());
//        auditHandle.setThisAuditAmountTotalNotTax(e.getThisAuditAmountNotTax());
    }

    private String getBusinessUnitCode(Map<String, Object> params) {
        Object businessUnitCode = params.get("businessUnitCode");
        return (String) businessUnitCode;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        liquibase.util.Validate.notNull(cacheKey,"缓存可以不能为空");
        return (String) cacheKey;
    }


    /**
     * 文字转编码
     * @param data
     */
    private void descToCode(LinkedHashMap<Integer, AuditHandleImportVo> data){

        List<String> dictTypeCodeList = Lists.newArrayList(AuditHandleConstant.BUSINESS_FORMAT_CODE_DICT_CODE,
                AuditHandleConstant.MDM_BUSINESS_UNIT_DICT_CODE,
                AuditHandleConstant.TPM_AUDIT_FORM_DICT_CODE,
                AuditHandleConstant.AUDIT_FORM_DICT_CODE);
        Map<String, List<DictDataVo>> dictDataVoListMap = this.dictDataVoService.findByDictTypeCodeList(dictTypeCodeList);

    }

    /**
     * 导入验证
     * @param data
     */
    private void auditHandleImportValidation(LinkedHashMap<Integer, AuditHandleImportVo> data){
        data.forEach((index, o) -> {
//            Validate.notBlank(o.getUndertakingType(),"第【%s】行，数据导入数据时，承接类型不能为空",index);
//            Validate.notBlank(o.getRelationType(),"第【%s】行，数据导入数据时，关联类型不能为空",index);
//            Validate.notBlank(o.getCostManage(),"第【%s】行，数据导入数据时，费用归口不能为空",index);
//            Validate.notBlank(o.getBudgetCode(),"第【%s】行，数据导入数据时，预算编码不能为空",index);
//            Validate.notBlank(o.getCostYearMonth(),"第【%s】行，数据导入数据时，费用年月不能为空",index);
//            Validate.notNull(o.getStartDate(),"第【%s】行，数据导入数据时，开始时间不能为空",index);
//            Validate.notNull(o.getEndDate(),"第【%s】行，数据导入数据时，结束时间不能为空",index);
            Validate.notBlank(o.getActivityTypeCode(),"第【%s】行，数据导入数据时，活动分类编码不能为空",index);
//            Validate.notBlank(o.getActivityTypeName(),"第【%s】行，数据导入数据时，活动分类名称不能为空",index);
            Validate.notBlank(o.getActivityFormCode(),"第【%s】行，数据导入数据时，活动形式编码不能为空",index);
//            Validate.notBlank(o.getActivityFormName(),"第【%s】行，数据导入数据时，活动形式名称不能为空",index);
            Validate.notBlank(o.getProductBrandCode(),"第【%s】行，数据导入数据时，品牌编码不能为空",index);
            Validate.notBlank(o.getProductCategoryCode(),"第【%s】行，数据导入数据时，品类编码不能为空",index);
            Validate.notBlank(o.getProductItemCode(),"第【%s】行，数据导入数据时，品项编码不能为空",index);
            Validate.notBlank(o.getProductCode(),"第【%s】行，数据导入数据时，产品编码不能为空",index);
            Validate.notBlank(o.getProductName(),"第【%s】行，数据导入数据时，产品名称不能为空",index);
//            Validate.notNull(o.getProductPrice(),"第【%s】行，数据导入数据时，产品单价不能为空",index);
//            Validate.notNull(o.getActivityPrice(),"第【%s】行，数据导入数据时，活动价不能为空",index);
            Validate.notBlank(o.getCustomerCode(),"第【%s】行，数据导入数据时，客户编码不能为空",index);
            Validate.notBlank(o.getCustomerName(),"第【%s】行，数据导入数据时，客户名称不能为空",index);
//            Validate.notBlank(o.getWhetherDeductionFeePool(),"第【%s】行，数据导入数据时，是否扣减费用池不能为空",index);
//            Validate.notBlank(o.getAuditForm(),"第【%s】行，数据导入数据时，结案形式不能为空",index);

//            AuditFormEnum formEnum = AuditFormEnum.findEnumByCode(o.getAuditForm());
//            switch (formEnum){
//                case DISCOUNT:
//                    Validate.notNull(o.getDiscountTaxRate(),"第【%s】行，数据导入数据时，折扣税率不能为空",index);
//                    Validate.notNull(o.getDiscountShouldHandleAmount(),"第【%s】行，数据导入数据时，折扣应处理金额不能为空",index);
//                    Validate.notNull(o.getDiscountDeductionTaxAmount(),"第【%s】行，数据导入数据时，折扣扣税金额不能为空",index);
//                    Validate.notNull(o.getInFeePoolAmount(),"第【%s】行，数据导入数据时，入费用池金额不能为空",index);
//                    break;
//                case REIMBURSE:
//                    Validate.notBlank(o.getInvoiceCode(),"第【%s】行，数据导入数据时，发票代码不能为空",index);
//                    Validate.notBlank(o.getInvoiceNumber(),"第【%s】行，数据导入数据时，发票号码不能为空",index);
//                    Validate.notBlank(o.getReimburseItemCode(),"第【%s】行，数据导入数据时，报销项目编码不能为空",index);
//                    Validate.notNull(o.getReimburseTaxRate(),"第【%s】行，数据导入数据时，报销税率不能为空",index);
//                    Validate.notNull(o.getReimburseAmountTax(),"第【%s】行，数据导入数据时，报销金额（含税）不能为空",index);
//                    Validate.notNull(o.getReimburseAmountNoTax(),"第【%s】行，数据导入数据时，报销金额（未税）不能为空",index);
//                    Validate.notNull(o.getTaxAmount(),"第【%s】行，数据导入数据时，税额不能为空",index);
//                    Validate.notNull(o.getPersonalTaxAmount(),"第【%s】行，数据导入数据时，个人所得税不能为空",index);
//                    Validate.notNull(o.getCostCenterCode(),"第【%s】行，数据导入数据时，成本中心编码不能为空",index);
//                    Validate.notNull(o.getCostCenterName(),"第【%s】行，数据导入数据时，成本中心名称不能为空",index);
//                    Validate.notNull(o.getProfitCenterName(),"第【%s】行，数据导入数据时，利润中心名称不能为空",index);
//                    break;
//                case RED_WORD_INVOICE:
//                    Validate.notBlank(o.getImpulseDifferenceProductCode(),"第【%s】行，数据导入数据时，冲差产品编码不能为空",index);
//                    Validate.notBlank(o.getImpulseDifferenceProductName(),"第【%s】行，数据导入数据时，冲差产品名称不能为空",index);
//                    Validate.notBlank(o.getUnit(),"第【%s】行，数据导入数据时，单位不能为空",index);
//                    Validate.notNull(o.getQuantity(),"第【%s】行，数据导入数据时，数量不能为空",index);
//                    Validate.notBlank(o.getFactoryName(),"第【%s】行，数据导入数据时，工厂不能为空",index);
//                    break;
//            }
            Validate.notNull(o.getThisAuditAmountTax(),"第【%s】行，数据导入数据时，本次结案金额(含税)不能为空",index);
//            Validate.notBlank(o.getWhetherWholeAudit(),"第【%s】行，数据导入数据时，是否完全结案不能为空",index);
        });
    }

    private void detailImportCacheSave(LinkedHashMap<Integer, AuditHandleImportVo> data,String cacheKey){
        List<AuditHandleImportVo> importVos = (ArrayList<AuditHandleImportVo>)data.values();

        List<AuditHandleDetailVo> auditHandleDetailVos = (ArrayList<AuditHandleDetailVo>)this.nebulaToolkitService.copyCollectionByWhiteList(importVos, AuditHandleImportVo.class, AuditHandleDetailVo.class, HashSet.class, ArrayList.class);
        redisTemplate.delete(cacheKey);
        if (CollectionUtils.isNotEmpty(auditHandleDetailVos)){
            auditHandleDetailVos.forEach(o -> o.setId(UUID.randomUUID().toString().replace(AuditHandleConstant.SHORT_LINE,StringUtils.EMPTY)));
            redisTemplate.opsForList().rightPushAll(cacheKey, auditHandleDetailVos.toArray());
            redisTemplate.expire(cacheKey, 1, TimeUnit.HOURS);
        }

    }


    @Override
    public List<AuditHandleDetailVo> findListForReconciliation(AuditHandleDetailDto handleDetailDto) {
        if (Objects.isNull(handleDetailDto)
                || StringUtils.isBlank(handleDetailDto.getBusinessFormatCode())
                || StringUtils.isBlank(handleDetailDto.getBusinessUnitCode())
                || StringUtils.isBlank(handleDetailDto.getCustomerCode())
                || Objects.isNull(handleDetailDto.getActivityBeginDate())
                || Objects.isNull(handleDetailDto.getActivityEndDate())){

            return Lists.newArrayList();
        }
        List<AuditHandleDetailVo> list = this.auditHandleDetailRepository.findListForReconciliation(handleDetailDto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public List<String> auditHandleCustomerList(AuditHandleDetailDto handleDetailDto) {
        if (Objects.isNull(handleDetailDto)
                || StringUtils.isBlank(handleDetailDto.getBusinessFormatCode())
                || StringUtils.isBlank(handleDetailDto.getBusinessUnitCode())
                || Objects.isNull(handleDetailDto.getActivityBeginDate())
                || Objects.isNull(handleDetailDto.getActivityEndDate())) {

            return Lists.newArrayList();
        }
        List<String> list = this.auditHandleDetailRepository.auditHandleCustomerList(handleDetailDto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}
