/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleProcessSubmitDto;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditPrintVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/v1/audit/handle"})
@RestController
@Api(tags={"\u624b\u52a8\u4e0a\u8d26controller"})
public class AuditHandleController {
    private static final Logger log = LoggerFactory.getLogger(AuditHandleController.class);
    @Autowired(required=false)
    private AuditHandleSdkService auditHandleSdkService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public Result<AuditHandleVo> create(@RequestBody AuditHandleDto auditHandleDto) {
        try {
            AuditHandleVo auditHandleVo = this.auditHandleSdkService.create(auditHandleDto);
            return Result.ok((Object)auditHandleVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PatchMapping
    @ApiOperation(value="\u7f16\u8f91")
    public Result<AuditHandleVo> update(@RequestBody AuditHandleDto auditHandleDto) {
        boolean isLock = false;
        String key = "";
        try {
            Validate.notBlank((CharSequence)auditHandleDto.getId(), (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            key = "audit:handle:update:" + auditHandleDto.getId();
            isLock = this.redisLockService.tryLock(key, TimeUnit.SECONDS, 3600L);
            if (!isLock) {
                throw new RuntimeException("\u52a0\u9501\u5f02\u5e38");
            }
            AuditHandleVo auditHandleVo = this.auditHandleSdkService.update(auditHandleDto);
            Result result = Result.ok((Object)auditHandleVo);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (isLock) {
                this.redisLockService.unlock(key);
            }
        }
    }

    @GetMapping(value={"findById"})
    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u8be6\u60c5")
    public Result<AuditHandleVo> findById(@ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            AuditHandleVo handleVo = this.auditHandleSdkService.findById(id);
            return Result.ok((Object)handleVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findByAuditHandleCode"})
    @ApiOperation(value="\u6839\u636e\u624b\u52a8\u6838\u9500\u7f16\u7801\u83b7\u53d6\u8be6\u60c5")
    public Result<AuditHandleVo> findByAuditHandleCode(@ApiParam(name="auditHandleCode", value="\u624b\u52a8\u6838\u9500\u7f16\u7801") String auditHandleCode) {
        try {
            AuditHandleVo handleVo = this.auditHandleSdkService.findByAuditHandleCode(auditHandleCode);
            return Result.ok((Object)handleVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u624b\u52a8\u4e0a\u8d26\u6838\u9500\u5355")
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.auditHandleSdkService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4")
    @PostMapping(value={"submitApproval"})
    public Result submitApproval(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4") @RequestBody AuditHandleProcessSubmitDto dto) {
        try {
            this.auditHandleSdkService.submitApprove(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4e0a\u8d26")
    @PostMapping(value={"upAccountBatch"})
    public Result upAccountBatch(@RequestBody List<String> ids) {
        boolean hasLock = false;
        try {
            hasLock = this.redisLockService.batchLock("audit_handle:up_account_batch", ids, TimeUnit.MINUTES, 30);
            if (!hasLock) {
                throw new RuntimeException("\u6b63\u5728\u4e0a\u8d26\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001");
            }
            this.auditHandleSdkService.upAccountBatch(ids);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (hasLock) {
                this.redisLockService.batchUnLock("audit_handle:up_account_batch", ids);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u624b\u52a8\u4e0a\u8d26\u62a5\u9500\u51b2\u9500")
    @PostMapping(value={"reimburseChargeAgainst"})
    public Result<?> reimburseChargeAgainst(@RequestBody List<String> ids) {
        boolean hasLock = false;
        try {
            hasLock = this.redisLockService.batchLock("audit_handle:audit_reimburse_charge_against", ids, TimeUnit.MINUTES, 30);
            Validate.isTrue((boolean)hasLock, (String)"\u6b63\u5728\u624b\u52a8\u4e0a\u8d26\u62a5\u9500\u51b2\u9500\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001", (Object[])new Object[0]);
            this.auditHandleSdkService.reimburseChargeAgainst(ids);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error("\u624b\u52a8\u4e0a\u8d26\u62a5\u9500\u51b2\u9500\u5931\u8d25\uff1a", (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (hasLock) {
                this.redisLockService.batchUnLock("audit_handle:audit_reimburse_charge_against", ids);
            }
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6253\u5370")
    @PostMapping(value={"batchPrint"})
    public Result<List<AuditPrintVo>> batchPrint(@RequestBody List<String> ids) {
        return Result.ok((Object)this.auditHandleSdkService.batchPrint(ids));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<AuditHandleDetailVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditHandleDetailDto dto) {
        try {
            Page page = this.auditHandleSdkService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

