/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleInvoiceCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleInvoiceDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleSaveInvoiceCacheDto;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleInvoiceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/v1/audit/auditHandleInvoice"})
@RestController
@Api(tags={"\u53d1\u7968controller"})
public class AuditHandleInvoiceCacheController
extends MnPageCacheController<AuditHandleInvoiceVo, AuditHandleInvoiceDto> {
    private static final Logger log = LoggerFactory.getLogger(AuditHandleInvoiceCacheController.class);
    @Autowired(required=false)
    private AuditHandleInvoiceCacheService auditHandleInvoiceCacheService;
    @Autowired(required=false)
    private AuditHandleSdkService auditHandleSdkService;

    @ApiOperation(value="\u4fdd\u5b58\u53d1\u7968\u5230\u7f13\u5b58")
    @PostMapping(value={"saveInvoiceCache"})
    public Result<?> saveInvoiceCache(@RequestBody AuditHandleSaveInvoiceCacheDto dto) {
        try {
            this.auditHandleInvoiceCacheService.saveInvoiceCache(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiModelProperty(value="\u53d1\u7968\u63d0\u4ea4")
    @GetMapping(value={"invoiceSubmit"})
    public Result<?> invoiceSubmit(@RequestParam(value="cacheKey") String cacheKey, @RequestParam(value="auditHandleCode") String auditHandleCode, @RequestParam(value="appendices") Integer appendices) {
        try {
            Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)auditHandleCode, (String)"\u624b\u52a8\u4e0a\u8d26\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)appendices, (String)"\u9644\u4ef6\u5f20\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            List cacheList = this.auditHandleInvoiceCacheService.findCacheList(cacheKey);
            this.auditHandleInvoiceCacheService.deleteAuditHandleCodeInvoiceRelation(auditHandleCode);
            if (CollectionUtils.isNotEmpty((Collection)cacheList)) {
                this.auditHandleInvoiceCacheService.invoiceSubmit(cacheList, auditHandleCode);
                this.auditHandleInvoiceCacheService.clearCache(cacheKey);
                this.auditHandleSdkService.updateAppendicesByAuditHandleCode(appendices, auditHandleCode);
            }
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

