/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditHandleCacheHelper
extends MnPageCacheHelper<AuditHandleDetailVo, AuditHandleDetailDto> {
    @Autowired(required=false)
    private AuditHandleDetailRepository auditHandleDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getCacheKeyPrefix() {
        return "audit_handle:item_cache:";
    }

    public Class<AuditHandleDetailDto> getDtoClass() {
        return AuditHandleDetailDto.class;
    }

    public Class<AuditHandleDetailVo> getVoClass() {
        return AuditHandleDetailVo.class;
    }

    public List<AuditHandleDetailDto> findDtoListFromRepository(AuditHandleDetailDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getAuditHandleCode())) {
            return Lists.newArrayList();
        }
        List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleCode(dto.getAuditHandleCode());
        if (CollectionUtils.isEmpty(auditHandleDetails)) {
            return Lists.newArrayList();
        }
        Collection auditHandleDetailDtos = this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleDetails, AuditHandleDetail.class, AuditHandleDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return auditHandleDetailDtos.stream().sorted(Comparator.comparing(AuditHandleDetailDto::getAuditHandleDetailCode)).collect(Collectors.toList());
    }

    public List<AuditHandleDetailDto> newItem(String cacheKey, List<AuditHandleDetailDto> itemList) {
        AuditHandleDetailDto newItem = new AuditHandleDetailDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList((Object[])new AuditHandleDetailDto[]{newItem});
    }

    public List<AuditHandleDetailDto> copyItem(String cacheKey, List<AuditHandleDetailDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, AuditHandleDetailDto.class, AuditHandleDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (AuditHandleDetailDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setAuditHandleDetailCode(null);
        }
        return newItemList;
    }

    public Object getDtoKey(AuditHandleDetailDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(AuditHandleDetailDto dto) {
        return dto.getChecked();
    }
}

