/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleInvoiceDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleInvoiceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditHandleInvoiceCacheHelper
extends MnPageCacheHelper<AuditHandleInvoiceVo, AuditHandleInvoiceDto> {
    @Autowired(required=false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getCacheKeyPrefix() {
        return "audit_handle:invoice_cache:";
    }

    public Class<AuditHandleInvoiceDto> getDtoClass() {
        return AuditHandleInvoiceDto.class;
    }

    public Class<AuditHandleInvoiceVo> getVoClass() {
        return AuditHandleInvoiceVo.class;
    }

    public List<AuditHandleInvoiceDto> findDtoListFromRepository(AuditHandleInvoiceDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getAuditHandleCode())) {
            return Lists.newArrayList();
        }
        List<AuditHandleInvoice> auditHandleInvoices = this.auditHandleInvoiceRepository.findByAuditHandleCode(dto.getAuditHandleCode());
        if (CollectionUtils.isEmpty(auditHandleInvoices)) {
            return Lists.newArrayList();
        }
        Collection auditHandleInvoiceDtos = this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleInvoices, AuditHandleInvoice.class, AuditHandleInvoiceDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditHandleInvoiceDtos;
    }

    public List<AuditHandleInvoiceDto> newItem(String cacheKey, List<AuditHandleInvoiceDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            AuditHandleInvoiceDto newItem = new AuditHandleInvoiceDto();
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            return Lists.newArrayList((Object[])new AuditHandleInvoiceDto[]{newItem});
        }
        for (AuditHandleInvoiceDto item : itemList) {
            item.setId(UUID.randomUUID().toString().replace("-", ""));
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return itemList;
    }

    public List<AuditHandleInvoiceDto> copyItem(String cacheKey, List<AuditHandleInvoiceDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, AuditHandleInvoiceDto.class, AuditHandleInvoiceDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (AuditHandleInvoiceDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return newItemList;
    }

    public Object getDtoKey(AuditHandleInvoiceDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(AuditHandleInvoiceDto dto) {
        return dto.getChecked();
    }
}

