/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.lisenter;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleRepository;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDto;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AuditHandleProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(AuditHandleProcessCallBackListener.class);
    @Autowired(required=false)
    private AuditHandleRepository auditHandleRepository;
    @Autowired(required=false)
    private AuditHandleDetailRepository auditHandleDetailRepository;
    @Autowired(required=false)
    private AuditHandleSdkService auditHandleSdkService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Value(value="${rocketmq.environment}")
    private String rocketmqEnvironment;

    public void onProcessComplete(ProcessStatusDto dto) {
        Date curDate = DateUtil.getDate((SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss);
        log.info("\u76f4\u63a5\u4e0a\u8d26\u5ba1\u6279\u6d41\u56de\u8c03\uff0c\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
        List ids = dto.getBusinessNoList();
        Validate.notEmpty((Collection)ids, (String)"\u76f4\u63a5\u4e0a\u8d26\u5ba1\u6279\u6210\u529f\u56de\u8c03,\u63d0\u4ea4\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditHandle> auditHandles = this.auditHandleRepository.findByIds(ids);
        if (StringUtils.equals((CharSequence)dto.getProcessStatus(), (CharSequence)ProcessStatusEnum.PASS.getDictCode())) {
            Validate.notEmpty(auditHandles, (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664", (Object[])new Object[0]);
            List<String> auditHandleCodes = auditHandles.stream().map(o -> o.getAuditHandleCode()).filter(Objects::nonNull).collect(Collectors.toList());
            List<AuditHandleDetail> handleDetails = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
            ArrayList auditHandleDetailDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(handleDetails, AuditHandleDetail.class, AuditHandleDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<AuditHandleDetailDto>> auditHandleCodeMap = auditHandleDetailDtos.stream().collect(Collectors.groupingBy(AuditHandleDetailDto::getAuditHandleCode));
            ArrayList auditHandleDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles, AuditHandle.class, AuditHandleDto.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<AuditHandleDto>> unitMap = auditHandleDtos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getBusinessUnitCode())).collect(Collectors.groupingBy(AuditHandleDto::getBusinessUnitCode));
            List<AuditHandleDto> handlesSon = unitMap.get(BusinessUnitEnum.SON_COMPANY.getCode());
            this.auditHandleSdkService.sonCompanyBudgetDeduction(handlesSon, auditHandleCodeMap);
            List<AuditHandleDto> handlesHead = unitMap.get(BusinessUnitEnum.HEADQUARTERS.getCode());
            this.auditHandleSdkService.headQuartersBudgetDeduction(handlesHead, auditHandleCodeMap);
            this.auditHandleRepository.updateProcessStatusByIds(ids, dto.getProcessStatus(), curDate);
        } else if (StringUtils.equals((CharSequence)dto.getProcessStatus(), (CharSequence)ProcessStatusEnum.REJECT.getDictCode()) || StringUtils.equals((CharSequence)dto.getProcessStatus(), (CharSequence)ProcessStatusEnum.RECOVER.getDictCode())) {
            ArrayList auditHandleDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles, AuditHandle.class, AuditHandleDto.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<AuditHandleDto>> unitMap = auditHandleDtos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getBusinessUnitCode())).collect(Collectors.groupingBy(AuditHandleDto::getBusinessUnitCode));
            List<AuditHandleDto> handlesHead = unitMap.get(BusinessUnitEnum.HEADQUARTERS.getCode());
            this.rejectBudget(handlesHead);
            this.auditHandleRepository.updateProcessStatusByIds(ids, dto.getProcessStatus(), curDate);
        }
    }

    private void rejectBudget(List<AuditHandleDto> handlesHead) {
        if (CollectionUtils.isEmpty(handlesHead)) {
            return;
        }
        for (AuditHandleDto auditHandleDto : handlesHead) {
            ArrayList<String> auditDetailCodes = new ArrayList<String>();
            auditDetailCodes.add(auditHandleDto.getAuditHandleCode());
            this.monthBudgetService.auditUseRetrunOperateBudget(auditDetailCodes, auditHandleDto.getAuditHandleCode());
        }
    }

    public String getBusinessCode() {
        return "tpm_audit_handle_process";
    }
}

