/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.mapper.AuditHandleDetailMapper;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditHandleDetailRepository
extends ServiceImpl<AuditHandleDetailMapper, AuditHandleDetail> {
    public List<AuditHandleDetail> findByAuditHandleCode(String auditHandleCode) {
        if (StringUtils.isEmpty((CharSequence)auditHandleCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditHandleDetail::getAuditHandleCode, (Object)auditHandleCode)).list();
    }

    public List<AuditHandleDetail> findByAuditHandleCodes(List<String> auditHandleCodes) {
        if (CollectionUtils.isEmpty(auditHandleCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditHandleDetail::getAuditHandleCode, auditHandleCodes)).list();
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).remove();
    }

    public void deleteByAuditHandleCodes(List<String> auditHandleCodes) {
        if (CollectionUtils.isEmpty(auditHandleCodes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditHandleDetail::getAuditHandleCode, auditHandleCodes)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<AuditHandleDetail> findByAuditHandleDetailCodes(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditHandleDetail::getAuditHandleDetailCode, detailCodes)).list();
    }

    public List<AuditHandleDetail> findByUpAccountCodes(List<String> accountCodes) {
        if (CollectionUtils.isEmpty(accountCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditHandleDetail::getUpAccountCode, accountCodes)).list();
    }

    public Page<AuditHandleDetailVo> findByConditions(Pageable pageable, AuditHandleDetailDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((AuditHandleDetailMapper)this.getBaseMapper()).findByConditions((Page<AuditHandleDetailVo>)page, dto);
    }

    public List<AuditHandleDetailVo> findListForReconciliation(AuditHandleDetailDto handleDetailDto) {
        return ((AuditHandleDetailMapper)this.baseMapper).findListForReconciliation(handleDetailDto, TenantUtils.getTenantCode());
    }

    public List<String> auditHandleCustomerList(AuditHandleDetailDto handleDetailDto) {
        return ((AuditHandleDetailMapper)this.baseMapper).auditHandleCustomerList(handleDetailDto);
    }
}

