/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.mapper.AuditHandleInvoiceMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

@Component
public class AuditHandleInvoiceRepository
extends ServiceImpl<AuditHandleInvoiceMapper, AuditHandleInvoice> {
    public List<AuditHandleInvoice> findByAuditHandleCode(String auditHandleCode) {
        if (StringUtils.isEmpty((CharSequence)auditHandleCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditHandleInvoice::getAuditHandleCode, (Object)auditHandleCode)).list();
    }

    public void deleteByAuditHandleCode(String auditHandleCode) {
        Validate.notBlank((CharSequence)auditHandleCode, (String)"\u76f4\u63a5\u4e0a\u8d26\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.remove((Wrapper)Wrappers.lambdaUpdate(AuditHandleInvoice.class).eq(AuditHandleInvoice::getAuditHandleCode, (Object)auditHandleCode));
    }

    public List<AuditHandleInvoice> findByAuditHandleCodes(List<String> auditHandleCodes) {
        if (CollectionUtils.isNotEmpty(auditHandleCodes)) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditHandleInvoice::getAuditHandleCode, auditHandleCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
            return list;
        }
        return Lists.newArrayList();
    }

    public void deleteByAuditHandleCodes(List<String> auditHandleCodes) {
        if (CollectionUtils.isNotEmpty(auditHandleCodes)) {
            this.remove((Wrapper)Wrappers.lambdaUpdate(AuditHandleInvoice.class).in(AuditHandleInvoice::getAuditHandleCode, auditHandleCodes));
        }
    }

    public void updateDelStatusByAuditHandleCode(String auditHandleCode) {
        if (StringUtils.isEmpty((CharSequence)auditHandleCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).eq(AuditHandleInvoice::getAuditHandleCode, (Object)auditHandleCode)).update();
    }
}

