/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.service.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleEditExportsVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditHandleEditExportsProcess
implements ExportProcess<AuditHandleEditExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditHandleEditExportsProcess.class);
    @Autowired(required=false)
    private AuditHandleSdkService auditHandleSdkService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        AuditHandleDetailDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page pageResult = this.auditHandleSdkService.findByConditions((Pageable)pageable, dto = this.convertParams(params));
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        AuditHandleDetailDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageRequest = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page page = this.auditHandleSdkService.findByConditions((Pageable)pageRequest, dto = this.convertParams(params));
        List records = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            new JSONArray();
        }
        this.fillData(records);
        return JSON.parseArray((String)JSON.toJSONString((Object)records));
    }

    private void fillData(List<AuditHandleDetailVo> records) {
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format", "mdm_business_unit"}));
        for (AuditHandleDetailVo record : records) {
            record.setBusinessFormatCode(this.findDictValue(mapDict, "mdm_business_format", String.valueOf(record.getBusinessFormatCode())));
            record.setBusinessUnitCode(this.findDictValue(mapDict, "mdm_business_unit", String.valueOf(record.getBusinessUnitCode())));
            record.setEndCaseForm(EndCaseFormEnum.codeTransitionStr((String)record.getEndCaseForm()));
        }
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    private AuditHandleDetailDto convertParams(Map<String, Object> params) {
        AuditHandleDetailDto dto = (AuditHandleDetailDto)JSON.parseObject((String)JSON.toJSONString(params), AuditHandleDetailDto.class);
        ArrayList<String> processStatusList = new ArrayList<String>();
        processStatusList.add(ProcessStatusEnum.PREPARE.getDictCode());
        processStatusList.add(ProcessStatusEnum.REJECT.getDictCode());
        processStatusList.add(ProcessStatusEnum.RECOVER.getDictCode());
        dto.setProcessStatusList(processStatusList);
        return dto;
    }

    public String getBusinessCode() {
        return "audit_handle_edit_exports";
    }

    public String getBusinessName() {
        return "\u76f4\u63a5\u4e0a\u8d26\u5bfc\u51fa\u7f16\u8f91";
    }
}

