/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.service.imports;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleRepository;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleEditImportVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditHandleEditImportsProcess
implements ImportProcess<AuditHandleEditImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditHandleEditImportsProcess.class);
    @Autowired(required=false)
    private AuditHandleRepository auditHandleRepository;
    @Autowired(required=false)
    private AuditHandleDetailRepository auditHandleDetailRepository;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetSdkService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CostCenterVoService costCenterVoService;
    @Autowired(required=false)
    private AccountSubjectService accountSubjectService;
    @Autowired(required=false)
    private AuditInvoiceManageService auditInvoiceManageService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;

    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditHandleEditImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Object, Object> errorMap = new HashMap();
        try {
            log.info("\u76f4\u63a5\u4e0a\u8d26\u7f16\u8f91\u5bfc\u5165+++++++++++++++++++++++++++");
            log.info("\u76f4\u63a5\u4e0a\u8d26\u7f16\u8f91\u5bfc\u5165,\u5bfc\u5165\u6570\u636e:{}", (Object)JsonUtils.obj2JsonString(data.values()));
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            ArrayList auditHandleList = Lists.newArrayList();
            ArrayList auditHandleDetailList = Lists.newArrayList();
            ArrayList auditHandleInvoiceList = Lists.newArrayList();
            errorMap = this.validate(data, auditHandleList, auditHandleDetailList, auditHandleInvoiceList);
            if (CollectionUtils.isEmpty(errorMap.keySet())) {
                this.batchUpdate(auditHandleList, auditHandleDetailList, auditHandleInvoiceList);
            }
            log.info("\u76f4\u63a5\u4e0a\u8d26\u7f16\u8f91\u5bfc\u5165---------------------------");
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u7f16\u8f91\u624b\u52a8\u4e0a\u8d26", (Throwable)e);
            throw e;
        }
        return errorMap;
    }

    private void batchUpdate(List<AuditHandle> auditHandleList, List<AuditHandleDetail> auditHandleDetailList, List<AuditHandleInvoice> auditHandleInvoiceList) {
        if (CollectionUtils.isNotEmpty(auditHandleList)) {
            log.info("\u76f4\u63a5\u4e0a\u8d26\u7f16\u8f91\u5bfc\u5165,auditHandleList:{}", (Object)JsonUtils.obj2JsonString(auditHandleList));
            auditHandleList.forEach(item -> ((LambdaUpdateChainWrapper)this.auditHandleRepository.lambdaUpdate().eq(AuditHandle::getAuditHandleCode, (Object)item.getAuditHandleCode())).set(StringUtils.isNotEmpty((CharSequence)item.getDepartmentCode()), AuditHandle::getDepartmentCode, (Object)item.getDepartmentCode()).set(StringUtils.isNotEmpty((CharSequence)item.getDepartmentName()), AuditHandle::getDepartmentName, (Object)item.getDepartmentName()).set(Objects.nonNull(item.getAuditHandleName()), AuditHandle::getAuditHandleName, (Object)item.getAuditHandleName()).set(Objects.nonNull(item.getAppendices()), AuditHandle::getAppendices, (Object)item.getAppendices()).update());
        }
        if (CollectionUtils.isNotEmpty(auditHandleDetailList)) {
            log.info("\u76f4\u63a5\u4e0a\u8d26\u7f16\u8f91\u5bfc\u5165,auditHandleDetailList:{}", (Object)JsonUtils.obj2JsonString(auditHandleDetailList));
            auditHandleDetailList.forEach(item -> ((LambdaUpdateChainWrapper)this.auditHandleDetailRepository.lambdaUpdate().eq(AuditHandleDetail::getAuditHandleCode, (Object)item.getAuditHandleCode())).set(StringUtils.isNotEmpty((CharSequence)item.getChannelCode()), AuditHandleDetail::getChannelCode, (Object)item.getChannelCode()).set(StringUtils.isNotEmpty((CharSequence)item.getChannelName()), AuditHandleDetail::getChannelName, (Object)item.getChannelName()).set(Objects.nonNull(item.getFeeYearMonth()), AuditHandleDetail::getFeeYearMonth, (Object)item.getFeeYearMonth()).set(StringUtils.isNotEmpty((CharSequence)item.getYearBudgetCode()), AuditHandleDetail::getYearBudgetCode, (Object)item.getYearBudgetCode()).set(StringUtils.isNotEmpty((CharSequence)item.getYearBudgetName()), AuditHandleDetail::getYearBudgetName, (Object)item.getYearBudgetName()).set(StringUtils.isNotEmpty((CharSequence)item.getActivityTypeCode()), AuditHandleDetail::getActivityTypeCode, (Object)item.getActivityTypeCode()).set(StringUtils.isNotEmpty((CharSequence)item.getActivityTypeName()), AuditHandleDetail::getActivityTypeName, (Object)item.getActivityTypeName()).set(StringUtils.isNotEmpty((CharSequence)item.getActivityFormCode()), AuditHandleDetail::getActivityFormCode, (Object)item.getActivityFormCode()).set(StringUtils.isNotEmpty((CharSequence)item.getActivityFormName()), AuditHandleDetail::getActivityFormName, (Object)item.getActivityFormName()).set(StringUtils.isNotEmpty((CharSequence)item.getProductBrandCode()), AuditHandleDetail::getProductBrandCode, (Object)item.getProductBrandCode()).set(StringUtils.isNotEmpty((CharSequence)item.getProductBrandName()), AuditHandleDetail::getProductBrandName, (Object)item.getProductBrandName()).set(StringUtils.isNotEmpty((CharSequence)item.getProductCategoryCode()), AuditHandleDetail::getProductCategoryCode, (Object)item.getProductCategoryCode()).set(StringUtils.isNotEmpty((CharSequence)item.getProductCategoryName()), AuditHandleDetail::getProductCategoryName, (Object)item.getProductCategoryName()).set(StringUtils.isNotEmpty((CharSequence)item.getProductItemCode()), AuditHandleDetail::getProductItemCode, (Object)item.getProductItemCode()).set(StringUtils.isNotEmpty((CharSequence)item.getProductItemName()), AuditHandleDetail::getProductItemName, (Object)item.getProductItemName()).set(StringUtils.isNotEmpty((CharSequence)item.getProductCode()), AuditHandleDetail::getProductCode, (Object)item.getProductCode()).set(StringUtils.isNotEmpty((CharSequence)item.getProductName()), AuditHandleDetail::getProductName, (Object)item.getProductName()).set(Objects.nonNull(item.getActivityBeginDate()), AuditHandleDetail::getActivityBeginDate, (Object)item.getActivityBeginDate()).set(Objects.nonNull(item.getActivityEndDate()), AuditHandleDetail::getActivityEndDate, (Object)item.getActivityEndDate()).set(Objects.nonNull(item.getApplyFee()) && item.getApplyFee().compareTo(BigDecimal.ZERO) != 0, AuditHandleDetail::getApplyFee, (Object)item.getApplyFee()).set(Objects.nonNull(item.getThisAuditAmountNotTax()) && item.getThisAuditAmountNotTax().compareTo(BigDecimal.ZERO) != 0, AuditHandleDetail::getThisAuditAmountNotTax, (Object)item.getThisAuditAmountNotTax()).set(Objects.nonNull(item.getOtherDeductAmount()) && item.getOtherDeductAmount().compareTo(BigDecimal.ZERO) != 0, AuditHandleDetail::getOtherDeductAmount, (Object)item.getOtherDeductAmount()).set(Objects.nonNull(item.getDeductTaxAmount()) && item.getDeductTaxAmount().compareTo(BigDecimal.ZERO) != 0, AuditHandleDetail::getDeductTaxAmount, (Object)item.getDeductTaxAmount()).set(Objects.nonNull(item.getThisAuditAmountTax()) && item.getThisAuditAmountTax().compareTo(BigDecimal.ZERO) != 0, AuditHandleDetail::getThisAuditAmountTax, (Object)item.getThisAuditAmountTax()).set(StringUtils.isNotEmpty((CharSequence)item.getEndCaseForm()), AuditHandleDetail::getEndCaseForm, (Object)item.getEndCaseForm()).set(StringUtils.isNotEmpty((CharSequence)item.getReimburseItemCode()), AuditHandleDetail::getReimburseItemCode, (Object)item.getReimburseItemCode()).set(StringUtils.isNotEmpty((CharSequence)item.getReimburseItemName()), AuditHandleDetail::getReimburseItemName, (Object)item.getReimburseItemName()).set(StringUtils.isNotEmpty((CharSequence)item.getCostCenterCode()), AuditHandleDetail::getCostCenterCode, (Object)item.getCostCenterCode()).set(StringUtils.isNotEmpty((CharSequence)item.getCostCenterName()), AuditHandleDetail::getCostCenterName, (Object)item.getCostCenterName()).set(StringUtils.isNotEmpty((CharSequence)item.getLookLikeSale()), AuditHandleDetail::getLookLikeSale, (Object)item.getLookLikeSale()).set(StringUtils.isNotEmpty((CharSequence)item.getRemark()), UuidFlagOpEntity::getRemark, (Object)item.getRemark()).set(Objects.nonNull(item.getAuditHandleName()), AuditHandleDetail::getAuditHandleName, (Object)item.getAuditHandleName()).set(Objects.nonNull(item.getType()), AuditHandleDetail::getType, (Object)item.getType()).update());
        }
        if (CollectionUtils.isNotEmpty(auditHandleInvoiceList)) {
            List<String> auditHandleCodes = auditHandleInvoiceList.stream().map(AuditHandleInvoice::getAuditHandleCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(auditHandleCodes)) {
                this.deleteInvoiceRelation(auditHandleCodes);
            }
            this.auditHandleInvoiceRepository.saveBatch(auditHandleInvoiceList);
            ArrayList<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<AuditInvoiceManageDto>();
            for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
                AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
                dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
                dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
                invoiceManageDtoList.add(dto);
            }
            String useDate = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
            this.auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.YES.getCode(), useDate);
        }
    }

    private void deleteInvoiceRelation(List<String> auditHandleCodeList) {
        ArrayList<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<AuditInvoiceManageDto>();
        List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCodes(auditHandleCodeList);
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
            AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
            dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
            dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
            invoiceManageDtoList.add(dto);
        }
        this.auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.NO.getCode(), null);
        this.auditHandleInvoiceRepository.deleteByAuditHandleCodes(auditHandleCodeList);
    }

    private Map<Integer, String> validate(LinkedHashMap<Integer, AuditHandleEditImportVo> data, List<AuditHandle> auditHandleList, List<AuditHandleDetail> auditHandleDetailList, List<AuditHandleInvoice> auditHandleInvoiceList) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(data.values()), (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
        Map<String, AuditHandle> auditHandleVoMap = this.getAuditHandleVoMap(data.values());
        Map<String, AuditHandleDetail> auditHandleDetailVoMap = this.getAuditHandleDetailVoMap(data.values());
        Map<String, OrgVo> orgVoMap = this.getDepartmentVoMap(data.values());
        Map<String, CustomerChannelVo> channelVoMap = this.getChannelVoMap(data.values());
        Map<String, YearBudgetVo> yearBudgetVoMap = this.getYearBudgetVoMap(data.values());
        Map<String, ActivityTypeVo> activityTypeVoMap = this.getActivityTYpeVoMap(data.values());
        Map<String, ActivityFormVo> activityFormVoMap = this.getActivityFormVoMap(data.values());
        Map<String, ProductVo> productVoMap = this.getProductVoMap(data.values());
        Map<String, AccountSubjectVo> accountSubjectVoMap = this.getAccountSubjectVoMap(data.values());
        Map<String, CostCenterVo> costCenterVoMap = this.getCostCenterVoMap(data.values());
        ArrayList invoices = new ArrayList();
        data.forEach((key, value) -> {
            AuditHandleDetail auditHandleDetail1;
            ArrayList<String> errorList = new ArrayList<String>();
            AuditHandle auditHandle1 = (AuditHandle)((Object)((Object)auditHandleVoMap.get(value.getAuditHandleCode())));
            if (Objects.isNull((Object)auditHandle1)) {
                errorList.add("\u624b\u52a8\u4e0a\u8d26\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            } else if (!(ProcessStatusEnum.PREPARE.getDictCode().equals(auditHandle1.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(auditHandle1.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(auditHandle1.getProcessStatus()))) {
                errorList.add("\u5ba1\u6279\u72b6\u6001\u4e3a\u5f85\u63d0\u4ea4\uff0c\u9a73\u56de\uff0c\u8ffd\u56de\u7684\u624d\u5141\u8bb8\u7f16\u8f91");
            }
            List auditHandleInvoices = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)value.getInvoiceCode()) && StringUtils.isEmpty((CharSequence)value.getInvoiceNumber())) {
                errorList.add("\u586b\u5199\u4e86\u53d1\u7968\u4ee3\u7801\uff0c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)value.getInvoiceCode()) && StringUtils.isNotEmpty((CharSequence)value.getInvoiceNumber())) {
                errorList.add("\u586b\u5199\u4e86\u53d1\u7968\u53f7\u7801\uff0c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getInvoiceCode()) && StringUtils.isNotEmpty((CharSequence)value.getInvoiceNumber())) {
                String[] invoiceCodes = value.getInvoiceCode().split(",");
                String[] invoiceNumbers = value.getInvoiceNumber().split(",");
                if (invoiceNumbers.length != invoiceNumbers.length) {
                    errorList.add("\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u7801\u4e0d\u5339\u914d");
                } else {
                    ArrayList<AuditInvoiceManageDto> dtoList = new ArrayList<AuditInvoiceManageDto>();
                    for (int i = 0; i < invoiceCodes.length; ++i) {
                        String invoiceCode = invoiceCodes[i];
                        String invoiceNumber = invoiceNumbers[i];
                        AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
                        auditInvoiceManageDto.setInvoiceCode(invoiceCode);
                        auditInvoiceManageDto.setInvoiceNo(invoiceNumber);
                        String invoice = StringUtils.isEmpty((CharSequence)invoiceCode) ? invoiceNumber : invoiceCode + ":" + invoiceNumber;
                        invoices.add(invoice);
                        dtoList.add(auditInvoiceManageDto);
                    }
                    List invoiceItemVos = this.auditInvoiceManageService.findByInvoiceNoCode(dtoList);
                    if (CollectionUtils.isEmpty((Collection)invoiceItemVos)) {
                        errorList.add("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u53d1\u7968\u6216\u8005\u53d1\u7968\u5df2\u7ecf\u88ab\u4f7f\u7528");
                    } else if (CollUtil.isNotEmpty((Collection)invoiceItemVos)) {
                        auditHandleInvoices = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)invoiceItemVos, AuditInvoiceItemVo.class, AuditHandleInvoice.class, HashSet.class, ArrayList.class, new String[0]);
                    }
                }
            }
            AuditHandle auditHandle = new AuditHandle();
            AuditHandleDetail auditHandleDetail = new AuditHandleDetail();
            auditHandleDetail.setAuditHandleCode(value.getAuditHandleCode());
            auditHandle.setAuditHandleCode(value.getAuditHandleCode());
            auditHandleInvoices.forEach(item -> {
                item.setAuditHandleCode(value.getAuditHandleCode());
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            if (StringUtils.isNotEmpty((CharSequence)value.getDepartmentCode())) {
                OrgVo orgVo = (OrgVo)orgVoMap.get(value.getDepartmentCode());
                if (Objects.isNull(orgVo)) {
                    errorList.add("\u672a\u627e\u5230\u90e8\u95e8\u4fe1\u606f");
                } else {
                    auditHandle.setDepartmentName(orgVo.getOrgName());
                    auditHandle.setDepartmentCode(orgVo.getOrgCode());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getChannelCode())) {
                CustomerChannelVo customerChannelVo = (CustomerChannelVo)channelVoMap.get(value.getChannelCode());
                if (Objects.isNull(customerChannelVo)) {
                    errorList.add("\u672a\u627e\u5230\u6e20\u9053\u4fe1\u606f");
                } else {
                    auditHandleDetail.setChannelName(customerChannelVo.getCustomerChannelName());
                    auditHandleDetail.setChannelCode(customerChannelVo.getCustomerChannelCode());
                }
            }
            auditHandleDetail.setFeeYearMonth(this.stringTransformDate(value.getFeeYearMonth(), "\u8d39\u7528\u6240\u5c5e\u5e74\u6708", sdf, errorList));
            if (StringUtils.isNotEmpty((CharSequence)value.getYearBudgetCode())) {
                YearBudgetVo yearBudgetVo = (YearBudgetVo)yearBudgetVoMap.get(value.getYearBudgetCode());
                if (Objects.isNull(yearBudgetVo)) {
                    errorList.add("\u672a\u627e\u5230\u5e74\u5ea6\u9884\u7b97\u79d1\u76ee\u4fe1\u606f");
                } else {
                    auditHandleDetail.setYearBudgetName(yearBudgetVo.getBudgetItemName());
                    auditHandleDetail.setYearBudgetCode(yearBudgetVo.getBudgetItemCode());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getActivityTypeCode())) {
                ActivityTypeVo activityTypeVo = (ActivityTypeVo)activityTypeVoMap.get(value.getActivityTypeCode());
                if (Objects.isNull(activityTypeVo)) {
                    errorList.add("\u672a\u627e\u5230\u6d3b\u52a8\u5206\u7c7b\u4fe1\u606f");
                } else {
                    auditHandleDetail.setActivityTypeName(activityTypeVo.getActivityTypeName());
                    auditHandleDetail.setActivityTypeCode(activityTypeVo.getActivityTypeCode());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getActivityFormCode())) {
                ActivityFormVo activityFormVo = (ActivityFormVo)activityFormVoMap.get(value.getActivityFormCode());
                if (Objects.isNull(activityFormVo)) {
                    errorList.add("\u672a\u627e\u5230\u6d3b\u52a8\u5f62\u5f0f\u4fe1\u606f");
                } else {
                    auditHandleDetail.setActivityFormName(activityFormVo.getActivityFormName());
                    auditHandleDetail.setActivityFormCode(activityFormVo.getActivityFormCode());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getProductCode())) {
                ProductVo productVo = (ProductVo)productVoMap.get(value.getProductCode());
                if (Objects.isNull(productVo)) {
                    errorList.add("\u672a\u627e\u5230\u5e74\u5ea6\u9884\u7b97\u79d1\u76ee\u4ea7\u54c1\u4fe1\u606f");
                } else {
                    auditHandleDetail.setProductName(productVo.getProductName());
                    auditHandleDetail.setProductCode(productVo.getProductCode());
                    auditHandleDetail.setProductBrandCode(productVo.getProductBrandCode());
                    auditHandleDetail.setProductBrandName(productVo.getProductBrandName());
                    auditHandleDetail.setProductCategoryCode(productVo.getProductCategoryCode());
                    auditHandleDetail.setProductCategoryName(productVo.getProductCategoryName());
                    auditHandleDetail.setProductItemCode(productVo.getProductLevelCode());
                    auditHandleDetail.setProductItemName(productVo.getProductLevelName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getActivityBeginDate())) {
                auditHandleDetail.setActivityBeginDate(this.stringTransformDate(value.getActivityBeginDate(), "\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", sdf2, errorList));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getActivityEndDate())) {
                auditHandleDetail.setActivityEndDate(this.stringTransformDate(value.getActivityEndDate(), "\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", sdf2, errorList));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getActivityBeginDate()) && StringUtils.isEmpty((CharSequence)value.getActivityEndDate())) {
                auditHandleDetail1 = (AuditHandleDetail)((Object)((Object)auditHandleDetailVoMap.get(value.getAuditHandleCode())));
                String activityEndDate = sdf2.format(auditHandleDetail1.getActivityEndDate());
                this.verifyIsTwoMonth(value.getActivityBeginDate(), activityEndDate, errorList);
            }
            if (StringUtils.isEmpty((CharSequence)value.getActivityBeginDate()) && StringUtils.isNotEmpty((CharSequence)value.getActivityEndDate())) {
                auditHandleDetail1 = (AuditHandleDetail)((Object)((Object)auditHandleDetailVoMap.get(value.getAuditHandleCode())));
                String activityBeginDate = sdf2.format(auditHandleDetail1.getActivityBeginDate());
                this.verifyIsTwoMonth(activityBeginDate, value.getActivityEndDate(), errorList);
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getActivityBeginDate()) && StringUtils.isNotEmpty((CharSequence)value.getActivityEndDate())) {
                this.verifyIsTwoMonth(value.getActivityBeginDate(), value.getActivityEndDate(), errorList);
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getApplyFee())) {
                auditHandleDetail.setApplyFee(this.stringTransformBigDecimal(value.getApplyFee(), "\u7533\u8bf7\u8d39\u7528", errorList));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getThisAuditAmountTax())) {
                auditHandleDetail.setThisAuditAmountTax(this.stringTransformBigDecimal(value.getThisAuditAmountTax(), "\u672c\u6b21\u5e94\u62a5\u8d39\u7528", errorList));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getOtherDeductAmount())) {
                auditHandleDetail.setOtherDeductAmount(this.stringTransformBigDecimal(value.getOtherDeductAmount(), "\u5176\u4ed6\u6263\u6b3e", errorList));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getDeductTaxAmount())) {
                auditHandleDetail.setDeductTaxAmount(this.stringTransformBigDecimal(value.getDeductTaxAmount(), "\u6263\u7a0e\u91d1", errorList));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getThisAuditAmountNotTax())) {
                auditHandleDetail.setThisAuditAmountNotTax(this.stringTransformBigDecimal(value.getThisAuditAmountNotTax(), "\u672c\u6b21\u5b9e\u62a5\u8d39\u7528", errorList));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getEndCaseForm())) {
                auditHandleDetail.setEndCaseForm(EndCaseFormEnum.transitionStr((String)value.getEndCaseForm()));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getReimburseItemCode()) && auditHandleDetail.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())) {
                AccountSubjectVo accountSubjectVo = (AccountSubjectVo)accountSubjectVoMap.get(value.getReimburseItemCode());
                if (Objects.isNull(accountSubjectVo)) {
                    errorList.add("\u672a\u627e\u5230\u4f1a\u8ba1\u79d1\u76ee\u4fe1\u606f");
                } else {
                    auditHandleDetail.setReimburseItemName(accountSubjectVo.getAccountSubjectName());
                    auditHandleDetail.setReimburseItemCode(accountSubjectVo.getAccountSubjectCode());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getCostCenterCode()) && StringUtils.isNotEmpty((CharSequence)value.getCostCenterCode())) {
                CostCenterVo costCenterVo = (CostCenterVo)costCenterVoMap.get(value.getCostCenterCode());
                if (Objects.isNull(costCenterVo)) {
                    errorList.add("\u672a\u627e\u5230\u6210\u672c\u4e2d\u5fc3\u4fe1\u606f");
                } else {
                    auditHandleDetail.setCostCenterName(costCenterVo.getCostCenterName());
                    auditHandleDetail.setCostCenterCode(costCenterVo.getCostCenterCode());
                    auditHandleDetail.setProfitCenterCode(costCenterVo.getProfitCenterCode());
                    auditHandleDetail.setProfitCenterName(costCenterVo.getProfitCenterName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getCostCenterCode())) {
                auditHandleDetail.setLookLikeSale(YesOrNoEnum.getByValue((String)value.getLookLikeSale()));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getRemark())) {
                auditHandleDetail.setRemark(value.getRemark());
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getAppendices())) {
                auditHandle.setAppendices(this.stringTransformInter(value.getAppendices(), "\u9644\u5355\u636e\u5f20\u6570", errorList));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getAuditHandleName())) {
                auditHandle.setAuditHandleName(value.getAuditHandleName());
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getType())) {
                auditHandleDetail.setType(value.getType());
            }
            auditHandleList.add(auditHandle);
            auditHandleDetailList.add(auditHandleDetail);
            auditHandleInvoiceList.addAll(auditHandleInvoices);
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorMap.put((Integer)key, String.join((CharSequence)",", errorList));
            }
        });
        if (CollectionUtils.isNotEmpty(invoices)) {
            Map<String, List<String>> invoicesMap = invoices.stream().collect(Collectors.groupingBy(o -> o));
            invoicesMap.forEach((key, value) -> Validate.isTrue((value.size() <= 1 ? 1 : 0) != 0, (String)"\u53d1\u7968\u3010%s\u3011\u5b58\u5728\u591a\u884c\uff0c\u4e0d\u80fd\u91cd\u590d\u5bfc\u5165", (Object[])new Object[]{key}));
        }
        return errorMap;
    }

    private void verifyIsTwoMonth(String activityBeginDate, String activityEndDate, List<String> errorList) {
        if (!activityBeginDate.substring(0, 7).equals(activityEndDate.substring(0, 7))) {
            errorList.add("\u6d3b\u52a8\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u4e0d\u5141\u8bb8\u8de8\u6708");
        }
    }

    private Map<String, AuditHandleDetail> getAuditHandleDetailVoMap(Collection<AuditHandleEditImportVo> values) {
        List<AuditHandleDetail> auditHandleDetailList;
        List<String> auditHandleCodes = values.stream().map(AuditHandleEditImportVo::getAuditHandleCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(auditHandleCodes) && CollectionUtils.isNotEmpty(auditHandleDetailList = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes))) {
            Map<String, AuditHandleDetail> auditHandleDetailMap = auditHandleDetailList.stream().collect(Collectors.toMap(AuditHandleDetail::getAuditHandleCode, Function.identity()));
            return auditHandleDetailMap;
        }
        return Maps.newHashMap();
    }

    private Map<String, AuditHandle> getAuditHandleVoMap(Collection<AuditHandleEditImportVo> values) {
        List<AuditHandle> auditHandleList;
        List<String> auditHandleCodes = values.stream().map(AuditHandleEditImportVo::getAuditHandleCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(auditHandleCodes) && CollectionUtils.isNotEmpty(auditHandleList = this.auditHandleRepository.findByAuditHandleCodes(auditHandleCodes))) {
            Map<String, AuditHandle> auditHandleMap = auditHandleList.stream().collect(Collectors.toMap(AuditHandle::getAuditHandleCode, Function.identity()));
            return auditHandleMap;
        }
        return Maps.newHashMap();
    }

    private Integer stringTransformInter(String orderNumber, String msg, List<String> errorList) {
        if (StringUtils.isEmpty((CharSequence)orderNumber)) {
            return 0;
        }
        int i = 0;
        try {
            i = Integer.parseInt(orderNumber);
        }
        catch (Exception e) {
            errorList.add(msg + "\u4e0d\u662f\u6570\u5b57");
        }
        return i;
    }

    private Date stringTransformDate(String feeYearMonth, String msg, SimpleDateFormat sdf, List<String> errorList) {
        if (StringUtils.isEmpty((CharSequence)feeYearMonth)) {
            return null;
        }
        Date result = null;
        try {
            result = sdf.parse(feeYearMonth);
        }
        catch (Exception e) {
            errorList.add(msg + "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
        }
        return result;
    }

    private BigDecimal stringTransformBigDecimal(String arguments, String msg, List<String> errorList) {
        if (StringUtils.isEmpty((CharSequence)arguments)) {
            return BigDecimal.ZERO;
        }
        if (!AuditHandleEditImportsProcess.isValidNumber(arguments)) {
            errorList.add(msg + "\u4e0d\u662f\u6570\u5b57,\u8bf7\u68c0\u67e5");
            return BigDecimal.ZERO;
        }
        if (!this.isValidDecimals(arguments)) {
            errorList.add(msg + "\u8bf7\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
            return BigDecimal.ZERO;
        }
        return new BigDecimal(arguments);
    }

    private static boolean isValidNumber(String str) {
        String reg = "^-?[0-9]+(.[0-9]+)?$";
        return str.matches(reg);
    }

    private boolean isValidDecimals(String str) {
        String reg = "^(\\-)?[0-9]+(\\.[0-9]{0,2})?$";
        return str.matches(reg);
    }

    private Map<String, OrgVo> getDepartmentVoMap(Collection<AuditHandleEditImportVo> values) {
        List departmentCodes = values.stream().map(AuditHandleEditImportVo::getDepartmentCode).collect(Collectors.toList());
        Map<String, Object> orgVoMap = new HashMap<String, OrgVo>();
        if (CollectionUtils.isNotEmpty(departmentCodes)) {
            List orgVos = this.orgVoService.findByOrgCodes(departmentCodes);
            orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        }
        return orgVoMap;
    }

    private Map<String, CustomerChannelVo> getChannelVoMap(Collection<AuditHandleEditImportVo> values) {
        Map<String, Object> customerChannelVoMap = new HashMap<String, CustomerChannelVo>();
        List channelCodes = values.stream().map(AuditHandleEditImportVo::getChannelCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(channelCodes)) {
            List customerChannelVos = this.customerChannelVoService.findByCodes(channelCodes);
            customerChannelVoMap = customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
        }
        return customerChannelVoMap;
    }

    private Map<String, YearBudgetVo> getYearBudgetVoMap(Collection<AuditHandleEditImportVo> values) {
        List yearBudgetCodes = values.stream().map(AuditHandleEditImportVo::getYearBudgetCode).collect(Collectors.toList());
        List yearBudgetVos = this.yearBudgetSdkService.findByYearBudgetCodes(yearBudgetCodes);
        return CollectionUtils.isNotEmpty((Collection)yearBudgetVos) ? yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, ActivityTypeVo> getActivityTYpeVoMap(Collection<AuditHandleEditImportVo> values) {
        List activityTypeCodes = values.stream().map(AuditHandleEditImportVo::getActivityTypeCode).collect(Collectors.toList());
        List activityTypeVos = this.activityTypeService.findByCodes(activityTypeCodes);
        return CollectionUtils.isNotEmpty((Collection)activityTypeVos) ? activityTypeVos.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, ActivityFormVo> getActivityFormVoMap(Collection<AuditHandleEditImportVo> values) {
        List activityFormVoList;
        List activityFormCodes = values.stream().map(AuditHandleEditImportVo::getActivityFormCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(activityFormCodes) && CollectionUtils.isNotEmpty((Collection)(activityFormVoList = this.activityFormService.findByCodes(activityFormCodes)))) {
            Map<String, ActivityFormVo> activityFormVoMap = activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
            return activityFormVoMap;
        }
        return Maps.newHashMap();
    }

    private Map<String, ProductVo> getProductVoMap(Collection<AuditHandleEditImportVo> values) {
        List productCodes = values.stream().map(AuditHandleEditImportVo::getProductCode).collect(Collectors.toList());
        List productVos = this.productVoService.findByProductCodes(productCodes);
        return CollectionUtils.isNotEmpty((Collection)productVos) ? productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, CostCenterVo> getCostCenterVoMap(Collection<AuditHandleEditImportVo> values) {
        List costCenterCodes = values.stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a.getCostCenterCode())).map(AuditHandleEditImportVo::getCostCenterCode).collect(Collectors.toList());
        ArrayList costCenterVos = CollectionUtils.isNotEmpty(costCenterCodes) ? this.costCenterVoService.findByCodeList(costCenterCodes) : Lists.newArrayList();
        return CollectionUtils.isNotEmpty((Collection)costCenterVos) ? costCenterVos.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, AccountSubjectVo> getAccountSubjectVoMap(Collection<AuditHandleEditImportVo> values) {
        List accountSubjectCodes = values.stream().map(AuditHandleEditImportVo::getReimburseItemCode).collect(Collectors.toList());
        List accountSubjectVos = this.accountSubjectService.findListByCode(accountSubjectCodes);
        return CollectionUtils.isNotEmpty((Collection)accountSubjectVos) ? accountSubjectVos.stream().collect(Collectors.toMap(AccountSubjectVo::getAccountSubjectCode, Function.identity())) : Maps.newHashMap();
    }

    public Class<AuditHandleEditImportVo> findCrmExcelVoClass() {
        return AuditHandleEditImportVo.class;
    }

    public String getTemplateCode() {
        return "audit_handle_edit_imports";
    }

    public String getTemplateName() {
        return "\u76f4\u63a5\u4e0a\u8d26\u7f16\u8f91\u5bfc\u5165";
    }

    public Integer getBatchCount() {
        return 10000;
    }
}

