/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.service.imports;

import cn.hutool.core.collection.CollUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.businessunit.sdk.service.MdmBusinessUnitVoService;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleImportVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditHandleImportProcess
implements ImportProcess<AuditHandleImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditHandleImportProcess.class);
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    AuditHandleSdkService auditHandleSdkService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MdmBusinessUnitVoService mdmBusinessUnitVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetSdkService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired
    private AccountSubjectService accountSubjectService;
    @Autowired
    private AuditInvoiceManageService auditInvoiceManageService;
    @Autowired
    private CostCenterVoService costCenterVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private AuditHandleCacheService auditHandleCacheService;

    public Integer getBatchCount() {
        return 5000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditHandleImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Object, Object> errorMap = new HashMap();
        try {
            log.info("\u6279\u91cf\u5bfc\u5165\u624b\u52a8\u4e0a\u8d26++++++++++++++++++++++++++++");
            log.info("\u6279\u91cf\u5bfc\u5165\u624b\u52a8\u4e0a\u8d26\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JsonUtils.obj2JsonString(data.values()));
            Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((data.values().size() <= this.getBatchCount() ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7%s\u6761", (long)this.getBatchCount().intValue());
            ArrayList auditHandleList = Lists.newArrayList();
            ArrayList auditHandleDetailList = Lists.newArrayList();
            ArrayList auditHandleInvoiceList = Lists.newArrayList();
            errorMap = this.validate(data, auditHandleList, auditHandleDetailList, auditHandleInvoiceList);
            if (CollectionUtils.isEmpty(errorMap.keySet())) {
                this.auditHandleCacheService.saveBatch(auditHandleList, auditHandleDetailList, auditHandleInvoiceList);
            }
        }
        catch (Exception e) {
            log.info("\u6279\u91cf\u5bfc\u5165\u624b\u52a8\u4e0a\u8d26\u62a5\u9519", (Throwable)e);
            throw e;
        }
        log.info("\u6279\u91cf\u5bfc\u5165\u624b\u52a8\u4e0a\u8d26--------------------------");
        log.info("\u6279\u91cf\u5bfc\u5165\u624b\u52a8\u4e0a\u8d26errorMap.key:{},value:{}", (Object)JsonUtils.obj2JsonString(errorMap.keySet()), (Object)JsonUtils.obj2JsonString(errorMap.values()));
        return errorMap;
    }

    private Map<Integer, String> validate(LinkedHashMap<Integer, AuditHandleImportVo> data, List<AuditHandle> auditHandleList, List<AuditHandleDetail> auditHandleDetailList, List<AuditHandleInvoice> auditHandleInvoiceList) {
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, String> businessFormatMap = this.getBusinessFormatDict();
        Map<String, MdmBusinessUnitVo> businessUnitVoMap = this.getBusinessUnitVoMap(data.values());
        data.forEach((key, value) -> {
            MdmBusinessUnitVo mdmBusinessUnitVo;
            String businessFormatCode = (String)businessFormatMap.get(value.getBusinessFormatCode());
            if (StringUtils.isNotEmpty((CharSequence)businessFormatCode)) {
                value.setBusinessFormatCode(businessFormatCode);
            }
            if (Objects.nonNull(mdmBusinessUnitVo = (MdmBusinessUnitVo)businessUnitVoMap.get(value.getBusinessUnitCode()))) {
                value.setBusinessUnitCode(mdmBusinessUnitVo.getBusinessUnitCode());
            }
        });
        Map<String, OrgVo> orgVoMap = this.getDepartmentVoMap(data.values());
        Map<String, CustomerChannelVo> channelVoMap = this.getChannelVoMap(data.values());
        Map<String, SalesOrgVo> salesOrgVoMap = this.getSalesOrgVoMap(data.values());
        Map<String, CustomerVo> customerVoMap = this.getCustomerVoMap(data.values());
        Map<String, YearBudgetVo> yearBudgetVoMap = this.getYearBudgetVoMap(data.values());
        Map<String, ActivityTypeVo> activityTypeVoMap = this.getActivityTYpeVoMap(data.values());
        Map<String, ActivityFormVo> activityFormVoMap = this.getActivityFormVoMap(data.values());
        Map<String, ProductVo> productVoMap = this.getProductVoMap(data.values());
        Map<String, AccountSubjectVo> accountSubjectVoMap = this.getAccountSubjectVoMap(data.values());
        Map<String, CostCenterVo> costCenterVoMap = this.getCostCenterVoMap(data.values());
        ArrayList invoices = new ArrayList();
        data.forEach((key, value) -> {
            OrgVo orgVo;
            List<String> errorList = this.validate2((AuditHandleImportVo)value);
            List auditHandleInvoices = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)value.getInvoiceCode()) && StringUtils.isEmpty((CharSequence)value.getInvoiceNumber())) {
                errorList.add("\u586b\u5199\u4e86\u53d1\u7968\u4ee3\u7801\uff0c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)value.getInvoiceCode()) && StringUtils.isNotEmpty((CharSequence)value.getInvoiceNumber())) {
                errorList.add("\u586b\u5199\u4e86\u53d1\u7968\u53f7\u7801\uff0c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getInvoiceCode()) && StringUtils.isNotEmpty((CharSequence)value.getInvoiceNumber())) {
                String[] invoiceCodes = value.getInvoiceCode().split(",");
                String[] invoiceNumbers = value.getInvoiceNumber().split(",");
                if (invoiceNumbers.length != invoiceNumbers.length) {
                    errorList.add("\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u7801\u4e0d\u5339\u914d");
                } else {
                    ArrayList<AuditInvoiceManageDto> dtoList = new ArrayList<AuditInvoiceManageDto>();
                    for (int i = 0; i < invoiceCodes.length; ++i) {
                        String invoiceCode = invoiceCodes[i];
                        String invoiceNumber = invoiceNumbers[i];
                        AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
                        auditInvoiceManageDto.setInvoiceCode(invoiceCode);
                        auditInvoiceManageDto.setInvoiceNo(invoiceNumber);
                        String invoice = StringUtils.isEmpty((CharSequence)invoiceCode) ? invoiceNumber : invoiceCode + ":" + invoiceNumber;
                        invoices.add(invoice);
                        dtoList.add(auditInvoiceManageDto);
                    }
                    List invoiceItemVos = this.auditInvoiceManageService.findByInvoiceNoCode(dtoList);
                    if (CollectionUtils.isEmpty((Collection)invoiceItemVos)) {
                        errorList.add("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u53d1\u7968\u6216\u8005\u53d1\u7968\u5df2\u7ecf\u88ab\u4f7f\u7528");
                    } else if (CollUtil.isNotEmpty((Collection)invoiceItemVos)) {
                        auditHandleInvoices = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)invoiceItemVos, AuditInvoiceItemVo.class, AuditHandleInvoice.class, HashSet.class, ArrayList.class, new String[0]);
                    }
                }
            }
            AuditHandle auditHandle = new AuditHandle();
            AuditHandleDetail auditHandleDetail = new AuditHandleDetail();
            BeanUtils.copyProperties((Object)value, (Object)((Object)auditHandle));
            auditHandle.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            auditHandle.setTenantCode(TenantUtils.getTenantCode());
            auditHandle.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            auditHandle.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            BeanUtils.copyProperties((Object)value, (Object)((Object)auditHandleDetail));
            auditHandleDetail.setApplyFee(this.stringTransformBigDecimal(value.getApplyFee(), "\u7533\u8bf7\u8d39\u7528", errorList));
            auditHandleDetail.setDeductTaxAmount(this.stringTransformBigDecimal(value.getDeductTaxAmount(), "\u6263\u7a0e\u91d1", errorList));
            auditHandleDetail.setThisAuditAmountNotTax(this.stringTransformBigDecimal(value.getThisAuditAmountNotTax(), "\u672c\u6b21\u5b9e\u62a5\u8d39\u7528", errorList));
            auditHandleDetail.setThisAuditAmountTax(this.stringTransformBigDecimal(value.getThisAuditAmountTax(), "\u672c\u6b21\u5e94\u62a5\u8d39\u7528", errorList));
            auditHandleDetail.setOtherDeductAmount(this.stringTransformBigDecimal(value.getOtherDeductAmount(), "\u5176\u4ed6\u6263\u6b3e", errorList));
            auditHandleDetail.setFeeYearMonth(this.stringTransformDate(value.getFeeYearMonth(), "\u8d39\u7528\u6240\u5c5e\u5e74\u6708", sdf, errorList));
            auditHandleDetail.setActivityBeginDate(this.stringTransformDate(value.getActivityBeginDate(), "\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", sdf2, errorList));
            auditHandleDetail.setActivityEndDate(this.stringTransformDate(value.getActivityEndDate(), "\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", sdf2, errorList));
            if (StringUtils.isNotEmpty((CharSequence)value.getActivityBeginDate()) && StringUtils.isNotEmpty((CharSequence)value.getActivityEndDate())) {
                this.verifyIsTwoMonth(value.getActivityBeginDate(), value.getActivityEndDate(), errorList);
            }
            auditHandle.setAppendices(this.stringTransformInter(value.getAppendices(), "\u9644\u5355\u636e\u5f20\u6570", errorList));
            auditHandleDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            auditHandleDetail.setTenantCode(TenantUtils.getTenantCode());
            auditHandleDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (EndCaseFormEnum.DISCOUNT.getCode().equals(auditHandleDetail.getEndCaseForm())) {
                auditHandleDetail.setUpAccountStatus(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode());
            }
            if (EndCaseFormEnum.REIMBURSE.getCode().equals(auditHandleDetail.getEndCaseForm())) {
                auditHandle.setUpAccountStatusReimburse(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode());
            }
            if (Objects.isNull(orgVo = (OrgVo)orgVoMap.get(value.getDepartmentCode()))) {
                errorList.add("\u672a\u627e\u5230\u90e8\u95e8\u4fe1\u606f");
            } else {
                auditHandle.setDepartmentName(orgVo.getOrgName());
            }
            CustomerChannelVo customerChannelVo = (CustomerChannelVo)channelVoMap.get(value.getChannelCode());
            if (Objects.isNull(customerChannelVo)) {
                errorList.add("\u672a\u627e\u5230\u6e20\u9053\u4fe1\u606f");
            } else {
                auditHandleDetail.setChannelName(customerChannelVo.getCustomerChannelName());
            }
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(value.getChannelCode());
            salesOrgCode.append(auditHandle.getBusinessFormatCode());
            salesOrgCode.append(value.getCompanyCode());
            SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(salesOrgCode.toString());
            if (Objects.isNull(salesOrgVo)) {
                errorList.add("\u672a\u627e\u5230\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f");
            } else {
                auditHandle.setCompanyName(salesOrgVo.getSalesOrgName());
            }
            salesOrgCode.append(value.getSalesOrgCode());
            SalesOrgVo salesOrgDepartmentVo = (SalesOrgVo)salesOrgVoMap.get(salesOrgCode.toString());
            if (Objects.isNull(salesOrgDepartmentVo)) {
                errorList.add("\u9500\u552e\u90e8\u95e8\u4e0d\u5c5e\u4e8e\u9500\u552e\u673a\u6784");
            } else {
                auditHandleDetail.setSalesOrgName(salesOrgDepartmentVo.getSalesOrgName());
            }
            salesOrgCode.append(value.getSalesGroupCode());
            SalesOrgVo salesOrgGroupVo = (SalesOrgVo)salesOrgVoMap.get(salesOrgCode.toString());
            if (Objects.isNull(salesOrgGroupVo)) {
                errorList.add("\u9500\u552e\u7ec4\u4e0d\u5c5e\u4e8e\u9500\u552e\u90e8\u95e8");
            } else {
                auditHandleDetail.setSalesGroupName(salesOrgGroupVo.getSalesOrgName());
            }
            StringBuffer customerCode = new StringBuffer();
            customerCode.append(value.getCustomerCode());
            customerCode.append(value.getCompanyCode());
            customerCode.append(value.getChannelCode());
            customerCode.append(value.getBusinessFormatCode());
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(customerCode.toString());
            if (Objects.isNull(customerVo)) {
                errorList.add("\u672a\u627e\u5230\u5ba2\u6237\u4fe1\u606f");
            } else {
                auditHandleDetail.setCustomerName(customerVo.getCustomerName());
            }
            YearBudgetVo yearBudgetVo = (YearBudgetVo)yearBudgetVoMap.get(value.getYearBudgetCode());
            if (Objects.isNull(yearBudgetVo)) {
                errorList.add("\u672a\u627e\u5230\u5e74\u5ea6\u9884\u7b97\u79d1\u76ee\u4fe1\u606f");
            } else {
                auditHandleDetail.setYearBudgetName(yearBudgetVo.getBudgetItemName());
            }
            ActivityTypeVo activityTypeVo = (ActivityTypeVo)activityTypeVoMap.get(value.getActivityTypeCode());
            if (Objects.isNull(activityTypeVo)) {
                errorList.add("\u672a\u627e\u5230\u6d3b\u52a8\u5206\u7c7b\u4fe1\u606f");
            } else {
                auditHandleDetail.setActivityTypeName(activityTypeVo.getActivityTypeName());
            }
            ActivityFormVo activityFormVo = (ActivityFormVo)activityFormVoMap.get(value.getActivityFormCode());
            if (Objects.isNull(activityFormVo)) {
                errorList.add("\u672a\u627e\u5230\u6d3b\u52a8\u5f62\u5f0f\u4fe1\u606f");
            } else {
                auditHandleDetail.setActivityFormName(activityFormVo.getActivityFormName());
            }
            ProductVo productVo = (ProductVo)productVoMap.get(value.getProductCode());
            if (Objects.isNull(productVo)) {
                errorList.add("\u672a\u627e\u5230\u5e74\u5ea6\u9884\u7b97\u79d1\u76ee\u4ea7\u54c1\u4fe1\u606f");
            } else {
                auditHandleDetail.setProductName(productVo.getProductName());
                auditHandleDetail.setProductBrandCode(productVo.getProductBrandCode());
                auditHandleDetail.setProductBrandName(productVo.getProductBrandName());
                auditHandleDetail.setProductCategoryCode(productVo.getProductCategoryCode());
                auditHandleDetail.setProductCategoryName(productVo.getProductCategoryName());
                auditHandleDetail.setProductItemCode(productVo.getProductLevelCode());
                auditHandleDetail.setProductItemName(productVo.getProductLevelName());
            }
            if (value.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())) {
                AccountSubjectVo accountSubjectVo = (AccountSubjectVo)accountSubjectVoMap.get(value.getReimburseItemCode());
                if (Objects.isNull(accountSubjectVo)) {
                    errorList.add("\u672a\u627e\u5230\u4f1a\u8ba1\u79d1\u76ee\u4fe1\u606f");
                } else {
                    auditHandleDetail.setReimburseItemName(accountSubjectVo.getAccountSubjectName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getCostCenterCode())) {
                CostCenterVo costCenterVo = (CostCenterVo)costCenterVoMap.get(value.getCostCenterCode());
                if (Objects.isNull(costCenterVo)) {
                    errorList.add("\u672a\u627e\u5230\u6210\u672c\u4e2d\u5fc3\u4fe1\u606f");
                } else {
                    auditHandleDetail.setCostCenterName(costCenterVo.getCostCenterName());
                    auditHandleDetail.setProfitCenterCode(costCenterVo.getProfitCenterCode());
                    auditHandleDetail.setProfitCenterName(costCenterVo.getProfitCenterName());
                }
            }
            String auditHandleCode = (String)this.generateCodeService.generateCode("D-4", 1, Integer.valueOf(9), 0L, TimeUnit.DAYS).get(0);
            auditHandle.setAuditHandleCode(auditHandleCode);
            for (AuditHandleInvoice item : auditHandleInvoices) {
                item.setAuditHandleCode(auditHandleCode);
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            }
            auditHandleDetail.setAuditHandleCode(auditHandleCode);
            auditHandleDetail.setAuditHandleDetailCode(auditHandleCode);
            auditHandleList.add(auditHandle);
            auditHandleDetail.setInvoiceNumber(null);
            auditHandleDetail.setInvoiceCode(null);
            auditHandleDetailList.add(auditHandleDetail);
            auditHandleInvoiceList.addAll(auditHandleInvoices);
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorMap.put((Integer)key, String.join((CharSequence)",", errorList));
            }
        });
        if (CollectionUtils.isNotEmpty(invoices)) {
            Map<String, List<String>> invoicesMap = invoices.stream().collect(Collectors.groupingBy(o -> o));
            invoicesMap.forEach((key, value) -> Validate.isTrue((value.size() <= 1 ? 1 : 0) != 0, (String)"\u53d1\u7968\u3010%s\u3011\u5b58\u5728\u591a\u884c\uff0c\u4e0d\u80fd\u91cd\u590d\u5bfc\u5165", (Object[])new Object[]{key}));
        }
        return errorMap;
    }

    private String disposeYear(String auditHandleCode) {
        return "D-4" + auditHandleCode.substring("D-4".length() + 4);
    }

    private void verifyIsTwoMonth(String activityBeginDate, String activityEndDate, List<String> errorList) {
        if (!activityBeginDate.substring(0, 7).equals(activityEndDate.substring(0, 7))) {
            errorList.add("\u6d3b\u52a8\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u4e0d\u5141\u8bb8\u8de8\u6708");
        }
    }

    private Integer stringTransformInter(String orderNumber, String msg, List<String> errorList) {
        if (StringUtils.isEmpty((CharSequence)orderNumber)) {
            return 0;
        }
        int i = 0;
        try {
            i = Integer.parseInt(orderNumber);
        }
        catch (Exception e) {
            errorList.add(msg + "\u4e0d\u662f\u6570\u5b57");
        }
        return i;
    }

    private Date stringTransformDate(String feeYearMonth, String msg, SimpleDateFormat sdf, List<String> errorList) {
        if (StringUtils.isEmpty((CharSequence)feeYearMonth)) {
            return null;
        }
        Date result = null;
        try {
            result = sdf.parse(feeYearMonth);
        }
        catch (Exception e) {
            errorList.add(msg + "\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9");
        }
        return result;
    }

    private Map<String, CustomerChannelVo> getChannelVoMap(Collection<AuditHandleImportVo> values) {
        Map<String, Object> customerChannelVoMap = new HashMap<String, CustomerChannelVo>();
        List channelCodes = values.stream().map(AuditHandleImportVo::getChannelCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(channelCodes)) {
            List customerChannelVos = this.customerChannelVoService.findByCodes(channelCodes);
            customerChannelVoMap = customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
        }
        return customerChannelVoMap;
    }

    private Map<String, OrgVo> getDepartmentVoMap(Collection<AuditHandleImportVo> values) {
        List departmentCodes = values.stream().map(AuditHandleImportVo::getDepartmentCode).collect(Collectors.toList());
        Map<String, Object> orgVoMap = new HashMap<String, OrgVo>();
        if (CollectionUtils.isNotEmpty(departmentCodes)) {
            List orgVos = this.orgVoService.findByOrgCodes(departmentCodes);
            orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        }
        return orgVoMap;
    }

    private BigDecimal stringTransformBigDecimal(String arguments, String msg, List<String> errorList) {
        if (StringUtils.isEmpty((CharSequence)arguments)) {
            return BigDecimal.ZERO;
        }
        if (!AuditHandleImportProcess.isValidNumber(arguments)) {
            errorList.add(msg + "\u4e0d\u662f\u6570\u5b57,\u8bf7\u68c0\u67e5");
            return BigDecimal.ZERO;
        }
        if (!this.isValidDecimals(arguments)) {
            errorList.add(msg + "\u8bf7\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
            return BigDecimal.ZERO;
        }
        return new BigDecimal(arguments);
    }

    private static boolean isValidNumber(String str) {
        String reg = "^-?[0-9]+(.[0-9]+)?$";
        return str.matches(reg);
    }

    private boolean isValidDecimals(String str) {
        String reg = "^(\\-)?[0-9]+(\\.[0-9]{0,2})?$";
        return str.matches(reg);
    }

    private Map<String, ActivityFormVo> getActivityFormVoMap(Collection<AuditHandleImportVo> values) {
        List activityFormVoList;
        List activityFormCodes = values.stream().map(AuditHandleImportVo::getActivityFormCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(activityFormCodes) && CollectionUtils.isNotEmpty((Collection)(activityFormVoList = this.activityFormService.findByCodes(activityFormCodes)))) {
            Map<String, ActivityFormVo> activityFormVoMap = activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
            return activityFormVoMap;
        }
        return Maps.newHashMap();
    }

    private Map<String, CostCenterVo> getCostCenterVoMap(Collection<AuditHandleImportVo> values) {
        List costCenterCodes = values.stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a.getCostCenterCode())).map(AuditHandleImportVo::getCostCenterCode).collect(Collectors.toList());
        ArrayList costCenterVos = CollectionUtils.isNotEmpty(costCenterCodes) ? this.costCenterVoService.findByCodeList(costCenterCodes) : Lists.newArrayList();
        return CollectionUtils.isNotEmpty((Collection)costCenterVos) ? costCenterVos.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, AccountSubjectVo> getAccountSubjectVoMap(Collection<AuditHandleImportVo> values) {
        List accountSubjectCodes = values.stream().map(AuditHandleImportVo::getReimburseItemCode).collect(Collectors.toList());
        List accountSubjectVos = this.accountSubjectService.findListByCode(accountSubjectCodes);
        return CollectionUtils.isNotEmpty((Collection)accountSubjectVos) ? accountSubjectVos.stream().collect(Collectors.toMap(AccountSubjectVo::getAccountSubjectCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, ProductVo> getProductVoMap(Collection<AuditHandleImportVo> values) {
        List productCodes = values.stream().map(AuditHandleImportVo::getProductCode).collect(Collectors.toList());
        List productVos = this.productVoService.findByProductCodes(productCodes);
        return CollectionUtils.isNotEmpty((Collection)productVos) ? productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, ActivityTypeVo> getActivityTYpeVoMap(Collection<AuditHandleImportVo> values) {
        List activityTypeCodes = values.stream().map(AuditHandleImportVo::getActivityTypeCode).collect(Collectors.toList());
        List activityTypeVos = this.activityTypeService.findByCodes(activityTypeCodes);
        return CollectionUtils.isNotEmpty((Collection)activityTypeVos) ? activityTypeVos.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, YearBudgetVo> getYearBudgetVoMap(Collection<AuditHandleImportVo> values) {
        List yearBudgetCodes = values.stream().map(AuditHandleImportVo::getYearBudgetCode).collect(Collectors.toList());
        List yearBudgetVos = this.yearBudgetSdkService.findByYearBudgetCodes(yearBudgetCodes);
        return CollectionUtils.isNotEmpty((Collection)yearBudgetVos) ? yearBudgetVos.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, CustomerVo> getCustomerVoMap(Collection<AuditHandleImportVo> values) {
        List customerCodes = values.stream().map(a -> {
            StringBuffer customerCode = new StringBuffer();
            customerCode.append(a.getCustomerCode());
            customerCode.append(a.getCompanyCode());
            customerCode.append(a.getChannelCode());
            customerCode.append(a.getBusinessFormatCode());
            return customerCode.toString();
        }).collect(Collectors.toList());
        List customerVos = this.customerVoService.findByCustomerCodes(customerCodes);
        return CollectionUtils.isNotEmpty((Collection)customerVos) ? customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, SalesOrgVo> getSalesOrgVoMap(Collection<AuditHandleImportVo> values) {
        List salesOrgCodes = values.stream().map(a -> {
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(a.getChannelCode());
            salesOrgCode.append(a.getBusinessFormatCode());
            salesOrgCode.append(a.getCompanyCode());
            return salesOrgCode.toString();
        }).collect(Collectors.toList());
        List salesOrgDepartmentCodes = values.stream().map(a -> {
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(a.getChannelCode());
            salesOrgCode.append(a.getBusinessFormatCode());
            salesOrgCode.append(a.getCompanyCode());
            salesOrgCode.append(a.getSalesOrgCode());
            return salesOrgCode.toString();
        }).collect(Collectors.toList());
        List salesOrgGroupCodes = values.stream().map(a -> {
            StringBuffer salesOrgCode = new StringBuffer();
            salesOrgCode.append(a.getChannelCode());
            salesOrgCode.append(a.getBusinessFormatCode());
            salesOrgCode.append(a.getCompanyCode());
            salesOrgCode.append(a.getSalesOrgCode());
            salesOrgCode.append(a.getSalesGroupCode());
            return salesOrgCode.toString();
        }).collect(Collectors.toList());
        ArrayList list = Lists.newArrayList();
        list.addAll(salesOrgCodes);
        list.addAll(salesOrgDepartmentCodes);
        list.addAll(salesOrgGroupCodes);
        List salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes((List)list);
        return CollectionUtils.isNotEmpty((Collection)salesOrgVos) ? salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity())) : Maps.newHashMap();
    }

    private Map<String, MdmBusinessUnitVo> getBusinessUnitVoMap(Collection<AuditHandleImportVo> values) {
        List businessUnitCodes = values.stream().map(AuditHandleImportVo::getBusinessUnitCode).collect(Collectors.toList());
        List businessUnitVos = this.mdmBusinessUnitVoService.findByNames(businessUnitCodes);
        return CollectionUtils.isNotEmpty((Collection)businessUnitVos) ? businessUnitVos.stream().collect(Collectors.toMap(MdmBusinessUnitVo::getBusinessUnitName, Function.identity())) : Maps.newHashMap();
    }

    public Class<AuditHandleImportVo> findCrmExcelVoClass() {
        return AuditHandleImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_AUDIT_HANDLE_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u624b\u52a8\u4e0a\u8d26\u5bfc\u5165";
    }

    private List<String> validate2(AuditHandleImportVo o) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)o.getBusinessFormatCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getBusinessUnitCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getDepartmentCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u6240\u5c5e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getCompanyCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getSalesOrgCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getChannelCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getCustomerCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getFeeYearMonth())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getYearBudgetCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u5e74\u5ea6\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getActivityTypeCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getActivityFormCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getProductBrandCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u54c1\u724c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getProductCode())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getActivityBeginDate())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getActivityEndDate())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getApplyFee())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getThisAuditAmountTax())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u672c\u6b21\u5e94\u62a5\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getThisAuditAmountNotTax())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u672c\u6b21\u5b9e\u62a5\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)o.getLookLikeSale())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u662f\u5426\u89c6\u540c\u9500\u552e\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            o.setLookLikeSale(YesOrNoEnum.getByValue((String)o.getLookLikeSale()));
        }
        if (StringUtils.isEmpty((CharSequence)o.getEndCaseForm())) {
            errorList.add("\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u7ed3\u6848\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            o.setEndCaseForm(EndCaseFormEnum.transitionStr((String)o.getEndCaseForm()));
        }
        if (o.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())) {
            if (StringUtils.isEmpty((CharSequence)o.getReimburseItemCode())) {
                errorList.add("\u7ed3\u6848\u65b9\u5f0f\u542b\u6709\u62a5\u9500\u65f6,\u62a5\u9500\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)o.getCostCenterCode())) {
                errorList.add("\u7ed3\u6848\u65b9\u5f0f\u542b\u6709\u62a5\u9500\u65f6,\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)o.getInvoiceCode()) && StringUtils.isEmpty((CharSequence)o.getInvoiceNumber())) {
                errorList.add("\u7ed3\u6848\u65b9\u5f0f\u542b\u6709\u62a5\u9500\u65f6,\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return errorList;
    }

    private Map<String, String> getBusinessFormatDict() {
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        if (CollectionUtils.isEmpty((Collection)dictDataVoList)) {
            return Maps.newHashMap();
        }
        return dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
    }
}

