/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.service.internal.impl;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleRepository;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditHandleCacheServiceImpl
extends MnPageCacheServiceImpl<AuditHandleDetailVo, AuditHandleDetailDto>
implements AuditHandleCacheService {
    private static final Logger log = LoggerFactory.getLogger(AuditHandleCacheServiceImpl.class);
    @Autowired(required=false)
    private AuditHandleRepository auditHandleRepository;
    @Autowired(required=false)
    private AuditHandleDetailRepository auditHandleDetailRepository;
    @Autowired(required=false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;
    @Autowired
    private AuditInvoiceManageService auditInvoiceManageService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatch(List<AuditHandle> auditHandleList, List<AuditHandleDetail> auditHandleDetailList, List<AuditHandleInvoice> auditHandleInvoiceList) {
        if (CollectionUtils.isNotEmpty(auditHandleList)) {
            log.info("\u6279\u91cf\u5bfc\u5165\u624b\u52a8\u4e0a\u8d26\uff0c\u4fdd\u5b58\u62ac\u5934\uff1a{}", (Object)JsonUtils.obj2JsonString(auditHandleList));
            this.auditHandleRepository.saveBatch(auditHandleList);
        }
        if (CollectionUtils.isNotEmpty(auditHandleDetailList)) {
            log.info("\u6279\u91cf\u5bfc\u5165\u624b\u52a8\u4e0a\u8d26\uff0c\u4fdd\u5b58\u660e\u7ec6\uff1a{}", (Object)JsonUtils.obj2JsonString(auditHandleDetailList));
            this.auditHandleDetailRepository.saveBatch(auditHandleDetailList);
        }
        if (CollectionUtils.isNotEmpty(auditHandleInvoiceList)) {
            this.auditHandleInvoiceRepository.saveBatch(auditHandleInvoiceList);
            ArrayList<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<AuditInvoiceManageDto>();
            for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
                AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
                dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
                dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
                invoiceManageDtoList.add(dto);
            }
            String useDate = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
            this.auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.YES.getCode(), useDate);
        }
    }
}

