/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.service.internal.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleInvoiceCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleInvoiceDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleSaveInvoiceCacheDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleInvoiceVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditHandleInvoiceCacheServiceImpl
extends MnPageCacheServiceImpl<AuditHandleInvoiceVo, AuditHandleInvoiceDto>
implements AuditHandleInvoiceCacheService {
    private static final Logger log = LoggerFactory.getLogger(AuditHandleInvoiceCacheServiceImpl.class);
    @Autowired(required=false)
    private AuditInvoiceManageService auditInvoiceManageService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;

    @Override
    public void saveInvoiceCache(AuditHandleSaveInvoiceCacheDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String cacheKey = dto.getCacheKey();
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String auditHandleCode = dto.getAuditHandleCode();
        Validate.notBlank((CharSequence)auditHandleCode, (String)"\u76f4\u63a5\u4e0a\u8d26\u7f16\u7801", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)dto.getAuditHandleInvoiceDtoList())) {
            return;
        }
        ArrayList<AuditInvoiceManageDto> invoiceManageDtos = new ArrayList<AuditInvoiceManageDto>();
        for (AuditHandleInvoiceDto auditHandleDto : dto.getAuditHandleInvoiceDtoList()) {
            String invoiceCode = auditHandleDto.getInvoiceCode();
            String invoiceNumber = auditHandleDto.getInvoiceNumber();
            AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
            auditInvoiceManageDto.setInvoiceNo(invoiceNumber);
            auditInvoiceManageDto.setInvoiceCode(invoiceCode);
            invoiceManageDtos.add(auditInvoiceManageDto);
        }
        ArrayList auditHandleInvoiceDtoList = new ArrayList();
        List invoiceItemVos = this.auditInvoiceManageService.findByInvoiceNoCode(invoiceManageDtos);
        log.info("\u76f4\u63a5\u4e0a\u8d26\u4fdd\u5b58\u7f13\u5b58:invoiceItemVos:{}", (Object)JsonUtils.obj2JsonString((Object)invoiceItemVos));
        if (CollUtil.isNotEmpty((Collection)invoiceItemVos)) {
            Collection auditHandleInvoiceDtos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)invoiceItemVos, AuditInvoiceItemVo.class, AuditHandleInvoiceDto.class, HashSet.class, ArrayList.class, new String[0]);
            auditHandleInvoiceDtos.forEach(item -> item.setAuditHandleCode(auditHandleCode));
            auditHandleInvoiceDtoList.addAll(auditHandleInvoiceDtos);
        }
        log.info("\u76f4\u63a5\u4e0a\u8d26\u4fdd\u5b58\u7f13\u5b58:auditHandleInvoiceDtoList:{}", (Object)JsonUtils.obj2JsonString(auditHandleInvoiceDtoList));
        if (CollectionUtils.isNotEmpty(auditHandleInvoiceDtoList)) {
            this.addItemCache(cacheKey, auditHandleInvoiceDtoList);
        }
    }

    @Override
    public void invoiceSubmit(List<AuditHandleInvoiceDto> auditHandleInvoiceDtoList, String auditHandleCode) {
        if (CollectionUtils.isNotEmpty(auditHandleInvoiceDtoList)) {
            for (AuditHandleInvoiceDto auditHandleInvoiceDto : auditHandleInvoiceDtoList) {
                auditHandleInvoiceDto.setId(null);
                auditHandleInvoiceDto.setTenantCode(TenantUtils.getTenantCode());
            }
            Collection auditHandleInvoices = this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleInvoiceDtoList, AuditHandleInvoiceDto.class, AuditHandleInvoice.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.auditHandleInvoiceRepository.deleteByAuditHandleCode(auditHandleCode);
            this.auditHandleInvoiceRepository.saveBatch(auditHandleInvoices);
            ArrayList<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<AuditInvoiceManageDto>();
            for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices) {
                AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
                dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
                dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
                invoiceManageDtoList.add(dto);
            }
            String useDate = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
            this.auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.YES.getCode(), useDate);
        }
    }

    @Override
    public void deleteAuditHandleCodeInvoiceRelation(String auditHandleCode) {
        if (StringUtils.isEmpty((CharSequence)auditHandleCode)) {
            return;
        }
        ArrayList<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<AuditInvoiceManageDto>();
        List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCode(auditHandleCode);
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
            AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
            dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
            dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
            invoiceManageDtoList.add(dto);
        }
        this.auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.NO.getCode(), null);
        this.auditHandleInvoiceRepository.deleteByAuditHandleCode(auditHandleCode);
    }
}

