/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.handle.local.service.internal.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.AccountingVoucherDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.ChargeAgainstAccountingVoucherDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.service.SapFiService;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.ChargeAgainstAccountingVoucherVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.SapAccountingVoucherVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountSonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandle;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleDetail;
import com.biz.crm.tpm.business.audit.handle.local.entity.AuditHandleInvoice;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleDetailRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleInvoiceRepository;
import com.biz.crm.tpm.business.audit.handle.local.repository.AuditHandleRepository;
import com.biz.crm.tpm.business.audit.handle.local.service.AuditHandleCacheService;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleProcessSubmitDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.log.AuditHandleLogEventDto;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.AcceptTypeEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.AuditFormEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.SaveTypeEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.SubComActivityAssociationTypeEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.SuccessAndFailEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.SucessOrFailEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.enums.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.handle.sdk.event.log.AuditHandleLogEventListener;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleImportVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditPrintVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.PaymentReceiptPaySdkVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.PaymentReceiptShouldSdkVo;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.UndertakeTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.AuditUseBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.FeeSourceEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditBudgetHeadVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditBudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.AuditBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.service.PaymentReceiptSdkService;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptPayVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptShouldVo;
import com.biz.crm.tpm.business.third.system.sdk.service.SAPCenterService;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditHandleSdkServiceImpl
implements AuditHandleSdkService {
    private static final Logger log = LoggerFactory.getLogger(AuditHandleSdkServiceImpl.class);
    @Autowired(required=false)
    private AuditHandleRepository auditHandleRepository;
    @Autowired(required=false)
    private AuditHandleDetailRepository auditHandleDetailRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private RedisTemplate redisTemplate;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private SapSdApiService sapSdApiService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SapFiService sapFiService;
    @Autowired(required=false)
    private AuditHandleCacheService auditHandleCacheService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private AuditHandleInvoiceRepository auditHandleInvoiceRepository;
    @Autowired(required=false)
    private AuditInvoiceManageService auditInvoiceManageService;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private SAPCenterService sapCenterService;
    @Autowired(required=false)
    private PaymentReceiptSdkService paymentReceiptSdkService;

    @Transactional
    public AuditHandleVo create(AuditHandleDto dto) {
        if (!SaveTypeEnum.temporary.getValue().equals(dto.getSaveType())) {
            this.createValidation(dto);
        }
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        String auditHandleCode = (String)this.generateCodeService.generateCode("D-4", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        dto.setAuditHandleCode(auditHandleCode);
        List detailDtos = this.auditHandleCacheService.findCacheList(dto.getCacheKey());
        List auditHandleDetailCodes = this.generateCodeService.generateCode("D-4", detailDtos.size(), Integer.valueOf(8), 2L, TimeUnit.DAYS);
        List upAccountCodes = new ArrayList();
        if (StringUtils.equals((CharSequence)BusinessUnitEnum.HEADQUARTERS.getCode(), (CharSequence)dto.getBusinessUnitCode())) {
            upAccountCodes = this.generateCodeService.generateCode("SZ", detailDtos.size(), Integer.valueOf(10), 2L, TimeUnit.DAYS);
        }
        for (int i = 0; i < detailDtos.size(); ++i) {
            String code = (String)auditHandleDetailCodes.get(i);
            AuditHandleDetailDto detail = (AuditHandleDetailDto)detailDtos.get(i);
            if (StringUtils.equals((CharSequence)BusinessUnitEnum.HEADQUARTERS.getCode(), (CharSequence)dto.getBusinessUnitCode())) {
                detail.setUpAccountCode((String)upAccountCodes.get(i));
            }
            detail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detail.setTenantCode(TenantUtils.getTenantCode());
            detail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detail.setAuditHandleDetailCode(code);
            detail.setAuditHandleCode(dto.getAuditHandleCode());
            detail.setAuditHandleName(dto.getAuditHandleName());
            detail.setUpAccountStatus(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode());
            if (!CollectionUtils.isNotEmpty((Collection)detail.getEndCaseForms())) continue;
            detail.setEndCaseForm(Joiner.on((String)",").join((Iterable)detail.getEndCaseForms()));
        }
        ArrayList auditHandleDetails = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailDtos, AuditHandleDetailDto.class, AuditHandleDetail.class, HashSet.class, ArrayList.class, new String[0]);
        AuditHandle auditHandle = (AuditHandle)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditHandle.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditHandleRepository.save((Object)auditHandle);
        this.auditHandleDetailRepository.saveBatch(auditHandleDetails);
        if (SaveTypeEnum.submit.getValue().equals(dto.getSaveType())) {
            dto.setId(auditHandle.getId());
            this.submitApproval(dto);
        }
        AuditHandleLogEventDto logEventDto = new AuditHandleLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = AuditHandleLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditHandleLogEventListener.class, (SerializableBiConsumer)onCreate);
        ArrayList auditHandleDetailVoList = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)auditHandleDetails, AuditHandleDetail.class, AuditHandleDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        AuditHandleVo auditHandleVo = (AuditHandleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditHandle, AuditHandleVo.class, HashSet.class, ArrayList.class, new String[0]);
        auditHandleVo.setAuditHandleDetailVoList((List)auditHandleDetailVoList);
        return auditHandleVo;
    }

    private void submitApproval(AuditHandleDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(dto.getId());
        processBusiness.setProcessTitle("\u624b\u52a8\u4e0a\u8d26[" + dto.getAuditHandleName() + "]\u53d1\u8d77\u5ba1\u6279\u6d41");
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("tpm_audit_handle_process");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        this.auditHandleRepository.updateProcessStatusAndNoByIds(Collections.singletonList(dto.getId()), ProcessStatusEnum.COMMIT, processBusinessVo.getProcessNo());
    }

    private void createValidation(AuditHandleDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCompanyName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCompanyCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDepartmentCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDepartmentName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAuditHandleName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u624b\u52a8\u4e0a\u8d26\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getCacheKey(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void detailValidation(List<AuditHandleDetailVo> detailVos) {
        Validate.notEmpty(detailVos, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        detailVos.forEach(o -> {
            Validate.notBlank((CharSequence)o.getUndertakingType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u627f\u63a5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getRelationType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getCostManage(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getBudgetCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getCostYearMonth(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8d39\u7528\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getActivityTypeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getActivityTypeName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getActivityFormCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getActivityFormName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductBrandCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u724c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductCategoryCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductItemCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u54c1\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)o.getProductPrice(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)o.getActivityPrice(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getWhetherDeductionFeePool(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u6263\u51cf\u8d39\u7528\u6c60\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getEndCaseForm(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            AuditFormEnum formEnum = AuditFormEnum.findEnumByCode((String)o.getEndCaseForm());
            switch (formEnum) {
                case DISCOUNT: {
                    Validate.notNull((Object)o.getDiscountTaxRate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6298\u6263\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getDiscountShouldHandleAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6298\u6263\u5e94\u5904\u7406\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getDiscountDeductionTaxAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6298\u6263\u6263\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getInFeePoolAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5165\u8d39\u7528\u6c60\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    break;
                }
                case REIMBURSE: {
                    Validate.notBlank((CharSequence)o.getInvoiceCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getInvoiceNumber(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getReimburseItemCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62a5\u9500\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getReimburseTaxRate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62a5\u9500\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getReimburseAmountTax(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62a5\u9500\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getReimburseAmountNoTax(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62a5\u9500\u91d1\u989d\uff08\u672a\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getTaxAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getPersonalTaxAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e2a\u4eba\u6240\u5f97\u7a0e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getCostCenterCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getCostCenterName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6210\u672c\u4e2d\u5fc3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getProfitCenterName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5229\u6da6\u4e2d\u5fc3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    break;
                }
                case RED_WORD_INVOICE: {
                    Validate.notBlank((CharSequence)o.getImpulseDifferenceProductCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u51b2\u5dee\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getImpulseDifferenceProductName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u51b2\u5dee\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getUnit(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getQuantity(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getFactoryName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5de5\u5382\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                }
            }
            Validate.notBlank((CharSequence)o.getWhetherWholeAudit(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
    }

    @Transactional
    public AuditHandleVo update(AuditHandleDto dto) {
        if (!SaveTypeEnum.temporary.getValue().equals(dto.getSaveType())) {
            this.updateValidation(dto);
        }
        List detailDtos = this.auditHandleCacheService.findCacheList(dto.getCacheKey());
        AuditHandle old = this.auditHandleRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)old), (String)"\u8be5\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.equals((CharSequence)ProcessStatusEnum.PREPARE.getDictCode(), (CharSequence)old.getProcessStatus()) || StringUtils.equals((CharSequence)ProcessStatusEnum.REJECT.getDictCode(), (CharSequence)old.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u4fee\u6539\u5f85\u63d0\u4ea4\u6216\u88ab\u9a73\u56de\u7684\u6570\u636e", (Object[])new Object[0]);
        List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleCode(old.getAuditHandleCode());
        AuditHandleDto oldDto = (AuditHandleDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)old, AuditHandleDto.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList handleDetailOldDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleDetails, AuditHandleDetail.class, AuditHandleDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        oldDto.setAuditHandleDetailDtoList((List)handleDetailOldDtos);
        if (CollectionUtils.isNotEmpty(auditHandleDetails)) {
            List<String> ids = auditHandleDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
            this.auditHandleDetailRepository.deleteByIds(ids);
        }
        List auditHandleDetailCodes = this.generateCodeService.generateCode("D-4", detailDtos.size(), Integer.valueOf(8), 2L, TimeUnit.DAYS);
        List upAccountCodes = this.generateCodeService.generateCode("SZ", detailDtos.size(), Integer.valueOf(10), 2L, TimeUnit.DAYS);
        for (int i = 0; i < detailDtos.size(); ++i) {
            String code = (String)auditHandleDetailCodes.get(i);
            String upAccountCode = (String)upAccountCodes.get(i);
            AuditHandleDetailDto detail = (AuditHandleDetailDto)detailDtos.get(i);
            detail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detail.setTenantCode(TenantUtils.getTenantCode());
            detail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detail.setAuditHandleDetailCode(code);
            detail.setAuditHandleCode(dto.getAuditHandleCode());
            detail.setAuditHandleName(dto.getAuditHandleName());
            detail.setUpAccountCode(upAccountCode);
            detail.setUpAccountStatus(UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode());
        }
        AuditHandle auditHandle = (AuditHandle)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditHandle.class, HashSet.class, ArrayList.class, new String[0]));
        ArrayList handleDetailsNew = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailDtos, AuditHandleDetailDto.class, AuditHandleDetail.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditHandleRepository.updateById((Object)auditHandle);
        this.auditHandleDetailRepository.saveBatch(handleDetailsNew);
        if (SaveTypeEnum.submit.getValue().equals(dto.getSaveType())) {
            this.submitApproval(dto);
        }
        AuditHandleLogEventDto logEventDto = new AuditHandleLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = AuditHandleLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditHandleLogEventListener.class, (SerializableBiConsumer)onUpdate);
        AuditHandleVo auditHandleVo = (AuditHandleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditHandleVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailDtos)) {
            Collection auditHandleDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailDtos, AuditHandleDetailDto.class, AuditHandleDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            auditHandleVo.setAuditHandleDetailVoList((List)auditHandleDetailVos);
        }
        return auditHandleVo;
    }

    private void updateValidation(AuditHandleDto dto) {
        Validate.notNull((Object)dto, (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCompanyName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCompanyCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDepartmentCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDepartmentName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAuditHandleName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u624b\u52a8\u4e0a\u8d26\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void updateDetailValidation(List<AuditHandleDetailVo> detailVos) {
        Validate.notEmpty(detailVos, (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        detailVos.forEach(o -> {
            Validate.notBlank((CharSequence)o.getUndertakingType(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u627f\u63a5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getRelationType(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getCostManage(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u8d39\u7528\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getBudgetCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getCostYearMonth(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u8d39\u7528\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getActivityTypeCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getActivityTypeName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getActivityFormCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getActivityFormName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductBrandCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u54c1\u724c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductCategoryCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u54c1\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductItemCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u54c1\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getProductName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)o.getProductPrice(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)o.getActivityPrice(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getCustomerCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getCustomerName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getWhetherDeductionFeePool(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u662f\u5426\u6263\u51cf\u8d39\u7528\u6c60\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getEndCaseForm(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            AuditFormEnum formEnum = AuditFormEnum.findEnumByCode((String)o.getEndCaseForm());
            switch (formEnum) {
                case DISCOUNT: {
                    Validate.notNull((Object)o.getDiscountTaxRate(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6298\u6263\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getDiscountShouldHandleAmount(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6298\u6263\u5e94\u5904\u7406\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getDiscountDeductionTaxAmount(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6298\u6263\u6263\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getInFeePoolAmount(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5165\u8d39\u7528\u6c60\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    break;
                }
                case REIMBURSE: {
                    Validate.notBlank((CharSequence)o.getInvoiceCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getInvoiceNumber(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getReimburseItemCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u62a5\u9500\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getReimburseTaxRate(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u62a5\u9500\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getReimburseAmountTax(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u62a5\u9500\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getReimburseAmountNoTax(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u62a5\u9500\u91d1\u989d\uff08\u672a\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getTaxAmount(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u7a0e\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getPersonalTaxAmount(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e2a\u4eba\u6240\u5f97\u7a0e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getCostCenterCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getCostCenterName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6210\u672c\u4e2d\u5fc3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getProfitCenterName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5229\u6da6\u4e2d\u5fc3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    break;
                }
                case RED_WORD_INVOICE: {
                    Validate.notBlank((CharSequence)o.getImpulseDifferenceProductCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u51b2\u5dee\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getImpulseDifferenceProductName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u51b2\u5dee\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getUnit(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)o.getQuantity(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)o.getFactoryName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5de5\u5382\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                }
            }
            Validate.notBlank((CharSequence)o.getWhetherWholeAudit(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
    }

    @Transactional
    public void delete(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u6838\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditHandle> auditHandles = this.auditHandleRepository.findByIds(ids);
        List<String> auditHandleCodeList = auditHandles.stream().map(AuditHandle::getAuditHandleCode).collect(Collectors.toList());
        auditHandles.forEach(o -> Validate.isTrue((StringUtils.equals((CharSequence)ProcessStatusEnum.PREPARE.getDictCode(), (CharSequence)o.getProcessStatus()) || StringUtils.equals((CharSequence)ProcessStatusEnum.REJECT.getDictCode(), (CharSequence)o.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u5220\u9664\u5f85\u63d0\u4ea4\u6216\u88ab\u9a73\u56de\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u3010%s\u3011", (Object[])new Object[]{o.getAuditHandleCode()}));
        List<AuditHandleDetail> detailList = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodeList);
        this.auditHandleRepository.deleteByAuditHandleCodes(auditHandleCodeList);
        this.auditHandleDetailRepository.deleteByAuditHandleCodes(auditHandleCodeList);
        this.deleteInvoiceRelation(auditHandleCodeList);
        ArrayList auditHandleDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles, AuditHandle.class, AuditHandleDto.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList auditHandleDetailDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(detailList, AuditHandleDetail.class, AuditHandleDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<AuditHandleDetailDto>> handleDetailMap = auditHandleDetailDtos.stream().collect(Collectors.groupingBy(AuditHandleDetailDto::getAuditHandleCode));
        for (AuditHandleDto handleDto : auditHandleDtos) {
            List<AuditHandleDetailDto> detailDtos = handleDetailMap.get(handleDto.getAuditHandleCode());
            handleDto.setAuditHandleDetailDtoList(detailDtos);
            handleDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            AuditHandleLogEventDto logEventDto = new AuditHandleLogEventDto();
            logEventDto.setNewest(handleDto);
            SerializableBiConsumer & Serializable onDelete = AuditHandleLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditHandleLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    private void deleteInvoiceRelation(List<String> auditHandleCodeList) {
        ArrayList<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<AuditInvoiceManageDto>();
        List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCodes(auditHandleCodeList);
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
            AuditInvoiceManageDto dto = new AuditInvoiceManageDto();
            dto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
            dto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
            invoiceManageDtoList.add(dto);
        }
        this.auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, YesOrNoEnum.NO.getCode(), null);
        this.auditHandleInvoiceRepository.deleteByAuditHandleCodes(auditHandleCodeList);
    }

    public void deleteByDetailCodes(List<String> auditHandleDetailCodes) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public AuditHandleVo submitApprove(AuditHandleProcessSubmitDto submitDto) {
        Validate.notNull((Object)submitDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)submitDto.getIds()), (String)"\u8bf7\u9009\u62e9\u63d0\u4ea4\u6570\u636e", (Object[])new Object[0]);
        List<AuditHandle> auditHandles = this.auditHandleRepository.findByIds(submitDto.getIds());
        auditHandles.forEach(o -> Validate.isTrue((StringUtils.equals((CharSequence)ProcessStatusEnum.PREPARE.getDictCode(), (CharSequence)o.getProcessStatus()) || StringUtils.equals((CharSequence)ProcessStatusEnum.REJECT.getDictCode(), (CharSequence)o.getProcessStatus()) || StringUtils.equals((CharSequence)ProcessStatusEnum.RECOVER.getDictCode(), (CharSequence)o.getProcessStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u63d0\u4ea4\u5f85\u63d0\u4ea4\u6216\u88ab\u9a73\u56de\u6216\u8ffd\u56de\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u3010%s\u3011", (Object[])new Object[]{o.getAuditHandleCode()}));
        List<String> auditHandleCodes = auditHandles.stream().map(AuditHandle::getAuditHandleCode).collect(Collectors.toList());
        this.submitVerify(auditHandleCodes, auditHandles);
        HashMap<String, Boolean> auditHandleLocks = new HashMap<String, Boolean>();
        try {
            for (AuditHandle auditHandle : auditHandles) {
                String key2 = "audit:handle:submit:" + auditHandle.getAuditHandleCode();
                boolean isLock = this.redisLockService.tryLock(key2, TimeUnit.HOURS, 1L);
                Validate.isTrue((boolean)isLock, (String)"\u624b\u52a8\u4e0a\u8d26\u5355\u53f7\uff1a\u3010%s\u3011,\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
                auditHandleLocks.put(key2, isLock);
            }
            List auditHandleDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles, AuditHandle.class, AuditHandleDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.useBudget(auditHandleDtos, AuditUseBudgetTypeEnum.USE);
            List<String> ids = auditHandles.stream().map(UuidEntity::getId).collect(Collectors.toList());
            ProcessBusinessDto processBusiness = submitDto.getProcessBusiness();
            processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)submitDto));
            processBusiness.setBusinessCode("tpm_audit_handle_process");
            processBusiness.setBusinessNoList(ids);
            processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
            ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
            this.auditHandleRepository.updateProcessStatusAndNoByIds(ids, ProcessStatusEnum.COMMIT, processBusinessVo.getProcessNo());
        }
        finally {
            auditHandleLocks.forEach((key, value) -> {
                if (value.booleanValue()) {
                    this.redisLockService.unlock(key);
                }
            });
        }
        return null;
    }

    private void submitVerify(List<String> auditHandleCodes, List<AuditHandle> auditHandles) {
        if (CollectionUtils.isNotEmpty(auditHandleCodes)) {
            List<AuditHandleDetail> auditHandleDetailList = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
            Map<Object, Object> auditHandleDetailMap = new HashMap();
            if (CollectionUtils.isNotEmpty(auditHandleDetailList)) {
                auditHandleDetailMap = auditHandleDetailList.stream().collect(Collectors.groupingBy(AuditHandleDetail::getAuditHandleCode));
            }
            List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCodes(auditHandleCodes);
            Map<Object, Object> auditHandleInvoiceMap = new HashMap();
            if (CollectionUtils.isNotEmpty(auditHandleInvoiceList)) {
                auditHandleInvoiceMap = auditHandleInvoiceList.stream().collect(Collectors.groupingBy(AuditHandleInvoice::getAuditHandleCode));
            }
            for (AuditHandle auditHandle : auditHandles) {
                List auditHandleDetailList1 = (List)auditHandleDetailMap.get(auditHandle.getAuditHandleCode());
                if (!CollectionUtils.isNotEmpty(auditHandleDetailList1 = auditHandleDetailList1.stream().filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())).collect(Collectors.toList()))) continue;
                BigDecimal thisAuditAmountTax = auditHandleDetailList1.stream().map(AuditHandleDetail::getThisAuditAmountTax).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                List auditHandleInvoiceList1 = (List)auditHandleInvoiceMap.get(auditHandle.getAuditHandleCode());
                Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)auditHandleInvoiceList1), (String)"\u76f4\u63a5\u4e0a\u8d26\u7f16\u7801\u3010%s\u3011\u672a\u4fdd\u5b58\u53d1\u7968", (Object[])new Object[]{auditHandle.getAuditHandleCode()});
                BigDecimal invoiceTaxAmount = auditHandleInvoiceList1.stream().map(AuditHandleInvoice::getInvoiceTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                Validate.isTrue((thisAuditAmountTax.compareTo(invoiceTaxAmount) <= 0 ? 1 : 0) != 0, (String)"\u53d1\u7968\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u62a5\u9500\u91d1\u989d", (Object[])new Object[0]);
            }
        }
    }

    private void useBudget(List<AuditHandleDto> auditHandles, AuditUseBudgetTypeEnum useType) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        if (CollectionUtils.isNotEmpty(auditHandles)) {
            List<String> auditHandleCodes = auditHandles.stream().map(AuditHandleDto::getAuditHandleCode).collect(Collectors.toList());
            List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
            Map<String, List<AuditHandleDetail>> auditHandleDetailsMap = auditHandleDetails.stream().collect(Collectors.groupingBy(AuditHandleDetail::getAuditHandleCode));
            for (AuditHandleDto auditHandle : auditHandles) {
                List<AuditHandleDetail> auditHandleDetails1 = auditHandleDetailsMap.get(auditHandle.getAuditHandleCode());
                AuditHandleDetail auditHandleDetail = auditHandleDetails1.get(0);
                AuditBudgetHeadVo auditBudgetHeadVo = new AuditBudgetHeadVo();
                auditBudgetHeadVo.setAuditCode(auditHandle.getAuditHandleCode());
                auditBudgetHeadVo.setBusinessUnitCode(auditHandle.getBusinessUnitCode());
                ArrayList<AuditBudgetVo> auditBudgetVoList = new ArrayList<AuditBudgetVo>();
                AuditBudgetVo auditBudgetVo = new AuditBudgetVo();
                auditBudgetVo.setAuditDetailCode(auditHandle.getAuditHandleCode());
                BigDecimal thisAuditAmountTax = Optional.ofNullable(auditHandleDetail.getThisAuditAmountTax()).orElse(BigDecimal.ZERO);
                if (AuditUseBudgetTypeEnum.USE.equals((Object)useType) && thisAuditAmountTax.compareTo(BigDecimal.ZERO) > 0) {
                    auditBudgetVo.setAmount(thisAuditAmountTax.abs());
                    auditBudgetVo.setType(AuditUseBudgetTypeEnum.USE);
                } else {
                    if (!AuditUseBudgetTypeEnum.RETURN.equals((Object)useType) || thisAuditAmountTax.compareTo(BigDecimal.ZERO) >= 0) continue;
                    auditBudgetVo.setAmount(thisAuditAmountTax.abs());
                    auditBudgetVo.setType(AuditUseBudgetTypeEnum.RETURN);
                }
                String feeYearMonth = df.format(auditHandleDetail.getFeeYearMonth());
                MonthBudgetVo monthBudgetVo = this.monthBudgetService.getOneByYearBudgetCodeAndMonth(auditHandleDetail.getYearBudgetCode(), feeYearMonth);
                ArrayList<AuditBudgetItemVo> auditBudgetItemVos = new ArrayList<AuditBudgetItemVo>();
                AuditBudgetItemVo auditBudgetItemVo = (AuditBudgetItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)monthBudgetVo, AuditBudgetItemVo.class, null, null, new String[0]);
                auditBudgetItemVos.add(auditBudgetItemVo);
                auditBudgetVo.setBudgetItems(auditBudgetItemVos);
                auditBudgetVoList.add(auditBudgetVo);
                auditBudgetHeadVo.setAuditBudgetVoList(auditBudgetVoList);
                this.monthBudgetService.auditUseBudget(auditBudgetHeadVo);
            }
        }
    }

    public void sonCompanyBudgetDeduction(List<AuditHandleDto> auditHandles, Map<String, List<AuditHandleDetailDto>> auditHandleCodeMap) {
        if (CollectionUtils.isEmpty(auditHandles)) {
            return;
        }
        for (AuditHandleDto auditHandle : auditHandles) {
            List<AuditHandleDetailDto> auditHandleDetails = auditHandleCodeMap.get(auditHandle.getAuditHandleCode());
            List budgeItemCodes = auditHandleDetails.stream().map(o -> o.getBudgetCode()).filter(Objects::nonNull).collect(Collectors.toList());
            List budgetForecastVoList = this.subComBudgetForecastService.findByBudgetItemCodes(budgeItemCodes);
            for (AuditHandleDetailDto detail : auditHandleDetails) {
                if (StringUtils.equals((CharSequence)detail.getUndertakingType(), (CharSequence)AcceptTypeEnum.NO_ACCEPT.getCode()) && StringUtils.equals((CharSequence)detail.getRelationType(), (CharSequence)SubComActivityAssociationTypeEnum.NON.getCode())) {
                    this.sonCompanyDeductionBudgetAmount(budgetForecastVoList, detail, null);
                }
                if (!StringUtils.equals((CharSequence)UndertakeTypeEnum.WHOLE_UNDERTAKE.getCode(), (CharSequence)detail.getUndertakingType()) && !StringUtils.equals((CharSequence)UndertakeTypeEnum.PART_UNDERTAKE.getCode(), (CharSequence)detail.getUndertakingType())) continue;
                String relationDataCode = detail.getRelationDataCode();
                List activityPlanItemVos = this.activityPlanItemSdkService.listByItemCodeList((List)Lists.newArrayList((Object[])new String[]{relationDataCode}));
                Validate.notEmpty((Collection)activityPlanItemVos, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d3b\u7ec6\u6848\u3010%s\u3011", (Object[])new Object[]{relationDataCode});
                ActivityPlanItemVo activityPlanItemVo = (ActivityPlanItemVo)activityPlanItemVos.get(0);
                ArrayList itemCodes = Lists.newArrayList();
                if (StringUtils.isNotBlank((CharSequence)activityPlanItemVo.getHeadBudgetItemCode())) {
                    itemCodes.add(activityPlanItemVo.getHeadBudgetItemCode());
                }
                if (StringUtils.isNotBlank((CharSequence)activityPlanItemVo.getMonthBudgetCode())) {
                    itemCodes.add(activityPlanItemVo.getMonthBudgetCode());
                }
                List monthBudgetVos = this.monthBudgetService.findByCodes((List)itemCodes, EnableStatusEnum.ENABLE.getCode());
                Map monthBudgetVoMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
                List budgetItemCodes = monthBudgetVos.stream().map(o -> o.getBudgetItemCode()).filter(Objects::nonNull).collect(Collectors.toList());
                List budgetItemVos = this.budgetItemService.listByMainBudgetItem(budgetItemCodes);
                for (BudgetItemVo budgetItemVo : budgetItemVos) {
                    detail.setBudgetCode(budgetItemVo.getBudgetItemCode());
                    if (Objects.nonNull(monthBudgetVoMap.get(activityPlanItemVo.getHeadBudgetItemCode()))) {
                        this.sonCompanyDeductionBudgetAmount(budgetForecastVoList, detail, detail.getHeadquartersUndertakeAmount());
                    }
                    if (!Objects.nonNull(monthBudgetVoMap.get(activityPlanItemVo.getMonthBudgetCode()))) continue;
                    this.sonCompanyDeductionBudgetAmount(budgetForecastVoList, detail, detail.getRegionUndertakeAmount());
                }
            }
        }
    }

    public void sonCompanyDeductionBudgetAmount(List<SubComBudgetForecastVo> budgetForecastVoList, AuditHandleDetailDto detail, BigDecimal currentAuditAmountTax) {
        BigDecimal sub;
        SubComBudgetForecastVo forecastVo;
        List forecastVos = budgetForecastVoList.stream().filter(o -> {
            if (StringUtils.equals((CharSequence)detail.getBudgetCode(), (CharSequence)o.getBudgetItemCode()) && StringUtils.equals((CharSequence)detail.getCostYearMonth(), (CharSequence)o.getYearMonthLy()) && StringUtils.equals((CharSequence)detail.getOrgCode(), (CharSequence)o.getOrgCode())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }).collect(Collectors.toList());
        Validate.notEmpty(forecastVos, (String)"\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u9884\u6d4b\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01", (Object[])new Object[0]);
        Map forecastVoMap = forecastVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getFeeSourceCode())).filter(o -> Objects.nonNull(o.getRemainderAmount())).collect(Collectors.toMap(SubComBudgetForecastVo::getFeeSourceCode, Function.identity()));
        if (Objects.isNull(forecastVoMap) || forecastVoMap.isEmpty()) {
            throw new IllegalArgumentException("\u672a\u80fd\u83b7\u53d6\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u4fe1\u606f");
        }
        if (forecastVoMap.containsKey(FeeSourceEnum.OFF_POINT_FEE.getCode()) && currentAuditAmountTax.compareTo(BigDecimal.ZERO) > 0) {
            forecastVo = (SubComBudgetForecastVo)forecastVoMap.get(FeeSourceEnum.OFF_POINT_FEE.getCode());
            sub = NumberUtil.sub((Number)currentAuditAmountTax, (Number)forecastVo.getRemainderAmount());
            if (sub.compareTo(BigDecimal.ZERO) >= 0) {
                currentAuditAmountTax = sub;
                forecastVo.setRemainderAmount(BigDecimal.ZERO);
            } else {
                forecastVo.setRemainderAmount(sub.negate());
            }
            this.subComBudgetForecastService.updateForecastRemainderAmount(forecastVo.getId(), forecastVo.getRemainderAmount());
        }
        if (forecastVoMap.containsKey(FeeSourceEnum.INTERNAL_POINT_FEE.getCode()) && currentAuditAmountTax.compareTo(BigDecimal.ZERO) > 0) {
            forecastVo = (SubComBudgetForecastVo)forecastVoMap.get(FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
            sub = NumberUtil.sub((Number)currentAuditAmountTax, (Number)forecastVo.getRemainderAmount());
            if (sub.compareTo(BigDecimal.ZERO) >= 0) {
                currentAuditAmountTax = sub;
                forecastVo.setRemainderAmount(BigDecimal.ZERO);
            } else {
                forecastVo.setRemainderAmount(sub.negate());
            }
            this.subComBudgetForecastService.updateForecastRemainderAmount(forecastVo.getId(), forecastVo.getRemainderAmount());
        }
        if (forecastVoMap.containsKey(FeeSourceEnum.AUTO_FEE.getCode()) && currentAuditAmountTax.compareTo(BigDecimal.ZERO) > 0) {
            forecastVo = (SubComBudgetForecastVo)forecastVoMap.get(FeeSourceEnum.AUTO_FEE.getCode());
            sub = NumberUtil.sub((Number)currentAuditAmountTax, (Number)forecastVo.getRemainderAmount());
            forecastVo.setRemainderAmount(sub.negate());
            this.subComBudgetForecastService.updateForecastRemainderAmount(forecastVo.getId(), forecastVo.getRemainderAmount());
        }
    }

    public void headQuartersBudgetDeduction(List<AuditHandleDto> auditHandles, Map<String, List<AuditHandleDetailDto>> auditHandleCodeMap) {
        if (CollectionUtils.isEmpty(auditHandles)) {
            return;
        }
        this.useBudget(auditHandles, AuditUseBudgetTypeEnum.RETURN);
    }

    public void sonCompanyDiscountCallBack(SonAuditCostPostingCallbackDto dto) {
        log.info("\u76f4\u63a5\u4e0a\u5e10 \u6298\u6263\u4e0a\u8d26 \u5206\u5b50\u516c\u53f8\u56de\u8c03 \u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
        List data = dto.getData();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            String zftpmhxd = ((SonAuditCostPostingCallbackDataDto)data.get(0)).getZftpmhxd();
            Map callBackDataMap = data.stream().collect(Collectors.toMap(SonAuditCostPostingCallbackDataDto::getZftpmhxd, Function.identity()));
            List<String> zftpmhxdCodes = data.stream().map(o -> o.getZftpmhxd()).filter(Objects::nonNull).collect(Collectors.toList());
            List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleDetailCodes(zftpmhxdCodes);
            if (CollectionUtils.isNotEmpty(auditHandleDetails)) {
                for (AuditHandleDetail auditHandleDetail : auditHandleDetails) {
                    SonAuditCostPostingCallbackDataDto callbackDataDto = (SonAuditCostPostingCallbackDataDto)callBackDataMap.get(auditHandleDetail.getAuditHandleDetailCode());
                    if (StringUtils.equals((CharSequence)SucessOrFailEnum.SUCESS.getCode(), (CharSequence)callbackDataDto.getFlag())) {
                        auditHandleDetail.setUpAccountStatus(UpAccountStatusEnum.COMMIT_SUCCESS.getCode());
                        auditHandleDetail.setUpAccountMessage(UpAccountStatusEnum.COMMIT_SUCCESS.getDesc());
                        continue;
                    }
                    auditHandleDetail.setUpAccountStatus(UpAccountStatusEnum.COMMIT_FAIL.getCode());
                    auditHandleDetail.setUpAccountMessage(UpAccountStatusEnum.COMMIT_FAIL.getDesc());
                }
                this.auditHandleDetailRepository.updateBatchById(auditHandleDetails);
            }
        }
    }

    public void headquartersDiscountCallBack(AuditCostPostingCallbackDto dto) {
        log.info("\u76f4\u63a5\u4e0a\u5e10\u6298\u6263\u4e0a\u8d26\u603b\u516c\u53f8\u56de\u8c03\u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
        List data = dto.getData();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            Map callBackDataMap = data.stream().collect(Collectors.toMap(key -> "D-" + key.getCamp_id(), Function.identity()));
            log.info("\u76f4\u63a5\u4e0a\u5e10\u6298\u6263\u4e0a\u8d26\u603b\u516c\u53f8\u56de\u8c03,key:{},values:{}", (Object)JsonUtils.obj2JsonString(callBackDataMap.keySet()), (Object)JsonUtils.obj2JsonString(callBackDataMap.values()));
            List<String> campIds = data.stream().map(o -> "D-" + o.getCamp_id()).collect(Collectors.toList());
            List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleCodes(campIds);
            log.info("\u76f4\u63a5\u4e0a\u5e10\u6298\u6263\u4e0a\u8d26\u603b\u516c\u53f8\u56de\u8c03,auditHandleDetails:{}", (Object)JsonUtils.obj2JsonString(auditHandleDetails));
            ArrayList<AuditHandleDetail> updateList = new ArrayList<AuditHandleDetail>();
            for (AuditHandleDetail auditHandleDetail : auditHandleDetails) {
                AuditHandleDetail auditHandleDetail1 = new AuditHandleDetail();
                auditHandleDetail1.setId(auditHandleDetail.getId());
                AuditCostPostingCallbackDataDto callbackDataDto = (AuditCostPostingCallbackDataDto)callBackDataMap.get(auditHandleDetail.getAuditHandleDetailCode());
                if (StringUtils.equals((CharSequence)SucessOrFailEnum.SUCESS.getCode(), (CharSequence)callbackDataDto.getFlag())) {
                    auditHandleDetail1.setUpAccountStatus(UpAccountStatusEnum.COMMIT_SUCCESS.getCode());
                    auditHandleDetail1.setUpAccountMessage(UpAccountStatusEnum.COMMIT_SUCCESS.getDesc());
                } else {
                    auditHandleDetail1.setUpAccountStatus(UpAccountStatusEnum.COMMIT_FAIL.getCode());
                    auditHandleDetail1.setUpAccountMessage(UpAccountStatusEnum.COMMIT_FAIL.getDesc());
                }
                updateList.add(auditHandleDetail1);
            }
            log.info("\u76f4\u63a5\u4e0a\u5e10\u6298\u6263\u4e0a\u8d26\u603b\u516c\u53f8\u56de\u8c03,updateList:{}", (Object)JsonUtils.obj2JsonString(updateList));
            this.auditHandleDetailRepository.updateBatchById(updateList);
        }
    }

    public List<AuditHandleDetailVo> findDetailListByAuditHandleCode(String auditDetailCode) {
        if (StringUtils.isEmpty((CharSequence)auditDetailCode)) {
            return Lists.newArrayList();
        }
        List<AuditHandleDetail> detailList = this.auditHandleDetailRepository.findByAuditHandleCode(auditDetailCode);
        ArrayList auditHandleDetailVos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(detailList, AuditHandleDetail.class, AuditHandleDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        return auditHandleDetailVos;
    }

    public AuditHandleVo findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditHandle byId = this.auditHandleRepository.findById(id);
        Validate.notNull((Object)((Object)byId), (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664!", (Object[])new Object[0]);
        AuditHandleVo handleVo = (AuditHandleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)byId, AuditHandleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return handleVo;
    }

    public AuditHandleVo findByAuditHandleCode(String auditHandleCode) {
        Validate.notBlank((CharSequence)auditHandleCode, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditHandle auditHandle = this.auditHandleRepository.findByAuditHandleCode(auditHandleCode);
        Validate.notNull((Object)((Object)auditHandle), (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664!", (Object[])new Object[0]);
        AuditHandleVo handleVo = (AuditHandleVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditHandle, AuditHandleVo.class, HashSet.class, ArrayList.class, new String[0]);
        return handleVo;
    }

    public List<AuditHandleVo> findByIds(List<String> ids) {
        Validate.notEmpty(ids, (String)"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditHandle> byIds = this.auditHandleRepository.findByIds(ids);
        Validate.notEmpty(byIds, (String)"\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664", (Object[])new Object[0]);
        List<String> auditHandleCodes = byIds.stream().map(o -> o.getAuditHandleCode()).collect(Collectors.toList());
        ArrayList auditHandleVos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(byIds, AuditHandle.class, AuditHandleVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<AuditHandleDetail> auditHandleDetails = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
        if (CollectionUtils.isNotEmpty(auditHandleDetails)) {
            Collection handleDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleDetails, AuditHandleDetail.class, AuditHandleDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<AuditHandleDetailVo>> detailVoMap = handleDetailVos.stream().collect(Collectors.groupingBy(AuditHandleDetailVo::getAuditHandleCode));
            for (AuditHandleVo handleVo : auditHandleVos) {
                List<AuditHandleDetailVo> auditHandleDetailVos = detailVoMap.get(handleVo.getAuditHandleCode());
                auditHandleDetailVos.forEach(item -> {
                    item.setCompanyCode(handleVo.getCompanyCode());
                    item.setCompanyName(handleVo.getCompanyName());
                    item.setBusinessFormatCode(handleVo.getBusinessFormatCode());
                    item.setBusinessUnitCode(handleVo.getBusinessUnitCode());
                });
                handleVo.setAuditHandleDetailVoList(auditHandleDetailVos);
            }
        }
        return auditHandleVos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void upAccount(String body) {
        log.info("\u76f4\u63a5\u4e0a\u8d26 \u53c2\u6570\u3010{}\u3011", (Object)body);
        if (StringUtils.isEmpty((CharSequence)body)) {
            return;
        }
        ArrayList ids = Lists.newArrayList((Object[])body.split(","));
        boolean hasLock = false;
        try {
            hasLock = this.redisLockService.batchLock("audit_handle:up_account_batch", (List)ids, TimeUnit.MINUTES, 30);
            if (!hasLock) {
                throw new RuntimeException("\u6b63\u5728\u4e0a\u8d26\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001");
            }
            List<AuditHandleVo> handleVos = this.findByIds(ids);
            block7: for (AuditHandleVo handleVo : handleVos) {
                BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum((String)handleVo.getBusinessUnitCode());
                switch (businessUnitEnum) {
                    case HEADQUARTERS: {
                        this.headquartersUpAccount(handleVo);
                        continue block7;
                    }
                    case SON_COMPANY: {
                        this.sonCompanyUpAccount(handleVo);
                        continue block7;
                    }
                }
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u5355\u5143\u7c7b\u578b\u3010" + businessUnitEnum + "\u3011");
            }
        }
        finally {
            if (hasLock) {
                this.redisLockService.batchUnLock("audit_handle:up_account_batch", (List)ids);
            }
        }
    }

    private void sonCompanyUpAccount(AuditHandleVo auditHandleVo) {
        log.info("\u76f4\u63a5\u4e0a\u8d26 \u3010\u5206\u5b50\u516c\u53f8\u63a5\u53e3\u3011\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)auditHandleVo));
        List auditHandleDetailVoList = auditHandleVo.getAuditHandleDetailVoList();
        List<AuditHandleDetailVo> discountDetailVo = auditHandleDetailVoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getEndCaseForm())).filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())).filter(o -> StringUtils.isEmpty((CharSequence)o.getUpAccountStatus()) || UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(o.getUpAccountStatus())).collect(Collectors.toList());
        List<AuditHandleDetailVo> reimburseDetailVo = null;
        if (UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(auditHandleVo.getUpAccountStatusReimburse()) || StringUtils.isEmpty((CharSequence)auditHandleVo.getUpAccountStatusReimburse())) {
            reimburseDetailVo = auditHandleDetailVoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getEndCaseForm())).filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(discountDetailVo)) {
            this.sonCompanyDiscountUpAccount(auditHandleVo, discountDetailVo);
        }
        if (CollectionUtils.isNotEmpty(reimburseDetailVo)) {
            this.sonCompanyReimburseAccount(auditHandleVo, reimburseDetailVo);
        }
    }

    private void sonCompanyDiscountUpAccount(AuditHandleVo handleVo, List<AuditHandleDetailVo> auditHandleDetailVoList) {
        List formCodes = auditHandleDetailVoList.stream().map(o -> o.getActivityFormCode()).filter(Objects::nonNull).collect(Collectors.toList());
        List activityFormVos = this.activityFormService.findByCodes(formCodes);
        Map formVoMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        AuditFeeUpAccountSonCompanyDto auditFeeUpAccountSonCompanyDto = new AuditFeeUpAccountSonCompanyDto();
        AuditFeeUpAccountSonCompanyDto.MessageHeader messageHeader = new AuditFeeUpAccountSonCompanyDto.MessageHeader();
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE("SI_TPM80_HXFYSZ_FGS_ASYN_OUT");
        messageHeader.setSENDER("TPM");
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER("ECC");
        auditFeeUpAccountSonCompanyDto.setMessageHeader(messageHeader);
        ArrayList<AuditFeeUpAccountSonCompanyDto.Item1> item1List = new ArrayList<AuditFeeUpAccountSonCompanyDto.Item1>();
        for (AuditHandleDetailVo detailVo : auditHandleDetailVoList) {
            AuditFeeUpAccountSonCompanyDto.Item1 item1 = new AuditFeeUpAccountSonCompanyDto.Item1();
            item1.setZFTPMHXD(detailVo.getAuditHandleCode());
            item1.setZFHXDLX(detailVo.getDiscountShouldHandleAmount().compareTo(BigDecimal.ZERO) >= 0 ? "ZSC1" : "ZSC2");
            item1.setKUNNR(detailVo.getCustomerCode());
            item1.setZFAMT1(Optional.ofNullable(detailVo.getDiscountShouldHandleAmount()).orElse(BigDecimal.ZERO).toPlainString());
            item1.setMATNR(detailVo.getProductCode());
            Calendar now = Calendar.getInstance();
            item1.setGJAHR(String.valueOf(now.get(1)));
            item1.setMONAT(String.valueOf(now.get(2) + 1));
            item1.setVKORG(handleVo.getCompanyCode());
            item1.setVTWEG(detailVo.getChannelCode());
            if (Objects.nonNull(formVoMap.get(detailVo.getEndCaseForm()))) {
                item1.setZFCXXS(((ActivityFormVo)formVoMap.get(detailVo.getEndCaseForm())).getSapCode());
            }
            DictDataVo businessFormatCodeVo = this.dictDataVoService.findByDictTypeCodeAndDictCode("mdm_business_format", handleVo.getBusinessFormatCode());
            Validate.notNull((Object)businessFormatCodeVo, (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u3010%s\u3011\u7684\u6570\u636e\u5b57\u5178", (Object[])new Object[]{handleVo.getBusinessFormatCode()});
            Map extendMap = businessFormatCodeVo.getExtendMap();
            if (extendMap != null) {
                String zfyt = (String)extendMap.get("ZFYT");
                item1.setZFYT(zfyt);
            }
            item1List.add(item1);
        }
        this.sapSdApiService.auditFeeUpAccountSonCompany(auditFeeUpAccountSonCompanyDto);
    }

    private void sonCompanyReimburseAccount(AuditHandleVo handleVo, List<AuditHandleDetailVo> auditHandleDetailVoList) {
        List<AuditHandleInvoice> auditHandleInvoices = this.auditHandleInvoiceRepository.findByAuditHandleCode(handleVo.getAuditHandleCode());
        AuditHandleVo auditHandleVo = this.reimburseUpAccountAll(auditHandleDetailVoList, auditHandleInvoices, handleVo);
        AuditHandle auditHandle = (AuditHandle)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditHandleVo, AuditHandle.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditHandleRepository.updateById((Object)auditHandle);
    }

    private void headquartersUpAccount(AuditHandleVo auditHandleVo) {
        log.info("\u76f4\u63a5\u4e0a\u8d26 \u3010\u603b\u516c\u53f8\u63a5\u53e3\u3011\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)auditHandleVo));
        List auditHandleDetailVoList = auditHandleVo.getAuditHandleDetailVoList();
        List<AuditHandleDetailVo> discountDetailVo = auditHandleDetailVoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getEndCaseForm())).filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())).filter(o -> StringUtils.isEmpty((CharSequence)o.getUpAccountStatus()) || UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(o.getUpAccountStatus())).collect(Collectors.toList());
        List<AuditHandleDetailVo> reimburseDetailVo = null;
        if (UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(auditHandleVo.getUpAccountStatusReimburse()) || StringUtils.isEmpty((CharSequence)auditHandleVo.getUpAccountStatusReimburse())) {
            reimburseDetailVo = auditHandleDetailVoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getEndCaseForm())).filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(discountDetailVo)) {
            this.headquartersDiscountAccount(auditHandleVo, discountDetailVo);
        }
        if (CollectionUtils.isNotEmpty(reimburseDetailVo)) {
            this.headquartersReimburseAccount(auditHandleVo, reimburseDetailVo);
        }
    }

    private void headquartersDiscountAccount(AuditHandleVo handleVo, List<AuditHandleDetailVo> auditHandleDetailVoList) {
        log.info("\u76f4\u63a5\u4e0a\u8d26 \u6298\u6263\u4e0a\u8d26 \u3010\u603b\u516c\u53f8\u63a5\u53e3\u3011\u53c2\u65701\uff1a\u3010{}\u3011\uff0c\u53c2\u65702\uff1a\u3010{}\u3011", (Object)JSON.toJSONString((Object)handleVo), (Object)JSON.toJSONString(auditHandleDetailVoList));
        AuditFeeUpAccountDto auditFeeUpAccountDto = new AuditFeeUpAccountDto();
        AuditFeeUpAccountDto.MessageHeader messageHeader = new AuditFeeUpAccountDto.MessageHeader();
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE("SI_TPM70_EXPENSES_HQ_ASYN_OUT");
        messageHeader.setSENDER("TPM");
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER("ECC");
        auditFeeUpAccountDto.setMessageHeader(messageHeader);
        ArrayList<AuditFeeUpAccountDto.Item1> item1List = new ArrayList<AuditFeeUpAccountDto.Item1>();
        List activityFormCodes = auditHandleDetailVoList.stream().map(AuditHandleDetailVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        List activityFormVos = this.activityFormService.findByCodes(activityFormCodes);
        Map formVoMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        List customerCodes = auditHandleDetailVoList.stream().map(AuditHandleDetailVo::getLongCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        List customerVoList = this.customerVoService.findByCustomerCodes(customerCodes);
        Map customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        ArrayList<AuditHandleDetail> auditHandleDetailList = new ArrayList<AuditHandleDetail>();
        for (AuditHandleDetailVo handleDetailVo : auditHandleDetailVoList) {
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(handleDetailVo.getLongCustomerCode());
            Validate.notNull((Object)customerVo, (String)"\u5ba2\u6237\u7f16\u7801\u3010%s\u3011\u4e0d\u5b58\u5728", (Object[])new Object[]{handleDetailVo.getLongCustomerCode()});
            AuditFeeUpAccountDto.Item1 item1 = new AuditFeeUpAccountDto.Item1();
            item1.setKUNNR(customerVo.getErpCode());
            String[] split = handleDetailVo.getAuditHandleCode().split("-");
            item1.setCAMP_ID(split[1]);
            item1.setMATNR(handleDetailVo.getProductCode());
            if (Objects.nonNull(formVoMap.get(handleDetailVo.getActivityFormCode()))) {
                item1.setCAMP_DES(((ActivityFormVo)formVoMap.get(handleDetailVo.getActivityFormCode())).getSapCode());
            }
            item1.setVKBUR(customerVo.getSalesRegionErpCode());
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            item1.setZFQSRQ(Objects.isNull(handleDetailVo.getActivityBeginDate()) ? null : sdf.format(handleDetailVo.getActivityBeginDate()));
            item1.setZFJSRQ(Objects.isNull(handleDetailVo.getActivityEndDate()) ? null : sdf.format(handleDetailVo.getActivityEndDate()));
            item1.setKSCHL(null);
            item1.setDMBTR(handleDetailVo.getThisAuditAmountTax().toPlainString());
            item1.setZFLAG("A");
            item1.setWAERS("CNY");
            item1.setVKGRP(customerVo.getSalesOrgErpCode());
            item1List.add(item1);
            AuditHandleDetail auditHandleDetail = new AuditHandleDetail();
            auditHandleDetail.setId(handleDetailVo.getId());
            auditHandleDetail.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTING.getCode());
            auditHandleDetailList.add(auditHandleDetail);
        }
        auditFeeUpAccountDto.setITEM1(item1List);
        this.sapSdApiService.auditFeeUpAccount(auditFeeUpAccountDto);
        this.auditHandleDetailRepository.updateBatchById(auditHandleDetailList);
        log.info("\u603b\u516c\u53f8 \u76f4\u63a5\u4e0a\u8d26\u6298\u6263\u4e0a\u8d26\u7ed3\u675f");
    }

    private void headquartersReimburseAccount(AuditHandleVo handleVo, List<AuditHandleDetailVo> auditHandleDetailVoList) {
        List<AuditHandleInvoice> auditHandleInvoices = this.auditHandleInvoiceRepository.findByAuditHandleCode(handleVo.getAuditHandleCode());
        AuditHandleVo auditHandleVo = this.reimburseUpAccountAll(auditHandleDetailVoList, auditHandleInvoices, handleVo);
        AuditHandle auditHandle = (AuditHandle)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditHandleVo, AuditHandle.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditHandleRepository.updateById((Object)auditHandle);
        ArrayList<AuditHandleInvoice> auditHandleInvoiceUpdates = new ArrayList<AuditHandleInvoice>();
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices) {
            AuditHandleInvoice auditHandleInvoice1 = new AuditHandleInvoice();
            auditHandleInvoice1.setId(auditHandleInvoice.getId());
            auditHandleInvoice1.setChangeAmount(auditHandleInvoice.getChangeAmount());
            auditHandleInvoiceUpdates.add(auditHandleInvoice1);
        }
        if (CollectionUtils.isNotEmpty(auditHandleInvoiceUpdates)) {
            this.auditHandleInvoiceRepository.updateBatchById(auditHandleInvoiceUpdates);
        }
    }

    private AuditHandleVo reimburseUpAccountAll(List<AuditHandleDetailVo> reimburseUpAccountList, List<AuditHandleInvoice> auditHandleInvoices, AuditHandleVo auditHandleVo) {
        int invoiceNum = auditHandleVo.getAppendices();
        String[] split = auditHandleVo.getAuditHandleCode().split("-");
        String auditHandleCode = split[1];
        Integer accId = 1;
        if (this.redisTemplate.hasKey((Object)"AUDIT:HANDLE:ACC_ID").booleanValue()) {
            Object o = this.redisTemplate.opsForValue().get((Object)"AUDIT:HANDLE:ACC_ID");
            accId = (Integer)o;
            accId = accId + 1;
            this.redisTemplate.opsForValue().set((Object)"AUDIT:HANDLE:ACC_ID", (Object)accId);
        } else {
            this.redisTemplate.opsForValue().set((Object)"AUDIT:HANDLE:ACC_ID", (Object)accId);
        }
        auditHandleVo.setAccId(Integer.toString(accId));
        boolean isSpecial = false;
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(auditHandleInvoices), (String)"\u53d1\u7968\u4e0d\u80fd\u4f4d\u7a7a", (Object[])new Object[0]);
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("tpm_audit_invoice_type");
        Map dictDataVoMap = dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        DictDataVo dictDataVo = (DictDataVo)dictDataVoMap.get(auditHandleInvoices.get(0).getInvoiceType());
        if (dictDataVo != null) {
            Map extendMap = dictDataVo.getExtendMap();
            String ext1 = (String)extendMap.get("ext1");
            isSpecial = YesOrNoEnum.YES.getCode().equals(ext1);
        }
        BigDecimal reimburseTaxAmount = reimburseUpAccountList.stream().map(AuditHandleDetailVo::getThisAuditAmountTax).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        AbstractCrmUserIdentity user = this.loginUserService.getAbstractLoginUser();
        CustomerVo customerVo = new CustomerVo();
        if (StringUtils.isNotEmpty((CharSequence)reimburseUpAccountList.get(0).getCustomerCode())) {
            customerVo = this.customerVoService.findDetailsByIdOrCode(null, reimburseUpAccountList.get(0).getLongCustomerCode());
        }
        AccountingVoucherDto accountingVoucherDto = new AccountingVoucherDto();
        AccountingVoucherDto.ItData itData = new AccountingVoucherDto.ItData();
        accountingVoucherDto.setIT_DATA(itData);
        ArrayList<Object> itemList = new ArrayList<Object>();
        AccountingVoucherDto.ItData.Item item1 = new AccountingVoucherDto.ItData.Item();
        item1.setACC_ID(auditHandleVo.getAccId());
        item1.setTPID(auditHandleCode);
        item1.setOBJECT_ID(auditHandleCode);
        item1.setBUKRS(auditHandleVo.getCompanyCode());
        item1.setINVOCE_NUM(String.valueOf(invoiceNum));
        item1.setUSNAM(user.getAccount());
        item1.setFLH("1");
        item1.setBSCHL("40");
        item1.setSAKNR(reimburseUpAccountList.get(0).getReimburseItemCode());
        item1.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).toPlainString());
        item1.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
        item1.setKOSTL(reimburseUpAccountList.get(0).getCostCenterCode());
        item1.setSALESOFFICE(customerVo.getSalesRegionErpCode());
        item1.setSALESGROUP(customerVo.getSalesOrgErpCode());
        item1.setKUNNR(customerVo.getErpCode());
        itemList.add(item1);
        if (isSpecial) {
            BigDecimal invoiceTaxAmount = auditHandleInvoices.stream().map(AuditHandleInvoice::getInvoiceTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            boolean changeFlag = false;
            if (reimburseTaxAmount.compareTo(invoiceTaxAmount) != 0) {
                changeFlag = true;
            }
            BigDecimal invoiceTaxAmount2 = BigDecimal.ZERO;
            BigDecimal changeAmount = BigDecimal.ZERO;
            for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices) {
                AccountingVoucherDto.ItData.Item item3 = new AccountingVoucherDto.ItData.Item();
                item3.setACC_ID(auditHandleVo.getAccId());
                item3.setTPID(auditHandleCode);
                item3.setOBJECT_ID(auditHandleCode);
                item3.setBUKRS(auditHandleVo.getCompanyCode());
                item3.setINVOCE_NUM(String.valueOf(invoiceNum));
                item3.setINVOICE_NO(auditHandleInvoice.getInvoiceNumber());
                item3.setUSNAM(user.getAccount());
                item3.setFLH("2");
                item3.setBSCHL("40");
                item3.setSAKNR(auditHandleInvoice.getTaxSubject());
                item3.setAMOUNT(auditHandleInvoice.getTaxAmount().setScale(2, RoundingMode.HALF_UP).toPlainString());
                invoiceTaxAmount2 = invoiceTaxAmount2.add(auditHandleInvoice.getTaxAmount().setScale(2, RoundingMode.HALF_UP));
                item3.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
                itemList.add(item3);
            }
            if (changeFlag) {
                auditHandleInvoices = auditHandleInvoices.stream().sorted(Comparator.comparing(AuditHandleInvoice::getTaxRate).thenComparing(AuditHandleInvoice::getTaxAmount).reversed()).collect(Collectors.toList());
                AccountingVoucherDto.ItData.Item item6 = new AccountingVoucherDto.ItData.Item();
                item6.setACC_ID(auditHandleVo.getAccId());
                item6.setTPID(auditHandleCode);
                item6.setOBJECT_ID(auditHandleCode);
                item6.setBUKRS(auditHandleVo.getCompanyCode());
                item6.setINVOCE_NUM(String.valueOf(invoiceNum));
                item6.setUSNAM(user.getAccount());
                item6.setFLH("2");
                item6.setBSCHL("50");
                item6.setSAKNR("2221010701");
                BigDecimal changeTaxAmount = invoiceTaxAmount.subtract(reimburseTaxAmount);
                for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices) {
                    if (changeTaxAmount.compareTo(auditHandleInvoice.getInvoiceTaxAmount()) > 0) {
                        changeTaxAmount = changeTaxAmount.subtract(auditHandleInvoice.getInvoiceTaxAmount());
                        changeAmount = changeAmount.add(auditHandleInvoice.getTaxAmount());
                        auditHandleInvoice.setChangeAmount(auditHandleInvoice.getTaxAmount());
                        continue;
                    }
                    BigDecimal thisChangeAmount = changeTaxAmount.divide(new BigDecimal(auditHandleInvoice.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.UP).add(BigDecimal.ONE), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(auditHandleInvoice.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.UP));
                    changeAmount = changeAmount.add(thisChangeAmount);
                    auditHandleInvoice.setChangeAmount(thisChangeAmount);
                    break;
                }
                item6.setAMOUNT(changeAmount.setScale(2, RoundingMode.HALF_UP).negate().toPlainString());
                item6.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
                itemList.add(item6);
            }
            if (changeFlag) {
                item1.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).add(changeAmount).subtract(invoiceTaxAmount2).setScale(2, RoundingMode.HALF_UP).toPlainString());
            } else {
                item1.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).subtract(invoiceTaxAmount2).setScale(2, RoundingMode.HALF_UP).toPlainString());
            }
        }
        AccountingVoucherDto.ItData.Item item2 = new AccountingVoucherDto.ItData.Item();
        item2.setACC_ID(auditHandleVo.getAccId());
        item2.setTPID(auditHandleCode);
        item2.setOBJECT_ID(auditHandleCode);
        item2.setBUKRS(auditHandleVo.getCompanyCode());
        item2.setINVOCE_NUM(String.valueOf(invoiceNum));
        item2.setUSNAM(user.getAccount());
        item2.setFLH("3");
        item2.setBSCHL("11");
        item2.setKUNNR(customerVo.getErpCode());
        item2.setSALESOFFICE(customerVo.getSalesRegionErpCode());
        item2.setSALESGROUP(customerVo.getSalesOrgErpCode());
        item2.setSAKNR(null);
        item2.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).negate().toPlainString());
        item2.setPRCTR(reimburseUpAccountList.get(0).getProfitCenterCode());
        item2.setKOSTL(null);
        item2.setSALESOFFICE(customerVo.getSalesRegionErpCode());
        item2.setSALESGROUP(customerVo.getSalesOrgErpCode());
        BigDecimal individualIncomeTax = reimburseUpAccountList.stream().map(AuditHandleDetailVo::getPersonalTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        itemList.add(item2);
        itData.setItem(itemList);
        SapAccountingVoucherVo sapAccountingVoucherVo = this.sapFiService.pushSapAccountingVoucher(accountingVoucherDto);
        String message = null;
        AuditHandleVo auditHandleVo1 = new AuditHandleVo();
        auditHandleVo1.setId(auditHandleVo.getId());
        if (Objects.nonNull(sapAccountingVoucherVo)) {
            if (Objects.nonNull(sapAccountingVoucherVo.getET_BELNR()) && CollectionUtils.isNotEmpty((Collection)sapAccountingVoucherVo.getET_BELNR().getItem())) {
                for (SapAccountingVoucherVo.EtBelnr.Item item : sapAccountingVoucherVo.getET_BELNR().getItem()) {
                    auditHandleVo1.setBelnr(item.getBELNR());
                    auditHandleVo1.setBukrs(item.getBUKRS());
                    auditHandleVo1.setGjahr(item.getGJAHR());
                }
            }
            if (Objects.nonNull(sapAccountingVoucherVo.getET_MESSAGE()) && CollectionUtils.isNotEmpty((Collection)sapAccountingVoucherVo.getET_MESSAGE().getItem())) {
                for (SapAccountingVoucherVo.EtBelnr.Item item : sapAccountingVoucherVo.getET_MESSAGE().getItem()) {
                    if (!SuccessAndFailEnum.FAIL.getCode().equals(item.getTYPE())) continue;
                    message = item.getMESSAGE() + "||" + message;
                }
                if (StringUtils.isNotEmpty(message)) {
                    auditHandleVo1.setUpAccountStatusReimburse(UpAccountStatusEnum.COMMIT_FAIL.getCode());
                    auditHandleVo1.setUpAccountMessageReimburse(message);
                } else {
                    auditHandleVo1.setUpAccountStatusReimburse(UpAccountStatusEnum.COMMIT_SUCCESS.getCode());
                    auditHandleVo1.setUpAccountMessageReimburse(UpAccountStatusEnum.COMMIT_SUCCESS.getDesc());
                }
            }
        }
        return auditHandleVo1;
    }

    public Map<Integer, String> auditHandleImportSave(LinkedHashMap<Integer, AuditHandleImportVo> data, Map<String, Object> params) {
        String businessCode = this.getBusinessUnitCode(params);
        String cacheKey = this.getCacheKey(params);
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        cacheKey = "AUDIT_HANDLE:CACHE:" + cacheKey;
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
        this.auditHandleImportValidation(data);
        this.detailImportCacheSave(data, cacheKey);
        return errorMap;
    }

    public void createOrUpdateBatchImport(Collection<AuditHandleImportVo> importVos) {
        Validate.notEmpty(importVos, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public void upAccountBatch(List<String> ids) {
        List<AuditHandleVo> handleVos = this.findByIds(ids);
        block4: for (AuditHandleVo handleVo : handleVos) {
            Validate.isTrue((boolean)ProcessStatusEnum.PASS.getDictCode().equals(handleVo.getProcessStatus()), (String)"\u4e0a\u8d26\u5355\u53f7\u3010%s\u3011\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u6838\u9500\u5355\u4e0d\u5141\u8bb8\u4e0a\u8d26", (Object[])new Object[]{handleVo.getAuditHandleCode()});
            AuditHandleDetailVo auditHandleDetailVo = (AuditHandleDetailVo)handleVo.getAuditHandleDetailVoList().get(0);
            if (EndCaseFormEnum.DISCOUNT.getCode().equals(auditHandleDetailVo.getEndCaseForm())) {
                Validate.isTrue((UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode().equals(auditHandleDetailVo.getUpAccountStatus()) || UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(auditHandleDetailVo.getUpAccountStatus()) ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u5355\u53f7\u3010%s\u3011\u72b6\u6001\u7684\u5305\u542b\u4e0d\u5141\u8bb8\u4e0a\u8d26\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{handleVo.getAuditHandleCode()});
            }
            if (EndCaseFormEnum.REIMBURSE.getCode().equals(auditHandleDetailVo.getEndCaseForm())) {
                Validate.isTrue((UpAccountStatusEnum.WAIT_UP_ACCOUNT.getCode().equals(handleVo.getUpAccountStatusReimburse()) || UpAccountStatusEnum.COMMIT_FAIL.getCode().equals(handleVo.getUpAccountStatusReimburse()) ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u5355\u53f7\u3010%s\u3011\u72b6\u6001\u7684\u5305\u542b\u4e0d\u5141\u8bb8\u4e0a\u8d26\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{handleVo.getAuditHandleCode()});
            }
            BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum((String)handleVo.getBusinessUnitCode());
            switch (businessUnitEnum) {
                case HEADQUARTERS: {
                    this.headquartersUpAccount(handleVo);
                    continue block4;
                }
                case SON_COMPANY: {
                    this.sonCompanyUpAccount(handleVo);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u5355\u5143\u7c7b\u578b\u3010" + businessUnitEnum + "\u3011");
        }
    }

    public Page<AuditHandleDetailVo> findByConditions(Pageable pageable, AuditHandleDetailDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditHandleDetailDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<AuditHandleDetailVo> page = this.auditHandleDetailRepository.findByConditions(pageable, dto);
        List records = page.getRecords();
        this.fillData(records);
        return page;
    }

    public void updateAppendicesByAuditHandleCode(Integer appendices, String auditHandleCode) {
        if (StringUtils.isEmpty((CharSequence)auditHandleCode)) {
            return;
        }
        if (Objects.isNull(appendices)) {
            return;
        }
        this.auditHandleRepository.updateAppendicesByAuditHandleCode(appendices, auditHandleCode);
    }

    public void reimburseChargeAgainst(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<AuditHandle> auditHandleList = this.auditHandleRepository.findByIds(ids);
        List auditHandleDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleList, AuditHandle.class, AuditHandleDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditHandleDtos.forEach(item -> Validate.isTrue((ProcessStatusEnum.PASS.getDictCode().equals(item.getProcessStatus()) && UpAccountStatusEnum.COMMIT_SUCCESS.getCode().equals(item.getUpAccountStatusReimburse()) ? 1 : 0) != 0, (String)("\u624b\u52a8\u4e0a\u8d26\u7f16\u7801" + item.getAuditHandleCode() + "\u4e0d\u80fd\u51b2\u9500"), (Object[])new Object[0]));
        this.doChargeAgainst(auditHandleDtos);
    }

    public List<AuditPrintVo> batchPrint(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<AuditHandle> auditHandles = this.auditHandleRepository.findByIds(ids);
        List auditHandleVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandles, AuditHandle.class, AuditHandleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<String> auditHandleCodes = auditHandleVos.stream().map(AuditHandleVo::getAuditHandleCode).collect(Collectors.toList());
        List<AuditHandleDetail> auditHandleDetailList = this.auditHandleDetailRepository.findByAuditHandleCodes(auditHandleCodes);
        List auditHandleDetailVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditHandleDetailList, AuditHandleDetail.class, AuditHandleDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Map auditHandleDetailVoMap = auditHandleDetailVos.stream().collect(Collectors.toMap(AuditHandleDetailVo::getAuditHandleCode, Function.identity()));
        ArrayList<AuditPrintVo> auditPrintVos = new ArrayList<AuditPrintVo>();
        for (AuditHandleVo auditHandleVo : auditHandleVos) {
            AuditHandleDetailVo auditHandleDetailVo = (AuditHandleDetailVo)auditHandleDetailVoMap.get(auditHandleVo.getAuditHandleCode());
            AuditPrintVo auditPrintVo = new AuditPrintVo();
            this.buildHeadInfo(auditPrintVo, auditHandleVo, auditHandleDetailVo);
            HashSet<String> auditCodes = new HashSet<String>();
            auditCodes.add(auditHandleVo.getAuditHandleCode());
            this.getPaymentReceiptShould(auditCodes, auditPrintVo);
            auditPrintVos.add(auditPrintVo);
        }
        return auditPrintVos;
    }

    private void getPaymentReceiptShould(Set<String> auditCodes, AuditPrintVo auditPrintVo) {
        List paymentReceiptShouldVos = this.paymentReceiptSdkService.findPaymentReceiptShouldByAuditCode(auditCodes);
        if (CollectionUtils.isNotEmpty((Collection)paymentReceiptShouldVos)) {
            auditPrintVo.setPaymentReceiptShouldVos((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)paymentReceiptShouldVos, PaymentReceiptShouldVo.class, PaymentReceiptShouldSdkVo.class, HashSet.class, ArrayList.class, new String[0]));
            Set paymentReceiptCodes = paymentReceiptShouldVos.stream().map(PaymentReceiptShouldVo::getPaymentReceiptCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            List receiptPayVos = this.paymentReceiptSdkService.findByPaymentReceiptCodes(paymentReceiptCodes);
            if (CollectionUtils.isNotEmpty((Collection)receiptPayVos)) {
                auditPrintVo.setReceiptPayVos((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)receiptPayVos, PaymentReceiptPayVo.class, PaymentReceiptPaySdkVo.class, HashSet.class, ArrayList.class, new String[0]));
            }
        }
    }

    private void buildHeadInfo(AuditPrintVo auditPrintVo, AuditHandleVo auditHandleVo, AuditHandleDetailVo auditHandleDetailVo) {
        String preparedBy;
        String belnr = auditHandleVo.getBelnr();
        String gjahr = auditHandleVo.getGjahr();
        String companyCode = auditHandleVo.getCompanyCode();
        BeanUtils.copyProperties((Object)auditHandleVo, (Object)auditPrintVo);
        auditPrintVo.setFiscalYear(gjahr);
        Date date = auditHandleVo.getCreateTime();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int month = localDate.getMonthValue();
        auditPrintVo.setPeriod(String.valueOf(month));
        String documentCode = (StringUtils.isNotBlank((CharSequence)belnr) ? belnr : "") + (StringUtils.isNotBlank((CharSequence)companyCode) ? companyCode : "") + (StringUtils.isNotBlank((CharSequence)gjahr) ? gjahr : "");
        auditPrintVo.setDocumentCode(documentCode);
        auditPrintVo.setCertificateCode(belnr);
        auditPrintVo.setCertificateTitleText(auditHandleDetailVo.getCostCenterName());
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        if (Objects.nonNull(loginDetails)) {
            auditPrintVo.setPreparedBy(auditHandleVo.getCreateAccount() + "-" + auditHandleVo.getCreateName());
        }
        if (StringUtils.isBlank((CharSequence)(preparedBy = auditPrintVo.getPreparedBy())) || preparedBy.contains("admin")) {
            auditPrintVo.setPreparedBy(auditHandleVo.getModifyAccount() + "-" + auditHandleVo.getModifyName());
        }
        auditPrintVo.setAppendices(auditHandleVo.getAppendices());
        auditPrintVo.setReference(auditHandleVo.getAuditHandleCode());
        auditPrintVo.setPaymentReference(auditHandleDetailVo.getCustomerCode());
        try {
            auditPrintVo.setBarCode(Base64.getEncoder().encodeToString(documentCode.getBytes("utf-8")));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        auditPrintVo.setCustomerSupplierName(auditHandleDetailVo.getCustomerName());
        auditPrintVo.setReimburseItem(auditHandleDetailVo.getReimburseItemName());
        auditPrintVo.setThisEndCaseTaxTotalAmount(auditHandleDetailVo.getThisAuditAmountTax());
        auditPrintVo.setReimburseTaxRate(Optional.ofNullable(auditHandleDetailVo.getDiscountTaxRate()).orElse(BigDecimal.ZERO).toPlainString());
        auditPrintVo.setAuditTaxTotalAmount(auditHandleDetailVo.getThisAuditAmountTax());
        auditPrintVo.setTaxTotalAmount(auditHandleDetailVo.getTaxAmount());
        auditPrintVo.setAuditTotalAmount(auditHandleDetailVo.getThisAuditAmountNotTax());
    }

    private void doChargeAgainst(List<AuditHandleDto> auditHandleList) {
        AuditHandleSdkServiceImpl bean = (AuditHandleSdkServiceImpl)this.applicationContext.getBean(AuditHandleSdkServiceImpl.class);
        for (AuditHandleDto auditHandle : auditHandleList) {
            bean.chargeAgainstOne(auditHandle);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void chargeAgainstOne(AuditHandleDto auditHandle) {
        this.pushSap(auditHandle);
        this.clearInvoice(auditHandle.getAuditHandleCode());
        this.useBudget(Collections.singletonList(auditHandle), AuditUseBudgetTypeEnum.RETURN);
    }

    private void pushSap(AuditHandleDto auditHandle) {
        ChargeAgainstAccountingVoucherDto chargeAgainstAccountingVoucherDto = new ChargeAgainstAccountingVoucherDto();
        ChargeAgainstAccountingVoucherDto.ItData itData = new ChargeAgainstAccountingVoucherDto.ItData();
        ArrayList<ChargeAgainstAccountingVoucherDto.ItData.Item> itemList = new ArrayList<ChargeAgainstAccountingVoucherDto.ItData.Item>();
        ChargeAgainstAccountingVoucherDto.ItData.Item item = new ChargeAgainstAccountingVoucherDto.ItData.Item();
        String[] split = auditHandle.getAuditHandleCode().split("-");
        item.setTPID(split[1]);
        item.setOBJECT_ID(split[1]);
        item.setBELNR(auditHandle.getBelnr());
        item.setBUKRS(auditHandle.getBukrs());
        item.setGJAHR(auditHandle.getGjahr());
        itemList.add(item);
        itData.setItem(itemList);
        chargeAgainstAccountingVoucherDto.setIT_DATA(itData);
        ChargeAgainstAccountingVoucherVo chargeAgainstAccountingVoucherVo = this.sapCenterService.pushSapChargeAgainstAccountingVoucher(chargeAgainstAccountingVoucherDto);
        String message = null;
        AuditHandle auditHandle1 = new AuditHandle();
        auditHandle1.setId(auditHandle.getId());
        if (Objects.nonNull(chargeAgainstAccountingVoucherVo)) {
            if (Objects.nonNull(chargeAgainstAccountingVoucherVo.getET_BELNR()) && CollectionUtils.isNotEmpty((Collection)chargeAgainstAccountingVoucherVo.getET_BELNR().getItem())) {
                for (ChargeAgainstAccountingVoucherVo.EtBelnr.Item item2 : chargeAgainstAccountingVoucherVo.getET_BELNR().getItem()) {
                    auditHandle1.setBelnr2(item2.getBELNR());
                    auditHandle1.setBukrs2(item2.getBUKRS());
                    auditHandle1.setGjahr2(item2.getGJAHR());
                    auditHandle1.setUpAccountStatusReimburse(UpAccountStatusEnum.WRITE_OFF.getCode());
                }
            }
            if (Objects.nonNull(chargeAgainstAccountingVoucherVo.getET_MESSAGE()) && CollectionUtils.isNotEmpty((Collection)chargeAgainstAccountingVoucherVo.getET_MESSAGE().getItem())) {
                for (ChargeAgainstAccountingVoucherVo.EtBelnr.Item item2 : chargeAgainstAccountingVoucherVo.getET_MESSAGE().getItem()) {
                    if (!SuccessAndFailEnum.FAIL.getCode().equals(item2.getTYPE())) continue;
                    message = item2.getMESSAGE() + "||" + message;
                }
                if (StringUtils.isNotEmpty(message)) {
                    throw new RuntimeException(message);
                }
            }
        }
        this.auditHandleRepository.updateById((Object)auditHandle1);
    }

    private void clearInvoice(String auditHandleCode) {
        if (StringUtils.isEmpty((CharSequence)auditHandleCode)) {
            return;
        }
        List<AuditHandleInvoice> auditHandleInvoiceList = this.auditHandleInvoiceRepository.findByAuditHandleCode(auditHandleCode);
        this.auditHandleInvoiceRepository.updateDelStatusByAuditHandleCode(auditHandleCode);
        ArrayList<AuditInvoiceManageDto> auditInvoiceManageDtoList = new ArrayList<AuditInvoiceManageDto>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoiceList) {
            AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
            auditInvoiceManageDto.setInvoiceNo(auditHandleInvoice.getInvoiceNumber());
            auditInvoiceManageDto.setInvoiceCode(auditHandleInvoice.getInvoiceCode());
            auditInvoiceManageDtoList.add(auditInvoiceManageDto);
        }
        this.auditInvoiceManageService.updateByNoAndCode(auditInvoiceManageDtoList, YesOrNoEnum.NO.getCode(), df.format(new Date()));
    }

    private void fillData(List<AuditHandleDetailVo> records) {
        List<String> auditHandleCodes = records.stream().map(AuditHandleDetailVo::getAuditHandleCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(auditHandleCodes)) {
            List<AuditHandleInvoice> auditHandleInvoices = this.auditHandleInvoiceRepository.findByAuditHandleCodes(auditHandleCodes);
            Map<Object, Object> auditHandleInvoicesMap = new HashMap();
            if (CollectionUtils.isNotEmpty(auditHandleInvoices)) {
                auditHandleInvoicesMap = auditHandleInvoices.stream().collect(Collectors.groupingBy(AuditHandleInvoice::getAuditHandleCode));
            }
            for (AuditHandleDetailVo record : records) {
                List auditHandleInvoices2 = (List)auditHandleInvoicesMap.get(record.getAuditHandleCode());
                if (!CollectionUtils.isNotEmpty((Collection)auditHandleInvoices2)) continue;
                String invoiceCode = null;
                String invoiceNumber = null;
                for (AuditHandleInvoice auditHandleInvoice : auditHandleInvoices2) {
                    String invoiceCode2 = auditHandleInvoice.getInvoiceCode();
                    String invoiceNumber2 = auditHandleInvoice.getInvoiceNumber();
                    if (!StringUtils.isNotEmpty((CharSequence)invoiceNumber2)) continue;
                    if (StringUtils.isEmpty((CharSequence)invoiceCode2)) {
                        invoiceCode2 = "0";
                    }
                    invoiceCode = StringUtils.isEmpty(invoiceCode) ? invoiceCode2 : invoiceCode + "," + invoiceCode2;
                    if (StringUtils.isEmpty(invoiceNumber)) {
                        invoiceNumber = invoiceNumber + "," + invoiceNumber2;
                        continue;
                    }
                    invoiceNumber = invoiceNumber2;
                }
                record.setInvoiceCode(invoiceCode);
                record.setInvoiceNumber(invoiceNumber);
            }
        }
    }

    private Map<String, String> getBusinessFormatDict() {
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        if (CollectionUtils.isEmpty((Collection)dictDataVoList)) {
            return Maps.newHashMap();
        }
        return dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
    }

    private void handleDetailData(AuditHandleDetail auditHandleDetail, AuditHandleImportVo e) {
        auditHandleDetail.setSalesOrgCode(e.getSalesOrgCode());
        auditHandleDetail.setSalesGroupCode(e.getSalesGroupCode());
        auditHandleDetail.setChannelCode(e.getChannelCode());
        auditHandleDetail.setCustomerCode(e.getCustomerCode());
        auditHandleDetail.setYearBudgetCode(e.getYearBudgetCode());
        auditHandleDetail.setActivityTypeCode(e.getActivityTypeCode());
        auditHandleDetail.setActivityFormCode(e.getActivityFormCode());
        auditHandleDetail.setProductBrandCode(e.getProductBrandCode());
        auditHandleDetail.setProductCode(e.getProductCode());
        auditHandleDetail.setEndCaseForm(e.getEndCaseForm());
        auditHandleDetail.setLookLikeSale(e.getLookLikeSale());
    }

    private void handleData(AuditHandle auditHandle, AuditHandleImportVo e) {
        auditHandle.setBusinessFormatCode(e.getBusinessFormatCode());
        auditHandle.setBusinessUnitCode(e.getBusinessUnitCode());
        auditHandle.setDepartmentCode(e.getDepartmentCode());
        auditHandle.setCompanyCode(e.getCompanyCode());
    }

    private String getBusinessUnitCode(Map<String, Object> params) {
        Object businessUnitCode = params.get("businessUnitCode");
        return (String)businessUnitCode;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        liquibase.util.Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58\u53ef\u4ee5\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    private void descToCode(LinkedHashMap<Integer, AuditHandleImportVo> data) {
        ArrayList dictTypeCodeList = Lists.newArrayList((Object[])new String[]{"mdm_business_format", "mdm_business_unit", "tpm_audit_form", "audit_form"});
        Map dictDataVoListMap = this.dictDataVoService.findByDictTypeCodeList((List)dictTypeCodeList);
    }

    private void auditHandleImportValidation(LinkedHashMap<Integer, AuditHandleImportVo> data) {
        data.forEach((index, o) -> {
            Validate.notBlank((CharSequence)o.getActivityTypeCode(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.notBlank((CharSequence)o.getActivityFormCode(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.notBlank((CharSequence)o.getProductBrandCode(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u54c1\u724c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.notBlank((CharSequence)o.getProductCategoryCode(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u54c1\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.notBlank((CharSequence)o.getProductItemCode(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u54c1\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.notBlank((CharSequence)o.getProductCode(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.notBlank((CharSequence)o.getProductName(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.notBlank((CharSequence)o.getCustomerCode(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.notBlank((CharSequence)o.getCustomerName(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
            Validate.notNull((Object)o.getThisAuditAmountTax(), (String)"\u7b2c\u3010%s\u3011\u884c\uff0c\u6570\u636e\u5bfc\u5165\u6570\u636e\u65f6\uff0c\u672c\u6b21\u7ed3\u6848\u91d1\u989d(\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{index});
        });
    }

    private void detailImportCacheSave(LinkedHashMap<Integer, AuditHandleImportVo> data, String cacheKey) {
        ArrayList importVos = (ArrayList)data.values();
        ArrayList auditHandleDetailVos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)importVos, AuditHandleImportVo.class, AuditHandleDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.redisTemplate.delete((Object)cacheKey);
        if (CollectionUtils.isNotEmpty((Collection)auditHandleDetailVos)) {
            auditHandleDetailVos.forEach(o -> o.setId(UUID.randomUUID().toString().replace("-", "")));
            this.redisTemplate.opsForList().rightPushAll((Object)cacheKey, auditHandleDetailVos.toArray());
            this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        }
    }

    public List<AuditHandleDetailVo> findListForReconciliation(AuditHandleDetailDto handleDetailDto) {
        if (Objects.isNull(handleDetailDto) || StringUtils.isBlank((CharSequence)handleDetailDto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)handleDetailDto.getBusinessUnitCode()) || StringUtils.isBlank((CharSequence)handleDetailDto.getCustomerCode()) || Objects.isNull(handleDetailDto.getActivityBeginDate()) || Objects.isNull(handleDetailDto.getActivityEndDate())) {
            return Lists.newArrayList();
        }
        List<AuditHandleDetailVo> list = this.auditHandleDetailRepository.findListForReconciliation(handleDetailDto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public List<String> auditHandleCustomerList(AuditHandleDetailDto handleDetailDto) {
        if (Objects.isNull(handleDetailDto) || StringUtils.isBlank((CharSequence)handleDetailDto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)handleDetailDto.getBusinessUnitCode()) || Objects.isNull(handleDetailDto.getActivityBeginDate()) || Objects.isNull(handleDetailDto.getActivityEndDate())) {
            return Lists.newArrayList();
        }
        List<String> list = this.auditHandleDetailRepository.auditHandleCustomerList(handleDetailDto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}

