package com.biz.crm.tpm.business.audit.handle.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:承接方式枚举
 * @Author qiancheng
 * @Date 2023/3/29
 */
public enum AcceptTypeEnum {

    FULL_ACCEPT("full_accept","完全承接"),

    PART_ACCEPT("part_accept","部分承接"),

    NO_ACCEPT("no_accept","不承接");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private AcceptTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        AcceptTypeEnum[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            AcceptTypeEnum acceptTypeEnum = var1[var3];
            codes.add(acceptTypeEnum.getCode());
        }

        return codes;
    }

    public static AcceptTypeEnum codeToEnum(String code) {
        AcceptTypeEnum acceptType = null;
        AcceptTypeEnum[] var2 = values();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            AcceptTypeEnum acceptTypeEnum = var2[var4];
            if (acceptTypeEnum.code.equals(code)) {
                acceptType = acceptTypeEnum;
            }
        }

        return acceptType;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            AcceptTypeEnum[] values = values();
            AcceptTypeEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                AcceptTypeEnum value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        } else {
            AcceptTypeEnum[] values = values();
            AcceptTypeEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                AcceptTypeEnum value = var2[var4];
                if (value.getCode().equals(code)) {
                    return true;
                }
            }

            return false;
        }
    }

}
