package com.biz.crm.tpm.business.audit.handle.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @ClassName AuditFormEnum
 * @Description 结案形式enum
 * @AUTHOR WangJJ
 * @DATE 2023/5/31 13:50
 **/
@AllArgsConstructor
@Getter
public enum AuditFormEnum {
    DISCOUNT("1","折扣"),
    REIMBURSE("2","报销"),
    RED_WORD_INVOICE("3","红字发票"),
    FOLLOW_DOCUMENT("4","随单"),
    ;

    private String code;
    private String desc;

    public static AuditFormEnum findEnumByCode(String code){
        AuditFormEnum[] enums = AuditFormEnum.values();
        for (AuditFormEnum anEnum : enums) {
            if (StringUtils.equals(anEnum.getCode(), code)){
                return anEnum;
            }
        }
        return null;
    }
}
