package com.biz.crm.tpm.business.audit.handle.sdk.enums;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/9 16:02
 * @description：结案形式
 */
public enum EndCaseFormEnum {

    DISCOUNT("1","折扣"),
    REIMBURSE("2","报销"),
    RED_INVOICE("3","红字发票"),
    WITH_ORDER("4","随单"),
    MILK_CARD("5","奶卡");

    @Getter
    private String code;

    @Getter
    private String value;
    EndCaseFormEnum(String code, String value){
        this.code = code;
        this.value = value;
    }

    public static String transitionStr(String endCaseForm) {
        endCaseForm = endCaseForm.replace("，",",");
        if(StringUtils.isNotEmpty(endCaseForm)){
            List<String> codes = new ArrayList<>();
            String[] split = endCaseForm.split(",");
            for (String s : split) {
                for (EndCaseFormEnum value : EndCaseFormEnum.values()) {
                    if(value.getValue().equals(s)){
                        codes.add(value.getCode());
                        break;
                    }
                }
            }
            if(CollectionUtils.isNotEmpty(codes)){
                return codes.stream().collect(Collectors.joining(","));
            }
        }
        return null;
    }

    public static String codeTransitionStr(String endCaseForm) {
        endCaseForm = endCaseForm.replace("，",",");
        if(StringUtils.isNotEmpty(endCaseForm)){
            List<String> codes = new ArrayList<>();
            String[] split = endCaseForm.split(",");
            for (String s : split) {
                for (EndCaseFormEnum value : EndCaseFormEnum.values()) {
                    if(value.getCode().equals(s)){
                        codes.add(value.getValue());
                        break;
                    }
                }
            }
            if(CollectionUtils.isNotEmpty(codes)){
                return codes.stream().collect(Collectors.joining(","));
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.printf(transitionStr("1,2"));
    }
}
