package com.biz.crm.tpm.business.audit.handle.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDto;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleProcessSubmitDto;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleImportVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleVo;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditPrintVo;
import org.springframework.data.domain.Pageable;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 手动上账 sdk service
 * @ClassName AuditHandleSdkService
 * @Description 手动上账 sdk service
 * @AUTHOR WangJJ
 * @DATE 2023/5/30 17:03
 **/
public interface AuditHandleSdkService {

    /**
     * 新增
     * @param dto
     * @return
     */
    AuditHandleVo create(AuditHandleDto dto);

    /**
     * 编辑
     * @param dto
     * @return
     */
    AuditHandleVo update(AuditHandleDto dto);

    /**
     * 删除（按核销单删除）
     * @param auditHandleCodes
     */
    void delete(List<String> auditHandleCodes);

    /**
     * 删除（按明细删除）
     * @param auditHandleDetailCodes
     */
    void deleteByDetailCodes(List<String> auditHandleDetailCodes);

    /**
     * 提交审批流
     * @param submitDto
     * @return
     */
    AuditHandleVo submitApprove(AuditHandleProcessSubmitDto submitDto);

    /**
     * 根据ID获取明细信息
     * @param id
     * @return
     */
    AuditHandleVo findById(String id);

    /**
     * 根据ID获取明细信息
     * @param auditHandleCode
     * @return
     */
    AuditHandleVo findByAuditHandleCode(String auditHandleCode);

    /**
     * 根据ID获取明细信息
     * @param ids
     * @return
     */
    List<AuditHandleVo> findByIds(List<String> ids);

    /**
     * 上账
     * @param ids
     */
    void upAccount(String body);

    /**
     * 手动上账导入保存
     * @param data
     * @return
     */
    Map<Integer, String> auditHandleImportSave(LinkedHashMap<Integer, AuditHandleImportVo> data, Map<String, Object> params);

    /**
     * 分子公司预算扣减
     */
    void sonCompanyBudgetDeduction(List<AuditHandleDto> auditHandles, Map<String, List<AuditHandleDetailDto>> auditHandleCodeMap);

    /**
     * 主体预算扣减
     */
    void headQuartersBudgetDeduction(List<AuditHandleDto> auditHandles, Map<String, List<AuditHandleDetailDto>> auditHandleCodeMap);

    /**
     * 折扣上账分子公司回调
     * @param dto
     */
    void sonCompanyDiscountCallBack(SonAuditCostPostingCallbackDto dto);

    /**
     * 折扣上账总公司回调
     * @param dto
     */
    void headquartersDiscountCallBack(AuditCostPostingCallbackDto dto);

    /**
     * 分页获取明细数据
     * @param pageable
     * @param auditDetailCode
     * @return
     */
    List<AuditHandleDetailVo> findDetailListByAuditHandleCode(String auditDetailCode);

    /**
     * 导入批量新增或编码
     * @param importVos
     */
    void createOrUpdateBatchImport(Collection<AuditHandleImportVo> importVos);

    /**
     * 批量上账
     * @param ids
     */
    void upAccountBatch(List<String> ids);

    /**
     * 分页查询
     * @param pageable
     * @param dto
     * @return
     */
    Page<AuditHandleDetailVo> findByConditions(Pageable pageable, AuditHandleDetailDto dto);

    /**
     * 更新附件张数量
     * @param appendices
     * @param auditHandleCode
     */
    void updateAppendicesByAuditHandleCode(Integer appendices, String auditHandleCode);

    /**
     * 主体结案对账单查询直接上账数据
     * @param handleDetailDto
     * @return
     */
    List<AuditHandleDetailVo> findListForReconciliation(AuditHandleDetailDto handleDetailDto);

    List<String> auditHandleCustomerList(AuditHandleDetailDto handleDetailDto);

    /**
     * 手动上账报销冲销
     * @param ids
     */
    void reimburseChargeAgainst(List<String> ids);

    /**
     * 打印
     * @param ids
     * @return
     */
    List<AuditPrintVo> batchPrint(List<String> ids);
}
