package com.biz.crm.tpm.business.audit.handle.sdk.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName AuditHandleDetail
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/29 18:56
 **/
@ApiModel(value = "AuditHandleDetailDto", description = "手动上账实体类")
@Data
public class AuditHandleDetailVo extends TenantFlagOpVo {

    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    @ApiModelProperty(name = "auditHandleCode", notes = "手动上账编码")
    private String auditHandleCode;

    @ApiModelProperty(name = "auditHandleName", notes = "手动上账名称（文件名称）")
    private String auditHandleName;

    @ApiModelProperty(name = "auditHandleDetailCode", notes = "手动上账明细编码")
    private String auditHandleDetailCode;

    @ApiModelProperty(name = "undertakingType", notes = "承接类型（分子）")
    private String undertakingType;

    @ApiModelProperty(name = "relationType", notes = "关联类型（分子）")
    private String relationType;

    @ApiModelProperty(name = "costManage", notes = "费用归口")
    private String costManage;

    @ApiModelProperty(name = "budgetCode", notes = "预算编码")
    private String budgetCode;

    @ApiModelProperty(name = "costYearMonth", notes = "费用年月")
    private String costYearMonth;

    @ApiModelProperty(name = "activityTypeCode", notes = "活动分类编码")
    private String activityTypeCode;

    @ApiModelProperty(name = "activityTypeName", notes = "活动分类名称")
    private String activityTypeName;

    @ApiModelProperty(name = "activityFormCode", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "productBrandCode", notes = "品牌编码")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName", notes = "品牌名称")
    private String productBrandName;

    @ApiModelProperty(name = "productCategoryCode", notes = "品类编码")
    private String productCategoryCode;

    @ApiModelProperty(name = "productCategoryName", notes = "品类名称")
    private String productCategoryName;

    @ApiModelProperty(name = "productItemCode", notes = "品项编码")
    private String productItemCode;

    @ApiModelProperty(name = "productItemName", notes = "品项名称")
    private String productItemName;

    @ApiModelProperty(name = "productCode", notes = "产品编码")
    private String productCode;

    @ApiModelProperty(name = "productName", notes = "产品名称")
    private String productName;

    @ApiModelProperty(name = "activityPrice", notes = "活动价（元）（分子）")
    private BigDecimal activityPrice;

    @ApiModelProperty(name = "productPrice", notes = "产品单价（元）（分子）")
    private BigDecimal productPrice;

    @ApiModelProperty(name = "impulseDifferenceProductCode", notes = "冲差产品编码（分子）")
    private String impulseDifferenceProductCode;

    @ApiModelProperty(name = "impulseDifferenceProductName", notes = "冲差产品名称（分子）")
    private String impulseDifferenceProductName;

    @ApiModelProperty(name = "unit", notes = "单位（分子）")
    private String unit;

    @ApiModelProperty(name = "quantity", notes = "数量（分子)")
    private Integer quantity;

    @ApiModelProperty(name = "factoryName", notes = "工厂名称（分子）")
    private String factoryName;

    @ApiModelProperty(name = "customerCode", notes = "客户编码(不拼接的)")
    private String customerCode;

    public String getLongCustomerCode(){
        return this.getCustomerCode()+this.getCompanyCode()+this.getChannelCode()+this.getBusinessFormatCode();
    }

    @ApiModelProperty(name = "customerName", notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "whetherDeductionFeePool", notes = "是否扣减费用池")
    private String whetherDeductionFeePool;

    @ApiModelProperty(name = "endCaseForm", notes = "结案形式")
    private String endCaseForm;

    @ApiModelProperty(name = "whetherWholeAudit", notes = "是否完全结案")
    private String whetherWholeAudit;

    @ApiModelProperty(name = "discountTaxRate", notes = "折扣税率")
    private BigDecimal discountTaxRate;

    @ApiModelProperty(name = "discountShouldHandleAmount", notes = "折扣应处理金额")
    private BigDecimal discountShouldHandleAmount;

    @ApiModelProperty(name = "discountDeductionTaxAmount", notes = "折扣扣税金额")
    private BigDecimal discountDeductionTaxAmount;

    @ApiModelProperty(name = "inFeePoolAmount", notes = "入费用池金额")
    private BigDecimal inFeePoolAmount;

    @ApiModelProperty(name = "invoiceCode", notes = "发票代码")
    private String invoiceCode;

    @ApiModelProperty(name = "invoiceNumber", notes = "发票号码")
    private String invoiceNumber;

    @ApiModelProperty(name = "reimburseItemCode", notes = "报销项目编码")
    private String reimburseItemCode;

    @ApiModelProperty(name = "reimburseTaxRate", notes = "报销税率(%)")
    private BigDecimal reimburseTaxRate;

    @ApiModelProperty(name = "reimburseAmountTax", notes = "报销金额(含税)")
    private BigDecimal reimburseAmountTax;

    @ApiModelProperty(name = "reimburseAmountNoTax", notes = "报销金额(未税)")
    private BigDecimal reimburseAmountNoTax;

    @ApiModelProperty(name = "taxAmount", notes = "税额")
    private BigDecimal taxAmount;

    @ApiModelProperty(name = "personalTaxAmount", notes = "个人所得税")
    private BigDecimal personalTaxAmount;

    @ApiModelProperty(name = "costCenterCode", notes = "成本中心编码")
    private String costCenterCode;

    @ApiModelProperty(name = "costCenterName", notes = "成本中心名称")
    private String costCenterName;

    @ApiModelProperty(name = "profitCenterCode", notes = "利润中心编码")
    private String profitCenterCode;

    @ApiModelProperty(name = "profitCenterName", notes = "利润中心名称")
    private String profitCenterName;

    @ApiModelProperty(name = "payMethod", notes = "付款方式（分子）")
    private String payMethod;

    @ApiModelProperty(name = "upAccountCode", notes = "上账编码")
    private String upAccountCode;

    @ApiModelProperty(name = "upAccountStatus", notes = "折扣上账状态")
    private String upAccountStatus;

    @ApiModelProperty(name = "upAccountStatusReimburse", notes = "报销上账状态")
    private String upAccountStatusReimburse;

    @ApiModelProperty(name = "upAccountMessage", notes = "上账信息")
    private String upAccountMessage;

    @ApiModelProperty(name = "orgCode", notes = "HR组织（分子）")
    private String orgCode;

    @ApiModelProperty(name = "relationDataCode", notes = "关联数据编码（分子）")
    private String relationDataCode;

    @ApiModelProperty(name = "relationDataCode", notes = "总部承担金额")
    private BigDecimal headquartersUndertakeAmount;

    @ApiModelProperty(name = "regionUndertakeAmount", notes = "大区承担金额")
    private BigDecimal regionUndertakeAmount;

    @ApiModelProperty(name = "供应商编码", notes = "供应商编码（分子）")
    private String supplierCode;

    @ApiModelProperty(name = "供应商名称（分子）", notes = "供应商名称")
    private String supplierName;

    @ApiModelProperty("客商类型（分子）")
    private String customerSupplierType;

    /**
     * 2023-07-27
     * 以下为新增字段
     */

    @ApiModelProperty(name = "销售部门编码", notes = "销售部门编码")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售部门名称", notes = "销售部门名称")
    private String salesOrgName;

    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    private String salesGroupCode;

    @ApiModelProperty(name = "salesGroupName",value = "销售组",notes = "销售组")
    private String salesGroupName;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @JSONField(format = "yyyy-MM")
    private Date feeYearMonth;

    @ApiModelProperty(name = "年度预算编码")
    private String yearBudgetCode;

    @ApiModelProperty(name = "年度预算名称")
    private String yearBudgetName;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date activityBeginDate;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date activityEndDate;

    @ApiModelProperty(value = "申请费用")
    private BigDecimal applyFee;

    @ApiModelProperty("其他扣款")
    private BigDecimal otherDeductAmount;

    @ApiModelProperty("扣税金")
    private BigDecimal deductTaxAmount;

    @ApiModelProperty("本次结案金额（未税）（本次实报费用）")
    private BigDecimal thisAuditAmountNotTax;

    @ApiModelProperty(name = "reimburseItemName", notes = "报销项目名称")
    private String reimburseItemName;

    @ApiModelProperty(name = "lookLikeSale", notes = "是否视同销售")
    private String lookLikeSale;

    @ApiModelProperty(name = "type", notes = "分类")
    private String type;

    @ApiModelProperty("本次结案金额（含税）（本次应报费用）")
    private BigDecimal thisAuditAmountTax;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("部门编码")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("公司编码")
    private String companyCode;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("附件数")
    private Integer appendices;
}
