package com.biz.crm.tpm.business.audit.handle.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @Author : dengwei
 * @Date :2023/9/22  18:27
 * @Description: TODO
 */
@Data
@CrmExcelImport
public class AuditHandleEditImportVo extends CrmExcelVo {
    @ApiModelProperty(name = "auditHandleCode", notes = "手动上账编码")
    @CrmExcelColumn(value = "*手动上账编码")
    private String auditHandleCode;

    @ApiModelProperty(name = "auditHandleDetailCode", notes = "手动上账明细编码")
    @CrmExcelColumn(value = "*手动上账明细编码")
    private String auditHandleDetailCode;

    @ApiModelProperty("业态")
    @CrmExcelColumn(value = "*业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    @CrmExcelColumn(value = "*业务单元")
    private String businessUnitCode;

    @ApiModelProperty("部门编码")
    @CrmExcelColumn(value = "*所属部门编码")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    @CrmExcelColumn(value = "所属部门名称")
    private String departmentName;

    @ApiModelProperty( notes = "公司编码")
    @CrmExcelColumn(value = "*公司编码")
    private	String	companyCode;

    @ApiModelProperty( notes = "公司名称")
    @CrmExcelColumn(value = "公司名称")
    private	String	companyName;

    /**
     * 以下为明细信息
     */

    @ApiModelProperty(name = "销售部门编码")
    @CrmExcelColumn(value = "*销售部门编码")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售部门名称")
    @CrmExcelColumn(value = "销售部门名称")
    private String salesOrgName;

    @ApiModelProperty(name = "salesGroupCode")
    @CrmExcelColumn(value = "销售组编码")
    private String salesGroupCode;

    @ApiModelProperty(name = "salesGroupName")
    @CrmExcelColumn(value = "销售组名称")
    private String salesGroupName;

    @ApiModelProperty("渠道编码")
    @CrmExcelColumn(value = "*渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    @CrmExcelColumn(value = "渠道名称")
    private String channelName;

    @ApiModelProperty(name = "*客户编码")
    @CrmExcelColumn(value = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "客户名称")
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    @ApiModelProperty("费用所属年月")
    @CrmExcelColumn(value = "*费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private String feeYearMonth;

    @ApiModelProperty(name = "年度预算编码")
    @CrmExcelColumn(value = "*年度预算编码")
    private String yearBudgetCode;

    @ApiModelProperty(name = "年度预算名称")
    @CrmExcelColumn(value = "*年度预算名称")
    private String yearBudgetName;

    @ApiModelProperty(name = "活动分类编码")
    @CrmExcelColumn(value = "*活动分类编码")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动分类名称")
    @CrmExcelColumn(value = "活动分类名称")
    private String activityTypeName;

    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "*活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty("品牌编码")
    @CrmExcelColumn(value = "*品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    @CrmExcelColumn(value = "品牌名称")
    private String productBrandName;

    @ApiModelProperty(value = "品类编码")
    @CrmExcelColumn(value = "品类编码")
    private String productCategoryCode;

    @ApiModelProperty(value = "品类名称")
    @CrmExcelColumn(value = "品类名称")
    private String productCategoryName;

    @ApiModelProperty(value = "品项编码")
    @CrmExcelColumn(value = "品项编码")
    private String productItemCode;

    @ApiModelProperty(value = "品项名称")
    @CrmExcelColumn(value = "品项名称")
    private String productItemName;

    @ApiModelProperty(value = "产品编码")
    @CrmExcelColumn(value = "*产品编码")
    private String productCode;

    @ApiModelProperty(value = "产品名称")
    @CrmExcelColumn(value = "产品名称")
    private String productName;


    @ApiModelProperty("活动开始时间")
    @CrmExcelColumn(value = "*活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String activityBeginDate;

    @ApiModelProperty("活动结束时间")
    @CrmExcelColumn(value = "*活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String activityEndDate;

    @ApiModelProperty(value = "申请费用")
    @CrmExcelColumn(value = "*申请费用")
    private String applyFee;

    @ApiModelProperty("*本次结案金额（含税）")
    @CrmExcelColumn(value = "*本次应报费用")
    private String thisAuditAmountTax;

    @ApiModelProperty("其他扣款")
    @CrmExcelColumn(value = "其他扣款")
    private String otherDeductAmount;

    @ApiModelProperty("扣税金")
    @CrmExcelColumn(value = "扣税金")
    private String deductTaxAmount;

    @ApiModelProperty("本次结案金额（未税）（本次实报费用）")
    @CrmExcelColumn(value = "*本次实报费用")
    private String thisAuditAmountNotTax;

    @ApiModelProperty("结案形式")
    @CrmExcelColumn(value = "结案形式")
    private String endCaseForm;

    @ApiModelProperty(name = "reimburseItemCode", notes = "报销项目编码")
    @CrmExcelColumn(value = "报销项目编码")
    private String reimburseItemCode;

    @ApiModelProperty(name = "reimburseItemName", notes = "报销项目名称")
    @CrmExcelColumn(value = "报销项目名称")
    private String reimburseItemName;

    @ApiModelProperty("成本中心编码")
    @CrmExcelColumn(value = "成本中心编码")
    private String costCenterCode;

    @ApiModelProperty("成本中心名称")
    @CrmExcelColumn(value = "成本中心名称")
    private String costCenterName;

    @ApiModelProperty("是否视同销售")
    @CrmExcelColumn(value = "*是否视同销售")
    private String lookLikeSale;

    @ApiModelProperty("备注")
    @CrmExcelColumn(value = "备注")
    private String remark;

    @ApiModelProperty("附单据张数（张）")
    @CrmExcelColumn(value = "附单据张数（张）")
    private String appendices;

    @ApiModelProperty("发票代码")
    @CrmExcelColumn(value = "发票代码")
    private String invoiceCode;

    @ApiModelProperty(name = "invoiceNumber", notes = "发票号码")
    @CrmExcelColumn(value = "发票号码")
    private String invoiceNumber;

    @ApiModelProperty(name = "auditHandleName", notes = "手动上账名称（文件名称）")
    @CrmExcelColumn(value = "文件名称")
    private String auditHandleName;

    @ApiModelProperty("分类")
    @CrmExcelColumn(value = "分类")
    private String type;
}
