package com.biz.crm.tpm.business.audit.handle.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName AuditHandle
 * @Description 手动上账dto
 * @AUTHOR WangJJ
 * @DATE 2023/5/29 15:41
 **/
@ApiModel(value = "AuditHandleVo", description = "手动上账dto")
@Data
public class AuditHandleVo extends TenantFlagOpVo {

    @ApiModelProperty("保存类型")
    private String saveType;

    @ApiModelProperty(name = "auditHandleCode", notes = "手动上账编码")
    private String auditHandleCode;

    @ApiModelProperty(name = "auditHandleName", notes = "手动上账名称（文件名称）")
    private String auditHandleName;

    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty("公司代码")
    private String companyCode;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("部门编码")
    private String departmentCode;

    @ApiModelProperty("本次结案金额汇总（含税）（本次应报费用之和）")
    private BigDecimal thisAuditAmountTotalTax;

    @ApiModelProperty("折扣应处理金额汇总")
    private BigDecimal discountShouldHandleAmountTotal;

    @ApiModelProperty("入费用池金额汇总")
    private BigDecimal feePoolAmountTotal;

    @ApiModelProperty("折扣扣税金额汇总")
    private BigDecimal discountTaxDeductionAmountTotal;

    @ApiModelProperty("报销金额汇总（含税）")
    private BigDecimal reimburseAmountTotalTax;

    @ApiModelProperty("报销金额汇总（未税）")
    private BigDecimal reimburseAmountTotalNoTax;

    @ApiModelProperty(name = "结案审批流程编码", notes = "结案审批流程编码")
    private String processNo;

    @ApiModelProperty(name = "结案审批流程编码", notes = "结案审批流程编码")
    private String processStatus;

    @ApiModelProperty(name = "upAccountStatusReimburse", notes = "报销上账状态")
    private String upAccountStatusReimburse;

    @ApiModelProperty(name = "upAccountMessageReimburse", notes = "报销上账信息")
    private String upAccountMessageReimburse;

    @ApiModelProperty(name = "accId", notes = "sap凭证标识")
    private String accId;

    @ApiModelProperty("公司代码")
    private String bukrs;

    @ApiModelProperty("会计凭证号")
    private String belnr;

    @ApiModelProperty("财年")
    private String gjahr;

    @ApiModelProperty("冲销公司代码")
    private String bukrs2;

    @ApiModelProperty("冲销会计凭证号")
    private String belnr2;

    @ApiModelProperty("冲销财年")
    private String gjahr2;

    @ApiModelProperty("本次结案金额汇总（未税）（本次实报费用之和）")
    private BigDecimal thisAuditAmountTotalNotTax;

    @ApiModelProperty("附件数")
    private Integer appendices;

    private List<AuditHandleDetailVo> auditHandleDetailVoList;

    @ApiModelProperty("审批时间")
    private Date processDate;
}
