package com.biz.crm.tpm.business.audit.handle.sdk.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author : dengwei
 * @Date :2023/11/14  19:10
 * @Description: 核销打印vo
 */
@Data
public class AuditPrintVo {

    @ApiModelProperty("公司代码")
    private String companyCode;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("会计年度")
    private String fiscalYear;

    @ApiModelProperty("期间")
    private String period;

    @ApiModelProperty("单据编码")
    private String documentCode;

    @ApiModelProperty("凭证编码")
    private String certificateCode;

    @ApiModelProperty("凭证抬头文本")
    private String certificateTitleText;

    @ApiModelProperty("制单人")
    private String preparedBy;

    @ApiModelProperty("附件数")
    private Integer appendices;

    @ApiModelProperty("参照")
    private String reference;

    @ApiModelProperty("付款参照")
    private String paymentReference;

    @ApiModelProperty("条码")
    private String barCode;

    @ApiModelProperty("客商名称")
    private String customerSupplierName;

    @ApiModelProperty("报销项目")
    private String reimburseItem;

    @ApiModelProperty("申报金额（本次结案金额）")
    private BigDecimal thisEndCaseTaxTotalAmount;

    @ApiModelProperty("税率")
    private String reimburseTaxRate;

    @ApiModelProperty("含税金额")
    private BigDecimal auditTaxTotalAmount;

    @ApiModelProperty("税金")
    private BigDecimal taxTotalAmount;

    @ApiModelProperty("不含税金额")
    private BigDecimal auditTotalAmount;

    @ApiModelProperty(name = "应付明细")
    List<PaymentReceiptShouldSdkVo> paymentReceiptShouldVos;

    @ApiModelProperty(name = "支付明细")
    List<PaymentReceiptPaySdkVo> receiptPayVos;
}
