/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.starter;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EntityScan(basePackages={"com.biz.crm.tpm.business.audit.local"})
@ComponentScan(basePackages={"com.biz.crm.tpm.business.audit"})
public class AuditLocalConfig {
    @Value(value="${tpm.thread.core-pool-size:4}")
    private Integer corePoolSize;
    @Value(value="${tpm.thread.max-pool-size:8}")
    private Integer maxPoolSize;
    @Value(value="${tpm.thread.keep-alive-seconds:120}")
    private Integer keepAliveSeconds;
    @Value(value="${tpm.thread.queue-capacity:512}")
    private Integer queueCapacity;

    @Bean(name={"auditServiceAsyncThread"})
    public Executor auditServiceAsyncThread() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize.intValue());
        executor.setMaxPoolSize(this.maxPoolSize.intValue());
        executor.setKeepAliveSeconds(this.keepAliveSeconds.intValue());
        executor.setQueueCapacity(this.queueCapacity.intValue());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

