/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.audit.local.service.AuditProcess;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import java.util.Collection;
import java.util.Objects;
import jodd.util.StringUtil;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="TPM_AUDIT_BPM_PROCESS_TOP${rocketmq.environment}", selectorExpression="TPM_AUDIT_BPM_PROCESS_TAG", consumerGroup="TPM_AUDIT_BPM_PROCESS_TAG${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class AuditProcessConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(AuditProcessConsumer.class);
    @Autowired(required=false)
    private AuditProcess auditProcess;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    protected Object handleMessage(MqMessageVo message) {
        log.info("=====>    \u6838\u9500\u5355\u5ba1\u6279\u540e\u56de\u8c03 mq message received  [{}]    <=====", com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSON((Object)message));
        try {
            ProcessStatusDto dto = (ProcessStatusDto)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.parseObject((String)message.getMsgBody(), ProcessStatusDto.class);
            log.info("=====>    \u6838\u9500\u5355\u5ba1\u6279\u540e\u56de\u8c03  [{}]    <=====", com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSON((Object)dto));
            if (Objects.isNull(dto)) {
                log.error("=====>    \u6838\u9500\u5355\u5ba1\u6279\u540e\u56de\u8c03  [{}]    <=====", com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSON((Object)dto));
                return "\u672a\u63a5\u6536\u5230\u5ba1\u6279\u4fe1\u606f!.";
            }
            if (CollectionUtils.isEmpty((Collection)dto.getBusinessNoList())) {
                log.error("=====>    \u6838\u9500\u5355\u5ba1\u6279\u540e\u56de\u8c03  [{}]    <=====", com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSON((Object)dto));
                return "\u672a\u63a5\u6536\u6838\u9500\u5355\u53f7\u4fe1\u606f!.";
            }
            if (StringUtil.isEmpty((CharSequence)dto.getProcessStatus())) {
                log.error("=====>    \u6838\u9500\u5355\u5ba1\u6279\u540e\u56de\u8c03\u4fe1\u606f  [{}]    <=====", com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSON((Object)dto));
                return "\u672a\u63a5\u6536\u5230\u5ba1\u6279\u72b6\u6001\u4fe1\u606f!.";
            }
            this.auditProcess.auditProcessComplete(dto, false);
            MqMessageVo closeRecordVo = new MqMessageVo();
            closeRecordVo.setTopic("TPM_AUDIT_BPM_PROCESS_TOP" + RocketMqUtil.mqEnvironment());
            closeRecordVo.setTag("TPM_AUDIT_UPDATE_CLOSE_RECORD");
            closeRecordVo.setMsgBody(JSON.toJSONString((Object)dto.getBusinessNoList()));
            this.rocketMqProducer.sendMqMsg(closeRecordVo, 10L);
        }
        catch (Exception e) {
            log.error("=====>    \u6838\u9500\u5355\u5ba1\u6279\u540e\u56de\u8c03\u4fe1\u606f  [{}]    <=====", com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSON((Object)message));
            log.error("", (Throwable)e);
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

