/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.audit.local.entity.Audit;
import com.biz.crm.tpm.business.audit.local.imports.CustomerAuditDetailColImportsProcess;
import com.biz.crm.tpm.business.audit.local.imports.CustomerAuditDetailImportsProcess;
import com.biz.crm.tpm.business.audit.local.service.AuditAsyncService;
import com.biz.crm.tpm.business.audit.local.service.AuditInvoiceService;
import com.biz.crm.tpm.business.audit.local.service.AuditProcess;
import com.biz.crm.tpm.business.audit.local.task.impl.AuditDetailSchedulingImp;
import com.biz.crm.tpm.business.audit.sdk.dto.ActivityDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditAutoConfigurationDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditBatchSubmitDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditBatchSubmitQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDetailLookDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditFindDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditOutDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditProductUpAccountDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditRedInvoiceProductDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditSupplierDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.QueryAuditInfoDto;
import com.biz.crm.tpm.business.audit.sdk.dto.QueryEndCaseInfoDto;
import com.biz.crm.tpm.business.audit.sdk.dto.SplitAuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditSdkService;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.ActivityDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditAutoConfigurationVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditDetailLookVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditEndCaseInfoVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceSdkVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditPayVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditPrintVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditProductUpAccountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSubmitAmountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSupplierDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSupplierMaterialFileVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditTotalReimburseTaxAmountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailColImportsVo;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailImportsVo;
import com.biz.crm.tpm.business.audit.sdk.vo.MobileAuditApprovedInfo1Vo;
import com.biz.crm.tpm.business.audit.sdk.vo.MobileAuditApprovedInfo2Vo;
import com.biz.crm.tpm.business.audit.sdk.vo.UpAccountAdjustVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/audit"})
@Api(tags={"\u6838\u9500\u4e3b\u8868"})
public class AuditController {
    private static final Logger log = LoggerFactory.getLogger(AuditController.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private AuditAsyncService auditAsyncService;
    @Autowired(required=false)
    private AuditSdkService auditSdkService;
    @Autowired(required=false)
    private CustomerAuditDetailColImportsProcess customerAuditDetailColImportsProcess;
    @Autowired(required=false)
    private AuditInvoiceService auditInvoiceService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private CustomerAuditDetailColImportsProcess auditDetailColImportsProcess;
    @Autowired
    private AuditProcess listener;
    @Autowired(required=false)
    private AuditDetailSchedulingImp detailSchedulingImp;
    @Autowired(required=false)
    private CustomerAuditDetailImportsProcess auditDetailImportsProcess;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<AuditVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="audit", value="\u6838\u9500\u4e3b\u8868") AuditDto audit) {
        try {
            Page page = this.auditService.findByConditions(pageable, audit);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findPageForOut"})
    public Result<Page<AuditVo>> findPageForOut(@ApiParam(name="pageable") @PageableDefault(value=10) Pageable pageable, AuditDto dto) {
        try {
            Page page = this.auditService.findPageForOut(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u7ed3\u6848\u6838\u9500\u5ba1\u6279\u4fe1\u606finfo1")
    @GetMapping(value={"mobileAuditApprovedInfo1"})
    public Result<Page<MobileAuditApprovedInfo1Vo>> mobileAuditApprovedInfo1(@ApiParam(name="pageable") @PageableDefault(value=10) Pageable pageable, AuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.mobileAuditApprovedInfo1(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u7ed3\u6848\u6838\u9500\u5ba1\u6279\u4fe1\u606f")
    @GetMapping(value={"mobileAuditApprovedInfo2"})
    public Result<MobileAuditApprovedInfo2Vo> mobileAuditApprovedInfo2(@RequestParam(value="processNo") String processNo) {
        try {
            return Result.ok((Object)this.auditService.mobileAuditApprovedInfo2(processNo));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u6838\u9500\u7f16\u7801\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{auditCode}"})
    public Result<AuditVo> findByAuditCode(@PathVariable @ApiParam(name="auditCode", value="\u6838\u9500\u7f16\u7801") String auditCode) {
        try {
            AuditVo audit = this.auditService.findByAuditCode(auditCode);
            return Result.ok((Object)audit);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6253\u5370\u4fe1\u606f")
    @GetMapping(value={"queryPrintInfo/{auditCode}"})
    public Result<AuditPrintVo> queryPrintInfo(@PathVariable(value="auditCode") @ApiParam(name="auditCode", value="\u6838\u9500\u7f16\u7801") String auditCode) {
        try {
            AuditPrintVo audit = this.auditService.queryPrintInfo(auditCode);
            return Result.ok((Object)audit);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u67e5\u8be2\u6253\u5370\u4fe1\u606f")
    @PostMapping(value={"queryPrintInfoList"})
    public Result<List<AuditPrintVo>> queryPrintInfoList(@RequestBody LinkedHashMap<String, String> map) {
        try {
            List auditList = this.auditService.queryPrintInfoList(map);
            return Result.ok((Object)auditList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<?> create(@ApiParam(name="audit", value="\u6838\u9500\u4e3b\u8868") @RequestBody AuditDto audit) {
        try {
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            this.auditAsyncService.create(audit, loginUser);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7269\u6599\u91c7\u8d2d\u5355\u53f7")
    @PostMapping(value={"findCacheMaterialPurchaseCode"})
    public Result<List<String>> findCacheMaterialPurchaseCode(@RequestBody AuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.findCacheMaterialPurchaseCode(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e-\u80fd\u529b\u4e2d\u5fc3")
    @PostMapping(value={"createForOut"})
    public Result<?> createForOut(@ApiParam(name="audit", value="\u6838\u9500\u4e3b\u8868") @RequestBody AuditOutDto audit) {
        try {
            this.auditService.createForOut(audit);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<?> update(@ApiParam(name="audit", value="\u6838\u9500\u4e3b\u8868") @RequestBody AuditDto audit) {
        String key = "AUDIT:UPDATE:" + audit.getAuditCode();
        boolean hasLock = false;
        try {
            hasLock = this.redisLockService.tryLock(key, TimeUnit.HOURS, 1L);
            if (!hasLock) {
                Result result = Result.error((String)"\u6838\u9500\u5355\u6b63\u5728\u66f4\u65b0\uff0c\u8bf7\u7a0d\u540e");
                return result;
            }
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            this.auditAsyncService.update(audit, loginUser);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (hasLock) {
                this.redisLockService.unlock(key);
            }
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.auditService.delete(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="deleteDetail")
    @DeleteMapping(value={"deleteDetail"})
    public Result<?> deleteDetail(@ApiParam(name="detailCodeList", value="\u660e\u7ec6\u7f16\u7801\u4e3b\u952e\u96c6\u5408") @RequestParam(value="detailCodeList") List<String> detailCodeList) {
        try {
            this.auditService.deleteDetail(detailCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6838\u9500\u5ba2\u6237\u5f52\u96c6\u660e\u7ec6")
    @GetMapping(value={"queryAuditCustomerDetailCollectionInfo"})
    public Result<Page<AuditCustomerDetailCollectionVo>> queryAuditCustomerDetailCollectionInfo(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditDto audit) {
        try {
            return Result.ok((Object)this.auditService.queryAuditCustomerDetailCollectionInfo(pageable, audit));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6838\u9500\u5ba2\u6237\u660e\u7ec6")
    @GetMapping(value={"queryAuditCustomerDetailInfo"})
    public Result<Page<AuditCustomerDetailVo>> queryAuditCustomerDetailInfo(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditDto audit) {
        try {
            return Result.ok((Object)this.auditService.queryAuditCustomerDetailInfo(pageable, audit));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5f52\u96c6\u5ba2\u6237\u6838\u9500\u660e\u7ec6")
    @PostMapping(value={"collectionAuditCustomerDetail"})
    public Result<?> collectionAuditCustomerDetail(@RequestBody AuditVo vo) {
        try {
            return Result.ok((String)this.auditService.collectionAuditCustomerDetail(vo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6e05\u695a\u6838\u9500\u660e\u7ec6\u7f13\u5b58")
    @PostMapping(value={"clearAuditDetailCache"})
    public Result<?> clearAuditDetailCache(@RequestBody AuditDto dto) {
        try {
            this.auditService.clearAuditDetailCache(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u5ba2\u6237\u6838\u9500\u660e\u7ec6")
    @PostMapping(value={"deleteCustomerDetail"})
    public Result<?> deleteCustomerDetail(@RequestBody AuditDto dto) {
        try {
            this.auditService.deleteCustomerDetail(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5ba2\u6237\u6838\u9500\u660e\u7ec6")
    @PostMapping(value={"changeCustomerAuditDetail"})
    public Result<?> changeCustomerAuditDetail(@RequestBody AuditDto dto) {
        try {
            log.info("\u4fee\u6539\u5ba2\u6237\u6838\u9500\u660e\u7ec6+++++++++++++++++++++++");
            this.auditService.changeCustomerAuditDetail(dto);
            log.info("\u4fee\u6539\u5ba2\u6237\u6838\u9500\u660e\u7ec6-----------------------");
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5ba2\u6237\u5f52\u96c6\u6838\u9500\u660e\u7ec6")
    @PostMapping(value={"changeCustomerAuditCollectionDetail"})
    public Result<?> changeCustomerAuditCollectionDetail(@RequestBody AuditDto dto) {
        try {
            this.auditService.changeCustomerAuditCollectionDetail(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u8ba1\u7b97\u62ac\u5934\u6570\u636e")
    @PostMapping(value={"queryCalculateHeaderData"})
    public Result<AuditVo> queryCalculateHeaderData(@RequestBody AuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.queryCalculateHeaderData(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"batchSubmitApproval"})
    public Result<?> batchSubmitApproval(@RequestBody AuditBatchSubmitDto dto) {
        try {
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            this.auditAsyncService.batchSubmitApproval(dto, loginUser);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u524d\u63a8\u9884\u7b97\u9884\u8b66\u63d0\u793a")
    @PostMapping(value={"batchSubmitApprovalWarning"})
    public Result<?> batchSubmitApprovalWarning(@RequestBody AuditDto dto) {
        try {
            return Result.ok((String)this.auditService.batchSubmitApprovalWarning(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findAuditApproval"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u83b7\u53d6\u5df2\u7ecf\u63d0\u4ea4\u7684\u7ed3\u6848\u6838\u9500\u4fe1\u606f")
    public Result<?> findAuditApproval(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u53f7") String processNo) {
        try {
            Page page = this.auditService.findAuditApproval(pageable, processNo);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u4f9b\u5e94\u5546\u7ed3\u6848\u660e\u7ec6")
    @PostMapping(value={"saveSupplierAuditDetail"})
    public Result<?> saveSupplierAuditDetail(@RequestBody AuditVo vo) {
        try {
            return Result.ok((String)this.auditService.saveSupplierAuditDetail(vo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6838\u9500\u4f9b\u5e94\u5546\u660e\u7ec6")
    @GetMapping(value={"queryAuditSupplierDetailInfo"})
    public Result<Page<AuditSupplierDetailVo>> queryAuditSupplierDetailInfo(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditDto audit) {
        try {
            return Result.ok((Object)this.auditService.queryAuditSupplierDetailInfo(pageable, audit));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u4f9b\u5e94\u5546\u6838\u9500\u660e\u7ec6")
    @PostMapping(value={"deleteSupplierDetail"})
    public Result<?> deleteSupplierDetail(@RequestBody AuditDto dto) {
        try {
            this.auditService.deleteSupplierDetail(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u4f9b\u5e94\u5546\u6838\u9500\u660e\u7ec6")
    @PostMapping(value={"changeSupplierAuditDetail"})
    public Result<?> changeSupplierAuditDetail(@RequestBody AuditDto dto) {
        try {
            this.auditService.changeSupplierAuditDetail(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6c47\u603b\u4f9b\u5e94\u5546\u4ed8\u6b3e\u4fe1\u606f")
    @PostMapping(value={"collectSupplierPayInfo"})
    public Result<List<AuditPayVo>> collectSupplierPayInfo(@RequestBody AuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.collectSupplierPayInfo(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4ed8\u6b3e\u65b9\u5f0f")
    @PostMapping(value={"batchChangePayWay"})
    public Result<?> batchChangePayWay(@RequestBody AuditDto dto) {
        try {
            this.auditService.batchChangePayWay(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6838\u9500\u8d44\u6599\u548c\u53d1\u7968\u4fdd\u5b58")
    @PostMapping(value={"auditInfoAndInvoiceSave"})
    public Result<?> auditInfoAndInvoiceSave(@RequestBody AuditDto dto) {
        try {
            this.auditService.auditInfoAndInvoiceSave(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u53d1\u7968")
    @GetMapping(value={"queryAuditInvoiceInfo"})
    public Result<Page<AuditInvoiceVo>> queryAuditInvoiceInfo(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditDto audit) {
        try {
            return Result.ok((Object)this.auditService.queryAuditInvoiceInfo(pageable, audit));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d1\u7968\u91d1\u989d\u6c47\u603b")
    @PostMapping(value={"getInvoiceTotalAmount"})
    public Result<Map<String, BigDecimal>> getInvoiceTotalAmount(@RequestBody AuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.getInvoiceTotalAmount(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d1\u7968\u76f8\u5173\u91d1\u989d\u6c47\u603b")
    @PostMapping(value={"getInvoiceAmountCollect"})
    public Result<AuditInvoiceSdkVo> getInvoiceAmountCollect(@RequestBody AuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.getInvoiceAmountCollect(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u6838\u9500\u660e\u7ec6code\u67e5\u8be2\u53d1\u7968\u548c\u6838\u9500\u4fe1\u606f")
    @PostMapping(value={"findByAuditDetailCodes"})
    public Result<AuditVo> findByAuditDetailCodes(@RequestBody AuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.findByAuditDetailCodes(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6838\u9500\u8d44\u6599")
    @PostMapping(value={"findAuditInfo"})
    public Result<AuditVo> findAuditInfo(@RequestBody QueryAuditInfoDto dto) {
        try {
            return Result.ok((Object)this.auditService.findAuditInfo(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u53d1\u7968")
    @PostMapping(value={"findAuditInfoData"})
    public Result<Page<AuditInvoiceVo>> findAuditInfoData(@PageableDefault(value=50) Pageable pageable, @RequestBody QueryAuditInfoDto dto) {
        try {
            return Result.ok((Object)this.auditService.findAuditInfoData(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d1\u7968\u7f13\u5b58copy")
    @GetMapping(value={"copyInvoiceCache"})
    public Result<?> copyInvoiceCache(@RequestParam(value="fromCacheKey") String fromCacheKey, @RequestParam(value="toCacheKey") String toCacheKey) {
        try {
            this.auditService.copyInvoiceCache(fromCacheKey, toCacheKey);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d1\u7968\u5173\u7cfb")
    @PostMapping(value={"findAuditData"})
    public Result<List<AuditInvoiceSdkVo>> findAuditInfoData(@RequestBody QueryAuditInfoDto dto) {
        try {
            return Result.ok((Object)this.auditService.findAuditData(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u6838\u9500\u8d44\u6599\u7f13\u5b58")
    @PostMapping(value={"saveAuditInfoCache"})
    public Result<?> saveAuditInfoCache(@RequestBody AuditDto dto) {
        try {
            this.auditService.saveAuditInfoCache(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u9644\u4ef6\u5f20\u6570")
    @GetMapping(value={"queryAppendices"})
    public Result<Integer> queryAppendices(@RequestParam(value="cacheKey") String cacheKey, @RequestParam(value="endCaseType", required=false) String endCaseType) {
        try {
            return Result.ok((Object)this.auditService.queryAppendices(cacheKey, endCaseType));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6838\u9500\u53d1\u7968\u4fdd\u5b58\u7f13\u5b58")
    @PostMapping(value={"saveAuditInvoiceCache"})
    public Result<?> saveAuditInvoiceCache(@RequestBody AuditDto auditDto) {
        try {
            this.auditService.saveAuditInvoiceCache(auditDto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6821\u9a8c\u53d1\u7968\u5ba2\u6237")
    @PostMapping(value={"checkInvoiceCustomer"})
    public Result<?> checkInvoiceCustomer(@RequestBody QueryAuditInfoDto dto) {
        try {
            this.auditService.checkInvoiceCustomer(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u884c\u4e0a\u6838\u9500\u53d1\u7968\u4fdd\u5b58\u7f13\u5b58")
    @PostMapping(value={"saveAuditInvoiceCache2"})
    public Result<?> saveAuditInvoiceCache2(@RequestBody AuditDto auditDto) {
        try {
            this.auditService.saveAuditInvoiceCache2(auditDto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6838\u9500\u53d1\u7968\u4fee\u6539\u7f13\u5b58")
    @PostMapping(value={"changeAuditInvoiceCache"})
    public Result<?> changeAuditInvoiceCache(@RequestBody AuditDto auditDto) {
        try {
            this.auditService.changeAuditInvoiceCache(auditDto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6838\u9500\u53d1\u7968\u5220\u9664\u7f13\u5b58")
    @PostMapping(value={"deleteAuditInvoice"})
    public Result<?> deleteAuditInvoice(@RequestBody AuditDto dto) {
        try {
            this.auditService.deleteAuditInvoice(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6838\u9500\u53d1\u7968\u6e05\u9664\u7f13\u5b58")
    @PostMapping(value={"clearAuditInvoice"})
    public Result<?> clearAuditInvoice(@RequestBody AuditDto dto) {
        try {
            this.auditService.clearAuditInvoice(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u70b9\u5f00\u4e0a\u8d26\u8c03\u6574")
    @PostMapping(value={"upAccountAdjust"})
    public Result<UpAccountAdjustVo> upAccountAdjust(@RequestBody List<String> auditDetailCodes) {
        try {
            return Result.ok((Object)this.auditService.upAccountAdjust(auditDetailCodes));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5b58\u5165\u6570\u91cf")
    @GetMapping(value={"getHasSaveNum"})
    public Result<?> getHasSaveNum(@RequestParam(value="cacheKey") String cacheKey) {
        try {
            return Result.ok((Object)this.auditService.getHasSaveNum(cacheKey));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6d3b\u52a8\u7ed3\u6848\u660e\u7ec6")
    @GetMapping(value={"queryActivityDetailPage"})
    public Result<Page<ActivityDetailVo>> queryActivityDetailPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, ActivityDetailDto dto) {
        try {
            return Result.ok((Object)this.auditService.queryActivityDetailPage(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6d3b\u52a8\u7533\u8bf7\u7f16\u7801\u6279\u91cf\u6dfb\u52a0\u7f13\u5b58")
    @GetMapping(value={"batchAddActivityDetailByCode"})
    public Result<?> batchAddActivityDetailByCode(ActivityDetailDto activityDetail) {
        try {
            log.info("\u7ed3\u6848\u6838\u9500\u6839\u636e\u6d3b\u52a8\u7533\u8bf7\u7f16\u7801\u6279\u91cf\u6dfb\u52a0\u7f13\u5b58++++++++++++++++++++++++++++++");
            String cacheKey = this.auditService.batchAddActivityDetailByCode(activityDetail);
            log.info("\u8fd4\u56de\u53c2\u6570:{}", (Object)cacheKey);
            String obj = activityDetail.getCacheKey();
            log.info("\u7ed3\u6848\u6838\u9500\u6839\u636e\u6d3b\u52a8\u7533\u8bf7\u7f16\u7801\u6279\u91cf\u6dfb\u52a0\u7f13\u5b58-------------------------------");
            return Result.ok((Object)obj);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u786e\u5b9a")
    @PostMapping(value={"confirm"})
    public Result<?> confirm(@RequestBody List<String> auditCodes) {
        try {
            String s = this.auditService.confirm(auditCodes);
            if (StringUtils.isNotEmpty((CharSequence)s)) {
                return Result.error((String)s);
            }
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ed3\u6848\u8d44\u6599\u4fdd\u5b58")
    @PostMapping(value={"endCaseInfoSave"})
    public Result<?> endCaseInfoSave(@RequestBody AuditDto dto) {
        try {
            this.auditService.endCaseInfoSave(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7ed3\u6848\u8d44\u6599")
    @PostMapping(value={"queryEndCaseInfo"})
    public Result<List<AuditEndCaseInfoVo>> queryEndCaseInfo(@RequestBody AuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.queryEndCaseInfo(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u884c\u4e0a\u67e5\u8be2\u7ed3\u6848\u8d44\u6599")
    @PostMapping(value={"queryEndCaseInfo2"})
    public Result<List<AuditEndCaseInfoVo>> queryEndCaseInfo2(@RequestBody QueryEndCaseInfoDto dto) {
        try {
            return Result.ok((Object)this.auditService.queryEndCaseInfo2(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u81ea\u52a8\u6838\u9500")
    @PostMapping(value={"autoAudit"})
    public Result<?> autoAudit(@RequestBody AutoAuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.autoAudit(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, Audit.class));
        }
    }

    @ApiOperation(value="\u81ea\u52a8\u6838\u9500-\u80fd\u529b\u4e2d\u5fc3\u63a5\u53e3")
    @PostMapping(value={"atomicAudit"})
    public Result<AuditDto> atomicAudit(@RequestBody AutoAuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.atomicAudit(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, Audit.class));
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u4f9b\u5e94\u5546\u5217\u8868")
    @GetMapping(value={"/supplier/findByConditions"})
    public Result<Page<AuditPayVo>> findSupplierByConditions(@PageableDefault(value=50) Pageable pageable, SupplierDto paginationDto) {
        try {
            return Result.ok((Object)this.auditService.findSupplierByConditions(pageable, paginationDto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0a\u8d26")
    @PostMapping(value={"upAccount"})
    public Result<?> upAccount(@RequestBody List<String> auditCodes) {
        try {
            String s = this.auditService.upAccount(auditCodes);
            if (StringUtils.isNotEmpty((CharSequence)s)) {
                return Result.error((String)s);
            }
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ea2\u5b57\u53d1\u7968\u4e0a\u8d26")
    @PostMapping(value={"redInvoiceUpAccount"})
    public Result<?> redInvoiceUpAccount(@RequestBody List<String> auditCodes) {
        try {
            String s = this.auditService.redInvoiceUpAccount(auditCodes);
            if (StringUtils.isNotEmpty((CharSequence)s)) {
                return Result.error((String)s);
            }
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ea2\u5b57\u53d1\u7968\u51b2\u9500")
    @PostMapping(value={"redInvoiceOffset"})
    public Result<?> redInvoiceOffset(@RequestBody List<String> auditCodes) {
        try {
            this.auditService.redInvoiceOffset(auditCodes);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6298\u6263\u4e0a\u5e10")
    @PostMapping(value={"discountUpAccount"})
    public Result<?> discountUpAccount(@RequestBody List<String> auditCodes) {
        try {
            auditCodes = auditCodes.stream().distinct().collect(Collectors.toList());
            auditCodes.forEach(auditCode -> {
                String s = this.auditService.discountUpAccount(auditCode);
            });
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7269\u6599\u91c7\u8d2d\u5355\u4fdd\u5b58\u7f13\u5b58\u6838\u9500\u8d44\u6599")
    @PostMapping(value={"supplierMaterialSaveCacheAuditInfo"})
    public Result<?> supplierMaterialSaveCacheAuditInfo(@RequestBody AuditDto dto) {
        try {
            this.auditService.supplierMaterialSaveCacheAuditInfo(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7269\u6599\u91c7\u8d2d\u5355\u67e5\u8be2\u7f13\u5b58\u6838\u9500\u8d44\u6599\u7f13\u5b58")
    @PostMapping(value={"supplierMaterialFindCacheAuditInfo"})
    public Result<List<AuditSupplierMaterialFileVo>> supplierMaterialFindCacheAuditInfo(@RequestBody AuditDto dto) {
        try {
            return Result.ok((Object)this.auditService.supplierMaterialFindCacheAuditInfo(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0a\u8d26\u51b2\u9500")
    @PostMapping(value={"upAccountChargeAgainst"})
    public Result<?> upAccountChargeAgainst(@RequestBody List<String> auditCodes) {
        try {
            String s = this.auditService.upAccountChargeAgainst(auditCodes);
            if (StringUtils.isNotEmpty((CharSequence)s)) {
                return Result.error((String)s);
            }
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u4e0a\u8d26")
    @GetMapping(value={"testUpAccount"})
    public Result testUpAccount(@RequestParam(value="auditCode") String auditCode) {
        try {
            ProcessStatusDto dto = new ProcessStatusDto();
            dto.setProcessStatus("3");
            dto.setBusinessNo(auditCode);
            dto.setBusinessNoList(Collections.singletonList(auditCode));
            this.listener.auditProcessComplete(dto, false);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u4e0a\u8d262")
    @PostMapping(value={"testUpAccount2"})
    public Result testUpAccount2(@RequestBody ProcessStatusDto dto) {
        try {
            this.listener.auditProcessComplete(dto, false);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63a8\u9001\u6570\u636e\u5230ECRM")
    @PostMapping(value={"pushEcrm"})
    public Result<?> pushEcrm(@RequestBody List<String> idList) {
        try {
            this.auditService.pushEcrm(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u5904\u7406\u62a5\u9500\u672a\u51cf\u53bb\u7684\u5df2\u62a5\u9500\u91d1\u989d")
    @GetMapping(value={"reimburseNotAlreadyReimburseAmount"})
    public Result<?> reimburseNotAlreadyReimburseAmount() {
        try {
            this.auditService.reimburseNotAlreadyReimburseAmount();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62c6\u5206\u5ba2\u6237\u6838\u9500\u660e\u7ec6")
    @PostMapping(value={"splitAuditCustomerDetail"})
    public Result<?> splitAuditCustomerDetail(@RequestBody SplitAuditCustomerDetailDto dto) {
        try {
            FacturerUserDetails identity = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            return Result.ok((String)this.auditService.splitAuditCustomerDetail(dto, identity));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u81ea\u52a8\u6838\u9500")
    @PostMapping(value={"autoAuditTest"})
    public Result<?> autoAudit() {
        try {
            this.detailSchedulingImp.autoAudit();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"detailColImport"})
    public Result<?> detailColImport(@RequestBody List<CustomerAuditDetailColImportsVo> list) {
        try {
            LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
            for (int i = 0; i < list.size(); ++i) {
                linkedHashMap.put(i, list.get(i));
            }
            HashMap params = Maps.newHashMap();
            params.put("cacheKey", "AUDIT:HX2023030500014");
            this.auditDetailColImportsProcess.execute(linkedHashMap, null, params);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"detailImport"})
    public void detailImport(@RequestBody List<CustomerAuditDetailImportsVo> list) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (int i = 0; i < list.size(); ++i) {
            linkedHashMap.put(i, list.get(i));
        }
        HashMap params = Maps.newHashMap();
        params.put("cacheKey", "AUDIT:HX2023031500053");
        this.auditDetailImportsProcess.execute(linkedHashMap, null, params);
    }

    @ApiOperation(value="\u81ea\u52a8\u7ed3\u6848\u53ef\u81ea\u5b9a\u4e49\u914d\u7f6e")
    @PostMapping(value={"createOrUpdateAutoConfiguration"})
    public Result<?> createOrUpdateAutoConfiguration(@RequestBody AuditAutoConfigurationDto auditAutoConfiguration) {
        try {
            this.auditService.createOrUpdateAutoConfiguration(auditAutoConfiguration);
            return Result.ok();
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u7ed3\u6848\u53ef\u81ea\u5b9a\u4e49\u914d\u7f6e\u5f02\u5e38:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u81ea\u52a8\u7ed3\u6848\u81ea\u5b9a\u4e49\u53c2\u6570\u67e5\u8be2")
    @GetMapping(value={"getConfigurationById"})
    public Result<?> getConfigurationById(@RequestParam(value="id") String id) {
        try {
            AuditAutoConfigurationVo configuration = this.auditService.getConfigurationById(id);
            return Result.ok((Object)configuration);
        }
        catch (Exception e) {
            log.error("\u53ef\u914d\u7f6e\u53c2\u6570\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u81ea\u52a8\u7ed3\u6848\u81ea\u5b9a\u4e49\u53c2\u6570\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findConfiguration/page"})
    public Result<?> findConfiguration(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="audit", value="\u81ea\u52a8\u7ed3\u6848\u81ea\u5b9a\u4e49\u53c2\u6570") AuditAutoConfigurationDto configuration) {
        try {
            Page resultPage = this.auditService.findConfigurationPage(pageable, configuration);
            return Result.ok((Object)resultPage);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u81ea\u5b9a\u4e49\u914d\u7f6e\u5220\u9664")
    @DeleteMapping(value={"delete/Configuration"})
    public Result<?> deleteConfiguration(@RequestParam(value="id") String id) {
        try {
            this.auditService.deleteConfiguration(id);
            return Result.ok();
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u4fe1\u606f\u5220\u9664\u5f02\u5e38:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0a\u5e10\u5206\u644a")
    @PostMapping(value={"upAccountApportion"})
    public Result<?> upAccountApportion(@RequestBody AuditDto dto) {
        try {
            return Result.ok((String)this.auditService.upAccountApportionOne(dto));
        }
        catch (Exception e) {
            log.error("\u4e0a\u5e10\u5206\u644a:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u660e\u7ec6\u590d\u5236")
    @PostMapping(value={"customerCopyNumber"})
    public Result<?> customerCopyNumber(@PageableDefault(value=50) Pageable pageable, @RequestBody AuditDto dto) {
        try {
            AuditVo auditVo = this.auditService.customerCopyNumber(pageable, dto);
            return Result.ok((Object)auditVo);
        }
        catch (Exception e) {
            log.error("\u660e\u7ec6\u590d\u5236\u5f02\u5e38:{}", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u63d0\u4ea4\u6838\u9500\u67e5\u8be2")
    @GetMapping(value={"findAuditBatch/querySubmit"})
    public Result<?> findAuditBatch(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") Pageable pageable, @ApiParam(name="audit", value="\u6838\u9500\u4e3b\u8868") AuditBatchSubmitQueryDto audit) {
        try {
            Page page = this.auditService.findBatchSubmit(pageable, audit);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u63d0\u4ea4\u6838\u9500\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u754c\u9762\u6279\u91cf\u6253\u9a73\u56de\u6807\u8bc6")
    @PostMapping(value={"batchRejectStatus"})
    public Result<?> batchRejectStatus(@RequestBody List<String> auditCodes) {
        try {
            this.auditService.batchRejectStatus(auditCodes);
            return Result.ok();
        }
        catch (Exception e) {
            log.error("\u5ba1\u6279\u754c\u9762\u6279\u91cf\u6253\u9a73\u56de\u6807\u8bc6\u5f02\u5e38", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ed3\u6848\u6838\u9500\u5ba1\u6279\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"findAuditDetailGroupSubmit"})
    public Result<?> findAuditDetailGroupSubmit(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") Pageable pageable, @ApiParam(name="audit", value="\u6838\u9500\u4e3b\u8868") AuditBatchSubmitQueryDto audit) {
        try {
            Page page = this.auditService.findAuditDetailGroupSubmit(pageable, audit);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u63d0\u4ea4\u6838\u9500\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6838\u9500\u7f16\u7801\u67e5\u8be2\u660e\u7ec6")
    @GetMapping(value={"findDetailByAuditCode"})
    public Result<?> findDetailByAuditCode(String auditCode) {
        try {
            List detailCollectionVos = this.auditService.findDetailByAuditCode(auditCode);
            return Result.ok((Object)detailCollectionVos);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u660e\u7ec6\u5f02\u5e38:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5782\u76f4\u8d39\u7528\u6c60\u9a8c\u8bc1")
    @PostMapping(value={"expensePoolVerify"})
    public Result<?> expensePoolVerify(@RequestBody AuditDto auditDto) {
        try {
            String s = this.auditService.expensePoolVerify(auditDto);
            return Result.ok((String)s);
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u5f02\u5e38", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5782\u76f4\u8d39\u7528\u6c60\u9a8c\u8bc1")
    @PostMapping(value={"batchExpensePoolVerify"})
    public Result<?> batchExpensePoolVerify(@RequestBody AuditDto auditDto) {
        try {
            List auditCodes = auditDto.getAuditCodes();
            String s = this.auditService.batchExpensePoolVerify(auditCodes);
            return Result.ok((String)s);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5782\u76f4\u8d39\u7528\u6c60\u9a8c\u8bc1\u5f02\u5e38", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6dfb\u52a0\u4ea7\u54c1\u4fe1\u606f\u5230\u660e\u7ec6")
    @PostMapping(value={"addProductCache"})
    public Result<?> addProductCache(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="companyCode", value="\u516c\u53f8\u4ee3\u7801") @RequestParam String companyCode, @ApiParam(name="businessUnitCode", value="\u4e1a\u52a1\u5355\u5143") @RequestParam String businessUnitCode, @ApiParam(name="id", value="\u6838\u9500\u660e\u7ec6id") @RequestParam String id, @RequestBody AuditRedInvoiceProductDto dto) {
        try {
            this.auditService.addProductCache(cacheKey, companyCode, businessUnitCode, id, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u4ea7\u54c1\u4fe1\u606f\u5230\u660e\u7ec6\u5f02\u5e38:{}", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9644\u4ef6\u6570\u4fee\u6539")
    @PatchMapping(value={"/updateAppendices"})
    public Result<?> updateAppendices(@RequestBody AuditDto auditDto) {
        try {
            this.auditService.updateAppendices(auditDto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u63a8\u9884\u7b97")
    @PostMapping(value={"manualReturnBudget"})
    public Result<?> manualReturnBudget(@RequestBody AuditDto auditDto) {
        try {
            log.info("\u5782\u76f4\u624b\u52a8\u63a8\u9884\u7b97+++++++++++++++++++++++++++++++++++++++++");
            this.auditService.manualReturnBudget(auditDto, true);
            log.info("\u5782\u76f4\u624b\u52a8\u63a8\u9884\u7b97-----------------------------------------");
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u63a8\u9884\u7b97,\u5305\u542b\u56de\u5199\u6d3b\u52a8\u4e0a\u7684\u72b6\u6001")
    @GetMapping(value={"manualReturnBudgetWriteBackActivityStatus"})
    public Result<?> manualReturnBudgetWriteBackActivityStatus(@RequestParam(value="auditCode") String auditCode) {
        try {
            this.auditService.manualReturnBudgetWriteBackActivityStatus(auditCode);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6298\u6263\u8c03\u6574\u660e\u7ec6")
    @GetMapping(value={"findByName"})
    public Result<Page<AuditVo>> findByName(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="auditName", value="\u6838\u9500\u4e3b\u8868") String auditName) {
        try {
            Page page = this.auditService.findByName(pageable, auditName);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u68c0\u67e5\u72b6\u6001\u4fee\u6539")
    @GetMapping(value={"/updateCheckStatus"})
    public Result<String> updateCheckStatus(@RequestParam String auditCode, @RequestParam String checkStatus) {
        try {
            Result result = new Result();
            String checkStatusCode = this.auditService.updateCheckStatus(auditCode, checkStatus);
            result.setResult((Object)checkStatusCode);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6838\u9500\u5ba1\u6279\u4fe1\u606f\u91d1\u989d\u6c47\u603b")
    @GetMapping(value={"findSubmitAmount"})
    public Result<?> findSubmitAmount(@ApiParam(name="audit", value="\u6838\u9500\u4e3b\u8868") AuditBatchSubmitQueryDto audit) {
        try {
            AuditSubmitAmountVo submitAmountVo = this.auditService.findSubmitAmount(audit);
            return Result.ok((Object)submitAmountVo);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6838\u9500\u5ba1\u6279\u4fe1\u606f\u91d1\u989d\u6c47\u603b:{}", (Object)e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u725be\u8d22\u901a\u83b7\u53d6\u660e\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/findDetailByConditions"})
    public Result<Page<AuditCustomerDetailCollectionVo>> findDetailByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditFindDetailDto dto) {
        try {
            Page page = this.auditSdkService.findDetailByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6838\u9500\u7f16\u7801\u5220\u9664\u53d1\u7968\u5173\u8054\u5173\u7cfb")
    @DeleteMapping(value={"deleteCodeList"})
    public Result<?> deleteByCodeList(@RequestParam(value="deleteCodeList") List<String> deleteCodeList) {
        try {
            this.auditInvoiceService.deleteByCodeList(deleteCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="TPM-\u6838\u9500\u4e0a\u8d26\u67e5\u770b")
    @GetMapping(value={"tpmAuditUpAccount"})
    public Result<Page<AuditProductUpAccountVo>> tpmAuditUpAccount(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditProductUpAccountDto dto) {
        try {
            Page page = this.auditService.tpmAuditUpAccount(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="TPM-\u7ed3\u6848\u6838\u9500\u67e5\u770b")
    @GetMapping(value={"auditDetailLook"})
    public Result<Page<AuditDetailLookVo>> auditDetailLook(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditDetailLookDto dto) {
        try {
            Page page = this.auditService.auditDetailLook(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="TPM-\u7ed3\u6848\u6838\u9500\u7ba1\u7406")
    @GetMapping(value={"auditReport"})
    public Result<Page<AuditCustomerDetailCollectionVo>> auditReport(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditCustomerDetailCollectionDto dto) {
        try {
            Page page = this.auditService.auditReport(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7269\u6599\u8d39\u6838\u9500")
    @GetMapping(value={"supplierAuditReport"})
    public Result<Page<AuditSupplierDetailVo>> supplierAuditReport(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, AuditSupplierDetailDto dto) {
        try {
            return Result.ok((Object)this.auditService.supplierAuditReport(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u725be\u8d22\u901a\u83b7\u53d6\u6838\u9500\u4fe1\u606f")
    @PostMapping(value={"/findAuditVoListByCondition"})
    public Result<List<AuditTotalReimburseTaxAmountVo>> findAuditVoListByCondition(@RequestBody AuditQueryDto dto) {
        try {
            List list = this.auditSdkService.findAuditVoListByCondition(dto);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u7f16\u53f7\u67e5\u8be2\u4e1a\u52a1\u5355\u5143")
    @GetMapping(value={"findBusinessUnitByProcessNo"})
    public Result<?> findBusinessUnitByProcessNo(@RequestParam(value="processNo") String processNo) {
        try {
            return Result.ok((String)this.auditSdkService.findBusinessUnitByProcessNo(processNo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

