/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.audit.local.service.AuditCustomerService;
import com.biz.crm.tpm.business.audit.local.service.AuditReportService;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.report.CostPoolAuditReportDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/audit/report"})
@Api(tags={"\u7ed3\u6848\u6838\u9500\u62a5\u8868"})
public class AuditReportController {
    private static final Logger log = LoggerFactory.getLogger(AuditReportController.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private AuditCustomerService auditCustomerService;
    @Autowired(required=false)
    private AuditReportService auditReportService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6838\u9500\u660e\u7ec6")
    @GetMapping(value={"auditDetail"})
    public Result<Page<AuditCustomerDetailCollectionVo>> auditDetail(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6838\u9500\u660e\u7ec6") AuditCustomerDetailCollectionDto dto) {
        try {
            Page page = this.auditService.auditDetail(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6838\u9500\u4e0a\u8d26\u660e\u7ec6\u67e5\u770b")
    @GetMapping(value={"auditUpAccountDetail"})
    public Result<Page<AuditCustomerDetailCollectionVo>> auditUpAccountDetail(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6838\u9500\u660e\u7ec6") AuditCustomerDetailCollectionDto dto) {
        try {
            Page page = this.auditService.auditUpAccountDetail(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ed3\u6848\u6838\u9500\u660e\u7ec6\u67e5\u770b")
    @GetMapping(value={"findAuditDetailList"})
    public Result<Page<AuditCustomerDetailVo>> findAuditDetailList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6838\u9500\u660e\u7ec6") AuditCustomerDetailDto dto) {
        try {
            Page<AuditCustomerDetailVo> page = this.auditCustomerService.findAuditDetailList(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868")
    @PostMapping(value={"manualUpdateCostPoolReport"})
    public Result<?> manualUpdateCostPoolReport(@RequestBody CostPoolAuditReportDto dto) {
        try {
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            this.auditReportService.manualUpdateCostPoolReport(loginUser, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error("\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868\u5931\u8d25", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8d39\u7528\u6c60\u6838\u9500\u8868\u7cfb\u7edf\u7ef4\u5ea6")
    @GetMapping(value={"costPoolReportSystem"})
    public Result<Page<CostPoolAuditReportVo>> costPoolReportSystem(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u8d39\u7528\u6c60\u6838\u9500\u8868") CostPoolAuditReportDto dto) {
        try {
            return Result.ok(this.auditReportService.costPoolReportSystem(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8d39\u7528\u6c60\u6838\u9500\u8868\u533a\u57df\u7ef4\u5ea6")
    @GetMapping(value={"costPoolReportRegion"})
    public Result<Page<CostPoolAuditReportVo>> costPoolReportRegion(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u8d39\u7528\u6c60\u6838\u9500\u8868") CostPoolAuditReportDto dto) {
        try {
            return Result.ok(this.auditReportService.costPoolReportRegion(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8d39\u7528\u6c60\u6838\u9500\u8868")
    @GetMapping(value={"costPoolReport"})
    public Result<Page<CostPoolAuditReportVo>> costPoolReport(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u8d39\u7528\u6c60\u6838\u9500\u8868") CostPoolAuditReportDto dto) {
        try {
            return Result.ok(this.auditReportService.costPoolReport(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

