/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.local.imports.CustomerAuditDetailColImportsProcess;
import com.biz.crm.tpm.business.audit.sdk.dto.TaxAccountDto;
import com.biz.crm.tpm.business.audit.sdk.service.TaxAccountService;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailColImportsVo;
import com.biz.crm.tpm.business.audit.sdk.vo.TaxAccountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/reimburseTaxRate"})
@Api(tags={"\u7a0e\u8d39\u79d1\u76ee"})
public class TaxAccountController {
    private static final Logger log = LoggerFactory.getLogger(TaxAccountController.class);
    @Autowired(required=false)
    private TaxAccountService taxAccountService;
    @Autowired
    CustomerAuditDetailColImportsProcess customerAuditDetailColImportsProcess;

    @ApiOperation(value="\u6839\u636e\u62a5\u9500\u7a0e\u7387\u67e5\u7a0e\u8d39\u79d1\u76ee")
    @GetMapping
    public Result<TaxAccountVo> findByReimburseTaxRate(@RequestParam @ApiParam(name="reimburseTaxRate", value="\u62a5\u9500\u7a0e\u7387") String reimburseTaxRate) {
        try {
            return Result.ok((Object)this.taxAccountService.findByReimburseTaxRate(reimburseTaxRate));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u7a0e\u8d39\u79d1\u76ee")
    @PostMapping
    public Result<?> create(@ApiParam(name="taxAccount", value="\u7a0e\u8d39\u79d1\u76ee\u4e3b\u8868") @RequestBody TaxAccountDto taxAccount) {
        try {
            this.taxAccountService.create(taxAccount);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"testImport"})
    public Result<?> testImport(@RequestParam(value="cacheKey") String cacheKey) {
        LinkedHashMap<Integer, CustomerAuditDetailColImportsVo> data = new LinkedHashMap<Integer, CustomerAuditDetailColImportsVo>();
        CustomerAuditDetailColImportsVo vo = new CustomerAuditDetailColImportsVo();
        vo.setId("55599a70aeac0cbd5127ea48b95556da");
        vo.setTaxSubject("5090400001");
        vo.setIsDeductionFeePool("\u662f");
        vo.setDiscountTaxRate("6");
        vo.setDiscountTaxAmount("100");
        vo.setReimburseItem("5090000001");
        vo.setIndividualIncomeTax("234");
        vo.setIsSpecialTicket("\u662f");
        vo.setCostCenter("2248107010");
        vo.setIsPushSap("\u662f");
        vo.setReimburseTaxRate("7");
        vo.setReimburseTaxAmount("402");
        data.put(1, vo);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("cacheKey", cacheKey);
        this.customerAuditDetailColImportsProcess.execute(data, null, param);
        return Result.ok();
    }
}

