/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditBatchSubmitQueryDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditBatchDetailExportsVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditBatchDetailExportsProcess
implements ExportProcess<AuditBatchDetailExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditBatchDetailExportsProcess.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Integer getTotal(Map<String, Object> params) {
        AuditBatchSubmitQueryDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page pageResult = this.auditService.findBatchDetailSubmit((Pageable)pageable, dto = this.convertParams(params));
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        AuditBatchSubmitQueryDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page pageResult = this.auditService.findBatchDetailSubmit((Pageable)pageable, dto = this.convertParams(params));
        if (CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return new JSONArray();
        }
        List records = pageResult.getRecords();
        Map auditDictMap = this.dictToolkitService.findMapByDictTypeCode("tpm_audit_form");
        this.adjustData(records, auditDictMap);
        return JSON.parseArray((String)JSON.toJSONString((Object)records, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    private void adjustData(Collection<AuditCustomerDetailVo> data, Map<String, String> auditDictMap) {
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"bpm_process_status", "yesOrNO", "check_status", "customer_supplier"}));
        for (AuditCustomerDetailVo vo : data) {
            vo.setProcessStatus(this.findDictValue(mapDict, "bpm_process_status", String.valueOf(vo.getProcessStatus())));
            vo.setReject(this.findDictValue(mapDict, "yesOrNO", StringUtils.isBlank((CharSequence)vo.getReject()) ? "N" : vo.getReject()));
            vo.setCheckStatus(this.findDictValue(mapDict, "check_status", String.valueOf(vo.getCheckStatus())));
            vo.setAuditType(TpmAuditTypeEnum.getDescByCode((String)vo.getAuditType()));
            vo.setCustomerSupplierType(this.findDictValue(mapDict, "customer_supplier", String.valueOf(vo.getCustomerSupplierType())));
            vo.setOverdue(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getOverdue())));
            vo.setIsDeductionFeePool(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getIsDeductionFeePool())));
            vo.setEndCaseForm(this.endCaseFormConversion(vo.getEndCaseForm(), auditDictMap));
            vo.setWholeAudit(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getWholeAudit())));
            vo.setIsPushSap(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getIsPushSap())));
        }
    }

    private String endCaseFormConversion(String endCaseForm, Map<String, String> auditDictMap) {
        if (StringUtils.isEmpty((CharSequence)endCaseForm)) {
            return "";
        }
        List endCaseFormNameList = Arrays.asList(endCaseForm.split(",")).stream().map(s -> {
            String endCaseFormName = (String)auditDictMap.get(s);
            return StringUtil.isEmpty((CharSequence)endCaseFormName) ? "" : endCaseFormName;
        }).collect(Collectors.toList());
        return StringUtils.join(endCaseFormNameList, (String)",");
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    private AuditBatchSubmitQueryDto convertParams(Map<String, Object> params) {
        return (AuditBatchSubmitQueryDto)JSON.parseObject((String)JSON.toJSONString(params), AuditBatchSubmitQueryDto.class);
    }

    public String getBusinessCode() {
        return "FIND_AUDIT_BATCH_DETAIL_EXPORT";
    }

    public String getBusinessName() {
        return "\u6279\u91cf\u63d0\u4ea4\u6838\u9500\u660e\u7ec6\u67e5\u8be2\u5bfc\u51fa";
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }
}

