/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.audit.local.entity.AuditInvoice;
import com.biz.crm.tpm.business.audit.local.repository.AuditInvoiceRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditRepository;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerAuditDetailQueryDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerAuditDetailExportsVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditCustomerAuditDetailExportsProcess
implements ExportProcess<AuditCustomerAuditDetailExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditCustomerAuditDetailExportsProcess.class);
    @Autowired(required=false)
    private AuditRepository auditRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private AuditInvoiceRepository auditInvoiceRepository;

    public Integer getTotal(Map<String, Object> params) {
        AuditCustomerAuditDetailQueryDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page<AuditCustomerDetailVo> pageResult = this.auditRepository.findCustomerAuditDetail((Pageable)pageable, dto = this.convertParams(params));
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      \u5ba2\u6237\u6838\u9500\u660e\u7ec6\u6279\u91cf\u5bfc\u51fa[{}]    <=====", (Object)JSON.toJSONString((Object)vo));
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        AuditCustomerAuditDetailQueryDto dto = this.convertParams(params);
        Page<AuditCustomerDetailVo> pageResult = this.auditRepository.findCustomerAuditDetail((Pageable)pageable, dto);
        if (CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return new JSONArray();
        }
        List records = pageResult.getRecords();
        log.info("=====>      \u5ba2\u6237\u6838\u9500\u660e\u7ec6\u6279\u91cf\u5bfc\u51fasss[{}]    <=====", (Object)JSON.toJSONString((Object)records));
        this.adjustData(records);
        log.info("=====>      \u5ba2\u6237\u6838\u9500\u660e\u7ec6\u6279\u91cf\u5bfc\u51fa[{}]    <=====", (Object)JSON.toJSONString((Object)records));
        return JSON.parseArray((String)JSON.toJSONString((Object)records, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    private AuditCustomerAuditDetailQueryDto convertParams(Map<String, Object> params) {
        Object createTime = params.get("createTime");
        if (Objects.nonNull(createTime)) {
            params.put("createTime1", createTime);
            params.remove("createTime");
        }
        return (AuditCustomerAuditDetailQueryDto)JSON.parseObject((String)JSON.toJSONString(params), AuditCustomerAuditDetailQueryDto.class);
    }

    private void adjustData(Collection<AuditCustomerDetailVo> data) {
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"tpm_audit_form", "yesOrNO", "Purchase method", "tpm_pay_type", "customer_supplier", "audit_type", "tpm_sub_com_activity_association_type", "accept_type"}));
        Set<String> auditCodes = data.stream().map(AuditCustomerDetailVo::getAuditCode).collect(Collectors.toSet());
        List<AuditInvoice> auditInvoices = this.auditInvoiceRepository.findByAuditCodes(auditCodes);
        Map<Object, Object> auditInvoicesMap = new HashMap();
        if (CollectionUtils.isNotEmpty(auditInvoices)) {
            auditInvoicesMap = auditInvoices.stream().collect(Collectors.groupingBy(AuditInvoice::getAuditCode));
        }
        for (AuditCustomerDetailVo vo : data) {
            vo.setEndCaseForm(this.endCaseFormConversion(vo.getEndCaseForm()));
            vo.setIsDeductionFeePool(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getIsDeductionFeePool())));
            vo.setIsSpecialTicket(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getIsSpecialTicket())));
            vo.setIsPushSap(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getIsPushSap())));
            vo.setWholeAudit(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getWholeAudit())));
            vo.setBuyWay(this.findDictValue(mapDict, "Purchase method", String.valueOf(vo.getBuyWay())));
            vo.setPayWayCode(this.findDictValue(mapDict, "tpm_pay_type", String.valueOf(vo.getPayWayCode())));
            vo.setDeemedSale(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getDeemedSale())));
            String offsetProductCode = vo.getOffsetProductCode();
            if (StringUtils.isNotBlank((CharSequence)offsetProductCode)) {
                vo.setImpactProductCode(offsetProductCode);
            }
            vo.setOverdue(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getOverdue())));
            vo.setCustomerSupplierType(this.findDictValue(mapDict, "customer_supplier", String.valueOf(vo.getCustomerSupplierType())));
            vo.setAuditType(TpmAuditTypeEnum.getDescByCode((String)vo.getAuditType()));
            vo.setSalesOrgName(vo.getSalesOrgName());
            vo.setAuditWay(this.findDictValue(mapDict, "audit_type", String.valueOf(vo.getAuditWay())));
            vo.setAssociationType(this.findDictValue(mapDict, "tpm_sub_com_activity_association_type", String.valueOf(vo.getAssociationType())));
            vo.setUndertakingMode(this.findDictValue(mapDict, "accept_type", String.valueOf(vo.getUndertakingMode())));
            List auditInvoices1 = (List)auditInvoicesMap.get(vo.getAuditCode());
            if (!CollectionUtils.isNotEmpty((Collection)auditInvoices1)) continue;
            this.setInvoiceNumberAndInvoiceCode(auditInvoices1, vo);
        }
    }

    private void setInvoiceNumberAndInvoiceCode(List<AuditInvoice> auditInvoices1, AuditCustomerDetailVo vo) {
        String invoiceNumber = null;
        String invoiceCode = null;
        for (AuditInvoice auditInvoice : auditInvoices1) {
            if (StringUtils.isEmpty((CharSequence)auditInvoice.getInvoiceCode())) {
                auditInvoice.setInvoiceCode("0");
            }
            invoiceNumber = StringUtils.isEmpty(invoiceNumber) ? auditInvoice.getInvoiceNumber() : invoiceNumber + "," + auditInvoice.getInvoiceNumber();
            if (StringUtils.isEmpty(invoiceCode)) {
                invoiceCode = auditInvoice.getInvoiceCode();
                continue;
            }
            invoiceCode = invoiceCode + "," + auditInvoice.getInvoiceCode();
        }
        vo.setInvoiceNumber(invoiceNumber);
        vo.setInvoiceCode(invoiceCode);
    }

    private String endCaseFormConversion(String endCaseForm) {
        String[] endCaseFormSplit;
        if (StringUtils.isEmpty((CharSequence)endCaseForm)) {
            return "";
        }
        ArrayList endCaseFormList = Lists.newArrayList();
        String[] stringArray = endCaseFormSplit = endCaseForm.split(",");
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String caseForm;
            switch (caseForm = stringArray[i]) {
                case "1": {
                    endCaseFormList.add("\u6298\u6263");
                    continue block12;
                }
                case "2": {
                    endCaseFormList.add("\u62a5\u9500");
                    continue block12;
                }
                case "3": {
                    endCaseFormList.add("\u7ea2\u5b57\u53d1\u7968");
                    continue block12;
                }
                case "4": {
                    endCaseFormList.add("\u968f\u5355");
                    continue block12;
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)endCaseFormList)) {
            return StringUtils.join((Iterable)endCaseFormList, (String)",");
        }
        return "";
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public String getBusinessCode() {
        return "AUDIT_CUSTOMER_AUDIT_DETAIL_EXPORT";
    }

    public String getBusinessName() {
        return "\u5ba2\u6237\u6838\u9500\u660e\u7ec6\u6279\u91cf\u5bfc\u51fa\u7f16\u8f91";
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }
}

