/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDetailLookDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditDetailLookExportsVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditDetailLookVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditDetailLookExportsProcess
implements ExportProcess<AuditDetailLookExportsVo> {
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        AuditDetailLookDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page pageResult = this.auditService.auditDetailLook((Pageable)pageable, dto = this.convertParams(params));
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    private AuditDetailLookDto convertParams(Map<String, Object> params) {
        return (AuditDetailLookDto)JSON.parseObject((String)JSON.toJSONString(params), AuditDetailLookDto.class);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        AuditDetailLookDto dto = this.convertParams(params);
        Page page = this.auditService.auditDetailLook((Pageable)PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize()), dto);
        return JSON.parseArray((String)JSON.toJSONString(this.adjustData(page.getRecords()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    private List<AuditDetailLookVo> adjustData(List<AuditDetailLookVo> records) {
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format", "MDM_CUSTOMIZE_ORG", "mdm_business_unit", "yesOrNO", "bpm_process_status", "up_account_status", "red_order_status", "payment_time_type", "audit_type", "tpm_activity_design_detail_status", "tpm_sub_com_activity_association_type"}));
        for (AuditDetailLookVo record : records) {
            if (StringUtils.isNotEmpty((CharSequence)record.getEndCaseForm())) {
                record.setEndCaseForm(EndCaseFormEnum.codeTransitionStr((String)record.getEndCaseForm()));
            }
            record.setBusinessFormatCode(this.findDictValue(mapDict, "mdm_business_format", record.getBusinessFormatCode()));
            record.setBusinessUnitCode(this.findDictValue(mapDict, "mdm_business_unit", record.getBusinessUnitCode()));
            record.setProcessStatus(this.findDictValue(mapDict, "bpm_process_status", record.getProcessStatus()));
            record.setWholeAudit(this.findDictValue(mapDict, "yesOrNO", record.getWholeAudit()));
            record.setActivityDetailStatus(this.findDictValue(mapDict, "tpm_activity_design_detail_status", record.getActivityDetailStatus()));
            record.setAssociationType(this.findDictValue(mapDict, "tpm_sub_com_activity_association_type", record.getAssociationType()));
            record.setUndertakingMode(this.findDictValue(mapDict, "accept_type", record.getUndertakingMode()));
            record.setAuditType(this.findDictValue(mapDict, "tpm_audit_type", record.getUndertakingMode()));
        }
        return records;
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public String getBusinessCode() {
        return "audit_detail_look_export";
    }

    public String getBusinessName() {
        return "\u7ed3\u6848\u6838\u9500\u67e5\u770b\u5bfc\u51fa";
    }
}

