/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.local.service.AuditInvoiceService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceExportsVo;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditInvoiceExportsProcess
implements ExportProcess<AuditInvoiceExportsVo> {
    @Autowired(required=false)
    private AuditInvoiceService auditInvoiceService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        Integer total = this.auditInvoiceService.getInvoiceExportTotal(cacheKey);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58Key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (String)cacheKey;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        List<AuditInvoiceExportsVo> result = this.auditInvoiceService.getInvoiceExportData(cacheKey);
        return JSON.parseArray((String)JSON.toJSONString(result));
    }

    public Class<AuditInvoiceExportsVo> findCrmExcelVoClass() {
        return AuditInvoiceExportsVo.class;
    }

    public String getBusinessCode() {
        return "TPM_INVOICE_DETAILS_EXPORT";
    }

    public String getBusinessName() {
        return "\u6838\u9500\u5355\u53d1\u7968\u660e\u7ec6\u5bfc\u51fa";
    }
}

