/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditListExportsVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditListExportsProcess
implements ExportProcess<AuditListExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditListExportsProcess.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        AuditCustomerDetailCollectionDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page pageResult = this.auditService.auditReport((Pageable)pageable, dto = this.convertParams(params));
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    private AuditCustomerDetailCollectionDto convertParams(Map<String, Object> params) {
        return (AuditCustomerDetailCollectionDto)JSON.parseObject((String)JSON.toJSONString(params), AuditCustomerDetailCollectionDto.class);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        AuditCustomerDetailCollectionDto dto = this.convertParams(params);
        Page page = this.auditService.auditReport((Pageable)PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize()), dto);
        return JSON.parseArray((String)JSON.toJSONString(this.adjustData(page.getRecords()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    private List<AuditCustomerDetailCollectionVo> adjustData(List<AuditCustomerDetailCollectionVo> records) {
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format", "MDM_CUSTOMIZE_ORG", "mdm_business_unit", "yesOrNO", "bpm_process_status", "up_account_status", "red_order_status", "payment_time_type", "audit_type"}));
        log.info("\u7ed3\u6848\u6838\u9500\u5217\u8868\u5bfc\u51fa\uff1arecords-1\uff1a{}", (Object)JsonUtils.obj2JsonString(records));
        for (AuditCustomerDetailCollectionVo record : records) {
            BigDecimal invoiceTaxAmountCollect;
            if (StringUtils.isNotEmpty((CharSequence)record.getEndCaseForm())) {
                record.setEndCaseForm(EndCaseFormEnum.codeTransitionStr((String)record.getEndCaseForm()));
            }
            record.setInvoiceTaxAmountCollect((invoiceTaxAmountCollect = record.getInvoiceTaxAmountCollect()) != null ? invoiceTaxAmountCollect : BigDecimal.ZERO);
            record.setEndCaseType(EndCaseTypeEnum.getDescByCode((String)record.getEndCaseType()));
            record.setBusinessFormatCode(this.findDictValue(mapDict, "mdm_business_format", record.getBusinessFormatCode()));
            record.setBusinessUnitCode(this.findDictValue(mapDict, "mdm_business_unit", record.getBusinessUnitCode()));
            record.setRegion(this.findDictValue(mapDict, "MDM_CUSTOMIZE_ORG", record.getRegion()));
            record.setIsValidate(this.findDictValue(mapDict, "yesOrNO", record.getIsValidate()));
            record.setProcessStatus(this.findDictValue(mapDict, "bpm_process_status", record.getProcessStatus()));
            record.setWholeAudit(this.findDictValue(mapDict, "yesOrNO", record.getWholeAudit()));
            record.setUpAccountStatus(this.findDictValue(mapDict, "up_account_status", record.getUpAccountStatus()));
            record.setReimburseUpAccountStatus(this.findDictValue(mapDict, "up_account_status", record.getReimburseUpAccountStatus()));
            record.setRedOrderCreateStatus(this.findDictValue(mapDict, "red_order_status", record.getRedOrderCreateStatus()));
            record.setWhetherPay(this.findDictValue(mapDict, "yesOrNO", record.getWhetherPay()));
            record.setPaymentType(this.findDictValue(mapDict, "payment_time_type", record.getPaymentType()));
            record.setAuditWay(this.findDictValue(mapDict, "audit_type", record.getAuditWay()));
        }
        log.info("\u7ed3\u6848\u6838\u9500\u5217\u8868\u5bfc\u51fa\uff1arecords-2\uff1a{}", (Object)JsonUtils.obj2JsonString(records));
        return records;
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public String getBusinessCode() {
        return "AUDIT_LIST_EXPORTS";
    }

    public String getBusinessName() {
        return "\u6838\u9500\u5217\u8868\u5bfc\u51fa";
    }
}

