/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.exports;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailColExportsVo;
import java.util.List;
import java.util.Map;
import liquibase.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerAuditDetailColExportsProcess
implements ExportProcess<CustomerAuditDetailColExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(CustomerAuditDetailColExportsProcess.class);
    @Autowired(required=false)
    private AuditService auditService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit audit = this.auditService.getAudit(auditDto);
        auditDto.setCacheKey(cacheKey);
        Integer total = audit.getColExportTotal(auditDto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"));
        return total;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58\u53ef\u4ee5\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        log.info("\u5f52\u96c6\u660e\u7ec6\u5bfc\u51fa\u53c2\u6570:\u3010{}\u3011,\u3010{}\u3011", (Object)JSONUtil.toJsonStr((Object)vo), (Object)JSONUtil.toJsonStr(params));
        String cacheKey = this.getCacheKey(params);
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit audit = this.auditService.getAudit(auditDto);
        auditDto.setCacheKey(cacheKey);
        List result = audit.getCustomerColExportData(auditDto);
        log.info("\u5f52\u96c6\u660e\u7ec6\u5bfc\u51fa\u6570\u636e\u5185\u5bb9:{}", (Object)JSONUtil.toJsonStr((Object)result));
        return JSON.parseArray((String)JSON.toJSONString((Object)result));
    }

    public Class<CustomerAuditDetailColExportsVo> findCrmExcelVoClass() {
        return CustomerAuditDetailColExportsVo.class;
    }

    public String getBusinessCode() {
        return "customer_audit_detail_col_export";
    }

    public String getBusinessName() {
        return "\u5ba2\u6237\u6838\u9500\u660e\u7ec6\u5f52\u96c6\u5bfc\u51fa";
    }
}

