/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailExportsVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import liquibase.util.Validate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerAuditDetailExportsProcess
implements ExportProcess<CustomerAuditDetailExportsVo> {
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_MAX_TOTAL;
    }

    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit audit = this.auditService.getAudit(auditDto);
        auditDto.setCacheKey(cacheKey);
        Integer total = audit.getExportTotal(auditDto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"));
        return total;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58\u53ef\u4ee5\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit audit = this.auditService.getAudit(auditDto);
        auditDto.setCacheKey(cacheKey);
        List result = audit.getCustomerExportData(auditDto);
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"tpm_audit_form", "yesOrNO", "Purchase method", "tpm_pay_type", "customer_supplier", "audit_type", "tpm_sub_com_activity_association_type", "accept_type"}));
        for (CustomerAuditDetailExportsVo detailExportsVo : result) {
            detailExportsVo.setCustomerSupplierType(this.findDictValue(mapDict, "customer_supplier", String.valueOf(detailExportsVo.getCustomerSupplierType())));
            detailExportsVo.setAuditType(TpmAuditTypeEnum.getDescByCode((String)detailExportsVo.getAuditType()));
            detailExportsVo.setOverdue(this.findDictValue(mapDict, "yesOrNO", String.valueOf(detailExportsVo.getOverdue())));
            detailExportsVo.setAuditWay(this.findDictValue(mapDict, "audit_type", String.valueOf(detailExportsVo.getAuditWay())));
            detailExportsVo.setAssociationType(this.findDictValue(mapDict, "tpm_sub_com_activity_association_type", String.valueOf(detailExportsVo.getAssociationType())));
            detailExportsVo.setUndertakingMode(this.findDictValue(mapDict, "accept_type", String.valueOf(detailExportsVo.getUndertakingMode())));
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)result));
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public Class<CustomerAuditDetailExportsVo> findCrmExcelVoClass() {
        return CustomerAuditDetailExportsVo.class;
    }

    public String getBusinessCode() {
        return "customer_audit_detail_export";
    }

    public String getBusinessName() {
        return "\u5ba2\u6237\u6838\u9500\u660e\u7ec6\u5bfc\u51fa";
    }
}

